/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.SignonEvent;
import com.ibm.as400.access.SignonHandler;
import com.ibm.as400.access.SignonHandlerAdapter;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Vector;
import nl.ibs.util.JobMessageHelper;
import nl.ibs.util.UserSpaceEnhanced;

public class AS400Enhanced
extends AS400 {
    private static final long serialVersionUID = 8634764526722408145L;
    private Vector userSpaceCollection = new Vector();
    private int nameCounter = 0;
    private long startIdleTime = 0L;
    private byte[] initSpace = null;
    private int daysUntilExpiration;
    private MySignonHandler signonHandler = new MySignonHandler();

    public AS400Enhanced(String systemName, String userProfile, String passWord) {
        super(systemName, userProfile, passWord);
        this.initialize();
    }

    public AS400Enhanced() {
        this.initialize();
    }

    private void initialize() {
        try {
            this.setGuiAvailable(false);
        }
        catch (PropertyVetoException pve) {
            System.err.print("ERROR: AS400 connection cannot set GUIAvailable to false!! This might cause problems due to (error)prompt windows that are not mionitored on consoles!");
            pve.printStackTrace();
        }
        this.setSignonHandler((SignonHandler)this.signonHandler);
    }

    public synchronized UserSpaceEnhanced getUserSpace() {
        UserSpaceEnhanced space = null;
        if (this.userSpaceCollection.isEmpty()) {
            space = this.createNewUserSpace();
        } else {
            space = this.getPooledUserSpace();
            if (space == null) {
                space = this.createNewUserSpace();
            }
        }
        return space;
    }

    private synchronized UserSpaceEnhanced createNewUserSpace() {
        UserSpaceEnhanced space = null;
        String spaceName = "IBS" + this.nameCounter++;
        String libraryName = "QTEMP";
        try {
            space = new UserSpaceEnhanced(this, spaceName, libraryName);
            space.setAutoExtendible(true);
        }
        catch (Exception e) {
            System.out.println("AS400Enhanced::getUserSpace- Error while creating UserSpace. Error=" + e.getMessage());
        }
        return space;
    }

    private synchronized UserSpaceEnhanced getPooledUserSpace() {
        UserSpaceEnhanced space = null;
        while (this.userSpaceCollection.size() > 0 && space == null) {
            space = (UserSpaceEnhanced)((Object)this.userSpaceCollection.firstElement());
            this.userSpaceCollection.removeElementAt(0);
            try {
                if (this.initSpace == null) {
                    this.initSpace = new byte[space.getLength()];
                }
                space.write(this.initSpace, 0);
            }
            catch (Exception e) {
                space = null;
            }
        }
        return space;
    }

    public synchronized void returnUserSpace(UserSpaceEnhanced us) {
        try {
            us.setLength(1);
        }
        catch (Exception e) {
            System.out.println("AS400Enhanced::returnUserSpace- Error while setting UserSpace aatribute Autoextendible. Error=" + e.getMessage());
        }
        this.userSpaceCollection.addElement(us);
    }

    public long getStartIdleTime() {
        return this.startIdleTime;
    }

    public void setStartIdleTime(long startIdleTime) {
        this.startIdleTime = startIdleTime;
    }

    public int getDaysUntilExpiration() {
        return this.daysUntilExpiration;
    }

    public StringBuffer getJobMessages(StringBuffer sb) throws Exception {
        ProgramCall pc = new ProgramCall((AS400)this);
        pc.setThreadSafe(true);
        JobMessageHelper.getJobMessages(pc.getServerJob(), sb);
        return sb;
    }

    private class MySignonHandler
    extends SignonHandlerAdapter
    implements Serializable {
        private static final long serialVersionUID = 5515222941215961695L;

        private MySignonHandler() {
        }

        public boolean passwordAboutToExpire(SignonEvent event, int i) {
            AS400Enhanced.this.daysUntilExpiration = i;
            return true;
        }
    }
}

