/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

public class Ascii2Ebcdic {
    private static final int SIZE = 95;
    private static final int[] ASCII = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126};
    private static final int[] EBCDIC = new int[]{64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122, 94, 76, 126, 110, 111, 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214, 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 173, 224, 189, 95, 109, 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150, 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192, 106, 208, 161};

    public static final int toEbcdic(int i) throws Exception {
        int j = 0;
        while (j < 95) {
            if (i == ASCII[j]) {
                return EBCDIC[j];
            }
            ++j;
        }
        throw new Exception("Unsupported ascii value: " + i);
    }

    public static final int toEbcdic(char c) throws Exception {
        return Ascii2Ebcdic.toEbcdic((int)c);
    }

    public static final int toAscii(int i) throws Exception {
        int j = 0;
        while (j < 95) {
            if (i == EBCDIC[j]) {
                return ASCII[j];
            }
            ++j;
        }
        throw new Exception("Unsupported ebcdic value: " + i);
    }

    public static final char toAsciiChar(int i) throws Exception {
        int j = 0;
        while (j < 95) {
            if (i == EBCDIC[j]) {
                return (char)ASCII[j];
            }
            ++j;
        }
        throw new Exception("Unsupported ebcdic value: " + i);
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 256) {
            try {
                System.out.println("Intvalue= " + i + "   char = " + (char)i + "  Ebcdicvalue = " + Ascii2Ebcdic.toEbcdic(i));
            }
            catch (Exception e) {
                System.out.println("Exception= " + e.getMessage());
            }
            ++i;
        }
    }
}

