/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobLog;
import com.ibm.as400.access.QueuedMessage;
import java.util.Enumeration;

public abstract class JobMessageHelper {
    private static final String LINESEPARATOR = System.getProperty("line.separator");

    public static StringBuffer getJobMessages(Job job, StringBuffer sb) throws Exception {
        try {
            sb.append(job.getNumber());
            sb.append('/');
            sb.append(job.getUser());
            sb.append('/');
            sb.append(job.getName());
            sb.append(LINESEPARATOR);
            JobLog jobLog = job.getJobLog();
            Enumeration messages = jobLog.getMessages();
            while (messages.hasMoreElements()) {
                QueuedMessage queuedMessage = (QueuedMessage)messages.nextElement();
                sb.append(queuedMessage.getID());
                sb.append(';');
                sb.append(JobMessageHelper.getType(queuedMessage.getType()));
                sb.append(';');
                sb.append(queuedMessage.getSeverity());
                sb.append(';');
                sb.append(queuedMessage.getDate().getTime());
                sb.append(';');
                sb.append(queuedMessage.getFromProgram());
                sb.append(';');
                sb.append(queuedMessage.getText());
                sb.append(';');
                sb.append(queuedMessage.getHelp());
                sb.append(';');
                if (queuedMessage.getSubstitutionData() == null) {
                    sb.append("");
                } else {
                    sb.append(queuedMessage.getSubstitutionData());
                }
                sb.append(';');
                sb.append(LINESEPARATOR);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            sb.append(e.getMessage());
        }
        return sb;
    }

    private static String getType(int type) {
        switch (type) {
            case 1: {
                return "COMPLETION";
            }
            case 2: {
                return "DIAGNOSTIC";
            }
            case 4: {
                return "INFORMATIONAL";
            }
            case 5: {
                return "INQUIRY";
            }
            case 6: {
                return "SENDERS_COPY";
            }
            case 8: {
                return "REQUEST";
            }
            case 10: {
                return "REQUEST_WITH_PROMPTING";
            }
            case 14: {
                return "NOTIFY";
            }
            case 15: {
                return "ESCAPE";
            }
            case 16: {
                return "NOTIFY_NOT_HANDLED";
            }
            case 17: {
                return "ESCAPE_NOT_HANDLED";
            }
            case 21: {
                return "REPLY_NOT_VALIDATY_CHECKED";
            }
            case 22: {
                return "REPLY_VALIDATY_CHECKED";
            }
            case 23: {
                return "REPLY_MESSAGE_DEFAULT_USED";
            }
            case 24: {
                return "REPLY_SYSTEM_DEFAULT_USED";
            }
            case 25: {
                return "REPLY_FROM_SYSTEM_REPLY_LIST";
            }
        }
        return Integer.toString(type);
    }
}

