/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class MethodInvoker {
    private static MethodInvoker mi = null;
    private HashMap classes = new HashMap();

    private MethodInvoker() {
    }

    public static MethodInvoker getInstance() {
        if (mi == null) {
            mi = new MethodInvoker();
        }
        return mi;
    }

    public static Object invoke(Object object, String methodName, Object[] arguments, Class[] argumentTypes) throws Exception {
        MethodInvoker mi = MethodInvoker.getInstance();
        return mi.getSignature(object.getClass(), methodName, argumentTypes).invoke(object, arguments);
    }

    public static Method getMethod(Class theClass, String methodName, Class[] argumentTypes) throws Exception {
        if (theClass == null) {
            throw new Exception("Method " + methodName + " not found!");
        }
        try {
            Method f = theClass.getDeclaredMethod(methodName, argumentTypes);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchMethodException nm) {
            return MethodInvoker.getMethod(theClass.getSuperclass(), methodName, argumentTypes);
        }
    }

    private HashMap getCachedClassMethods(Class theClass) throws Exception {
        if (!this.classes.containsKey(theClass.getName())) {
            HashMap methods = new HashMap();
            this.classes.put(theClass.getName(), methods);
            return methods;
        }
        return (HashMap)this.classes.get(theClass.getName());
    }

    private ArrayList getCachedMethods(Class theClass, String methodName) throws Exception {
        HashMap cachedClassMethods = this.getCachedClassMethods(theClass);
        if (!cachedClassMethods.containsKey(methodName)) {
            ArrayList signatures = new ArrayList();
            cachedClassMethods.put(methodName, signatures);
            return signatures;
        }
        return (ArrayList)cachedClassMethods.get(methodName);
    }

    public Method getSignature(Class theClass, String methodName, Class[] types) throws Exception {
        ArrayList signatures = this.getCachedMethods(theClass, methodName);
        Method m = null;
        int typesLength = 0;
        if (types != null) {
            typesLength = types.length;
        }
        int i = 0;
        while (i < signatures.size()) {
            m = (Method)signatures.get(i);
            Class<?>[] mTypes = m.getParameterTypes();
            if (mTypes.length == typesLength) {
                boolean match = true;
                int x = 0;
                while (x < mTypes.length) {
                    if (!mTypes[x].equals(types[x])) {
                        match = false;
                        break;
                    }
                    ++x;
                }
                if (match) {
                    return m;
                }
            }
            ++i;
        }
        m = MethodInvoker.getMethod(theClass, methodName, types);
        signatures.add(m);
        return m;
    }
}

