/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nl.ibs.jeelog.Log;
import nl.ibs.util.NameValuePair;

public abstract class PropertiesHelper {
    public static final String EOL = System.getProperty("line.separator");
    private static HashMap times = new HashMap();
    private static HashMap propertiesMap = new HashMap();

    public static List getPropertyList(String fileName) throws Exception {
        Properties properties = PropertiesHelper.getProperties(fileName);
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            list.add(new NameValuePair((String)entry.getKey(), (String)entry.getValue()));
        }
        return list;
    }

    public static Properties getProperties(String fileName) throws IOException {
        URL url = PropertiesHelper.class.getClassLoader().getResource(fileName);
        if (url == null) {
            throw new IOException("file_not_found: " + fileName);
        }
        File file = new File(URLDecoder.decode(url.getFile(), System.getProperty("file.encoding")));
        long time = file.lastModified();
        if (times.containsKey(url) && Long.parseLong((String)times.get(url)) == time) {
            return (Properties)propertiesMap.get(url);
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        propertiesMap.put(url, properties);
        times.put(url, "" + time);
        return properties;
    }

    public static String savePropertyList(List properties, String fileName) throws Exception {
        String message = null;
        FileOutputStream fos = null;
        try {
            try {
                URL url = PropertiesHelper.class.getClassLoader().getResource(fileName);
                fos = new FileOutputStream(URLDecoder.decode(url.getFile(), System.getProperty("file.encoding")));
                fos.write(PropertiesHelper.getBytes(properties));
            }
            catch (Exception e) {
                message = e.getMessage();
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return message;
    }

    public static byte[] getBytes(List properties) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (NameValuePair pair : properties) {
            String name = pair.getName();
            String value = pair.getValue();
            sb.append(name);
            sb.append('=');
            sb.append(value);
            sb.append(EOL);
        }
        if (Log.debug()) {
            Log.debug((String)sb.toString());
        }
        return sb.toString().getBytes();
    }
}

