/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.PrintObjectPageInputStream;
import com.ibm.as400.access.PrintObjectTransformedInputStream;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.SpooledFileList;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import nl.ibs.jeelog.Log;
import nl.ibs.util.SpooledFileInfo;

public class SpooledFileConverter {
    private static final byte LINEFEED = 10;
    private static final byte NEWLINE = 13;
    private static final byte NEWPAGE = 12;
    protected static final String STARS = "******************************************************************************";

    public static Collection getSpoolFileList(AS400 as400, String libname, String queuename) throws Exception {
        SpooledFileList splList = new SpooledFileList(as400);
        splList.setQueueFilter("/QSYS.LIB/" + libname + ".LIB/" + queuename + ".OUTQ");
        splList.setUserFilter("*ALL");
        return SpooledFileConverter.getSpoolFileList(splList);
    }

    public static Collection getSpoolFileList(AS400 as400, String user) throws Exception {
        SpooledFileList splList = new SpooledFileList(as400);
        splList.setUserFilter(user);
        return SpooledFileConverter.getSpoolFileList(splList);
    }

    public static Collection getSpoolFileList(SpooledFileList splList) throws Exception {
        ArrayList<SpooledFileInfo> splfiles = new ArrayList<SpooledFileInfo>();
        splList.openSynchronously();
        SpooledFileInfo splfInfo = null;
        Enumeration pol = splList.getObjects();
        while (pol.hasMoreElements()) {
            SpooledFile spooledFile = (SpooledFile)pol.nextElement();
            splfInfo = new SpooledFileInfo(spooledFile);
            splfiles.add(splfInfo);
        }
        return splfiles;
    }

    public static StringBuffer getLastPages(AS400 as400, SpooledFile splF, int numberOfPages) throws Exception {
        PrintParameterList printParms = new PrintParameterList();
        printParms.setParameter(-8, "/QSYS.LIB/QWPDEFAULT.WSCST");
        printParms.setParameter(65, "*WSCST");
        PrintObjectPageInputStream inStream = splF.getPageInputStream(printParms);
        int lastPage = splF.getIntegerAttribute(111);
        int page = lastPage - numberOfPages + 1;
        if (page <= 0) {
            page = lastPage;
        }
        StringBuffer sb = new StringBuffer();
        while (page <= lastPage) {
            inStream.selectPage(page);
            int avail = inStream.available();
            byte[] buf = new byte[avail + 1];
            while (avail > 0) {
                if (avail > buf.length) {
                    buf = new byte[avail + 1];
                }
                int read = inStream.read(buf, 0, avail);
                int x = 0;
                while (x < read) {
                    switch (buf[x]) {
                        case 0: {
                            break;
                        }
                        case 10: {
                            break;
                        }
                        case 13: {
                            sb.append('\n');
                            break;
                        }
                        case 12: {
                            break;
                        }
                        default: {
                            sb.append(SpooledFileConverter.byte2char(buf[x], "cp850"));
                        }
                    }
                    ++x;
                }
                avail = inStream.available();
            }
            ++page;
        }
        return sb;
    }

    public static StringBuffer cvtToText(SpooledFileInfo splFileInfo) throws Exception {
        PrintParameterList printParms = new PrintParameterList();
        printParms.setParameter(-8, "/QSYS.LIB/QWPDEFAULT.WSCST");
        printParms.setParameter(65, "*WSCST");
        PrintObjectTransformedInputStream inStream = splFileInfo.getSpooledFile().getTransformedInputStream(printParms);
        int avail = inStream.available();
        byte[] buf = new byte[avail];
        int read = 0;
        StringBuffer sb = new StringBuffer();
        while (avail > 0) {
            if (avail > buf.length) {
                buf = new byte[avail];
            }
            read = inStream.read(buf, 0, avail);
            int x = 0;
            while (x < read) {
                switch (buf[x]) {
                    case 0: {
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 13: {
                        sb.append('\n');
                        break;
                    }
                    case 12: {
                        break;
                    }
                    default: {
                        sb.append(SpooledFileConverter.byte2char(buf[x], "cp850"));
                    }
                }
                ++x;
            }
            avail = inStream.available();
        }
        inStream.close();
        splFileInfo.getSpooledFile().getSystem().disconnectService(1);
        return sb;
    }

    public static byte[] cvtToPdf(SpooledFileInfo splFileInfo) throws Exception {
        boolean portrait = SpooledFileConverter.getOrientation(splFileInfo.getPageRotation(), splFileInfo.getWidth(), splFileInfo.getCpi());
        return SpooledFileConverter.cvtToPdf(splFileInfo, portrait, null);
    }

    public static byte[] cvtToPdf(SpooledFileInfo splFileInfo, boolean portrait, byte[] contentUnder) throws Exception {
        Document doc = null;
        float pagewidth = splFileInfo.getWidth();
        float fontsize = SpooledFileConverter.getFontSize(portrait, pagewidth);
        float afterspacing = SpooledFileConverter.getAfterspacing(portrait, pagewidth, splFileInfo.getLen(), splFileInfo.getLpi());
        doc = portrait ? new Document(PageSize.A4, 0.0f, 0.0f, 10.0f, 0.0f) : new Document(PageSize.A4.rotate(), 10.0f, 10.0f, 0.0f, 10.0f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)baos);
        if (!portrait && contentUnder != null) {
            writer.setPageEvent((PdfPageEvent)new ContentUnderPageEvent(writer, new PdfReader(contentUnder), PageSize.A4.rotate()));
        }
        BaseFont bf = BaseFont.createFont((String)"Lucida Console.ttf", (String)"Cp1252", (boolean)false);
        Font font = new Font(bf, fontsize, 0);
        PrintParameterList printParms = new PrintParameterList();
        printParms.setParameter(-8, "/QSYS.LIB/QWPDEFAULT.WSCST");
        printParms.setParameter(65, "*WSCST");
        PrintObjectTransformedInputStream inStream = splFileInfo.getSpooledFile().getTransformedInputStream(printParms);
        int avail = inStream.available();
        byte[] buf = new byte[avail];
        int read = 0;
        StringBuffer sb = new StringBuffer();
        boolean firstPage = true;
        boolean skipPage = false;
        while (avail > 0) {
            if (avail > buf.length) {
                buf = new byte[avail];
            }
            read = inStream.read(buf, 0, avail);
            int x = 0;
            while (x < read) {
                switch (buf[x]) {
                    case 0: {
                        break;
                    }
                    case 10: {
                        sb.append('\n');
                        if (firstPage && sb.toString().startsWith(STARS)) {
                            skipPage = true;
                            Log.debug((String)"skip first page");
                        }
                        if (!skipPage) {
                            SpooledFileConverter.writeBuffer(doc, font, sb.toString(), afterspacing);
                        }
                        sb.setLength(0);
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 12: {
                        if (!skipPage) {
                            SpooledFileConverter.writeBuffer(doc, font, sb.toString(), 0.0f);
                            doc.newPage();
                        }
                        firstPage = false;
                        skipPage = false;
                        sb.setLength(0);
                        break;
                    }
                    default: {
                        sb.append(SpooledFileConverter.byte2char(buf[x], "cp850"));
                    }
                }
                ++x;
            }
            avail = inStream.available();
        }
        inStream.close();
        doc.close();
        splFileInfo.getSpooledFile().getSystem().disconnectService(1);
        doc = null;
        return baos.toByteArray();
    }

    protected static float getAfterspacing(boolean portrait, float pagewidth, float pagelen, float lpi) {
        if (portrait) {
            float myCPI = pagewidth / 8.0f;
            if (myCPI <= 10.0f) {
                return -(pagelen / 11.0f - lpi) - 1.0f;
            }
            if (myCPI <= 12.0f) {
                return -(pagelen / 11.0f - lpi) - 1.5f;
            }
            if (myCPI <= 15.0f) {
                return -(pagelen / 11.0f - lpi) - 1.0f;
            }
            return -(pagelen / 11.0f - lpi);
        }
        float myCPI = pagewidth / 11.0f;
        if (myCPI <= 10.0f) {
            return -(pagelen / 8.0f - lpi) - 1.0f;
        }
        if (myCPI <= 12.0f) {
            return -(pagelen / 8.0f - lpi) - 1.0f;
        }
        if (myCPI <= 15.0f) {
            return -(pagelen / 8.0f - lpi);
        }
        return -(pagelen / 8.0f - lpi) + 1.0f;
    }

    protected static float getFontSize(boolean portrait, float pagewidth) {
        if (portrait) {
            float myCPI = pagewidth / 8.0f;
            if (myCPI <= 10.0f) {
                return 10.0f;
            }
            if (myCPI <= 12.0f) {
                return 9.0f;
            }
            if (myCPI <= 15.0f) {
                return 8.0f;
            }
            return 7.0f;
        }
        float myCPI = pagewidth / 11.0f;
        if (myCPI <= 10.0f) {
            return 9.0f;
        }
        if (myCPI <= 12.0f) {
            return 8.0f;
        }
        if (myCPI <= 15.0f) {
            return 7.0f;
        }
        return 6.0f;
    }

    private static boolean getOrientation(int pageRotation, float pagewidth, float cpi) {
        if (pageRotation < 0) {
            float breedte = pagewidth / cpi;
            return (double)breedte <= 8.2;
        }
        return pageRotation == 90 || pageRotation == 270;
    }

    protected static char byte2char(byte b, String charsetName) throws Exception {
        byte[] bytes = new byte[]{b};
        return new String(bytes, charsetName).charAt(0);
    }

    protected static void writeBuffer(Document doc, Font font, String s, float afterspacing) throws Exception {
        Log.debug((String)s);
        if (!doc.isOpen()) {
            doc.open();
        }
        if (s.equals("\n")) {
            Paragraph p = new Paragraph(s, font);
            p.setSpacingAfter(afterspacing);
            doc.add((Element)p);
            return;
        }
        String[] poList = s.split("\n");
        int i = 0;
        while (i < poList.length) {
            Paragraph p = new Paragraph(String.valueOf(poList[i]) + '\n', font);
            p.setSpacingAfter(afterspacing);
            doc.add((Element)p);
            ++i;
        }
    }

    public static byte[] concatenatePdfs(byte[][] bytes) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document document = null;
        PdfCopy writer = null;
        int i = 0;
        while (i < bytes.length) {
            PdfReader reader = new PdfReader(bytes[i]);
            if (i == 0) {
                document = new Document(reader.getPageSizeWithRotation(1));
                writer = new PdfCopy(document, (OutputStream)baos);
                document.open();
                writer.addJavaScript("this.print(true);", false);
            }
            int j = 0;
            while (j < reader.getNumberOfPages()) {
                writer.addPage(writer.getImportedPage(reader, ++j));
            }
            ++i;
        }
        document.close();
        return baos.toByteArray();
    }

    private static class ContentUnderPageEvent
    extends PdfPageEventHelper {
        private PdfImportedPage page;
        private float top;
        private float right;

        public ContentUnderPageEvent(PdfWriter writer, PdfReader reader, Rectangle targetRectangle) throws Exception {
            Rectangle rectangle = reader.getPageSize(1);
            this.top = targetRectangle.getTop() - rectangle.getTop();
            this.right = targetRectangle.getRight() - rectangle.getRight();
            this.page = writer.getImportedPage(reader, 1);
        }

        public void onEndPage(PdfWriter writer, Document document) {
            PdfContentByte contentunder = writer.getDirectContentUnder();
            contentunder.saveState();
            contentunder.addTemplate((PdfTemplate)this.page, this.top / 2.0f, this.right / 2.0f);
            contentunder.restoreState();
        }
    }
}

