/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import com.ibm.as400.access.SpooledFile;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class SpooledFileInfo
implements Serializable {
    private static final long serialVersionUID = 495545872492817162L;
    private SpooledFile spooledFile;
    private String spoolfileName;
    private String jobUser;
    private String outQueue;
    private String outQueueLibrary;
    private String state;
    private Date date;
    private String sDate;
    private String time;
    private int pages;
    private int size;
    private int copies;
    private int splfNumber;
    private String jobName;
    private String jobNumber;
    private float pageLen;
    private float pageWidth;
    private float linesPerInch;
    private float charsPerInch;
    private int pageRotation;
    private int measurementMethod;
    private String formType;
    private String usrDefData;

    public SpooledFileInfo(SpooledFile spooledFile) throws Exception {
        this.spooledFile = spooledFile;
        this.spoolfileName = spooledFile.getName();
        this.jobName = spooledFile.getJobName();
        this.jobNumber = spooledFile.getJobNumber();
        this.jobUser = spooledFile.getJobUser();
        this.sDate = spooledFile.getCreateDate();
        this.setDate();
        this.time = spooledFile.getCreateTime();
        this.size = spooledFile.getIntegerAttribute(310) * spooledFile.getIntegerAttribute(311) / 1024;
        String qualifiedQueue = spooledFile.getStringAttribute(-6);
        int i = qualifiedQueue.lastIndexOf(47);
        this.outQueue = qualifiedQueue.substring(i + 1, qualifiedQueue.length() - ".OUTQ".length());
        this.outQueueLibrary = qualifiedQueue.substring("/QSYS.LIB/".length(), i - ".LIB".length());
        this.state = this.translateState(spooledFile.getStringAttribute(106));
        this.pages = spooledFile.getIntegerAttribute(111);
        this.copies = spooledFile.getIntegerAttribute(28);
        this.splfNumber = spooledFile.getIntegerAttribute(105);
        this.charsPerInch = spooledFile.getFloatAttribute(23).floatValue();
        this.linesPerInch = spooledFile.getFloatAttribute(64).floatValue();
        this.pageLen = spooledFile.getFloatAttribute(78).floatValue();
        this.pageWidth = spooledFile.getFloatAttribute(81).floatValue();
        this.pageRotation = spooledFile.getIntegerAttribute(36);
        this.formType = spooledFile.getStringAttribute(48);
        this.usrDefData = spooledFile.getStringAttribute(162);
    }

    private void setDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000 + Integer.parseInt(this.sDate.substring(1, 3)));
        cal.set(2, Integer.parseInt(this.sDate.substring(3, 5)) - 1);
        cal.set(5, Integer.parseInt(this.sDate.substring(5, 7)));
        this.date = cal.getTime();
    }

    private String translateState(String inState) {
        if (inState.compareTo("*HELD") == 0) {
            return "HLD";
        }
        if (inState.compareTo("*READY") == 0) {
            return "RDY";
        }
        if (inState.compareTo("*SAVED") == 0) {
            return "SAV";
        }
        if (inState.compareTo("*WRITING") == 0) {
            return "WTR";
        }
        return inState;
    }

    public SpooledFile getSpooledFile() {
        return this.spooledFile;
    }

    public String getJobNumber() {
        return this.jobNumber;
    }

    public String getJobName() {
        return this.jobName;
    }

    public int getSplfNumber() {
        return this.splfNumber;
    }

    public int getCopies() {
        return this.copies;
    }

    public String getOutQueue() {
        return this.outQueue;
    }

    public String getOutQueueLibrary() {
        return this.outQueueLibrary;
    }

    public int getPages() {
        return this.pages;
    }

    public String getSpoolfileName() {
        return this.spoolfileName;
    }

    public String getState() {
        return this.state;
    }

    public String getJobUser() {
        return this.jobUser;
    }

    public float getCpi() {
        return this.charsPerInch;
    }

    public float getLpi() {
        return this.linesPerInch;
    }

    public int getMeasurementMethod() {
        return this.measurementMethod;
    }

    public float getLen() {
        return this.pageLen;
    }

    public int getPageRotation() {
        return this.pageRotation;
    }

    public float getWidth() {
        return this.pageWidth;
    }

    public String getDateAsString() {
        return this.sDate;
    }

    public Date getDate() {
        return this.date;
    }

    public String getTime() {
        return String.valueOf(this.time.substring(0, 2)) + ":" + this.time.substring(2, 4) + ":" + this.time.substring(4, 6);
    }

    public int getSize() {
        return this.size;
    }

    public String getFormType() {
        return this.formType;
    }

    public String getUsrDefData() {
        return this.usrDefData;
    }
}

