/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import nl.ibs.util.Scrambler;
import nl.ibs.util.Scrambler2;
import nl.ibs.util.http.CorruptParameterException;

public abstract class DecodedURLParameters
implements Serializable {
    public static String PARM_UTF_8 = "UTF-8";
    public static String PARAMETER_ID = "dURLp";
    private static int shaker = 1;
    public static String SEPERATOR = ";";

    protected void decode(String codedParameters) throws ClassNotFoundException, IOException, CorruptParameterException {
        String unscrambledString = URLDecoder.decode(codedParameters, PARM_UTF_8);
        int i = 0;
        while (i < shaker) {
            unscrambledString = Scrambler.unscramble(unscrambledString);
            ++i;
        }
        String chk = unscrambledString.substring(0, unscrambledString.indexOf(SEPERATOR));
        long checksum = -1L;
        try {
            checksum = new Long(chk);
        }
        catch (NumberFormatException e) {
            throw new CorruptParameterException("DecodedURLParameters::decode - Checksum failed!!");
        }
        String x = unscrambledString.substring(unscrambledString.indexOf(SEPERATOR) + 1);
        if (checksum != this.calculateChecksum(x)) {
            throw new CorruptParameterException("DecodedURLParameters::decode - Checksum failed!!");
        }
        this.setDecodeData(x);
        this.validate();
    }

    protected void decode2(String codedParameters) throws ClassNotFoundException, IOException, CorruptParameterException {
        String unscrambledString = URLDecoder.decode(codedParameters, PARM_UTF_8);
        int i = 0;
        while (i < shaker) {
            unscrambledString = Scrambler2.unscramble(unscrambledString);
            ++i;
        }
        String chk = unscrambledString.substring(0, unscrambledString.indexOf(SEPERATOR));
        long checksum = -1L;
        try {
            checksum = new Long(chk);
        }
        catch (NumberFormatException e) {
            throw new CorruptParameterException("DecodedURLParameters::decode - Checksum failed!!");
        }
        String x = unscrambledString.substring(unscrambledString.indexOf(SEPERATOR) + 1);
        if (checksum != this.calculateChecksum(x)) {
            throw new CorruptParameterException("DecodedURLParameters::decode - Checksum failed!!");
        }
        this.setDecodeData(x);
        this.validate();
    }

    public String encode() throws IOException {
        String x = this.getEncodeData();
        long checksum = this.calculateChecksum(x);
        x = String.valueOf(checksum) + SEPERATOR + x;
        int i = 0;
        while (i < shaker) {
            x = Scrambler.scramble(x);
            ++i;
        }
        return String.valueOf(PARAMETER_ID) + "=" + URLEncoder.encode(x, PARM_UTF_8);
    }

    public String encodeSimple() throws IOException {
        String x = this.getEncodeData();
        long checksum = this.calculateChecksum(x);
        x = String.valueOf(checksum) + SEPERATOR + x;
        int i = 0;
        while (i < shaker) {
            x = Scrambler.scramble(x);
            ++i;
        }
        return x;
    }

    private long calculateChecksum(String x) throws IOException {
        Adler32 adler32 = new Adler32();
        CheckedInputStream cis = new CheckedInputStream(new ByteArrayInputStream(x.getBytes()), adler32);
        while (cis.read() != -1) {
        }
        return cis.getChecksum().getValue();
    }

    protected abstract String getEncodeData();

    protected abstract void setDecodeData(String var1);

    protected abstract void validate() throws CorruptParameterException;
}

