/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util.socket.requestdispatcher;

public class BrowserLauncher {
    private static final String WIN_ID = "Windows";
    private static final String MAC_ID = "Mac";
    private static final String LINUX_ID = "Linux";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";
    private static final int MAC = 0;
    private static final int LINUX = 1;
    private static final int UNIX = 2;
    private static final int WINDOWS = 3;

    public static Process displayURL(String url) throws Exception {
        String cmd = null;
        Process process = null;
        try {
            switch (BrowserLauncher.getPlatform()) {
                case 3: {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    process = Runtime.getRuntime().exec(cmd);
                    break;
                }
                case 0: {
                    String[] commandLine = new String[]{UNIX_PATH, url};
                    process = Runtime.getRuntime().exec(commandLine);
                }
                default: {
                    cmd = "netscape -remote openURL(" + url + ")";
                    process = Runtime.getRuntime().exec(cmd);
                    int exitCode = process.waitFor();
                    if (exitCode != 0) {
                        cmd = "netscape " + url;
                        process = Runtime.getRuntime().exec(cmd);
                    }
                    break;
                }
            }
        }
        catch (Exception x) {
            throw new Exception("Could not invoke browser, command=" + cmd + " Caught: " + x.getMessage());
        }
        return process;
    }

    public static int getPlatform() throws Exception {
        String os = System.getProperty("os.name");
        if (os == null) {
            throw new Exception("Unknown operating system");
        }
        if (os.startsWith(WIN_ID)) {
            return 3;
        }
        if (os.startsWith(MAC_ID)) {
            return 0;
        }
        if (os.startsWith(LINUX_ID)) {
            return 1;
        }
        return 2;
    }

    public static void main(String[] args) {
        try {
            BrowserLauncher.displayURL("www.ibs.nl");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }
}

