/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util.socket.requestdispatcher;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import nl.ibs.util.socket.requestdispatcher.BrowserLauncher;
import nl.ibs.util.socket.requestdispatcher.ExternalRequest;
import nl.ibs.util.socket.requestdispatcher.RequestDispatcherListener;

public class RequestDispatcher
extends Thread {
    public static final char EOT = '\u00ff';
    private static final String STOP_SOCKET_SERVER = "Manual stop request received!";
    boolean handleRequests = true;
    String userId = null;
    String password = null;
    String responseHost = null;
    String requestEnhancementEncoded = null;
    String codeBase = "";
    ServerSocket serverSocket = null;
    Socket clientSocket = null;
    PrintStream outputStream = null;
    DataInputStream inputStream = null;
    RequestDispatcherListener listener = null;
    int requestPort = 2000;
    int answerPort = 2001;

    public RequestDispatcher(String userId, String password) throws Exception {
        this.initialize(userId, password);
    }

    public RequestDispatcher(String userId, String password, int requestPort) throws Exception {
        this.requestPort = requestPort;
        this.initialize(userId, password);
    }

    public RequestDispatcher(String userId, String password, int requestPort, int answerPort) throws Exception {
        this.requestPort = requestPort;
        this.answerPort = answerPort;
        this.initialize(userId, password);
    }

    private void initialize(String userId, String password) throws Exception {
        this.userId = userId;
        this.password = password;
        this.responseHost = InetAddress.getLocalHost().getHostAddress();
    }

    public void run() {
        try {
            this.serverSocket = new ServerSocket(this.requestPort);
            if (this.listener != null) {
                this.listener.started();
            }
            this.startPortListener();
            while (this.handleRequests) {
                this.handleRequest();
            }
        }
        catch (Exception e) {
            this.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private void handleRequest() throws Exception {
        try {
            String request = this.getRequest();
            String requestPart1 = request.substring(0, request.indexOf("requestData=") + 12);
            String xml = request.substring(request.indexOf("requestData=") + 12);
            this.show("Request: " + request);
            if (request.startsWith("http")) {
                request = this.enhanceRequest(requestPart1);
                this.reply(this.getAnswer(request, xml).toString());
            } else if (!request.startsWith(STOP_SOCKET_SERVER)) {
                request = this.createPage("Request ", request);
                this.reply(this.getAnswer(request, xml).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reply("Error=" + e.getMessage());
        }
    }

    private String getAnswer(String request, String xml) throws Exception {
        ServerSocket browserServerSocket = null;
        Socket browserSocket = null;
        Process process = BrowserLauncher.displayURL(request);
        process.waitFor();
        if (this.listener != null) {
            this.listener.startWaitForReply();
        }
        browserServerSocket = new ServerSocket(this.getAnswerPort());
        browserSocket = browserServerSocket.accept();
        DataOutputStream outputStream = new DataOutputStream(browserSocket.getOutputStream());
        outputStream.writeBytes(String.valueOf(xml.trim()) + '\u00ff');
        outputStream.flush();
        browserServerSocket.close();
        browserServerSocket = new ServerSocket(this.getAnswerPort());
        browserSocket = browserServerSocket.accept();
        DataInputStream browserInputStream = new DataInputStream(browserSocket.getInputStream());
        String answer = RequestDispatcher.readInputStream(browserInputStream);
        browserInputStream.close();
        outputStream.close();
        browserServerSocket.close();
        if (this.listener != null) {
            this.listener.replyReceived();
        }
        return answer;
    }

    private void startPortListener() throws Exception {
        this.clientSocket = this.serverSocket.accept();
        this.outputStream = new PrintStream(this.clientSocket.getOutputStream());
        this.inputStream = new DataInputStream(this.clientSocket.getInputStream());
    }

    private String getRequest() throws Exception {
        String answer;
        try {
            answer = RequestDispatcher.readInputStream(this.inputStream);
        }
        catch (Exception e) {
            this.startPortListener();
            return this.getRequest();
        }
        return answer;
    }

    private void reply(String data) throws Exception {
        this.show("Answer :" + data);
        this.outputStream.print(String.valueOf(data.trim()) + '\u00ff');
        this.outputStream.flush();
    }

    public void abortCurrentClientWait(String abortMessage) {
        try {
            RequestDispatcher.sendRequestAnswer(abortMessage, this.responseHost, this.answerPort);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.show("Error during abort request!");
        }
    }

    public static String readInputStream(DataInputStream inputStream) throws Exception {
        StringBuffer answer = new StringBuffer();
        int bufferSize = 300;
        byte[] b = new byte[bufferSize];
        int bytesRead = inputStream.read(b);
        int lastChar = 0;
        while (bytesRead == -1) {
            Thread.currentThread().wait(100L);
            bytesRead = inputStream.read(b);
        }
        while (bytesRead != -1) {
            String s = new String(b, 0, bytesRead);
            answer.append(s);
            lastChar = answer.length() - 1;
            if (answer.charAt(lastChar) == '\u00ff') {
                return answer.substring(0, lastChar);
            }
            bytesRead = inputStream.read(b);
        }
        return answer.toString();
    }

    private String createPage(String label, String request) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(label) + ": " + request + " <INPUT NAME=\"text1\" TYPE=Text>\n");
        sb.append("<INPUT NAME=\"submit\" TYPE=Button VALUE=\"Send\" onClick=\"sendData(form.text1.value)\">\n");
        return this.createPage(sb.toString());
    }

    private String createPage(String dynamicContent) throws Exception {
        String fName = "start.html";
        File f = new File(fName);
        FileWriter fos = new FileWriter(f);
        fos.write("<HTML><HEAD><TITLE>Fac socket server</TITLE></HEAD>\n");
        fos.write("<SCRIPT LANGUAGE=\"JavaScript\" ID=\"Ex1\">\n");
        fos.write("<!--\n");
        fos.write("function sendData(data) {\n");
        fos.write("    document.sokApp.send(data,\"" + this.responseHost + "\"," + this.answerPort + ");\n ");
        fos.write("    window.opener=null;\n");
        fos.write("    window.close();\n");
        fos.write("}\n");
        fos.write("function checkClose() {\n");
        fos.write("     // document.sokApp.send(\"checkClose\",\"" + this.responseHost + "\"," + this.answerPort + ");\n ");
        fos.write(" //   if (self.closed) {\n ");
        fos.write("      document.sokApp.send(\"AUTO_REPLY\",\"" + this.responseHost + "\"," + this.answerPort + ");\n ");
        fos.write(" //   }\n");
        fos.write("}\n");
        fos.write("//-->\n");
        fos.write("</SCRIPT>\n");
        fos.write("\n");
        fos.write("</HEAD>\n ");
        fos.write("<BODY  onunload=\"checkClose()\" Bgcolor= \"#FFFBE7\">\n ");
        fos.write("<FORM>\n");
        fos.write(dynamicContent);
        String archive = "";
        String theCodeBase = "";
        if (this.codeBase.trim().equals("")) {
            archive = " ARCHIVE = 'RequestDispatcher.jar' ";
        } else {
            theCodeBase = " codeBase = '" + this.codeBase + "' ";
        }
        fos.write("<applet " + theCodeBase + " code=\"nl.ibs.util.socket.requestdispatcher.RequestDispatcherAnswerApplet\" name=sokApp MAYSCRIPT " + archive + " WIDTH = \"100%\" HEIGHT = \"10%\">\n");
        fos.write("</applet>\n");
        fos.write("</FORM>\n");
        fos.write("</BODY>\n");
        fos.write("</HTML>\n");
        fos.flush();
        fos.close();
        return f.getAbsolutePath();
    }

    public static void sendRequestAnswer(String text, String host, int port) throws Exception {
        if (host == null || host.trim().equals("")) {
            host = "localhost";
        }
        Socket socket = new Socket(host, port);
        DataOutputStream outputStream = new DataOutputStream(socket.getOutputStream());
        if (socket == null || outputStream == null) {
            throw new Exception("Socket Initialisation error");
        }
        outputStream.writeBytes(text);
        outputStream.close();
        socket.close();
    }

    public int getAnswerPort() {
        return this.answerPort;
    }

    public int getRequestPort() {
        return this.requestPort;
    }

    private String enhanceRequest(String request) throws Exception {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(request, "?&", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int indexOfiz = token.indexOf(61);
            if (indexOfiz == -1 || !token.substring(0, indexOfiz).toLowerCase().equals("requestdata")) {
                sb.append(token);
                continue;
            }
            sb.append(new ExternalRequest(this.userId, this.password, this.responseHost, this.answerPort, "").encode());
        }
        return sb.toString();
    }

    private void show(String text) {
        if (this.listener == null) {
            System.out.println(text);
        } else {
            this.listener.log(text);
        }
    }

    private void error(String text) {
        if (this.listener == null) {
            System.out.println(text);
        } else {
            this.listener.socketError(text);
        }
    }

    public void setListener(RequestDispatcherListener listener) {
        this.listener = listener;
    }

    public void stopRunning() {
        this.handleRequests = false;
        try {
            Socket socket = new Socket(this.responseHost, this.requestPort);
            if (socket == null) {
                throw new Exception("Initialisation error in RequestDispatcherTester");
            }
            DataOutputStream outputStream = new DataOutputStream(socket.getOutputStream());
            outputStream.writeBytes("Manual stop request received!\u00ff");
            outputStream.flush();
            socket.close();
            if (this.listener != null) {
                this.listener.stopped();
            }
        }
        catch (UnknownHostException e) {
            this.show("Can't connect to host to stop:" + this.responseHost);
            e.printStackTrace();
        }
        catch (IOException e) {
            this.show("Couldn't get I/O for the connection to: " + this.responseHost);
            e.printStackTrace();
        }
        catch (Exception e) {
            this.show("Error while stopping requestDispatcher: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getCodeBase() {
        return this.codeBase;
    }

    public void setCodeBase(String codeBase) {
        this.codeBase = codeBase;
    }
}

