/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jeelog;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import nl.ibs.jeelog.Logger;
import nl.ibs.jeelog.Type;

public class Log {
    private static InheritableThreadLocal threadLocale = new InheritableThreadLocal();
    public static final int OFF = -1;
    public static final int ERROR = 0;
    public static final int WARN = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static char[] blancs = new char[255];
    private static List logLine;
    public static boolean callStackNeeded;
    public static boolean classLevelSelection;
    public static boolean threadLocalSelection;
    public static int debugLevel;
    public static boolean PrintErrorStackTrace;
    public static ArrayList includePaths;
    public static ArrayList excludePaths;
    public static ArrayList includeThreadLocals;
    public static ArrayList excludeThreadLocals;
    public static Properties prop;
    private static FileListener fileListener;
    private static File file;
    private static boolean reloadProperties;
    private static boolean currentSettingsLoadedFromFile;
    private static int stackLevel;
    private static Logger defaultLogger;
    private static Logger logger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        int x = 0;
        while (x < blancs.length) {
            Log.blancs[x] = 32;
            ++x;
        }
        logLine = new ArrayList();
        callStackNeeded = false;
        classLevelSelection = false;
        threadLocalSelection = false;
        debugLevel = 0;
        PrintErrorStackTrace = true;
        includePaths = new ArrayList();
        excludePaths = new ArrayList();
        includeThreadLocals = new ArrayList();
        excludeThreadLocals = new ArrayList();
        prop = new Properties();
        reloadProperties = true;
        currentSettingsLoadedFromFile = false;
        stackLevel = 4;
        logger = defaultLogger = new Logger(){

            public void error(String message) {
                System.err.println(message);
            }

            public void out(String message) {
                System.out.println(message);
            }
        };
        Log.buildLogLineDefinitionArray("[%{MESSAGETYPE}%] %{TIME}% - %{METHOD_COMPACT2}%: %{MESSAGE}%");
        Log.load();
    }

    private static void load() {
        InputStream ip;
        debugLevel = 2;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("nl.ibs.jeelog.Log");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ip = clazz.getClassLoader().getResourceAsStream("jeeLog.properties")) == null) {
            Log.log("No \"jeeLog.properties\" found. Log class wil use default values");
            reloadProperties = false;
        } else {
            try {
                prop.load(ip);
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("nl.ibs.jeelog.Log");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                file = new File(clazz2.getClassLoader().getResource("jeeLog.properties").getFile());
                Log.load(prop);
                reloadProperties = false;
                currentSettingsLoadedFromFile = true;
            }
            catch (Exception e) {
                Log.log("Problem loading jeeLog.properties");
            }
        }
    }

    public static boolean dynamicReloadingActive() {
        return fileListener != null;
    }

    public static boolean currentSettingsLoadedFromFile() {
        return currentSettingsLoadedFromFile;
    }

    public static void setProperties(Properties prop) {
        Log.log("load properties");
        prop.remove("Wait");
        Log.load(prop);
        currentSettingsLoadedFromFile = false;
        reloadProperties = false;
    }

    public static void setThreadLocale(Object value) {
        threadLocale.set(value);
    }

    public static Object getThreadLocale(Object value) {
        return threadLocale.get();
    }

    public static void setConsole(Object _object) throws NoSuchMethodException {
        logger = defaultLogger;
        if (_object != null) {
            logger = new ConsoleLogger(_object);
        }
    }

    public void setLogger(Logger _logger) {
        logger = _logger != null ? _logger : defaultLogger;
    }

    private static void load(Properties prop) {
        String next;
        block17: {
            String wait = prop.getProperty("Wait", "").trim();
            if (!wait.equals("") && file != null && file.exists()) {
                try {
                    long w = Long.parseLong(wait);
                    if (fileListener == null) {
                        fileListener = new FileListener(file, w);
                        break block17;
                    }
                    Log.fileListener.wait = w;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (fileListener != null) {
                fileListener.stop();
                fileListener = null;
            }
        }
        String _debugLevel = prop.getProperty("InfoLevel", "ERROR").trim();
        callStackNeeded = false;
        classLevelSelection = false;
        threadLocalSelection = false;
        if (_debugLevel.equalsIgnoreCase("OFF")) {
            debugLevel = -1;
        }
        if (_debugLevel.equalsIgnoreCase("ERROR")) {
            debugLevel = 0;
        }
        if (_debugLevel.equalsIgnoreCase("WARN")) {
            debugLevel = 1;
        }
        if (_debugLevel.equalsIgnoreCase("INFO")) {
            debugLevel = 2;
        }
        if (_debugLevel.equalsIgnoreCase("DEBUG")) {
            debugLevel = 3;
        }
        PrintErrorStackTrace = !prop.getProperty("PrintErrorStackTrace", "TRUE").trim().equalsIgnoreCase("FALSE");
        Log.buildLogLineDefinitionArray(prop.getProperty("LineDefinition", "[%{MESSAGETYPE}%\t] [%{TIMESTAMP}%] - %{MESSAGE}%"));
        StringTokenizer includesClasses = new StringTokenizer(prop.getProperty("IncludePathList", ""), ";");
        StringTokenizer excludesClasses = new StringTokenizer(prop.getProperty("ExcludePathList", ""), ";");
        StringTokenizer includesThreadLocals = new StringTokenizer(prop.getProperty("IncludeThreadLocalList", ""), ";");
        StringTokenizer excludesThreadLocals = new StringTokenizer(prop.getProperty("ExcludeThreadLocalList", ""), ";");
        includePaths.clear();
        excludePaths.clear();
        includeThreadLocals.clear();
        excludeThreadLocals.clear();
        while (includesClasses.hasMoreTokens()) {
            next = includesClasses.nextToken();
            if (next.equals("")) continue;
            includePaths.add(next);
        }
        while (excludesClasses.hasMoreTokens()) {
            next = excludesClasses.nextToken();
            if (next.equals("")) continue;
            excludePaths.add(next);
        }
        while (includesThreadLocals.hasMoreTokens()) {
            next = includesThreadLocals.nextToken();
            if (next.equals("")) continue;
            includeThreadLocals.add(next);
        }
        while (excludesThreadLocals.hasMoreTokens()) {
            next = excludesThreadLocals.nextToken();
            if (next.equals("")) continue;
            excludeThreadLocals.add(next);
        }
        if (includePaths.size() > 0 || excludePaths.size() > 0) {
            classLevelSelection = true;
            callStackNeeded = true;
        }
        if (includeThreadLocals.size() > 0 || excludeThreadLocals.size() > 0) {
            threadLocalSelection = true;
        }
    }

    public static void buildLogLineDefinitionArray(String lineDefinition) {
        logLine.clear();
        while (true) {
            int x;
            if ((x = lineDefinition.indexOf("%{")) < 0) {
                logLine.add(new Type(lineDefinition));
                break;
            }
            int y = lineDefinition.indexOf("}%", x);
            if (y < 0) break;
            if (x != 0) {
                logLine.add(new Type(lineDefinition.substring(0, x)));
            }
            String lineItem = lineDefinition.substring(x + 2, y).trim();
            lineDefinition = lineDefinition.substring(y + 2);
            if (lineItem.equalsIgnoreCase("CLASS")) {
                logLine.add(new Type(4));
                callStackNeeded = true;
                continue;
            }
            if (lineItem.equalsIgnoreCase("DATE")) {
                logLine.add(new Type(1));
                continue;
            }
            if (lineItem.equalsIgnoreCase("MESSAGE")) {
                logLine.add(new Type(6));
                continue;
            }
            if (lineItem.equalsIgnoreCase("MESSAGETYPE")) {
                logLine.add(new Type(7));
                continue;
            }
            if (lineItem.equalsIgnoreCase("METHOD")) {
                logLine.add(new Type(5));
                callStackNeeded = true;
                continue;
            }
            if (lineItem.equalsIgnoreCase("TIME")) {
                logLine.add(new Type(2));
                continue;
            }
            if (lineItem.equalsIgnoreCase("TIMESTAMP")) {
                logLine.add(new Type(3));
                continue;
            }
            if (lineItem.equalsIgnoreCase("THREAD")) {
                logLine.add(new Type(12));
                continue;
            }
            if (lineItem.equalsIgnoreCase("THREAD_LOCAL")) {
                logLine.add(new Type(14));
                continue;
            }
            if (lineItem.equalsIgnoreCase("CLASS")) {
                logLine.add(new Type(4));
                callStackNeeded = true;
                continue;
            }
            if (lineItem.equalsIgnoreCase("CLASS_COMPACT")) {
                logLine.add(new Type(9));
                callStackNeeded = true;
                continue;
            }
            if (lineItem.equalsIgnoreCase("TIME_MS")) {
                logLine.add(new Type(8));
                continue;
            }
            if (lineItem.equalsIgnoreCase("METHOD_COMPACT1")) {
                logLine.add(new Type(10));
                callStackNeeded = true;
                continue;
            }
            if (!lineItem.equalsIgnoreCase("METHOD_COMPACT2")) continue;
            logLine.add(new Type(11));
            callStackNeeded = true;
        }
    }

    public static boolean error() {
        return debugLevel >= 0 && Log.logable(0);
    }

    public static boolean warn() {
        return debugLevel >= 1 && Log.logable(1);
    }

    public static boolean info() {
        return debugLevel >= 2 && Log.logable(2);
    }

    public static boolean debug() {
        return debugLevel >= 3 && Log.logable(3);
    }

    private static boolean logable(int level) {
        if (threadLocalSelection && level > 0 && !Log.threadLocalSelected()) {
            return false;
        }
        if (classLevelSelection) {
            try {
                StringWriter sw = new StringWriter();
                new Throwable().printStackTrace(new PrintWriter(sw));
                String callStack = sw.toString();
                if (!Log.getInfo(Log.getClassName(callStack))) {
                    return false;
                }
            }
            catch (Exception e) {
                return level == 0;
            }
        }
        return true;
    }

    private static boolean log(int level, String type, String message) {
        String callStack;
        block13: {
            if (threadLocalSelection && level > 0 && !Log.threadLocalSelected()) {
                return false;
            }
            callStack = null;
            try {
                if (callStackNeeded) {
                    StringWriter sw = new StringWriter();
                    new Throwable().printStackTrace(new PrintWriter(sw));
                    callStack = sw.toString();
                }
                if (!classLevelSelection || Log.getInfo(Log.getClassName(callStack))) break block13;
                return false;
            }
            catch (Exception e) {
                String msg = String.valueOf(type) + ": " + message;
                if (level == 0) {
                    if (logger != null) {
                        logger.error(msg);
                    } else {
                        System.err.println(msg);
                    }
                } else if (logger != null) {
                    logger.out(msg);
                } else {
                    System.out.println(msg);
                }
                return true;
            }
        }
        if (level == 0) {
            Log.error(type, callStack, message);
        } else {
            Log.out(type, callStack, message);
        }
        return true;
    }

    public static void error(Exception e) {
        if (debugLevel < 0) {
            return;
        }
        if (Log.log(0, "ERROR", Log.getMessage(e)) && PrintErrorStackTrace) {
            Throwable t = e;
            while (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)e).getTargetException();
            }
            t.printStackTrace();
        }
    }

    public static void error(String message) {
        if (debugLevel >= 0) {
            Log.log(0, "ERROR", message);
        }
    }

    public static void warn(String message) {
        if (debugLevel >= 1) {
            Log.log(1, "WARN", message);
        }
    }

    public static void info(String message) {
        if (debugLevel >= 2) {
            Log.log(2, "INFO", message);
        }
    }

    public static void debug(String message) {
        if (debugLevel >= 3) {
            Log.log(3, "DEBUG", message);
        }
    }

    private static void out(String type, String callStack, String message) {
        Log.write(type, callStack, message, false);
    }

    private static void error(String type, String callStack, String message) {
        Log.write(type, callStack, message, true);
    }

    private static synchronized void write(String messagetype, String callStack, String message, boolean error) {
        if (reloadProperties) {
            Log.load();
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = logLine.iterator();
        Throwable ex = null;
        block48: while (iterator.hasNext()) {
            Type typeObj = (Type)iterator.next();
            int type = typeObj.getType();
            switch (type) {
                case 0: {
                    try {
                        buffer.append(typeObj.getString());
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 6: {
                    try {
                        buffer.append(message);
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 7: {
                    try {
                        buffer.append(messagetype);
                        buffer.append(String.copyValueOf(blancs, 0, Math.max(0, 7 - messagetype.length())));
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 3: {
                    String ts;
                    try {
                        ts = new Timestamp(System.currentTimeMillis()).toString();
                        buffer.append(ts);
                        buffer.append(String.copyValueOf(blancs, 0, Math.max(0, 21 - ts.length())));
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 12: {
                    String ts;
                    try {
                        ts = Thread.currentThread().getName();
                        buffer.append(ts);
                        buffer.append(String.copyValueOf(blancs, 0, Math.max(0, 11 - ts.length())));
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 14: {
                    try {
                        Object o = threadLocale.get();
                        String ts = o == null ? "" : String.valueOf(o);
                        buffer.append(ts);
                        buffer.append(String.copyValueOf(blancs, 0, Math.max(0, 11 - ts.length())));
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 1: {
                    try {
                        buffer.append(new Date(System.currentTimeMillis()).toString());
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 2: {
                    try {
                        String tm = new Time(System.currentTimeMillis()).toString();
                        buffer.append(tm);
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 4: {
                    try {
                        buffer.append(Log.getClassName(callStack));
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 5: {
                    try {
                        buffer.append(Log.getMethodInfo(callStack));
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 10: {
                    String md;
                    try {
                        md = Log.getMethodInfo(callStack);
                        int x = md.indexOf(":");
                        buffer.append(String.valueOf(md.substring(0, md.indexOf("(") + 1)) + (x > 0 ? md.substring(x + 1) : ")"));
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 11: {
                    String md;
                    try {
                        md = Log.getMethodInfo(callStack);
                        String cn = Log.getClassName(callStack);
                        String cnc = cn.lastIndexOf(46) < 0 ? cn : cn.substring(cn.lastIndexOf(46) + 1);
                        int x = md.indexOf(":");
                        String mdc1 = String.valueOf(md.substring(0, md.indexOf("(") + 1)) + (x > 0 ? md.substring(x + 1) : ")");
                        String mdc2 = mdc1.substring(mdc1.indexOf(cnc));
                        buffer.append(mdc2);
                        buffer.append(String.copyValueOf(blancs, 0, Math.max(0, 40 - mdc2.length())));
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 9: {
                    try {
                        String cn = Log.getClassName(callStack);
                        buffer.append(cn.lastIndexOf(46) < 0 ? cn : cn.substring(cn.lastIndexOf(46) + 1));
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                    continue block48;
                }
                case 8: {
                    String ts;
                    try {
                        ts = new Timestamp(System.currentTimeMillis()).toString();
                        String tsms = ts.substring(ts.indexOf(32) + 1);
                        buffer.append(tsms);
                        buffer.append(String.copyValueOf(blancs, 0, 12 - tsms.length()));
                        break;
                    }
                    catch (Exception e) {
                        if (ex != null) break;
                        ex = e;
                    }
                }
            }
        }
        if (ex != null) {
            try {
                int x;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("nl.ibs.jeelog.Log");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String name = clazz.getName();
                if (callStack != null && (x = callStack.lastIndexOf(name)) > -1 && (x = callStack.indexOf("\n", x)) > -1 && (x = callStack.indexOf("\n", x)) > -1) {
                    buffer.append(callStack.substring(x));
                    ex = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (error) {
            logger.error(buffer.toString());
        } else {
            logger.out(buffer.toString());
        }
        if (ex != null && error) {
            ex.printStackTrace();
        }
    }

    private static String getMethodInfo(String callStack) {
        StringTokenizer tk = new StringTokenizer(callStack, "\n");
        String str = " ";
        int x = 0;
        while (tk.hasMoreTokens() && x++ < stackLevel) {
            str = tk.nextToken();
        }
        while ((str = str.replace('/', '.')).indexOf("nl.ibs.jeelog.Log") >= 0 && tk.hasMoreTokens()) {
            str = tk.nextToken();
        }
        x = (str = str.trim()).indexOf(41);
        if (x > 0) {
            str = str.substring(0, x + 1);
        }
        if ((x = str.indexOf(46)) > 0 && (x = str.lastIndexOf(32, x)) > 0) {
            str = str.substring(x + 1);
        }
        return str;
    }

    private static String getClassName(String callStack) {
        String methodInfo = Log.getMethodInfo(callStack);
        int x = methodInfo.lastIndexOf("(");
        if (x < 0) {
            x = methodInfo.lastIndexOf(" ");
        }
        if (x < 0) {
            x = methodInfo.length();
        }
        String className = methodInfo.substring(0, methodInfo.lastIndexOf(".", x));
        return className;
    }

    private static boolean getInfo(String className) {
        int i;
        if (reloadProperties) {
            return true;
        }
        if (includePaths.size() > 0) {
            boolean include = false;
            i = 0;
            while (i < includePaths.size()) {
                if (className.startsWith((String)includePaths.get(i))) {
                    include = true;
                    break;
                }
                ++i;
            }
            if (!include) {
                return false;
            }
        }
        if (excludePaths.size() > 0) {
            boolean exclude = false;
            i = 0;
            while (i < excludePaths.size()) {
                if (className.startsWith((String)excludePaths.get(i))) {
                    exclude = true;
                    break;
                }
                ++i;
            }
            if (exclude) {
                return false;
            }
        }
        return true;
    }

    private static boolean threadLocalSelected() {
        int i;
        String tl;
        if (reloadProperties) {
            return true;
        }
        Object o = threadLocale.get();
        if (includeThreadLocals.size() > 0) {
            if (o == null) {
                return false;
            }
            boolean include = false;
            tl = String.valueOf(o);
            i = 0;
            while (i < includeThreadLocals.size()) {
                if (tl.startsWith((String)includeThreadLocals.get(i))) {
                    include = true;
                    break;
                }
                ++i;
            }
            if (!include) {
                return false;
            }
        }
        if (excludeThreadLocals.size() > 0) {
            if (o == null) {
                return true;
            }
            boolean exclude = false;
            tl = String.valueOf(o);
            i = 0;
            while (i < excludeThreadLocals.size()) {
                if (tl.startsWith((String)excludeThreadLocals.get(i))) {
                    exclude = true;
                    break;
                }
                ++i;
            }
            if (exclude) {
                return false;
            }
        }
        return true;
    }

    private static void log(String message) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = logLine.iterator();
        block23: while (iterator.hasNext()) {
            Type typeObj = (Type)iterator.next();
            int type = typeObj.getType();
            switch (type) {
                case 0: {
                    try {
                        buffer.append(typeObj.getString());
                    }
                    catch (Exception exception) {}
                    continue block23;
                }
                case 6: {
                    try {
                        buffer.append(message);
                    }
                    catch (Exception exception) {}
                    continue block23;
                }
                case 7: {
                    try {
                        buffer.append("LOG");
                    }
                    catch (Exception exception) {}
                    continue block23;
                }
                case 3: {
                    String ts2;
                    try {
                        ts2 = new Timestamp(System.currentTimeMillis()).toString();
                        buffer.append(ts2);
                        buffer.append(String.copyValueOf(blancs, 0, Math.max(0, 21 - ts2.length())));
                    }
                    catch (Exception ts2) {}
                    continue block23;
                }
                case 1: {
                    try {
                        buffer.append(new Date(System.currentTimeMillis()).toString());
                    }
                    catch (Exception ts2) {}
                    continue block23;
                }
                case 2: {
                    try {
                        String tm = new Time(System.currentTimeMillis()).toString();
                        buffer.append(tm);
                    }
                    catch (Exception tm) {}
                    continue block23;
                }
                case 8: {
                    String ts2;
                    try {
                        ts2 = new Timestamp(System.currentTimeMillis()).toString();
                        String tsms = ts2.substring(ts2.indexOf(32) + 1);
                        buffer.append(tsms);
                        buffer.append(String.copyValueOf(blancs, 0, 12 - tsms.length()));
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        logger.out(buffer.toString());
    }

    private static String getShortClassName(Object obj) {
        String path = obj.getClass().getName();
        int x = path.lastIndexOf(46);
        if (x == -1) {
            return path;
        }
        return path.substring(x + 1);
    }

    private static String getMessage(Exception e) {
        return String.valueOf(Log.getShortClassName(e)) + ": " + e.getMessage();
    }

    static /* synthetic */ boolean access$0() {
        return reloadProperties;
    }

    static class FileListener
    implements Runnable {
        private File file;
        private long lastmodified = 0L;
        public long wait;
        public boolean active = true;

        public FileListener(File _file, long _wait) {
            this.file = _file;
            this.wait = _wait;
            Thread listener = new Thread(this);
            listener.setDaemon(true);
            listener.start();
        }

        public void stop() {
            this.active = false;
        }

        public void run() {
            Log.info("Start listening on file " + this.file.getPath() + " for changes every " + this.wait + " milliseconds.");
            while (Thread.currentThread().isAlive() && this.active) {
                if (this.file.lastModified() > this.lastmodified) {
                    if (this.lastmodified != 0L) {
                        Log.info("File " + this.file.getPath() + " changed.");
                        reloadProperties = true;
                        debugLevel = 3;
                    }
                    this.lastmodified = this.file.lastModified();
                }
                try {
                    Thread.sleep(this.wait);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Log.info("End listening on file " + this.file.getPath() + " for changes");
        }
    }

    static class ConsoleLogger
    implements Logger {
        private Object[] msg = new Object[1];
        private static Class[] parameterTypes;
        Method toError;
        Method toConsole;
        Object console;

        static {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            parameterTypes = classArray;
        }

        public ConsoleLogger(Object obj) throws NoSuchMethodException {
            this.console = obj;
            this.toConsole = obj.getClass().getMethod("toConsole", parameterTypes);
            this.toError = obj.getClass().getMethod("toError", parameterTypes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void error(String message) {
            Object[] objectArray = this.msg;
            synchronized (this.msg) {
                this.msg[0] = message;
                try {
                    this.toError.invoke(this.console, this.msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void out(String message) {
            Object[] objectArray = this.msg;
            synchronized (this.msg) {
                this.msg[0] = message;
                try {
                    this.toConsole.invoke(this.console, this.msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
        }
    }
}

