/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCNClobLocator;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.AS400JDBCSQLXMLLocator;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLClobLocator
implements SQLLocator {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private SQLConversionSettings settings_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private int truncated_;
    private boolean outOfBounds_;
    private int columnIndex_;
    private String value_;
    private String savedValue_;
    private Object savedObject_;
    private int scale_;
    private boolean savedObjectWrittenToServer_ = false;

    SQLClobLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3) {
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.locator_ = new JDLobLocator(aS400JDBCConnection, n, n2, false);
        this.maxLength_ = n2;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.settings_ = sQLConversionSettings;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
    }

    public Object clone() {
        return new SQLClobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    public void setHandle(int n) {
        this.locator_.setHandle(n);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    public int getHandle() {
        return this.locator_.getHandle();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.convertFromRawBytes(byArray, n, convTable, false);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (!this.savedObjectWrittenToServer_ && this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    public void validateRawTruncatedData(byte[] byArray, int n, ConvTable convTable) {
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            String string = (String)object;
            int n2 = string.length();
            this.truncated_ = n2 > this.maxLength_ ? n2 - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (!(object instanceof Reader || object instanceof InputStream || object instanceof Clob || object instanceof SQLXML)) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.savedObjectWrittenToServer_ = false;
        if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        Object object;
        int n = this.scale_;
        if (n == -1) {
            try {
                n = (int)this.locator_.getLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object2 = this.savedObject_;
        if (this.savedObject_ instanceof String) {
            this.value_ = (String)object2;
        } else if (object2 instanceof Reader) {
            this.value_ = SQLDataBase.getStringFromReader((Reader)object2, n, this);
            this.savedObject_ = this.value_;
        } else if (object2 instanceof Clob) {
            if (object2 instanceof AS400JDBCClobLocator) {
                object = (AS400JDBCClobLocator)object2;
                Clob clob = object;
                synchronized (clob) {
                    if (((AS400JDBCClobLocator)object).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)object).savedObject_;
                        this.savedObjectWrittenToServer_ = false;
                        this.scale_ = ((AS400JDBCClobLocator)object).savedScale_;
                        if (!(this.savedObject_ instanceof AS400JDBCClobLocator)) {
                            this.doConversion();
                            return;
                        }
                    }
                }
            }
            object = (Clob)object2;
            this.value_ = object.getSubString(1L, (int)object.length());
        } else if (object2 instanceof InputStream) {
            this.value_ = n > 0 ? JDUtilities.streamToString((InputStream)object2, n, "UTF-8") : JDUtilities.streamToString((InputStream)object2, "UTF-8");
            this.savedObject_ = this.value_;
        } else if (object2 instanceof SQLXML) {
            object = (SQLXML)object2;
            this.value_ = object.getString();
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int n2 = this.value_.length();
        if (n2 > this.maxLength_) {
            this.value_ = this.value_.substring(0, this.maxLength_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToServer() throws SQLException {
        block36: {
            try {
                Object object = this.savedObject_;
                if (object instanceof String) {
                    String string = (String)object;
                    int n = this.settings_.getBidiStringType();
                    if (n == -1) {
                        n = this.converter_.bidiStringType_;
                    }
                    BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n);
                    bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                    bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                    byte[] byArray = this.converter_.stringToByteArray(string, bidiConversionProperties);
                    this.locator_.writeData(0L, byArray, true);
                    break block36;
                }
                if (object instanceof Reader) {
                    int n = this.scale_;
                    if (n == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block36;
                    }
                    if (n > 0) {
                        int n2 = n < 1000000 ? n : 1000000;
                        String string = JDUtilities.readerToString((Reader)this.savedObject_);
                        this.savedObject_ = string;
                        int n3 = this.settings_.getBidiStringType();
                        if (n3 == -1) {
                            n3 = this.converter_.bidiStringType_;
                        }
                        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n3);
                        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                        byte[] byArray = this.converter_.stringToByteArray(string, bidiConversionProperties);
                        int n4 = 0;
                        int n5 = n2;
                        int n6 = n;
                        if (byArray.length < n6) {
                            n6 = byArray.length;
                        }
                        while (n5 > 0 && n4 < n6) {
                            this.locator_.writeData(n4, byArray, n4, n5, true);
                            int n7 = n6 - (n4 += n5);
                            if (n7 >= n5) continue;
                            n5 = n7;
                        }
                        if (n4 < n) {
                            JDError.throwSQLException((Object)this, "07006");
                        }
                        break block36;
                    }
                    if (n == -2) {
                        String string = JDUtilities.readerToString((Reader)this.savedObject_);
                        this.savedObject_ = string;
                        int n8 = this.settings_.getBidiStringType();
                        if (n8 == -1) {
                            n8 = this.converter_.bidiStringType_;
                        }
                        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n8);
                        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                        byte[] byArray = this.converter_.stringToByteArray(string, bidiConversionProperties);
                        this.locator_.writeData(0L, byArray, true);
                        break block36;
                    } else {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    break block36;
                }
                if (object instanceof InputStream) {
                    int n = this.scale_;
                    if (n == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block36;
                    }
                    if (n > 0) {
                        InputStream inputStream = (InputStream)this.savedObject_;
                        int n9 = n < 1000000 ? n : 1000000;
                        byte[] byArray = new byte[n9];
                        try {
                            int n10 = 0;
                            int n11 = inputStream.read(byArray, 0, n9);
                            while (n11 > -1 && n10 < n) {
                                this.locator_.writeData(n10, byArray, 0, n11, true);
                                int n12 = n - (n10 += n11);
                                if (n12 < n9) {
                                    n9 = n12;
                                }
                                n11 = inputStream.read(byArray, 0, n9);
                            }
                            if (n10 < n) {
                                JDError.throwSQLException((Object)this, "07006");
                            }
                            break block36;
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException((Object)this, "HY000", iOException);
                        }
                        break block36;
                    }
                    if (n == -2) {
                        InputStream inputStream = (InputStream)this.savedObject_;
                        int n13 = 1000000;
                        byte[] byArray = new byte[n13];
                        try {
                            int n14 = 0;
                            int n15 = inputStream.read(byArray, 0, n13);
                            while (n15 > -1) {
                                this.locator_.writeData(n14, byArray, 0, n15, true);
                                n14 += n15;
                                n15 = inputStream.read(byArray, 0, n13);
                            }
                            break block36;
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException((Object)this, "HY000", iOException);
                            break block36;
                        }
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block36;
                }
                if (object instanceof Clob) {
                    Clob clob;
                    boolean bl = false;
                    if (object instanceof AS400JDBCClobLocator) {
                        clob = (AS400JDBCClobLocator)object;
                        AS400JDBCClobLocator aS400JDBCClobLocator = clob;
                        synchronized (aS400JDBCClobLocator) {
                            if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                                this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                                this.savedObjectWrittenToServer_ = false;
                                this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                                ((AS400JDBCClobLocator)clob).savedObject_ = null;
                                this.writeToServer();
                                // MONITOREXIT @DISABLED, blocks:[0, 16, 17, 5, 27] lbl126 : MonitorExitStatement: MONITOREXIT : var4_19
                                Object var14_43 = null;
                                this.savedObjectWrittenToServer_ = true;
                                return;
                            }
                        }
                    }
                    if (!bl) {
                        clob = (Clob)object;
                        int n = (int)clob.length();
                        String string = clob.getSubString(1L, n);
                        this.savedObject_ = string;
                        byte[] byArray = this.converter_.stringToByteArray(string);
                        this.locator_.writeData(0L, byArray, 0, byArray.length, true);
                        bl = true;
                        break block36;
                    } else {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    break block36;
                }
                if (object instanceof SQLXML) {
                    SQLXML sQLXML = (SQLXML)object;
                    String string = sQLXML.getString();
                    this.savedObject_ = string;
                    byte[] byArray = this.converter_.stringToByteArray(string);
                    this.locator_.writeData(0L, byArray, 0, byArray.length, true);
                } else {
                    JDError.throwSQLException((Object)this, "07006");
                }
            }
            catch (Throwable throwable) {
                Object var14_45 = null;
                this.savedObjectWrittenToServer_ = true;
                throw throwable;
            }
        }
        Object var14_44 = null;
        this.savedObjectWrittenToServer_ = true;
        this.scale_ = (int)this.locator_.getLength();
    }

    public int getSQLType() {
        return 8;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCClobLocator";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "CLOB";
    }

    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 964;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2005;
    }

    public String getTypeName() {
        return "CLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public void clearTruncated() {
        this.truncated_ = 0;
    }

    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 819);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new HexReaderInputStream(new StringReader(this.value_));
            }
            return new HexReaderInputStream(new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            byte[] byArray = BinaryConverter.stringToBytes(this.getString());
            return new AS400JDBCBlob(byArray, byArray.length);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new StringReader(this.value_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCClob(this.value_, this.maxLength_);
        }
        AS400JDBCClobLocator aS400JDBCClobLocator = new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
        if (ConvTable.isMixedCCSID(this.converter_.ccsid_)) {
            this.savedObject_ = aS400JDBCClobLocator.getSubString(1L, (int)aS400JDBCClobLocator.length());
            this.savedObjectWrittenToServer_ = false;
            return new AS400JDBCClob((String)this.savedObject_, this.maxLength_);
        }
        return aS400JDBCClobLocator;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return string;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException("HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new StringReader(this.value_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCNClob(this.value_, this.maxLength_);
        }
        AS400JDBCNClobLocator aS400JDBCNClobLocator = new AS400JDBCNClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
        if (ConvTable.isMixedCCSID(this.converter_.ccsid_)) {
            this.savedObject_ = aS400JDBCNClobLocator.getSubString(1L, (int)aS400JDBCNClobLocator.length());
            this.savedObjectWrittenToServer_ = false;
            return new AS400JDBCNClob((String)this.savedObject_, this.maxLength_);
        }
        return aS400JDBCNClobLocator;
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        return string;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCSQLXML(this.value_, this.maxLength_);
        }
        return new AS400JDBCSQLXMLLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_, false);
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void updateSettings(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
    }

    public void saveValue() throws SQLException {
        if (this.value_ == null && this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }

    public Object getSavedValue() {
        return this.savedValue_;
    }
}

