/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDWriter;
import com.ibm.as400.access.NPCPSelWrtJ;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectList;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.WriterJob;
import java.beans.PropertyVetoException;
import java.io.Serializable;

public class WriterJobList
extends PrintObjectList
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String QUEUE_FILTER = "queueFilter";
    private static final String WRITER_FILTER = "writerFilter";

    public WriterJobList() {
        super(2, new NPCPSelWrtJ());
    }

    public WriterJobList(AS400 aS400) {
        super(2, new NPCPSelWrtJ(), aS400);
    }

    void chooseImpl() {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use WriterJobList before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectListImpl)aS400.loadImpl2("com.ibm.as400.access.WriterJobListImplRemote", "com.ibm.as400.access.WriterJobListImplProxy");
        super.setImpl();
    }

    public String getQueueFilter() {
        NPCPSelWrtJ nPCPSelWrtJ = (NPCPSelWrtJ)this.getSelectionCP();
        return nPCPSelWrtJ.getQueue();
    }

    public String getWriterFilter() {
        NPCPSelWrtJ nPCPSelWrtJ = (NPCPSelWrtJ)this.getSelectionCP();
        return nPCPSelWrtJ.getWriter();
    }

    PrintObject newNPObject(NPCPID nPCPID, NPCPAttribute nPCPAttribute) {
        return new WriterJob(this.system_, (NPCPIDWriter)nPCPID, nPCPAttribute);
    }

    public void setQueueFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'queueFilter' is null");
            throw new NullPointerException(QUEUE_FILTER);
        }
        String string2 = this.getQueueFilter();
        this.vetos.fireVetoableChange(QUEUE_FILTER, string2, string);
        NPCPSelWrtJ nPCPSelWrtJ = (NPCPSelWrtJ)this.getSelectionCP();
        nPCPSelWrtJ.setQueue(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("writerJobQueue", string);
        }
        this.changes.firePropertyChange(QUEUE_FILTER, string2, string);
    }

    public void setWriterFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'writerFilter' is null");
            throw new NullPointerException(WRITER_FILTER);
        }
        if (string.length() > 10) {
            Trace.log(2, "Parameter 'writerFilter' is greater than 10 characters in length.");
            throw new ExtendedIllegalArgumentException("writerFilter(" + string + ")", 1);
        }
        String string2 = this.getWriterFilter();
        this.vetos.fireVetoableChange(WRITER_FILTER, string2, string);
        NPCPSelWrtJ nPCPSelWrtJ = (NPCPSelWrtJ)this.getSelectionCP();
        nPCPSelWrtJ.setWriter(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("writer", string);
        }
        this.changes.firePropertyChange(WRITER_FILTER, string2, string);
    }
}

