/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.Descriptor;
import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.PcmlDescriptor;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocument;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlSAXParser;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XPCMLHelper;
import com.ibm.as400.data.XmlException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.MissingResourceException;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class ProgramCallDocument
implements Serializable,
Cloneable {
    static final long serialVersionUID = -1836686444079106483L;
    public static final int SERIALIZED = 0;
    public static final int SOURCE_PCML = 1;
    public static final int SOURCE_XPCML = 2;
    private AS400 m_as400;
    private PcmlDocument m_pcmlDoc;
    static boolean exceptionIfParseError_;
    private int m_timeOut = 0;

    public ProgramCallDocument(AS400 aS400, String string) throws PcmlException {
        if (aS400 == null) {
            ProgramCallDocument.warnNull("sys");
        }
        if (string == null) {
            ProgramCallDocument.warnNull("docName");
        }
        this.m_as400 = aS400;
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(string, null, null);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public ProgramCallDocument(AS400 aS400, String string, InputStream inputStream) throws PcmlException {
        if (aS400 == null) {
            ProgramCallDocument.warnNull("sys");
        }
        if (string == null) {
            ProgramCallDocument.warnNull("docName");
        }
        this.m_as400 = aS400;
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(string, null, inputStream);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public ProgramCallDocument(AS400 aS400, String string, ClassLoader classLoader) throws PcmlException {
        if (aS400 == null) {
            ProgramCallDocument.warnNull("sys");
        }
        if (string == null) {
            ProgramCallDocument.warnNull("docName");
        }
        this.m_as400 = aS400;
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(string, classLoader, null);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public ProgramCallDocument(AS400 aS400, String string, ClassLoader classLoader, InputStream inputStream) throws PcmlException {
        if (aS400 == null) {
            ProgramCallDocument.warnNull("sys");
        }
        if (string == null) {
            ProgramCallDocument.warnNull("docName");
        }
        this.m_as400 = aS400;
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(string, classLoader, inputStream);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public ProgramCallDocument(AS400 aS400, String string, InputStream inputStream, ClassLoader classLoader, InputStream inputStream2, int n) throws PcmlException {
        if (aS400 == null) {
            ProgramCallDocument.warnNull("sys");
        }
        if (string == null) {
            ProgramCallDocument.warnNull("docName");
        }
        if (n == 0) {
            this.m_pcmlDoc = ProgramCallDocument.loadSerializedPcmlDocumentFromStream(inputStream);
        } else if (n == 1) {
            this.m_pcmlDoc = ProgramCallDocument.loadSourcePcmlDocumentFromStream(string, inputStream, classLoader, inputStream2, false);
        } else if (n == 2) {
            this.m_pcmlDoc = ProgramCallDocument.loadSourcePcmlDocumentFromStream(string, inputStream, classLoader, inputStream2, true);
        } else {
            throw new ExtendedIllegalArgumentException("type (" + n + ")", 2);
        }
        this.m_as400 = aS400;
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public ProgramCallDocument() throws PcmlException {
        this.m_as400 = null;
        this.m_pcmlDoc = null;
    }

    public ProgramCallDocument(String string) throws PcmlException {
        if (string == null) {
            throw new NullPointerException("docName");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(string, null, null);
    }

    public ProgramCallDocument(String string, ClassLoader classLoader) throws XmlException {
        if (string == null) {
            throw new NullPointerException("docName");
        }
        if (classLoader == null) {
            throw new NullPointerException("loader");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(string, classLoader, null);
    }

    public Object clone() {
        ProgramCallDocument programCallDocument = null;
        try {
            programCallDocument = (ProgramCallDocument)super.clone();
            if (this.m_pcmlDoc != null) {
                programCallDocument.m_pcmlDoc = (PcmlDocument)this.m_pcmlDoc.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return programCallDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ProgramCallDocument programCallDocument = this;
        synchronized (programCallDocument) {
            if (this.m_pcmlDoc != null) {
                this.m_pcmlDoc.setSerializingWithData(true);
            }
            objectOutputStream.defaultWriteObject();
        }
    }

    public static void main(String[] stringArray) {
        PcmlDocument pcmlDocument = null;
        System.setErr(System.out);
        String string = SystemResourceFinder.format("PCD_ARGUMENTS");
        if (stringArray.length == 2) {
            if (!stringArray[0].equalsIgnoreCase("-SERIALIZE")) {
                System.out.println(string);
                System.exit(-1);
            }
            try {
                pcmlDocument = ProgramCallDocument.loadSourcePcmlDocument(stringArray[1], null, null);
            }
            catch (PcmlException pcmlException) {
                System.out.println(pcmlException.getLocalizedMessage());
                System.exit(-1);
            }
            try {
                ProgramCallDocument.savePcmlDocument(pcmlDocument);
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                System.exit(-1);
            }
        } else {
            System.out.println(string);
            System.exit(-1);
        }
    }

    public boolean callProgram(String string) throws PcmlException {
        try {
            this.m_pcmlDoc.setTimeOut(this.m_timeOut);
            return this.m_pcmlDoc.callProgram(string);
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (Trace.isTraceErrorOn()) {
                aS400SecurityException.printStackTrace(Trace.getPrintWriter());
            }
            PcmlException pcmlException = new PcmlException(aS400SecurityException);
            throw pcmlException;
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            if (Trace.isTraceErrorOn()) {
                objectDoesNotExistException.printStackTrace(Trace.getPrintWriter());
            }
            PcmlException pcmlException = new PcmlException(objectDoesNotExistException);
            throw pcmlException;
        }
        catch (InterruptedException interruptedException) {
            if (Trace.isTraceErrorOn()) {
                interruptedException.printStackTrace(Trace.getPrintWriter());
            }
            PcmlException pcmlException = new PcmlException(interruptedException);
            throw pcmlException;
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            if (Trace.isTraceErrorOn()) {
                errorCompletingRequestException.printStackTrace(Trace.getPrintWriter());
            }
            PcmlException pcmlException = new PcmlException(errorCompletingRequestException);
            throw pcmlException;
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                iOException.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(iOException);
        }
    }

    public int getErrno(String string) throws PcmlException {
        return this.m_pcmlDoc.getErrno(string);
    }

    public static Descriptor getDescriptor(String string) throws PcmlException {
        PcmlDocument pcmlDocument = null;
        pcmlDocument = ProgramCallDocument.loadPcmlDocument(string, null, null);
        return new PcmlDescriptor(pcmlDocument);
    }

    public static Descriptor getDescriptor(String string, InputStream inputStream) throws PcmlException {
        PcmlDocument pcmlDocument = null;
        pcmlDocument = ProgramCallDocument.loadPcmlDocument(string, null, inputStream);
        return new PcmlDescriptor(pcmlDocument);
    }

    public static Descriptor getDescriptor(String string, ClassLoader classLoader) throws PcmlException {
        PcmlDocument pcmlDocument = null;
        pcmlDocument = ProgramCallDocument.loadPcmlDocument(string, classLoader, null);
        return new PcmlDescriptor(pcmlDocument);
    }

    public static Descriptor getDescriptor(String string, ClassLoader classLoader, InputStream inputStream) throws PcmlException {
        PcmlDocument pcmlDocument = null;
        pcmlDocument = ProgramCallDocument.loadPcmlDocument(string, classLoader, inputStream);
        return new PcmlDescriptor(pcmlDocument);
    }

    public Descriptor getDescriptor() {
        if (this.m_pcmlDoc == null) {
            return null;
        }
        return new PcmlDescriptor(this.m_pcmlDoc);
    }

    public int getIntReturnValue(String string) throws PcmlException {
        return this.m_pcmlDoc.getIntReturnValue(string);
    }

    public int getIntValue(String string) throws PcmlException {
        return this.m_pcmlDoc.getIntValue(string);
    }

    public int getIntValue(String string, int[] nArray) throws PcmlException {
        return this.m_pcmlDoc.getIntValue(string, new PcmlDimensions(nArray));
    }

    public ProgramCall getProgramCall() {
        return this.m_pcmlDoc == null ? null : this.m_pcmlDoc.getProgramCall();
    }

    public String getStringValue(String string) throws PcmlException {
        return this.m_pcmlDoc.getStringValue(string, 0);
    }

    public String getStringValue(String string, int n) throws PcmlException {
        return this.m_pcmlDoc.getStringValue(string, n);
    }

    public String getStringValue(String string, int[] nArray) throws PcmlException {
        return this.m_pcmlDoc.getStringValue(string, new PcmlDimensions(nArray), 0);
    }

    public String getStringValue(String string, int[] nArray, int n) throws PcmlException {
        return this.m_pcmlDoc.getStringValue(string, new PcmlDimensions(nArray), n);
    }

    public AS400Message[] getMessageList(String string) throws PcmlException {
        return this.m_pcmlDoc.getMessageList(string);
    }

    public int getOutputsize(String string) throws PcmlException {
        return this.m_pcmlDoc.getOutputsize(string);
    }

    public int getOutputsize(String string, int[] nArray) throws PcmlException {
        return this.m_pcmlDoc.getOutputsize(string, new PcmlDimensions(nArray));
    }

    public Object getValue(String string) throws PcmlException {
        if (Trace.isTraceOn()) {
            Trace.log(7, "Entered method ProgramCallDocument.getValue(" + string + ")");
        }
        Object object = this.m_pcmlDoc.getValue(string);
        if (Trace.isTraceOn()) {
            Trace.log(7, "Exiting method ProgramCallDocument.getValue(" + string + ")");
        }
        return object;
    }

    public Object getValue(String string, int[] nArray) throws PcmlException {
        if (Trace.isTraceOn()) {
            Trace.log(7, "Entered method ProgramCallDocument.getValue(" + string + ", indices)");
        }
        Object object = this.m_pcmlDoc.getValue(string, new PcmlDimensions(nArray));
        if (Trace.isTraceOn()) {
            Trace.log(7, "Exiting method ProgramCallDocument.getValue(" + string + ", indices)");
        }
        return object;
    }

    public AS400 getSystem() {
        return this.m_as400;
    }

    public void serialize() throws PcmlException {
        if (this.m_pcmlDoc == null) {
            throw new PcmlException("DOCUMENT_NOT_SET");
        }
        try {
            ProgramCallDocument.savePcmlDocument(this.m_pcmlDoc);
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                iOException.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(iOException);
        }
    }

    public void serialize(OutputStream outputStream) throws IOException, PcmlException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (this.m_pcmlDoc == null) {
            throw new PcmlException("DOCUMENT_NOT_SET");
        }
        ProgramCallDocument.savePcmlDocument(this.m_pcmlDoc, outputStream);
    }

    public void serialize(File file) throws IOException, XmlException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.serialize(fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public void setIntValue(String string, int n) throws PcmlException {
        this.setValue(string, new Integer(n));
    }

    public void setIntValue(String string, int[] nArray, int n) throws PcmlException {
        this.setValue(string, nArray, new Integer(n));
    }

    public void setStringValue(String string, String string2) throws PcmlException {
        this.setStringValue(string, string2, 0);
    }

    public void setStringValue(String string, String string2, int n) throws PcmlException {
        this.m_pcmlDoc.setStringValue(string, string2, n);
    }

    public void setStringValue(String string, int[] nArray, String string2, int n) throws PcmlException {
        this.m_pcmlDoc.setStringValue(string, string2, new PcmlDimensions(nArray), n);
    }

    public void setDocument(String string) throws PcmlException {
        if (this.m_pcmlDoc != null) {
            throw new PcmlException("DOCUMENT_ALREADY_SET");
        }
        if (string == null) {
            throw new NullPointerException("docName");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(string, null, null);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public void setDocument(String string, InputStream inputStream) throws PcmlException {
        if (this.m_pcmlDoc != null) {
            throw new PcmlException("DOCUMENT_ALREADY_SET");
        }
        if (string == null) {
            throw new NullPointerException("docName");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(string, null, inputStream);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public void setDocument(String string, ClassLoader classLoader) throws PcmlException {
        if (this.m_pcmlDoc != null) {
            throw new PcmlException("DOCUMENT_ALREADY_SET");
        }
        if (string == null) {
            throw new NullPointerException("docName");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(string, classLoader, null);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public void setDocument(String string, ClassLoader classLoader, InputStream inputStream) throws PcmlException {
        if (this.m_pcmlDoc != null) {
            throw new PcmlException("DOCUMENT_ALREADY_SET");
        }
        if (string == null) {
            throw new NullPointerException("docName");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(string, classLoader, inputStream);
        this.m_pcmlDoc.setAs400(this.m_as400);
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.m_as400 = aS400;
        this.m_pcmlDoc.setAs400(this.m_as400);
    }

    public void setValue(String string, Object object) throws PcmlException {
        this.m_pcmlDoc.setValue(string, object);
    }

    public void setValue(String string, int[] nArray, Object object) throws PcmlException {
        this.m_pcmlDoc.setValue(string, object, new PcmlDimensions(nArray));
    }

    public void setPath(String string, String string2) throws PcmlException {
        this.m_pcmlDoc.setPath(string, string2);
    }

    public void setThreadsafeOverride(String string, boolean bl) throws PcmlException {
        this.m_pcmlDoc.setThreadsafeOverride(string, bl);
    }

    public boolean getThreadsafeOverride(String string) throws PcmlException {
        return this.m_pcmlDoc.getThreadsafeOverride(string);
    }

    private static void savePcmlDocument(PcmlDocument pcmlDocument) throws PcmlException, IOException {
        String string = pcmlDocument.getDocName() + ".pcml.ser";
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            ProgramCallDocument.savePcmlDocument(pcmlDocument, filterOutputStream);
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePcmlDocument(PcmlDocument pcmlDocument, OutputStream outputStream) throws PcmlException, IOException {
        pcmlDocument.setSerializingWithData(false);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(pcmlDocument);
            String string = pcmlDocument.getDocName() + ".pcml.ser";
            Trace.log(7, SystemResourceFinder.format("PCML_SERIALIZED", new Object[]{string}));
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    private static PcmlDocument loadPcmlDocument(String string, ClassLoader classLoader, InputStream inputStream) throws PcmlException {
        PcmlDocument pcmlDocument = null;
        pcmlDocument = ProgramCallDocument.loadSerializedPcmlDocument(string, classLoader);
        if (pcmlDocument != null) {
            return pcmlDocument;
        }
        pcmlDocument = ProgramCallDocument.loadZippedSerializedPcmlDocument(string, classLoader);
        if (pcmlDocument != null) {
            return pcmlDocument;
        }
        pcmlDocument = ProgramCallDocument.loadSourcePcmlDocument(string, classLoader, inputStream);
        return pcmlDocument;
    }

    private static PcmlDocument loadSerializedPcmlDocumentFromStream(InputStream inputStream) throws PcmlException {
        PcmlDocument pcmlDocument = null;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            pcmlDocument = (PcmlDocument)objectInputStream.readObject();
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                exception.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(exception);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return pcmlDocument;
    }

    private static PcmlDocument loadSourcePcmlDocumentFromStream(String string, InputStream inputStream, ClassLoader classLoader, InputStream inputStream2, boolean bl) throws PcmlException {
        PcmlDocument pcmlDocument = null;
        try {
            PcmlSAXParser pcmlSAXParser = new PcmlSAXParser(string, inputStream, inputStream2, bl, exceptionIfParseError_);
            pcmlDocument = pcmlSAXParser.getPcmlDocument();
        }
        catch (ParseException parseException) {
            if (Trace.isTraceErrorOn()) {
                parseException.printStackTrace(Trace.getPrintWriter());
            }
            parseException.reportErrors();
            throw new PcmlException(parseException);
        }
        catch (PcmlSpecificationException pcmlSpecificationException) {
            if (Trace.isTraceErrorOn()) {
                pcmlSpecificationException.printStackTrace(Trace.getPrintWriter());
            }
            pcmlSpecificationException.reportErrors();
            throw new PcmlException(pcmlSpecificationException);
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable;
            if (Trace.isTraceErrorOn()) {
                runtimeException.printStackTrace(Trace.getPrintWriter());
            }
            if ((throwable = runtimeException.getCause()) instanceof PcmlSpecificationException) {
                PcmlSpecificationException pcmlSpecificationException = (PcmlSpecificationException)throwable;
                pcmlSpecificationException.reportErrors();
                throw new PcmlException(pcmlSpecificationException);
            }
            if (Trace.isTraceErrorOn()) {
                runtimeException.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(runtimeException);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                exception.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(exception);
        }
        return pcmlDocument;
    }

    private static PcmlDocument loadSerializedPcmlDocument(String string, ClassLoader classLoader) throws PcmlException {
        PcmlDocument pcmlDocument = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = SystemResourceFinder.getSerializedPCMLDocument(string, classLoader);
            objectInputStream = new ObjectInputStream(inputStream);
            pcmlDocument = (PcmlDocument)objectInputStream.readObject();
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (StreamCorruptedException streamCorruptedException) {
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                iOException.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Trace.isTraceErrorOn()) {
                classNotFoundException.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(classNotFoundException);
        }
        finally {
            block32: {
                block31: {
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (Exception exception) {
                            if (!Trace.isTraceErrorOn()) break block31;
                            exception.printStackTrace(Trace.getPrintWriter());
                        }
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        if (!Trace.isTraceErrorOn()) break block32;
                        exception.printStackTrace(Trace.getPrintWriter());
                    }
                }
            }
        }
        return pcmlDocument;
    }

    /*
     * Loose catch block
     */
    private static PcmlDocument loadZippedSerializedPcmlDocument(String string, ClassLoader classLoader) throws PcmlException {
        PcmlDocument pcmlDocument;
        block34: {
            Exception exception2222;
            ObjectInputStream objectInputStream;
            GZIPInputStream gZIPInputStream;
            InputStream inputStream;
            block31: {
                block30: {
                    pcmlDocument = null;
                    inputStream = null;
                    gZIPInputStream = null;
                    objectInputStream = null;
                    inputStream = SystemResourceFinder.getSerializedPCMLDocument(string, classLoader);
                    gZIPInputStream = new GZIPInputStream(inputStream);
                    objectInputStream = new ObjectInputStream(gZIPInputStream);
                    pcmlDocument = (PcmlDocument)objectInputStream.readObject();
                    Object var8_6 = null;
                    if (objectInputStream == null) break block30;
                    try {
                        objectInputStream.close();
                    }
                    catch (Exception exception2222) {
                        if (!Trace.isTraceErrorOn()) break block30;
                        exception2222.printStackTrace(Trace.getPrintWriter());
                    }
                }
                if (gZIPInputStream != null) {
                    try {
                        gZIPInputStream.close();
                    }
                    catch (Exception exception2222) {
                        if (!Trace.isTraceErrorOn()) break block31;
                        exception2222.printStackTrace(Trace.getPrintWriter());
                    }
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception2222) {
                    if (Trace.isTraceErrorOn()) {
                        exception2222.printStackTrace(Trace.getPrintWriter());
                    }
                }
            }
            break block34;
            {
                catch (MissingResourceException missingResourceException) {
                    Exception exception32222;
                    block33: {
                        block32: {
                            Object var8_7 = null;
                            if (objectInputStream != null) {
                                try {
                                    objectInputStream.close();
                                }
                                catch (Exception exception32222) {
                                    if (!Trace.isTraceErrorOn()) break block32;
                                    exception32222.printStackTrace(Trace.getPrintWriter());
                                }
                            }
                        }
                        if (gZIPInputStream != null) {
                            try {
                                gZIPInputStream.close();
                            }
                            catch (Exception exception32222) {
                                if (!Trace.isTraceErrorOn()) break block33;
                                exception32222.printStackTrace(Trace.getPrintWriter());
                            }
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception32222) {
                            if (Trace.isTraceErrorOn()) {
                                exception32222.printStackTrace(Trace.getPrintWriter());
                            }
                        }
                    }
                    break block34;
                }
                catch (IOException iOException) {
                    if (Trace.isTraceErrorOn()) {
                        iOException.printStackTrace(Trace.getPrintWriter());
                    }
                    throw new PcmlException(iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (Trace.isTraceErrorOn()) {
                        classNotFoundException.printStackTrace(Trace.getPrintWriter());
                    }
                    throw new PcmlException(classNotFoundException);
                }
            }
            catch (Throwable throwable) {
                block37: {
                    Exception exception42222;
                    block36: {
                        block35: {
                            Object var8_8 = null;
                            if (objectInputStream != null) {
                                try {
                                    objectInputStream.close();
                                }
                                catch (Exception exception42222) {
                                    if (!Trace.isTraceErrorOn()) break block35;
                                    exception42222.printStackTrace(Trace.getPrintWriter());
                                }
                            }
                        }
                        if (gZIPInputStream != null) {
                            try {
                                gZIPInputStream.close();
                            }
                            catch (Exception exception42222) {
                                if (!Trace.isTraceErrorOn()) break block36;
                                exception42222.printStackTrace(Trace.getPrintWriter());
                            }
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception42222) {
                            if (!Trace.isTraceErrorOn()) break block37;
                            exception42222.printStackTrace(Trace.getPrintWriter());
                        }
                    }
                }
                throw throwable;
            }
        }
        return pcmlDocument;
    }

    private static PcmlDocument loadSourcePcmlDocument(String string, ClassLoader classLoader, InputStream inputStream) throws PcmlException {
        PcmlDocument pcmlDocument = null;
        try {
            InputStream inputStream2 = SystemResourceFinder.getPCMLDocument(string, classLoader);
            boolean bl = SystemResourceFinder.isXPCML(string, classLoader);
            PcmlSAXParser pcmlSAXParser = new PcmlSAXParser(string, inputStream2, inputStream, bl, exceptionIfParseError_);
            pcmlDocument = pcmlSAXParser.getPcmlDocument();
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new PcmlException(parseException);
        }
        catch (PcmlSpecificationException pcmlSpecificationException) {
            pcmlSpecificationException.reportErrors();
            throw new PcmlException(pcmlSpecificationException);
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            if (throwable instanceof PcmlSpecificationException) {
                PcmlSpecificationException pcmlSpecificationException = (PcmlSpecificationException)throwable;
                pcmlSpecificationException.reportErrors();
                throw new PcmlException(pcmlSpecificationException);
            }
            if (Trace.isTraceErrorOn()) {
                runtimeException.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(runtimeException);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                exception.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(exception);
        }
        return pcmlDocument;
    }

    public void generateXPCML(String string, OutputStream outputStream) throws IOException, XmlException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (this.m_pcmlDoc == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_pcmlDoc.generateXPCML(string, outputStream);
    }

    public void generateXPCML(OutputStream outputStream) throws IOException, XmlException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (this.m_pcmlDoc == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_pcmlDoc.generateXPCML(null, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generateXPCML(String string) throws IOException, XmlException {
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            this.generateXPCML(null, fileOutputStream);
            Object var4_3 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generateXPCML(String string, String string2) throws IOException, XmlException {
        if (string2 == null) {
            throw new NullPointerException("fileName");
        }
        if (string == null) {
            throw new NullPointerException("pgmName");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
            this.generateXPCML(string, fileOutputStream);
            Object var5_4 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    public void setXsdName(String string) {
        this.m_pcmlDoc.setXsdName(string);
    }

    public String getXsdName() {
        return this.m_pcmlDoc.getXsdName();
    }

    public static void transformPCMLToXPCML(InputStream inputStream, OutputStream outputStream) throws IOException, PcmlException, TransformerException, SAXException {
        if (inputStream == null) {
            throw new NullPointerException("pcmlStream");
        }
        if (outputStream == null) {
            throw new NullPointerException("xpcmlStream");
        }
        XPCMLHelper.doTransform("pcml_xpcml.xsl", inputStream, outputStream);
    }

    public static void condenseXPCML(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, String string) throws IOException, PcmlException, TransformerException, SAXException {
        Object object;
        String string2 = "";
        if (inputStream == null) {
            throw new NullPointerException("fullStream");
        }
        if (outputStream == null) {
            throw new NullPointerException("xsdStream");
        }
        if (outputStream2 == null) {
            throw new NullPointerException("condensedStream");
        }
        if (string == null) {
            throw new NullPointerException("xsdStreamName");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1000];
        int n = 0;
        n = inputStream.read(byArray);
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(byteArrayInputStream));
        try {
            object = lineNumberReader.readLine();
            boolean bl = false;
            while (object != null && !bl) {
                int n2;
                int n3;
                int n4;
                if (((String)object).indexOf("xsi:noNamespaceSchemaLocation=") != -1) {
                    bl = true;
                    n4 = ((String)object).indexOf("xsi:noNamespaceSchemaLocation=");
                    n3 = 0;
                    n3 = ((String)object).indexOf("'", n4);
                    n2 = 0;
                    if (n3 == -1) {
                        n3 = ((String)object).indexOf("\"", n4);
                        if (n3 != -1) {
                            n2 = ((String)object).indexOf("\"", n3 + 1);
                        }
                    } else {
                        n2 = ((String)object).indexOf("'", n3 + 1);
                    }
                    string2 = ((String)object).substring(n3 + 1, n2);
                    continue;
                }
                if (((String)object).indexOf("xsi:noNamespaceSchemaLocation =") != -1) {
                    bl = true;
                    n4 = ((String)object).indexOf("xsi:noNamespaceSchemaLocation =");
                    n3 = 0;
                    n3 = ((String)object).indexOf("'", n4);
                    n2 = 0;
                    if (n3 == -1) {
                        n3 = ((String)object).indexOf("\"", n4);
                        if (n3 != -1) {
                            n2 = ((String)object).indexOf("\"", n3 + 1);
                        }
                    } else {
                        n2 = ((String)object).indexOf("'", n3 + 1);
                    }
                    string2 = ((String)object).substring(n3 + 1, n2);
                    continue;
                }
                object = lineNumberReader.readLine();
            }
        }
        catch (IOException iOException) {
            Trace.log(7, "Error when reading input stream in condenseXPCML");
            if (Trace.isTraceErrorOn()) {
                iOException.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(iOException);
        }
        if (string2 == "") {
            string2 = "xpcml.xsd";
        }
        object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        XPCMLHelper.doCondenseTransform("xpcml_xsd.xsl", (InputStream)object, outputStream, string2);
        XPCMLHelper.doCondenseTransform("xpcml_basic.xsl", byteArrayInputStream2, outputStream2, string);
    }

    private static final void warnNull(String string) {
        if (Trace.isTraceOn()) {
            Trace.log(4, "Null value specified for '" + string + "' parameter on ProgramCallDocument constructor.");
        }
    }

    public void setTimeOut(int n) {
        this.m_timeOut = n;
    }

    public int getTimeout() {
        return this.m_timeOut;
    }

    static {
        String string = null;
        try {
            string = SystemProperties.getProperty("com.ibm.as400.data.ProgramCallDocument.throwSAXExceptionIfParseError");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        exceptionIfParseError_ = string == null ? false : string.trim().equalsIgnoreCase("true");
    }
}

