/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.CommTrace;
import com.ibm.as400.util.commtrace.CommTraceDisplayListener;
import com.ibm.as400.util.commtrace.Find;
import com.ibm.as400.util.commtrace.Format;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import com.ibm.as400.vaccess.FileFilter;
import com.ibm.as400.vaccess.IFSFileDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

class FormatDisplay
extends WindowAdapter
implements Runnable {
    private final String ALL = "*ALL";
    private final String YES = "*YES";
    private final String NO = "*NO";
    private final String CLASS = "FormatDisplay";
    private AS400 sys;
    private Thread fmtThread = null;
    private Format fmt = null;
    private Find find = null;
    private String filterIPaddr_;
    private String filterIPaddr2_;
    private String filterPort_;
    private String filterBdcst_;
    private String currPage = "";
    private String lastPage = "";
    private String slastPage = "";
    private String path = null;
    private String file = null;
    private String filename = null;
    private String outfile = null;
    private int nextRecLen = 0;
    private int index = 0;
    public static final int OPEN = 1;
    public static final int OPENRMT = 2;
    public static final int FMT = 3;
    private static final String SAVEEXT = ".bin";
    private int ifsrecs = 0;
    private int recsdisp = 0;
    private int page = 0;
    private int oper;
    private JMenuItem fsave;
    private JMenuItem fclose;
    private JMenuItem ffind;
    private JMenuItem fcopy;
    private JMenuItem fclear;
    private JMenuItem fcut;
    private JMenuItem fpaste;
    private JButton next;
    private JButton prev;
    private JComboBox numberList_;
    private JLabel msg;
    private JTextArea formattrace;
    private JFrame l;

    public FormatDisplay(String string, String string2, String string3, String string4, int n) {
        this.filterIPaddr_ = string;
        this.filterIPaddr2_ = string2;
        this.filterPort_ = string3;
        this.filterBdcst_ = string4;
        this.oper = n;
        if (n == 3) {
            FileDialog fileDialog = new FileDialog((Frame)CommTrace.getMainFrame(), ResourceBundleLoader_ct.getText("FormatDialog"), 0);
            fileDialog.show();
            String string5 = fileDialog.getDirectory();
            this.filename = fileDialog.getFile();
            if (string5 == null || this.filename == null) {
                return;
            }
            this.filename = string5 + this.filename;
        } else if (n == 1 || n == 2) {
            this.open();
        }
    }

    public FormatDisplay(String string, String string2, AS400 aS400, int n) {
        this.oper = n;
        this.sys = aS400;
        this.path = string;
        this.file = string2;
        if (n == 2 || n == 1) {
            this.open();
        }
    }

    public void run() {
        boolean bl = true;
        Thread thread = Thread.currentThread();
        while (this.fmtThread == thread) {
            if (bl) {
                if (this.oper == 3) {
                    if (this.filename == null) {
                        return;
                    }
                    FileDialog fileDialog = new FileDialog((Frame)CommTrace.getMainFrame(), ResourceBundleLoader_ct.getText("SaveAs"), 1);
                    fileDialog.setFile(this.filename + SAVEEXT);
                    fileDialog.show();
                    String string = fileDialog.getDirectory();
                    String string2 = fileDialog.getFile();
                    if (string2 == null) {
                        return;
                    }
                    this.outfile = string + string2;
                    FormatProperties formatProperties = new FormatProperties();
                    formatProperties.setProgress("True");
                    if (!this.filterIPaddr_.equals("*ALL")) {
                        formatProperties.setIPAddress(this.filterIPaddr_);
                        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                            Trace.log(3, "FormatDisplay.run() Filtering on IP address");
                        }
                    }
                    if (!this.filterIPaddr2_.equals("*ALL")) {
                        formatProperties.setSecondIPAddress(this.filterIPaddr2_);
                        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                            Trace.log(3, "FormatDisplay.run() Filtering on IP address");
                        }
                    }
                    if (!this.filterPort_.equals("*ALL")) {
                        formatProperties.setPort(this.filterPort_);
                        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                            Trace.log(3, "FormatDisplay.run() Filtering on port number");
                        }
                    }
                    if (this.filterBdcst_.equals("*NO")) {
                        formatProperties.setBroadcast(this.filterBdcst_);
                        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                            Trace.log(3, "FormatDisplay.run() Filtering broadcast records");
                        }
                    }
                    this.fmt = new Format(formatProperties, this.outfile, this.filename);
                    long l = System.currentTimeMillis();
                    this.fmt.toLclBinFile();
                    long l2 = System.currentTimeMillis();
                    if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                        Trace.log(3, "FormatDisplay.run() Format Start/End/Total Time:" + l + "/" + l2 + "/" + (l2 - l));
                    }
                    this.fmt.openLclFile();
                    this.showOutput();
                    bl = false;
                    continue;
                }
                if (this.oper != 1 && this.oper != 2) continue;
                this.showOutput();
                bl = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fmt.close();
    }

    private void showOutput() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "FormatDisplay.showOutput() Showing Output");
        }
        this.l = new JFrame("Comm Trace");
        this.formattrace = new JTextArea("", 10, 80);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(ResourceBundleLoader_ct.getText("File"));
        JMenu jMenu2 = new JMenu(ResourceBundleLoader_ct.getText("Edit"));
        JScrollPane jScrollPane = new JScrollPane(this.formattrace);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        JLabel jLabel = new JLabel(ResourceBundleLoader_ct.getText("Show"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = -1;
        String[] stringArray = new String[]{"10", "50", "100", "1000", "10000"};
        this.numberList_ = new JComboBox<String>(stringArray);
        this.numberList_.setSelectedIndex(2);
        gridBagLayout.setConstraints(this.numberList_, gridBagConstraints);
        jPanel2.add(this.numberList_);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        JLabel jLabel2 = new JLabel(ResourceBundleLoader_ct.getText("ShowDescription"));
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        JLabel jLabel3 = new JLabel(ResourceBundleLoader_ct.getText("DisplayDescription"));
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel2.add(jLabel3);
        gridBagConstraints.gridwidth = 0;
        this.msg = new JLabel(ResourceBundleLoader_ct.getText("Prolog"));
        gridBagLayout.setConstraints(this.msg, gridBagConstraints);
        jPanel2.add(this.msg);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = 0;
        this.prev = new JButton(ResourceBundleLoader_ct.getText("Prev"));
        this.prev.addActionListener(new CommTraceDisplayListener(this));
        gridBagLayout.setConstraints(this.prev, gridBagConstraints);
        jPanel2.add(this.prev);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this.next = new JButton(ResourceBundleLoader_ct.getText("Next"));
        this.next.addActionListener(new CommTraceDisplayListener(this));
        gridBagLayout.setConstraints(this.next, gridBagConstraints);
        jPanel2.add(this.next);
        jPanel.add(jPanel2);
        String string = ResourceBundleLoader_ct.getText("Record");
        String string2 = ResourceBundleLoader_ct.getText("MACAddress");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("       ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Data"));
        stringBuffer.append("      ");
        stringBuffer.append(string);
        stringBuffer.append("                     ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Destination"));
        stringBuffer.append("     ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Source"));
        stringBuffer.append("           ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Frame"));
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(ResourceBundleLoader_ct.getText("Number"));
        stringBuffer2.append("  ");
        stringBuffer2.append(ResourceBundleLoader_ct.getText("S/R"));
        stringBuffer2.append("  ");
        stringBuffer2.append(ResourceBundleLoader_ct.getText("Length"));
        stringBuffer2.append("    ");
        stringBuffer2.append(ResourceBundleLoader_ct.getText("Timer"));
        stringBuffer2.append("                      ");
        stringBuffer2.append(string2);
        stringBuffer2.append("     ");
        stringBuffer2.append(string2);
        stringBuffer2.append("      ");
        stringBuffer2.append(ResourceBundleLoader_ct.getText("Format"));
        String string3 = "------  ---  ------    ------------               --------------  --------------   ------";
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(3, 1));
        JLabel jLabel4 = new JLabel(stringBuffer.toString());
        JLabel jLabel5 = new JLabel(stringBuffer2.toString());
        JLabel jLabel6 = new JLabel(string3);
        jLabel4.setFont(new Font("Monospaced", 0, 12));
        jLabel5.setFont(new Font("Monospaced", 0, 12));
        jLabel6.setFont(new Font("Monospaced", 0, 12));
        jPanel3.add(jLabel4);
        jPanel3.add(jLabel5);
        jPanel3.add(jLabel6);
        this.fsave = new JMenuItem(ResourceBundleLoader_ct.getText("Save"), 83);
        this.fsave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        if (this.oper == 1 || this.oper == 2) {
            this.fsave.setEnabled(false);
        }
        this.fclose = new JMenuItem(ResourceBundleLoader_ct.getText("Close"), 87);
        this.fclose.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.ffind = new JMenuItem(ResourceBundleLoader_ct.getText("Find"), 70);
        this.ffind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.fcopy = new JMenuItem(ResourceBundleLoader_ct.getText("Copy"), 67);
        this.fcopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.fclear = new JMenuItem(ResourceBundleLoader_ct.getText("Clear"));
        this.fcut = new JMenuItem(ResourceBundleLoader_ct.getText("Cut"), 88);
        this.fcut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.fpaste = new JMenuItem(ResourceBundleLoader_ct.getText("Paste"), 86);
        this.fpaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenu.add(this.fsave);
        this.fsave.addActionListener(new CommTraceDisplayListener(this));
        jMenu.add(this.fclose);
        this.fclose.addActionListener(new CommTraceDisplayListener(this));
        jMenu2.add(this.ffind);
        this.ffind.addActionListener(new CommTraceDisplayListener(this));
        jMenu2.add(this.fcopy);
        this.fcopy.addActionListener(new CommTraceDisplayListener(this));
        jMenu2.add(this.fclear);
        this.fclear.addActionListener(new CommTraceDisplayListener(this));
        jMenu2.add(this.fcut);
        this.fcut.addActionListener(new CommTraceDisplayListener(this));
        jMenu2.add(this.fpaste);
        this.fpaste.addActionListener(new CommTraceDisplayListener(this));
        this.fcut.setEnabled(false);
        this.fpaste.setEnabled(false);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.l.setJMenuBar(jMenuBar);
        this.formattrace.enableInputMethods(true);
        this.formattrace.setFont(new Font("Monospaced", 0, 12));
        if (this.fmt == null) {
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(2, "FormatDisplay.showOutput() initialization failed");
            }
            return;
        }
        this.showRecs(1);
        this.msg.setText("Prolog");
        this.recsdisp = 0;
        this.ifsrecs = this.fmt.getIntFromFile();
        this.l.getContentPane().add((Component)jScrollPane, "Center");
        this.l.getContentPane().add((Component)jPanel, "South");
        this.l.getContentPane().add((Component)jPanel3, "North");
        this.l.setBackground(Color.black);
        this.l.setForeground(Color.white);
        this.l.addWindowListener(this);
        this.l.setSize(800, 600);
        this.l.setVisible(true);
    }

    public boolean showRecs(int n) {
        int n2 = this.fmt.getNumberOfTCPRecords();
        ((Component)this.l).setCursor(new Cursor(3));
        if (this.page == 0) {
            if (this.oper == 1 || this.oper == 2) {
                int n3 = this.recsdisp + n;
                if (n3 > this.ifsrecs) {
                    this.msg.setText(this.recsdisp + "-" + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("of") + " " + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("possible"));
                } else {
                    this.msg.setText(this.recsdisp + "-" + (this.recsdisp + n) + " " + ResourceBundleLoader_ct.getText("of") + " " + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("possible"));
                }
                this.recsdisp = n3;
                if (this.lastPage.equals("")) {
                    this.lastPage = this.formattrace.getText();
                } else {
                    this.slastPage = this.lastPage;
                    this.lastPage = this.formattrace.getText();
                }
                this.formattrace.setText(null);
                for (int i = 0; i < n; ++i) {
                    String string = null;
                    string = this.fmt.getRecFromFile();
                    if (string == null) {
                        ((Component)this.l).setCursor(new Cursor(0));
                        return false;
                    }
                    this.formattrace.append(string);
                }
            } else {
                int n4 = this.recsdisp + n;
                if (n4 > n2) {
                    this.msg.setText(this.recsdisp + "-" + n2 + " " + ResourceBundleLoader_ct.getText("of") + " " + n2);
                } else {
                    this.msg.setText(this.recsdisp + "-" + n4 + " " + ResourceBundleLoader_ct.getText("of") + " " + n2);
                }
                this.recsdisp = n4;
                if (this.lastPage.equals("")) {
                    this.lastPage = this.formattrace.getText();
                } else {
                    this.slastPage = this.lastPage;
                    this.lastPage = this.formattrace.getText();
                }
                this.formattrace.setText(null);
                for (int i = 0; i < n; ++i) {
                    String string = null;
                    string = this.fmt.getRecFromFile();
                    if (string == null) {
                        ((Component)this.l).setCursor(new Cursor(0));
                        return false;
                    }
                    this.formattrace.append(string);
                }
            }
        } else if (this.page == 1) {
            this.formattrace.setText(this.currPage);
            if (n2 == 0) {
                if (this.recsdisp > this.ifsrecs) {
                    this.msg.setText(this.recsdisp + "-" + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("of") + " " + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("possible"));
                } else {
                    this.msg.setText(this.recsdisp - n + "-" + this.recsdisp + " " + ResourceBundleLoader_ct.getText("of") + " " + this.ifsrecs + " " + ResourceBundleLoader_ct.getText("possible"));
                }
                if (this.recsdisp >= this.ifsrecs) {
                    ((Component)this.l).setCursor(new Cursor(0));
                    this.page = 0;
                    return false;
                }
            } else {
                if (this.recsdisp > n2) {
                    this.msg.setText(this.recsdisp + "-" + n2 + " " + ResourceBundleLoader_ct.getText("of") + " " + n2);
                } else {
                    this.msg.setText(this.recsdisp - n + "-" + this.recsdisp + " " + ResourceBundleLoader_ct.getText("of") + " " + n2);
                }
                if (this.recsdisp >= n2) {
                    ((Component)this.l).setCursor(new Cursor(0));
                    this.page = 0;
                    return false;
                }
            }
            this.page = 0;
        } else if (this.page == 2) {
            this.formattrace.setText(this.lastPage);
            this.msg.setText(ResourceBundleLoader_ct.getText("PreviousPage"));
            this.page = 1;
        }
        ((Component)this.l).setCursor(new Cursor(0));
        return true;
    }

    public void showPrev() {
        if (this.page == 0) {
            this.currPage = this.formattrace.getText();
            this.formattrace.setText(this.lastPage);
            this.msg.setText(ResourceBundleLoader_ct.getText("PreviousPage"));
            this.page = 1;
        } else if (this.page == 1) {
            this.formattrace.setText(this.slastPage);
            this.msg.setText(ResourceBundleLoader_ct.getText("PreviousPage") + " 2");
            this.page = 2;
        } else if (this.page == 2) {
            CommTrace.error(this.l, "Not Found", "Only the two previous pages are stored");
        }
    }

    public void open() {
        if (this.oper == 1) {
            FileDialog fileDialog = new FileDialog((Frame)CommTrace.getMainFrame(), ResourceBundleLoader_ct.getText("OpenDialog"), 0);
            fileDialog.show();
            String string = fileDialog.getDirectory();
            String string2 = fileDialog.getFile();
            if (string == null || string2 == null) {
                return;
            }
            this.fmt = new Format();
            this.fmt.openLclFile(string + string2);
            this.outfile = string + string2;
        } else if (this.oper == 2) {
            if (this.path != "" && this.file != "") {
                this.fmt = new Format(this.sys);
                this.fmt.openIFSFile(this.path + "/" + this.file + SAVEEXT);
            } else {
                IFSFileDialog iFSFileDialog = new IFSFileDialog((Frame)new JFrame(), ResourceBundleLoader_ct.getText("FiletoView"), this.sys);
                FileFilter[] fileFilterArray = new FileFilter[]{new FileFilter(ResourceBundleLoader_ct.getText("AllFiles"), "*.*"), new FileFilter(ResourceBundleLoader_ct.getText("CommTraceFiles"), "*.bin")};
                iFSFileDialog.setFileFilter(fileFilterArray, 0);
                iFSFileDialog.setDirectory(this.path);
                iFSFileDialog.setFileName(this.file);
                String string = "";
                if (iFSFileDialog.showDialog() == 1) {
                    string = iFSFileDialog.getAbsolutePath();
                    this.fmt = new Format(this.sys);
                    this.fmt.openIFSFile(string);
                }
            }
        }
    }

    public boolean save() {
        BufferedWriter bufferedWriter;
        String string;
        FileDialog fileDialog = new FileDialog((Frame)this.l, ResourceBundleLoader_ct.getText("SaveAs"), 1);
        if (this.filename == null) {
            string = this.outfile;
            int n = this.outfile.indexOf(46);
            if (n != -1) {
                string = this.outfile.substring(0, n);
            }
            fileDialog.setFile(string + ".txt");
        } else {
            fileDialog.setFile(this.filename + ".txt");
        }
        fileDialog.show();
        String string2 = fileDialog.getDirectory();
        string = fileDialog.getFile();
        ((Component)this.l).setCursor(new Cursor(3));
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string2 + string));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "FormatDisplay.save() Error opening " + string2 + string, (Throwable)iOException);
            }
            return false;
        }
        try {
            String string3;
            Format format = new Format();
            format.openLclFile(this.outfile);
            String string4 = format.getRecFromFile();
            bufferedWriter.write(string4);
            int n = format.getIntFromFile();
            int n2 = 0;
            while ((string3 = format.getRecFromFile()) != null) {
                if (n2 % 5 == 0) {
                    bufferedWriter.write(this.fmt.addBanner());
                }
                bufferedWriter.write(string3);
                ++n2;
            }
            format.close();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "FormatDisplay.save() Error writing to " + string2 + string, (Throwable)iOException);
            }
            return false;
        }
        try {
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "FormatDisplay.save() Error closing " + string2 + string, (Throwable)iOException);
            }
            return false;
        }
        ((Component)this.l).setCursor(new Cursor(0));
        return true;
    }

    private String addEndBanner() {
        return "\n* * * * * * * * * * * * *    " + ResourceBundleLoader_ct.getText("EOCP") + "    * * * * * * * * * * * * *\n";
    }

    public void close() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "FormatDisplay.close()");
        }
        if (this.l != null) {
            this.l.setVisible(false);
        }
        if (this.fmt != null) {
            this.fmt.close();
        }
        this.fmtThread = null;
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.l) {
            this.close();
        }
    }

    public void find() {
        if (this.find == null || this.find.isClosed()) {
            this.find = new Find(this.formattrace);
        } else {
            this.find.toFront();
        }
    }

    public void copy() {
        this.formattrace.copy();
    }

    public void clear() {
        this.formattrace.setText("");
    }

    public void cut() {
        this.formattrace.cut();
    }

    public void paste() {
        this.formattrace.paste();
    }

    public Thread getThread() {
        return this.fmtThread;
    }

    public void setThread(Thread thread) {
        this.fmtThread = thread;
    }

    public JComboBox getNumberList() {
        return this.numberList_;
    }

    public JMenuItem getSaveMenuItem() {
        return this.fsave;
    }

    public JMenuItem getCloseMenuItem() {
        return this.fclose;
    }

    public JMenuItem getFindMenuItem() {
        return this.ffind;
    }

    public JMenuItem getCopyMenuItem() {
        return this.fcopy;
    }

    public JMenuItem getClearMenuItem() {
        return this.fclear;
    }

    public JMenuItem getCutMenuItem() {
        return this.fcut;
    }

    public JMenuItem getPasteMenuItem() {
        return this.fpaste;
    }

    public JButton getNextButton() {
        return this.next;
    }

    public JButton getPrevButton() {
        return this.prev;
    }

    public JFrame getDisplayFrame() {
        return this.l;
    }
}

