/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.language.UserContext;
import nl.ibs.util.NameValuePair;

public abstract class AlphaNumericEnum
extends EnumHelper {
    public static final String ALPHA = "A";
    public static final String NUMERIC = "N";
    public static final String FORMATSTRING = "0000000000";
    private static Map map = new HashMap(2);

    public static synchronized List getCollection() {
        String locale = UserContext.getLocale().toString();
        List<Object> list = (ArrayList<NameValuePair>)map.get(locale);
        if (list != null) {
            return list;
        }
        list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair(ALPHA, "ALPHA"));
        list.add(new NameValuePair(NUMERIC, "NUMERIC"));
        list = AlphaNumericEnum.translate(list);
        map.put(locale, list);
        return list;
    }

    public static String getValue(String code) {
        for (NameValuePair pair : AlphaNumericEnum.getCollection()) {
            if (!pair.getName().equals(code)) continue;
            return pair.getValue();
        }
        return null;
    }

    public static String validateLength(int length, String type) throws Exception {
        if (length <= 0) {
            return "value_must_be_positive";
        }
        if (type.equals(ALPHA) && length > 10) {
            return "value_exceeds_10";
        }
        if (type.equals(NUMERIC) && length > 9) {
            return "value_exceeds_9";
        }
        return null;
    }

    public static String validateStartValue(boolean autoNumber, int startValue, int length) throws Exception {
        if (!autoNumber) {
            return null;
        }
        if (startValue <= 0) {
            return "value_must_be_positive";
        }
        if (Integer.toString(startValue).length() > length) {
            return "value_too_long";
        }
        return null;
    }
}

