/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.CalculatorParameter;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ProofDepreciationCalculator;
import nl.ibs.fac.boadapters.InterestTableHelper;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.YearPercentageDetailBO;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.YearPercentageDetail;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.jsql.DBData;

public abstract class BaseDepreciationCalculator
implements Serializable {
    private static final long serialVersionUID = -7729935890795345539L;
    protected Collection<CalculationValue> values;
    protected CalculationValue primusInterPares;
    protected boolean doDepreciationCalculation;
    protected boolean doInterestCalculation;
    protected DBData dbData;
    protected Company company;
    private boolean use445Correction;
    private BigDecimal twelve;
    private BigDecimal thirteen;
    private BigDecimal depreciationBase445;
    private BigDecimal grossAmount445;
    protected boolean credit;
    protected Asset asset;
    protected Valuation valuation;
    protected int assState;
    protected int assCreditState;
    protected int assStartUseYear;
    protected int assStartUsePeriod;
    protected boolean assNegativeInvestment;
    protected int valAccountingPrinciple;
    protected int valDepreciationMethod;
    protected int valStartPeriodHandlingMethod;
    protected int valNumberOfDepreciatedPeriods;
    protected int valDepreciatableLife;
    protected int valLastDepreciationBookYear;
    protected int valLastDepreciationPeriod;
    protected int valStartDepreciationBookYear;
    protected int valStartDepreciationPeriod;
    protected int valInterestCalculationMethod;
    protected int valStartInterestBookYear;
    protected int valStartInterestPeriod;
    protected int valLastAcquisitionBookYear;
    protected int valLastAcquisitionPeriod;
    protected boolean valDepreciationPaused;
    protected BigDecimal valPostedAcquisitionBalance;
    protected BigDecimal valPreviousBookvalueBalance;
    protected BigDecimal valResidualValue;
    protected BigDecimal valResidualPercentage;
    protected BigDecimal valPostedDepreciationBalance;
    protected BigDecimal valDegressivePercentage;
    protected BigDecimal valAnnuityPercentage;
    protected String valAnnuityInterestTableId;
    protected BigDecimal valInterestPercentage;
    protected BigDecimal valCorrection445A;
    protected BigDecimal valCorrection445B;
    protected String valYearPercentageTableId;
    protected String valInterestTableId;
    protected boolean depreciateBeyondEconomicLife;
    protected BigDecimal beyondEconomicLifePercentage;
    protected int depreciationYearFrom;
    protected int depreciationPeriodFrom;
    protected int interestYearFrom;
    protected int interestPeriodFrom;
    protected int yearTo;
    protected int periodTo;
    protected int currentYear;
    protected int currentPeriod;
    protected BigDecimal bookValue;
    protected BigDecimal acquisitionTotal;
    protected BigDecimal residualValue;
    protected BigDecimal depreciationBase;
    protected boolean depreciationBaseStable;
    protected BigDecimal currentDepreciationAmount;
    protected BigDecimal currentInterestAmount;
    protected BigDecimal totalDepreciationAmount;
    protected BigDecimal totalDepreciationAmountBeyondEconomicLife;
    protected BigDecimal totalInterestAmount;
    protected int currentRemainingLife;
    protected int currentReasonCode;
    protected int numberOfPeriods;
    protected InterestTableHelper interestTableHelper = new InterestTableHelper();
    protected boolean firstTime = true;
    protected boolean onePeriod = false;
    protected boolean lastPeriod;
    protected Vector periodsToSkipForDepreciation = null;
    protected boolean fullInterestIn1stPeriod;
    protected BigDecimal currentInterestPercentage;
    protected BigDecimal correction445;
    protected boolean annuityInitialized = false;
    protected int annuityYears;
    protected int annuityDepreciatableLife;
    protected BigDecimal capital;
    protected double perunage;
    protected double annuity;
    protected boolean depreciationBeyondEconomicLife = false;
    protected int currentAnnuityYear;
    protected int annRemainingLifeCorrection;

    public BaseDepreciationCalculator(boolean theFullInterestIn1stPeriod) {
        this.fullInterestIn1stPeriod = theFullInterestIn1stPeriod;
    }

    protected void initialize(DBData theDBData, Company theCompany, int theNumberOfPeriods, boolean theCredit, int theYearTo, int thePeriodTo) throws Exception {
        this.values = new ArrayList<CalculationValue>();
        this.primusInterPares = new CalculationValue();
        this.dbData = theDBData;
        this.company = theCompany;
        this.use445Correction = this.company.getProcessParameters().getUse445Correction();
        this.twelve = new BigDecimal("12.00");
        this.thirteen = new BigDecimal("13.00");
        this.numberOfPeriods = theNumberOfPeriods;
        this.credit = theCredit;
        this.yearTo = theYearTo;
        this.periodTo = thePeriodTo;
        this.totalDepreciationAmount = new BigDecimal(0);
        this.totalDepreciationAmountBeyondEconomicLife = new BigDecimal(0);
        this.totalInterestAmount = new BigDecimal(0);
    }

    protected void setValuationAttributes(Valuation valuation) throws Exception {
        this.assState = this.asset.getState();
        this.assCreditState = this.asset.getCreditState();
        this.assStartUseYear = this.asset.getStartUseYear();
        this.assStartUsePeriod = this.asset.getStartUsePeriod();
        this.assNegativeInvestment = this.asset.getNegativeInvestment();
        this.valAccountingPrinciple = valuation.getAccountingPrinciple();
        this.valDepreciationMethod = valuation.getDepreciationMethod();
        this.valStartPeriodHandlingMethod = valuation.getStartPeriodHandlingMethod();
        this.valNumberOfDepreciatedPeriods = valuation.getNumberOfDepreciatedPeriods();
        this.valDepreciatableLife = valuation.getDepreciatableLife();
        this.valLastDepreciationBookYear = valuation.getLastDepreciationBookYear();
        this.valLastDepreciationPeriod = valuation.getLastDepreciationPeriod();
        this.valStartDepreciationBookYear = valuation.getStartDepreciationBookYear();
        this.valStartDepreciationPeriod = valuation.getStartDepreciationPeriod();
        this.valInterestCalculationMethod = valuation.getInterestCalculationMethod();
        this.valStartInterestBookYear = valuation.getInterestBookYear();
        this.valStartInterestPeriod = valuation.getInterestPeriod();
        this.valLastAcquisitionBookYear = valuation.getLastAcquisitionBookYear();
        this.valLastAcquisitionPeriod = valuation.getLastAcquisitionPeriod();
        this.valPostedAcquisitionBalance = valuation.getPostedAcquisitionBalance();
        this.valResidualValue = valuation.getResidualValue();
        this.valResidualPercentage = valuation.getResidualPercentage();
        this.valPostedDepreciationBalance = valuation.getPostedDepreciationBalance();
        this.valPreviousBookvalueBalance = valuation.getPreviousBookvalueBalance();
        this.valDepreciationPaused = valuation.getDepreciationPaused();
        this.valDegressivePercentage = valuation.getDegressivePercentage();
        this.valAnnuityPercentage = valuation.getAnnuityPercentage();
        this.valAnnuityInterestTableId = valuation.getAnnuityInterestTableId();
        this.valYearPercentageTableId = valuation.getYearPercentageTableId();
        this.valInterestPercentage = valuation.getInterestPercentage();
        this.valInterestTableId = valuation.getInterestTableId();
        this.valCorrection445A = valuation.getCorrectionAmount445A();
        this.valCorrection445B = valuation.getCorrectionAmount445B();
        this.depreciateBeyondEconomicLife = valuation.getBeyondEconomicLifePercentage().doubleValue() > 0.0;
        this.beyondEconomicLifePercentage = valuation.getBeyondEconomicLifePercentage();
        this.annuityInitialized = false;
    }

    protected boolean validateAssetState(Valuation valuation) throws Exception {
        if (this.assState != 2) {
            this.primusInterPares.setReasonCode(51);
            this.values.add(this.primusInterPares);
            return false;
        }
        if (this.credit && this.assCreditState == 4) {
            this.primusInterPares.setReasonCode(52);
            this.values.add(this.primusInterPares);
            return false;
        }
        return true;
    }

    protected void validate() throws Exception {
        this.doDepreciationCalculation = true;
        this.validateForDepreciation();
        this.doInterestCalculation = true;
        this.validateForInterestCalculation();
    }

    protected void validateForDepreciation() throws Exception {
        this.depreciationYearFrom = 0;
        this.depreciationPeriodFrom = 0;
        if (this.valDepreciationMethod == 99) {
            this.doDepreciationCalculation = false;
            return;
        }
        if (!this.depreciateBeyondEconomicLife && this.valNumberOfDepreciatedPeriods >= this.valDepreciatableLife) {
            this.doDepreciationCalculation = false;
            return;
        }
        if (this.valLastDepreciationBookYear > 0) {
            int[] yp = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.valLastDepreciationBookYear, this.valLastDepreciationPeriod);
            this.depreciationYearFrom = yp[0];
            this.depreciationPeriodFrom = yp[1];
        }
        if (PeriodHelper.isBefore(this.depreciationYearFrom, this.depreciationPeriodFrom, this.valStartDepreciationBookYear, this.valStartDepreciationPeriod)) {
            this.depreciationYearFrom = this.valStartDepreciationBookYear;
            this.depreciationPeriodFrom = this.valStartDepreciationPeriod;
        }
        this.doDepreciationCalculation = !PeriodHelper.isBefore(this.yearTo, this.periodTo, this.depreciationYearFrom, this.depreciationPeriodFrom);
    }

    protected void validateForInterestCalculation() throws Exception {
        this.interestYearFrom = 0;
        this.interestPeriodFrom = 0;
        if (this.valInterestCalculationMethod == 0) {
            this.doInterestCalculation = false;
            return;
        }
        if (this.valLastDepreciationBookYear > 0) {
            int[] yp = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.valLastDepreciationBookYear, this.valLastDepreciationPeriod);
            this.interestYearFrom = yp[0];
            this.interestPeriodFrom = yp[1];
        } else {
            this.interestYearFrom = this.valStartDepreciationBookYear;
            this.interestPeriodFrom = this.valStartDepreciationPeriod;
        }
        if (this.valStartInterestBookYear > 0 && PeriodHelper.isBefore(this.interestYearFrom, this.interestPeriodFrom, this.valStartInterestBookYear, this.valStartInterestPeriod)) {
            this.interestYearFrom = this.valStartInterestBookYear;
            this.interestPeriodFrom = this.valStartInterestPeriod;
        }
        this.doInterestCalculation = !PeriodHelper.isBefore(this.yearTo, this.periodTo, this.interestYearFrom, this.interestPeriodFrom);
    }

    protected void calculate() throws Exception {
        if (this.firstTime) {
            this.initializeCurrentPeriod();
            if (this.doDepreciationCalculation) {
                this.currentRemainingLife = this.valDepreciatableLife - this.valNumberOfDepreciatedPeriods;
            } else if (this.doInterestCalculation) {
                this.currentRemainingLife = PeriodHelper.calculateNumberOfPeriods(this.numberOfPeriods, this.currentYear, this.currentPeriod, this.yearTo, this.periodTo);
            }
            this.initializeCalculationValues();
        }
        if (!this.depreciateBeyondEconomicLife && this.currentRemainingLife <= 0) {
            return;
        }
        this.lastPeriod = PeriodHelper.isAfter(this.currentYear, this.currentPeriod, this.yearTo, this.periodTo);
        while (!this.lastPeriod) {
            this.currentReasonCode = 0;
            this.currentDepreciationAmount = new BigDecimal("0");
            this.currentInterestAmount = new BigDecimal("0");
            if (this.doDepreciationCalculation && !PeriodHelper.isBefore(this.currentYear, this.currentPeriod, this.depreciationYearFrom, this.depreciationPeriodFrom)) {
                this.calculateDepreciations();
            }
            if (this.doInterestCalculation && !PeriodHelper.isBefore(this.currentYear, this.currentPeriod, this.interestYearFrom, this.interestPeriodFrom)) {
                this.calculateInterest();
            }
            this.handleCalculationValue();
            if (this.doDepreciationCalculation && this.currentReasonCode != 11 && !PeriodHelper.isBefore(this.currentYear, this.currentPeriod, this.depreciationYearFrom, this.depreciationPeriodFrom)) {
                --this.currentRemainingLife;
                if (this.currentRemainingLife <= 0) {
                    if (this.doInterestCalculation) {
                        if (this.bookValue.add(this.currentDepreciationAmount).subtract(this.acquisitionTotal).doubleValue() != 0.0) {
                            if (!this.depreciateBeyondEconomicLife) {
                                this.doDepreciationCalculation = false;
                                this.currentRemainingLife = PeriodHelper.calculateNumberOfPeriods(this.numberOfPeriods, this.currentYear, this.currentPeriod, this.yearTo, this.periodTo);
                            }
                        } else if (!this.depreciateBeyondEconomicLife) {
                            break;
                        }
                    } else if (!this.depreciateBeyondEconomicLife) break;
                }
            }
            if (this.onePeriod) break;
            this.handleNextPeriod();
        }
    }

    protected void initializeCurrentPeriod() throws Exception {
        if (this.doDepreciationCalculation && this.doInterestCalculation) {
            if (PeriodHelper.isBefore(this.depreciationYearFrom, this.depreciationPeriodFrom, this.interestYearFrom, this.interestPeriodFrom)) {
                this.currentYear = this.depreciationYearFrom;
                this.currentPeriod = this.depreciationPeriodFrom;
            } else {
                this.currentYear = this.interestYearFrom;
                this.currentPeriod = this.interestPeriodFrom;
            }
        } else if (this.doDepreciationCalculation && !this.doInterestCalculation) {
            this.currentYear = this.depreciationYearFrom;
            this.currentPeriod = this.depreciationPeriodFrom;
        } else if (!this.doDepreciationCalculation && this.doInterestCalculation) {
            this.currentYear = this.interestYearFrom;
            this.currentPeriod = this.interestPeriodFrom;
        }
    }

    protected void initializeCalculationValues() throws Exception {
        this.currentReasonCode = 0;
        this.correction445 = new BigDecimal("0.00");
        this.depreciationBaseStable = true;
        if (PeriodHelper.isAfter(this.valLastAcquisitionBookYear, this.valLastAcquisitionPeriod, this.currentYear, this.currentPeriod)) {
            this.acquisitionTotal = TransactionBO.calculateAcquisitionValue(this.asset, this.valAccountingPrinciple, this.currentYear, this.currentPeriod)[0];
            this.depreciationBaseStable = false;
        } else {
            this.acquisitionTotal = this.valPostedAcquisitionBalance;
        }
        this.residualValue = this.valResidualValue.doubleValue() != 0.0 ? this.valResidualValue : (this.valResidualPercentage.doubleValue() != 0.0 ? this.acquisitionTotal.multiply(this.valResidualPercentage).divide(new BigDecimal("100"), 2, 4) : new BigDecimal("0"));
        this.bookValue = this.acquisitionTotal.subtract(this.valPostedDepreciationBalance).subtract(this.totalDepreciationAmount);
        if (this.asset != null && this.valuation.getLastDepreciationBookYear() != 0) {
            int[] previousPeriod = PeriodHelper.getPreviousPeriod(this.numberOfPeriods, this.currentYear, this.currentPeriod);
            if (this.valInterestCalculationMethod == 2) {
                BigDecimal acquisitionTotal2 = TransactionBO.calculateAcquisitionValue(this.asset, this.valAccountingPrinciple, previousPeriod[0], previousPeriod[1])[0];
                this.valPreviousBookvalueBalance = acquisitionTotal2.subtract(this.valPostedDepreciationBalance).subtract(this.totalDepreciationAmount);
            } else if (this.valInterestCalculationMethod == 1 && this.currentYear != previousPeriod[0]) {
                BigDecimal acquisitionTotal2 = TransactionBO.calculateAcquisitionValue(this.asset, this.valAccountingPrinciple, previousPeriod[0], previousPeriod[1])[0];
                this.valPreviousBookvalueBalance = acquisitionTotal2.subtract(this.valPostedDepreciationBalance).subtract(this.totalDepreciationAmount);
            }
        }
        this.depreciationBase = this.bookValue.subtract(this.residualValue);
    }

    private void handleCalculationValue() throws Exception {
        if (this.onePeriod) {
            this.values.clear();
        }
        if (this.currentReasonCode != 0 || this.currentDepreciationAmount.doubleValue() != 0.0 || this.currentInterestAmount.doubleValue() != 0.0) {
            int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.currentYear, this.currentPeriod);
            BigDecimal calBookValue = this.bookValue;
            if (!this.depreciationBeyondEconomicLife) {
                calBookValue = this.bookValue.subtract(this.currentDepreciationAmount);
            }
            BigDecimal calPreviousBookvalueBalance = this.valPreviousBookvalueBalance;
            if (this.valInterestCalculationMethod == 2) {
                calPreviousBookvalueBalance = calBookValue;
            } else if (this.valInterestCalculationMethod == 1 && this.currentYear != nextPeriod[0]) {
                calPreviousBookvalueBalance = calBookValue;
            } else {
                this.currentInterestPercentage = null;
            }
            if (!this.depreciationBeyondEconomicLife) {
                this.totalDepreciationAmount = this.totalDepreciationAmount.add(this.currentDepreciationAmount);
            } else {
                this.totalDepreciationAmountBeyondEconomicLife = this.totalDepreciationAmountBeyondEconomicLife.add(this.currentDepreciationAmount);
            }
            this.values.add(new CalculationValue(this.currentReasonCode, this.currentYear, this.currentPeriod, this.currentDepreciationAmount, this.currentInterestAmount, this.asset, this.valuation, this.bookValue, this.acquisitionTotal, this.totalDepreciationAmount, this.totalInterestAmount.add(this.currentInterestAmount), calPreviousBookvalueBalance, this.currentInterestPercentage, this.correction445, this.depreciationBeyondEconomicLife, this.totalDepreciationAmountBeyondEconomicLife));
        }
    }

    public void handleNextPeriod() throws Exception {
        if (this.currentDepreciationAmount == null) {
            return;
        }
        if (this.currentInterestAmount.doubleValue() != 0.0) {
            this.totalInterestAmount = this.totalInterestAmount.add(this.currentInterestAmount);
        }
        int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.currentYear, this.currentPeriod);
        if (!this.depreciationBeyondEconomicLife) {
            this.bookValue = this.bookValue.subtract(this.currentDepreciationAmount);
        }
        if (this.valInterestCalculationMethod == 2) {
            this.valPreviousBookvalueBalance = this.bookValue;
        } else if (this.valInterestCalculationMethod == 1 && this.currentYear != nextPeriod[0]) {
            this.valPreviousBookvalueBalance = this.bookValue;
        }
        this.currentYear = nextPeriod[0];
        this.currentPeriod = nextPeriod[1];
        this.lastPeriod = PeriodHelper.isAfter(this.currentYear, this.currentPeriod, this.yearTo, this.periodTo);
        if (this.lastPeriod) {
            return;
        }
        if (this.depreciationBaseStable) {
            this.depreciationBase = this.depreciationBase.subtract(this.currentDepreciationAmount);
        } else {
            this.initializeCalculationValues();
        }
    }

    private void calculateDepreciations() throws Exception {
        double dbdv;
        if (this.valDepreciationPaused) {
            this.currentReasonCode = 11;
            return;
        }
        if (this.periodsToSkipForDepreciation != null && this.periodsToSkipForDepreciation.contains("" + (this.currentYear * 100 + this.currentPeriod))) {
            this.currentReasonCode = 11;
            return;
        }
        if (this.currentRemainingLife == 1) {
            this.currentReasonCode = 3;
            if (this.valDepreciationMethod != 11) {
                this.currentDepreciationAmount = this.depreciationBase;
                return;
            }
        }
        if (this.depreciateBeyondEconomicLife && this.currentRemainingLife <= 0) {
            this.depreciationBeyondEconomicLife = true;
            this.calculateDepreciationBeyondEconomicLife();
            return;
        }
        if (this.currentRemainingLife == this.valDepreciatableLife) {
            if (this.valStartPeriodHandlingMethod == 3) {
                this.currentReasonCode = 5;
                this.handleBacklogFirstPeriod(this.determineStartPeriodForBacklog());
                return;
            }
            if (this.valStartPeriodHandlingMethod == 4) {
                this.currentReasonCode = 6;
                this.handleBacklogFirstPeriod(this.determineStartPeriodForBacklog());
                return;
            }
            this.currentReasonCode = 2;
        }
        if ((dbdv = this.depreciationBase.doubleValue()) == 0.0) {
            this.currentReasonCode = 21;
        } else if (!this.assNegativeInvestment && dbdv < 0.0) {
            this.currentReasonCode = 22;
        } else if (this.assNegativeInvestment && dbdv > 0.0) {
            this.currentReasonCode = 23;
        }
        boolean backlog = false;
        BigDecimal backlogAmount = new BigDecimal(0.0);
        if (this.valStartPeriodHandlingMethod == 3 && this.valDepreciatableLife - 12 < this.currentRemainingLife || this.valStartPeriodHandlingMethod == 4 && this.valDepreciatableLife - 6 < this.currentRemainingLife) {
            backlogAmount = this.handleBacklogAdditionalInvestment(this.determineStartPeriodForBacklog());
            this.depreciationBase = this.depreciationBase.subtract(backlogAmount);
            backlog = true;
        }
        switch (this.valDepreciationMethod) {
            case 1: {
                this.calculateLinearDepreciation();
                break;
            }
            case 2: {
                this.calculateDegressiveDepreciation();
                break;
            }
            case 3: {
                this.calculateVariableDepreciation();
                break;
            }
            case 11: {
                this.calculateAnnuityYearDepreciation();
                break;
            }
        }
        if (backlog) {
            this.currentDepreciationAmount = this.currentDepreciationAmount.add(backlogAmount);
            this.depreciationBase = this.depreciationBase.add(backlogAmount);
        }
    }

    private void calculateDepreciationBeyondEconomicLife() throws Exception {
        this.currentDepreciationAmount = this.acquisitionTotal.multiply(new BigDecimal("" + this.beyondEconomicLifePercentage)).divide(new BigDecimal("100"), 2).divide(new BigDecimal("" + this.numberOfPeriods), 2, 4);
    }

    private void calculateLinearDepreciation() throws Exception {
        if (!this.use445Correction) {
            this.currentDepreciationAmount = this.depreciationBase.divide(new BigDecimal("" + this.currentRemainingLife), 2, 4);
        } else {
            this.calculateLinearDepreciationWith445Correction();
        }
    }

    private void calculateLinearDepreciationWith445Correction() throws Exception {
        int remainder = this.currentPeriod % 3;
        switch (remainder) {
            case 1: {
                this.grossAmount445 = this.depreciationBase.divide(new BigDecimal("" + this.currentRemainingLife), 2, 4);
                this.currentDepreciationAmount = this.grossAmount445.multiply(this.twelve).divide(this.thirteen, 2, 4);
                this.correction445 = this.valCorrection445A = this.grossAmount445.subtract(this.currentDepreciationAmount);
                break;
            }
            case 2: {
                this.depreciationBase445 = new BigDecimal("0.00").add(this.depreciationBase).subtract(this.valCorrection445A);
                this.grossAmount445 = this.depreciationBase445.divide(new BigDecimal("" + this.currentRemainingLife), 2, 4);
                this.currentDepreciationAmount = this.grossAmount445.multiply(this.twelve).divide(this.thirteen, 2, 4);
                this.correction445 = this.valCorrection445B = this.grossAmount445.subtract(this.currentDepreciationAmount);
                break;
            }
            case 0: {
                this.depreciationBase445 = new BigDecimal("0.00").add(this.depreciationBase).subtract(this.valCorrection445A).subtract(this.valCorrection445B);
                this.currentDepreciationAmount = this.depreciationBase445.divide(new BigDecimal("" + this.currentRemainingLife), 2, 4);
                this.currentDepreciationAmount = this.currentDepreciationAmount.add(this.valCorrection445A);
                this.currentDepreciationAmount = this.currentDepreciationAmount.add(this.valCorrection445B);
                this.valCorrection445A = new BigDecimal("0.00");
                this.valCorrection445B = new BigDecimal("0.00");
                this.correction445 = new BigDecimal("0.00");
            }
        }
    }

    private void calculateDegressiveDepreciation() throws Exception {
        BigDecimal degressiveAmount = this.depreciationBase.multiply(new BigDecimal("" + this.valDegressivePercentage)).divide(new BigDecimal("100"), 2).divide(new BigDecimal("" + this.numberOfPeriods), 2, 4);
        BigDecimal linearAmount = this.depreciationBase.divide(new BigDecimal("" + this.currentRemainingLife), 2, 4);
        if (!this.assNegativeInvestment && linearAmount.compareTo(degressiveAmount) == 1 || this.assNegativeInvestment && linearAmount.compareTo(degressiveAmount) == -1) {
            this.currentDepreciationAmount = linearAmount;
            this.currentReasonCode = 1;
        } else {
            this.currentDepreciationAmount = degressiveAmount;
        }
    }

    private void calculateVariableDepreciation() throws Exception {
        int yearNbr = (this.valDepreciatableLife - this.currentRemainingLife) / this.numberOfPeriods;
        YearPercentageTable table = (YearPercentageTable)YearPercentageTableBO.get(this.dbData, this.valYearPercentageTableId)[0];
        int periodsInYear = yearNbr + 1 == table.getActualYears() ? this.valDepreciatableLife - yearNbr * this.numberOfPeriods : this.numberOfPeriods;
        YearPercentageDetail detail = (YearPercentageDetail)YearPercentageDetailBO.get(this.dbData, table.getId(), yearNbr)[0];
        this.currentDepreciationAmount = this.acquisitionTotal.subtract(this.residualValue).multiply(detail.getPercentage()).divide(new BigDecimal("" + 100 * periodsInYear), 2, 4);
    }

    private void calculateAnnuityYearDepreciation() throws Exception {
        if (!this.annuityInitialized) {
            this.initializeDuration(this.valDepreciatableLife - this.valNumberOfDepreciatedPeriods);
            this.initializeCapital();
            this.initializeAnnuity();
            this.currentAnnuityYear = this.currentYear;
            this.annuityInitialized = true;
        }
        if (this.currentYear > this.currentAnnuityYear && this.currentRemainingLife % this.numberOfPeriods == 0) {
            this.initializeDuration(this.valDepreciatableLife - this.valNumberOfDepreciatedPeriods - this.annRemainingLifeCorrection);
            this.updateCapital();
            this.initializeAnnuity();
            this.currentAnnuityYear = this.currentYear;
        }
        this.calculateAnnuityYearPeriodAmounts();
    }

    private void initializeDuration(int annRemainingLife) throws Exception {
        this.annuityYears = annRemainingLife / this.numberOfPeriods;
        int annRemainder = annRemainingLife % this.numberOfPeriods;
        if (annRemainder > 0) {
            ++this.annuityYears;
        }
        this.annuityDepreciatableLife = this.annuityYears * this.numberOfPeriods;
    }

    private void initializeCapital() throws Exception {
        this.capital = new BigDecimal("0.00");
        if (this.valLastDepreciationBookYear > 0 && PeriodHelper.calculateNumberOfPeriods(this.numberOfPeriods, this.valStartDepreciationBookYear, this.valStartDepreciationPeriod, this.currentYear, this.currentPeriod) >= this.numberOfPeriods) {
            int thePeriod;
            int theYear;
            if (this.valStartDepreciationPeriod == 1) {
                theYear = this.currentYear - 1;
                thePeriod = this.numberOfPeriods;
            } else {
                thePeriod = this.valStartDepreciationPeriod - 1;
                theYear = this.currentPeriod >= this.valStartDepreciationPeriod ? this.currentYear : this.currentYear - 1;
            }
            BigDecimal[] amounts1 = TransactionBO.calculateAcquisitionValue(this.asset, this.valAccountingPrinciple, theYear, thePeriod);
            BigDecimal[] amounts2 = TransactionBO.calculateDepreciatedTotal(this.asset, this.valAccountingPrinciple, theYear, thePeriod);
            this.capital = this.capital.add(amounts1[0]).subtract(amounts1[1]).subtract(amounts2[0]);
        } else if (this.asset == null) {
            this.capital = this.acquisitionTotal;
        } else {
            BigDecimal[] amounts = TransactionBO.calculateAcquisitionValue(this.asset, this.valAccountingPrinciple, this.valStartDepreciationBookYear, this.valStartDepreciationPeriod);
            this.capital = this.capital.add(amounts[0]).subtract(amounts[1]);
        }
        this.capital = this.capital.subtract(this.residualValue);
    }

    private void updateCapital() throws Exception {
        if (this.asset == null) {
            this.capital = this.depreciationBase;
        } else {
            this.capital = new BigDecimal("0.00");
            int[] pp = PeriodHelper.getPreviousPeriod(this.numberOfPeriods, this.currentYear, this.currentPeriod);
            BigDecimal[] amounts1 = TransactionBO.calculateAcquisitionValue(this.asset, this.valAccountingPrinciple, pp[0], pp[1]);
            BigDecimal[] amounts2 = TransactionBO.calculateDepreciatedTotal(this.asset, this.valAccountingPrinciple, pp[0], pp[1]);
            this.capital = this.capital.add(amounts1[0]).subtract(amounts1[1]).subtract(amounts2[0]);
            this.capital = this.capital.subtract(this.totalDepreciationAmount).subtract(this.residualValue);
        }
    }

    private void initializeAnnuity() throws Exception {
        BigDecimal basePercentage = new BigDecimal("0.000");
        basePercentage = this.valAnnuityPercentage != null && this.valAnnuityPercentage.doubleValue() != 0.0 ? this.valAnnuityPercentage : this.interestTableHelper.getPercentage(this.dbData, this.valAnnuityInterestTableId, this.currentYear, this.valStartDepreciationPeriod);
        this.perunage = basePercentage.doubleValue() / 100.0;
        double h01 = Math.pow(this.perunage + 1.0, this.annuityYears);
        double h02 = 1.0 / h01;
        double h03 = 1.0 - h02;
        this.annuity = this.round(this.capital.doubleValue() * this.perunage / h03);
    }

    private void calculateAnnuityYearPeriodAmounts() throws Exception {
        int thePeriodNumber = this.annuityDepreciatableLife - this.currentRemainingLife + 1;
        int theYearNumber = (thePeriodNumber - 1) / this.numberOfPeriods;
        int theLastYearPeriod = this.numberOfPeriods;
        if (this.valStartDepreciationPeriod > 1) {
            theLastYearPeriod = this.valStartDepreciationPeriod - 1;
        }
        double yearBookValue = this.capital.doubleValue();
        int i = 0;
        while (i < this.annuityYears) {
            double yearInterestAmount = this.round(this.perunage * yearBookValue);
            double yearDepreciationAmount = this.round(this.annuity - yearInterestAmount);
            yearBookValue = this.round(yearBookValue - yearDepreciationAmount);
            if (i == theYearNumber) {
                double theDepreciationAmount = this.round(yearDepreciationAmount / (double)this.numberOfPeriods);
                double theInterestAmount = this.round(yearInterestAmount / (double)this.numberOfPeriods);
                if (this.currentPeriod != theLastYearPeriod) {
                    this.currentDepreciationAmount = new BigDecimal(theDepreciationAmount);
                    this.currentInterestAmount = new BigDecimal(theInterestAmount);
                } else {
                    this.currentDepreciationAmount = this.currentRemainingLife != 1 ? new BigDecimal(yearDepreciationAmount - (double)(this.numberOfPeriods - 1) * theDepreciationAmount) : this.depreciationBase;
                    this.currentInterestAmount = new BigDecimal(yearInterestAmount - (double)(this.numberOfPeriods - 1) * theInterestAmount);
                }
                ++this.annRemainingLifeCorrection;
                break;
            }
            ++i;
        }
    }

    private double round(double input) {
        double intermediate = Math.round(input * 100.0);
        return intermediate / 100.0;
    }

    private void handleBacklogFirstPeriod(int startPeriod) throws Exception {
        CalculatorParameter parameter = this.retrieveCalculatorParameter(startPeriod);
        parameter.setPostedAcquisitionBalance(this.valPostedAcquisitionBalance);
        if (this.asset != null && this.valLastAcquisitionBookYear > 0 && PeriodHelper.isAfter(this.valLastAcquisitionBookYear, this.valLastAcquisitionPeriod, this.assStartUseYear, this.assStartUsePeriod)) {
            parameter.setPostedAcquisitionBalance(TransactionBO.calculateAcquisitionValue(this.asset, this.valAccountingPrinciple, this.currentYear, this.currentPeriod)[0]);
        }
        BigDecimal backlogAmount = this.calculateBacklog(parameter, this.currentYear, this.currentPeriod);
        this.currentDepreciationAmount = this.currentDepreciationAmount.add(backlogAmount);
        this.currentRemainingLife = this.currentRemainingLife - PeriodHelper.calculateNumberOfPeriods(this.numberOfPeriods, this.currentYear, startPeriod, this.currentYear, this.currentPeriod) + 1;
    }

    private BigDecimal handleBacklogAdditionalInvestment(int startPeriod) throws Exception {
        BigDecimal backlogAmount = new BigDecimal(0.0);
        if (this.asset == null) {
            return backlogAmount;
        }
        int[] previousYP = PeriodHelper.getPreviousPeriod(this.numberOfPeriods, this.currentYear, this.currentPeriod);
        BigDecimal acquisitionValuePreviousPeriod = TransactionBO.calculateAcquisitionValue(this.asset, this.valAccountingPrinciple, previousYP[0], previousYP[1])[0];
        if (acquisitionValuePreviousPeriod.doubleValue() == this.acquisitionTotal.doubleValue()) {
            return backlogAmount;
        }
        BigDecimal backlogAcquisitionValue = this.acquisitionTotal.subtract(acquisitionValuePreviousPeriod);
        CalculatorParameter parameter = this.retrieveCalculatorParameter(startPeriod);
        parameter.setPostedAcquisitionBalance(backlogAcquisitionValue);
        return this.calculateBacklog(parameter, previousYP[0], previousYP[1]);
    }

    private BigDecimal calculateBacklog(CalculatorParameter parameter, int year, int period) throws Exception {
        ProofDepreciationCalculator calculator = new ProofDepreciationCalculator(this.fullInterestIn1stPeriod);
        ArrayList collection = (ArrayList)calculator.calculate(this.dbData, this.company, this.numberOfPeriods, false, year, period, parameter);
        Iterator ci = collection.iterator();
        BigDecimal backlogAmount = new BigDecimal("0.00");
        while (ci.hasNext()) {
            CalculationValue value = (CalculationValue)ci.next();
            backlogAmount = backlogAmount.add(value.getDepreciationAmount());
        }
        return backlogAmount;
    }

    private CalculatorParameter retrieveCalculatorParameter(int startPeriod) throws Exception {
        CalculatorParameter parameter = new CalculatorParameter();
        parameter.setState(this.assState);
        parameter.setCreditState(this.assCreditState);
        parameter.setNegativeInvestment(this.assNegativeInvestment);
        parameter.setAccountingPrinciple(this.valAccountingPrinciple);
        parameter.setInterestBookYear(this.valStartInterestBookYear);
        parameter.setInterestPeriod(this.valStartInterestPeriod);
        parameter.setAnnuityPercentage(this.valAnnuityPercentage);
        parameter.setAnnuityInterestTableId(this.valAnnuityInterestTableId);
        parameter.setDegressivePercentage(this.valDegressivePercentage);
        parameter.setDepreciatableLife(this.valDepreciatableLife);
        parameter.setDepreciationMethod(this.valDepreciationMethod);
        parameter.setDepreciationPaused(this.valDepreciationPaused);
        parameter.setInterestCalculationMethod(this.valInterestCalculationMethod);
        parameter.setInterestPercentage(this.valInterestPercentage);
        parameter.setInterestTableId(this.valInterestTableId);
        parameter.setResidualPercentage(this.valResidualPercentage);
        parameter.setResidualValue(this.valResidualValue);
        parameter.setYearPercentageTableId(this.valYearPercentageTableId);
        parameter.setNumberOfDepreciatedPeriods(0);
        parameter.setPostedDepreciationBalance(new BigDecimal("0.00"));
        parameter.setPreviousBookvalueBalance(new BigDecimal("0.00"));
        parameter.setStartUseYear(this.currentYear);
        parameter.setStartUsePeriod(startPeriod);
        parameter.setLastAcquisitionBookYear(this.currentYear);
        parameter.setLastAcquisitionPeriod(startPeriod);
        parameter.setStartDepreciationBookYear(this.currentYear);
        parameter.setStartDepreciationPeriod(startPeriod);
        parameter.setStartPeriodHandlingMethod(1);
        parameter.setCorrectionAmount445A(new BigDecimal("0.00"));
        parameter.setCorrectionAmount445B(new BigDecimal("0.00"));
        return parameter;
    }

    private int determineStartPeriodForBacklog() throws Exception {
        int startPeriod = 1;
        if (this.valStartPeriodHandlingMethod == 4 && this.currentPeriod > 7) {
            startPeriod = 7;
        }
        return startPeriod;
    }

    public BigDecimal calculateInterest() throws Exception {
        switch (this.valInterestCalculationMethod) {
            case 2: {
                this.calculateMeanBookValueInterest();
                break;
            }
            case 1: {
                this.calculateBookValueInterest();
                break;
            }
        }
        return this.currentInterestAmount;
    }

    private void calculateMeanBookValueInterest() throws Exception {
        this.currentInterestPercentage = this.getInterestPercentage();
        if (this.currentInterestPercentage != null) {
            if (this.fullInterestIn1stPeriod && this.valPreviousBookvalueBalance.doubleValue() == 0.0) {
                this.valPreviousBookvalueBalance = this.valPreviousBookvalueBalance.add(this.bookValue);
            }
            this.currentInterestAmount = this.depreciateBeyondEconomicLife ? this.bookValue.add(this.valPreviousBookvalueBalance).multiply(this.currentInterestPercentage).divide(new BigDecimal("" + 200 * this.numberOfPeriods), 2, 4) : this.bookValue.subtract(this.currentDepreciationAmount).add(this.valPreviousBookvalueBalance).multiply(this.currentInterestPercentage).divide(new BigDecimal("" + 200 * this.numberOfPeriods), 2, 4);
        }
    }

    private void calculateBookValueInterest() throws Exception {
        this.currentInterestPercentage = this.getInterestPercentage();
        if (this.currentInterestPercentage != null) {
            this.currentInterestAmount = this.valPreviousBookvalueBalance.multiply(this.currentInterestPercentage).divide(new BigDecimal("" + 100 * this.numberOfPeriods), 2, 4);
        }
    }

    private BigDecimal getInterestPercentage() throws Exception {
        if (this.valInterestPercentage != null && this.valInterestPercentage.doubleValue() != 0.0) {
            return this.valInterestPercentage;
        }
        return this.interestTableHelper.getPercentage(this.dbData, this.valInterestTableId, this.currentYear, this.currentPeriod);
    }

    public void setPeriodsToSkipForDepreciation(Vector vector) throws Exception {
        this.periodsToSkipForDepreciation = vector;
    }
}

