/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharacterDataArea;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobList;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import nl.ibs.fac.BatchJob;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.UserContext;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.AS400Enhanced;
import nl.ibs.util.Scrambler;

public abstract class BatchJobHelper {
    private static final String FACOBJLIB = "FACOBJLIB";

    public static String[] submitRPG(LoginHelper loginHelper, String jobName, String rpgName, String objectLibrary, String[][] selections, Date date) throws Exception {
        String message = BatchJobHelper.validate(date);
        if (message != null) {
            String[] result = new String[2];
            result[0] = message;
            return result;
        }
        String facDataLibrary = "";
        StringBuffer sb = new StringBuffer();
        sb.append("SBMJOB CMD(CALL PGM(");
        sb.append(rpgName);
        sb.append(") PARM(");
        int i = 0;
        while (i < selections.length) {
            if ("facLib".equals(selections[i][0])) {
                facDataLibrary = selections[i][1];
            } else {
                sb.append("'");
                sb.append(BatchJobHelper.escapeQuote(selections[i][1]));
                sb.append("' ");
            }
            ++i;
        }
        sb.append(")) INLLIBL(");
        sb.append(facDataLibrary.trim());
        sb.append(" ");
        sb.append(objectLibrary);
        sb.append(")");
        sb.append(" CURLIB(QGPL)");
        sb.append(" JOB(" + jobName + ") JOBQ(" + loginHelper.getLibrary() + "/" + "FAC" + ")");
        sb.append(" INQMSGRPY(*DFT)");
        if (Log.debug()) {
            sb.append(" LOG(4 0 *SECLVL) LOGCLPGM(*YES)");
        }
        if (date != null) {
            sb.append(" SCDDATE(");
            sb.append(BatchJobHelper.getDate(date));
            sb.append(")");
            sb.append(" SCDTIME(");
            sb.append(BatchJobHelper.getTime(date));
            sb.append(")");
        }
        return BatchJobHelper.runCommand(loginHelper, sb.toString());
    }

    public static String[] submitJava(LoginHelper loginHelper, String jobName, String className, String[][] selections, Date date) throws Exception {
        String message = BatchJobHelper.validate(date);
        if (message != null) {
            String[] result = new String[2];
            result[0] = message;
            return result;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SBMJOB CMD(JAVA CLASS(");
        sb.append("'");
        sb.append(className);
        sb.append("') PARM(");
        sb.append("'");
        sb.append("FAC");
        sb.append("' '");
        sb.append(FacConstants.getContextName());
        sb.append("' ");
        sb.append("'");
        sb.append("locale");
        sb.append("' '");
        sb.append(UserContext.getLocale().toString());
        sb.append("' ");
        int i = 0;
        while (i < selections.length) {
            sb.append("'");
            sb.append(selections[i][0]);
            sb.append("' '");
            sb.append(BatchJobHelper.escapeQuote(selections[i][1]));
            sb.append("' ");
            ++i;
        }
        sb.append(") CLASSPATH(");
        sb.append("'");
        sb.append(FacConstants.getClassPath());
        sb.append("') PROP(('java.AWT.Headless' 'true') (java.version '1.5'))) JOB(" + LanguageHelper.getString("nl.ibs.fac.language", jobName) + ") JOBQ(" + loginHelper.getLibrary() + "/" + "FAC" + ")");
        if (Log.debug()) {
            sb.append(" LOG(4 0 *SECLVL)");
        }
        sb.append(" INLLIBL(");
        sb.append(StartStopServlet.getObjectLibrary());
        sb.append(")");
        if (date != null) {
            sb.append(" SCDDATE(");
            sb.append(BatchJobHelper.getDate(date));
            sb.append(")");
            sb.append(" SCDTIME(");
            sb.append(BatchJobHelper.getTime(date));
            sb.append(")");
        }
        return BatchJobHelper.runCommand(loginHelper, sb.toString());
    }

    public static String[] runCommand(LoginHelper loginHelper, String command) throws Exception {
        if (Log.debug()) {
            Log.debug((String)command);
        }
        String[] result = new String[2];
        AS400Enhanced as400 = loginHelper.getAs400();
        CommandCall commandCall = new CommandCall((AS400)as400);
        commandCall.run(command);
        if (commandCall.getMessageList().length > 0) {
            result[0] = commandCall.getMessageList()[0].getText();
            result[1] = commandCall.getMessageList()[0].getID();
        }
        if (Log.debug()) {
            Log.debug((String)result[0]);
            Log.debug((String)result[1]);
        }
        return result;
    }

    private static String validate(Date date) {
        if (date != null && date.before(Calendar.getInstance().getTime())) {
            return "schedule_date/time_is_in_the_past";
        }
        return null;
    }

    private static String escapeQuote(String value) {
        if (value == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = value.indexOf("'");
        int j = 0;
        while (i >= 0) {
            sb.append(value.substring(j, i + 1));
            sb.append("'");
            j = i + 1;
            i = value.indexOf("'", j);
        }
        sb.append(value.substring(j));
        return sb.toString();
    }

    private static String getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        StringBuffer sb = new StringBuffer();
        int day = cal.get(5);
        if (day < 10) {
            sb.append("0");
        }
        sb.append(day);
        int month = cal.get(2) + 1;
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month);
        sb.append(cal.get(1));
        return sb.toString();
    }

    private static String getTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        StringBuffer sb = new StringBuffer();
        int hour = cal.get(11);
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        int minute = cal.get(12);
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append("00");
        return sb.toString();
    }

    public static String[][] getSelections(String[] args) {
        if (args.length == 0) {
            return null;
        }
        int i = 0;
        if (args[0].equals("FAC")) {
            i = 2;
        }
        if (args[i].equals("locale")) {
            int n = ++i;
            ++i;
            UserContext.setLocale(BatchJobHelper.getLocale(args[n]));
            Log.debug((String)UserContext.getLocale().toString());
        }
        String[][] selections = new String[(args.length - i) / 2][2];
        boolean odd = true;
        int j = 0;
        while (i < args.length) {
            if (odd) {
                selections[j][0] = args[i];
            } else {
                selections[j][1] = args[i];
                ++j;
            }
            odd = !odd;
            ++i;
        }
        return selections;
    }

    private static Locale getLocale(String key) {
        StringTokenizer st = new StringTokenizer(key, "_");
        if (st.countTokens() == 0) {
            return Locale.getDefault();
        }
        if (st.countTokens() == 1) {
            return new Locale(st.nextToken(), "");
        }
        if (st.countTokens() == 2) {
            return new Locale(st.nextToken(), st.nextToken());
        }
        return new Locale(st.nextToken(), st.nextToken(), st.nextToken());
    }

    public static Map getSelections(String[][] selections) {
        HashMap<String, String> result = null;
        if (selections != null) {
            result = new HashMap<String, String>(selections.length);
            int i = 0;
            while (i < selections.length) {
                result.put(selections[i][0], selections[i][1]);
                ++i;
            }
        }
        return result;
    }

    public static void setCompanyId(String[][] selections, String companyId) {
        if (selections != null) {
            int i = 0;
            while (i < selections.length) {
                if (selections[i][0].equals("Company")) {
                    selections[i][1] = companyId;
                    break;
                }
                ++i;
            }
        }
    }

    public static LoginHelper getLoginHelper(Map map) {
        String system = (String)map.get("System");
        String user = (String)map.get("User");
        String password = (String)map.get("Password");
        return new LoginHelper(system, user, Scrambler.unscramble((String)password), DBData.getDefaultDBData("fac").getSchema());
    }

    public static String getContextName(String[] args) {
        if (args[0].equals("FAC")) {
            return args[1];
        }
        return null;
    }

    public static String getUser(String[] args) {
        String[][] selections = BatchJobHelper.getSelections(args);
        if (selections != null) {
            int i = 0;
            while (i < selections.length) {
                if (selections[i][0].equals("User")) {
                    return selections[i][1];
                }
                ++i;
            }
        }
        return "";
    }

    public static String getEnvironment(String[] args) {
        String[][] selections = BatchJobHelper.getSelections(args);
        if (selections != null) {
            int i = 0;
            while (i < selections.length) {
                if (selections[i][0].equals("Environment")) {
                    return selections[i][1];
                }
                ++i;
            }
        }
        return "";
    }

    public static String getCompany(String[] args) {
        String[][] selections = BatchJobHelper.getSelections(args);
        if (selections != null) {
            int i = 0;
            while (i < selections.length) {
                if (selections[i][0].equals("Company")) {
                    return selections[i][1];
                }
                ++i;
            }
        }
        return "";
    }

    public static List getBatchJobs(LoginHelper loginHelper) throws Exception {
        ArrayList<BatchJob> result = new ArrayList<BatchJob>();
        AS400Enhanced as400 = loginHelper.getAs400();
        JobList jobList = new JobList((AS400)as400);
        jobList.setUser(loginHelper.getUser());
        Enumeration jobs = jobList.getJobs();
        while (jobs.hasMoreElements()) {
            Job job = (Job)jobs.nextElement();
            if (job.getName().startsWith("Q") || !job.getType().equals("B")) continue;
            try {
                BatchJob batchJob = new BatchJob(job);
                result.add(batchJob);
            }
            catch (Exception e) {
                Log.debug((String)e.getMessage());
            }
        }
        return result;
    }

    public static String holdJob(LoginHelper loginHelper, BatchJob batchJob) throws Exception {
        if (batchJob.getStatus().equals("*ACTIVE")) {
            return "job_is_active";
        }
        return BatchJobHelper.runCommand(loginHelper, "HLDJOB JOB(" + batchJob.getNumber() + "/" + loginHelper.getUser() + "/" + batchJob.getName() + ")")[0];
    }

    public static String releaseJob(LoginHelper loginHelper, BatchJob batchJob) throws Exception {
        if (batchJob.getStatus().equals("*ACTIVE")) {
            return "job_is_active";
        }
        return BatchJobHelper.runCommand(loginHelper, "RLSJOB JOB(" + batchJob.getNumber() + "/" + loginHelper.getUser() + "/" + batchJob.getName() + ")")[0];
    }

    public static String deleteJob(LoginHelper loginHelper, BatchJob batchJob) throws Exception {
        if (batchJob.getStatus().equals("*ACTIVE")) {
            return "job_is_active";
        }
        return BatchJobHelper.runCommand(loginHelper, "ENDJOB JOB(" + batchJob.getNumber() + "/" + loginHelper.getUser() + "/" + batchJob.getName() + ") OPTION(*IMMED)")[0];
    }

    public static void setupBatch(LoginHelper loginHelper) throws Exception {
        String library = loginHelper.getLibrary();
        ObjectDescription od = new ObjectDescription((AS400)loginHelper.getAs400(), "/QSYS.LIB/" + library + ".LIB/" + "FAC" + ".JOBQ");
        if (od.exists()) {
            Log.info((String)"Jobqueue FAC already exists");
            return;
        }
        Log.info((String)BatchJobHelper.runCommand(loginHelper, "CRTJOBQ JOBQ(" + library + "/" + "FAC" + ")")[0]);
        Log.info((String)BatchJobHelper.runCommand(loginHelper, "GRTOBJAUT OBJ(" + library + "/" + "FAC" + ") OBJTYPE(*JOBQ) USER(*PUBLIC) AUT(*USE)")[0]);
        int seqnbr = 70;
        String[] result = BatchJobHelper.addJobQueuEntry(seqnbr, loginHelper);
        if (!"CPD1535".equals(result[1])) {
            while ("CPD1538".equals(result[1]) && seqnbr < 9999) {
                result = BatchJobHelper.addJobQueuEntry(++seqnbr, loginHelper);
            }
        }
        Log.info((String)BatchJobHelper.runCommand(loginHelper, "CHGMSGD MSGID(JVA0122) MSGF(QJVAMSGF) SEV(40)")[0]);
    }

    private static String[] addJobQueuEntry(int seqnbr, LoginHelper loginHelper) throws Exception {
        String[] result = BatchJobHelper.runCommand(loginHelper, "ADDJOBQE SBSD(QGPL/QBATCH) JOBQ(" + loginHelper.getLibrary() + "/" + "FAC" + ") MAXACT(1) SEQNBR(" + seqnbr + ")");
        Log.info((String)result[0]);
        if ("CPD1401".equals(result[1])) {
            result = BatchJobHelper.runCommand(loginHelper, "ADDJOBQE SBSD(QSYS/QBATCH) JOBQ(" + loginHelper.getLibrary() + "/" + "FAC" + ") MAXACT(1) SEQNBR(" + seqnbr + ")");
            Log.info((String)result[0]);
        }
        if ("CPD1402".equals(result[1])) {
            Log.error((String)result[0]);
        }
        return result;
    }

    public static String[] getObjectLibrary(LoginHelper loginHelper) throws Exception {
        String name = FACOBJLIB;
        String library = loginHelper.getLibrary();
        AS400Enhanced as400 = loginHelper.getAs400();
        String objectLibrary = FACOBJLIB;
        CharacterDataArea dataArea = new CharacterDataArea((AS400)as400, "/QSYS.LIB/" + library + ".LIB/" + name + ".DTAARA");
        try {
            dataArea.create(10, objectLibrary, "FAC object libraryname", "*USE");
            Log.info((String)("created dataArea: " + library + "/" + name));
        }
        catch (ObjectAlreadyExistsException e) {
            Log.info((String)("already exists: dataArea " + library + "/" + name));
            objectLibrary = dataArea.read();
        }
        Log.info((String)("objectLibrary: " + objectLibrary));
        String objectLibraryVersion = null;
        try {
            objectLibraryVersion = new CharacterDataArea((AS400)loginHelper.getAs400(), "/QSYS.LIB/" + objectLibrary + ".LIB/PRODINFO.DTAARA").read().trim();
        }
        catch (ObjectDoesNotExistException e) {
            objectLibraryVersion = "";
            Log.warn((String)("DTAARA " + objectLibrary + "/PRODINFO does not exist"));
        }
        Log.info((String)("objectLibraryVersion: " + objectLibraryVersion));
        return new String[]{objectLibrary.trim(), objectLibraryVersion.trim()};
    }
}

