/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Vector;

public class ComparisonValue
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5119883102074472493L;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final String ACQUISITION_ACCOUNT_DESCRIPTION = "acquisitionAccountDescription";
    public static final String ACQUISITION_ACCOUNT = "acquisitionAccount";
    public static final String ASSET_STATE = "assetState";
    public static final String ASSET_TYPE_ID = "assetTypeId";
    public static final String CREDIT_ID = "creditId";
    public static final String ASSET_TYPE_DESCRIPTION = "assetTypeDescription";
    public static final String MULTIPLE_TYPES = "multipleTypes";
    public static final String GL_ACQUISITION_TOTAL = "gLAcquisitionTotal";
    public static final String GL_DEPRECIATION_TOTAL = "gLDepreciationTotal";
    public static final String FAC_ACQUISITION_TOTAL = "fACAcquisitionTotal";
    public static final String FAC_DEPRECIATION_TOTAL = "fACDepreciationTotal";
    public static final String FAC_COST_TOTAL = "fACCostTotal";
    public static final String FAC_BOOK_TOTAL = "fACBookTotal";
    public static final String ACQUISITION_TOTAL_DIFFERENCE = "acquisitionTotalDifference";
    public static final String DEPRECIATION_TOTAL_DIFFERENCE = "depreciationTotalDifference";
    public static final String COST_TOTAL_DIFFERENCE = "costTotalDifference";
    private boolean multipleTypes = false;
    private BigDecimal acquisitionTotalDifference;
    private BigDecimal depreciationTotalDifference;
    private BigDecimal costTotalDifference;
    private boolean detailsAlreadyAvailable = false;
    private BigDecimal[] acquisitionDetailDifferences;
    private BigDecimal[] depreciationDetailDifferences;
    private BigDecimal[] costDetailDifferences;
    private int numberOfPeriods;
    private int accountingPrinciple;
    private int beanType;
    private String assetTypeId;
    private Vector<String> typeIds = null;
    private String assetTypeDescription;
    private String creditId;
    private int currentIndex;
    private int assetState;
    private BigDecimal[][] figures;
    private BigDecimal[][] figuresYTD;
    private String acquisitionAccount;
    private String depreciationAccount;
    private String costAccount;
    private String acquisitionAccountDescription;
    private String depreciationAccountDescription;
    private String costAccountDescription;
    private BigDecimal glAcquisitionTotal;
    private BigDecimal glDepreciationTotal;
    private BigDecimal facAcquisitionTotal;
    private BigDecimal facDepreciationTotal;
    private BigDecimal investmentTotalAcquisition;
    private BigDecimal investmentTotalDepreciation;
    private BigDecimal disinvestmentTotalAcquisition;
    private BigDecimal disinvestmentTotalDepreciation;

    public ComparisonValue(int ap, int bt, String id, String aa, String da, String ca, int periods, int correctionPeriods) {
        this.numberOfPeriods = periods;
        if (correctionPeriods > 0) {
            ++this.numberOfPeriods;
        }
        this.accountingPrinciple = ap;
        this.beanType = bt;
        this.assetTypeId = id;
        this.acquisitionAccount = aa;
        if (da == null) {
            da = "";
        }
        this.depreciationAccount = da;
        if (ca == null) {
            ca = "";
        }
        this.costAccount = ca;
        this.acquisitionDetailDifferences = this.initializeDifferencesArray(this.numberOfPeriods);
        this.depreciationDetailDifferences = this.initializeDifferencesArray(this.numberOfPeriods);
        this.costDetailDifferences = this.initializeDifferencesArray(this.numberOfPeriods);
        this.figures = this.initializeFiguresArray(this.numberOfPeriods);
        this.figuresYTD = this.initializeFiguresArray(this.numberOfPeriods);
        this.glAcquisitionTotal = ZERO;
        this.glDepreciationTotal = ZERO;
        this.facAcquisitionTotal = ZERO;
        this.facDepreciationTotal = ZERO;
        this.investmentTotalAcquisition = ZERO;
        this.investmentTotalDepreciation = ZERO;
        this.disinvestmentTotalAcquisition = ZERO;
        this.disinvestmentTotalDepreciation = ZERO;
        this.acquisitionTotalDifference = ZERO;
        this.depreciationTotalDifference = ZERO;
        this.costTotalDifference = ZERO;
    }

    public ComparisonValue(int ap, String description, BigDecimal[] theDigits) {
        this.accountingPrinciple = ap;
        this.acquisitionAccountDescription = description;
        this.glAcquisitionTotal = theDigits[0];
        this.glDepreciationTotal = theDigits[2];
        this.facAcquisitionTotal = theDigits[1];
        this.facDepreciationTotal = theDigits[3];
        this.acquisitionTotalDifference = this.glAcquisitionTotal.subtract(this.facAcquisitionTotal);
        this.depreciationTotalDifference = this.glDepreciationTotal.subtract(this.facDepreciationTotal);
    }

    public ComparisonValue(String id, String desc, int state, int ap, BigDecimal bd1, BigDecimal bd2, BigDecimal bd3, BigDecimal bd4) {
        this.accountingPrinciple = ap;
        this.acquisitionAccount = id;
        this.acquisitionAccountDescription = desc;
        this.assetState = state;
        this.glAcquisitionTotal = bd2;
        this.glDepreciationTotal = bd4;
        this.facAcquisitionTotal = bd1;
        this.facDepreciationTotal = bd3;
        this.acquisitionTotalDifference = this.glAcquisitionTotal.subtract(this.facAcquisitionTotal);
        this.depreciationTotalDifference = this.glDepreciationTotal.subtract(this.facDepreciationTotal);
    }

    private BigDecimal[] initializeDifferencesArray(int numberOfPeriods) {
        BigDecimal[] bigDecimalArray = new BigDecimal[numberOfPeriods + 1];
        int i = 0;
        while (i <= numberOfPeriods) {
            bigDecimalArray[i] = ZERO;
            ++i;
        }
        return bigDecimalArray;
    }

    private BigDecimal[][] initializeFiguresArray(int numberOfPeriods) {
        BigDecimal[][] figureArray = new BigDecimal[6][numberOfPeriods + 1];
        int i = 0;
        while (i <= 5) {
            int j = 0;
            while (j <= numberOfPeriods) {
                figureArray[i][j] = ZERO;
                ++j;
            }
            ++i;
        }
        return figureArray;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addFigures(ComparisonValue bean) {
        int i = 0;
        while (i <= this.numberOfPeriods) {
            this.figures[1][i] = this.figures[1][i].add(bean.getFigure(1, i));
            this.figures[3][i] = this.figures[3][i].add(bean.getFigure(3, i));
            this.figures[5][i] = this.figures[5][i].add(bean.getFigure(5, i));
            this.figuresYTD[1][i] = this.figuresYTD[1][i].add(bean.getFigureYTD(1, i));
            this.figuresYTD[3][i] = this.figuresYTD[3][i].add(bean.getFigureYTD(3, i));
            this.figuresYTD[5][i] = this.figuresYTD[5][i].add(bean.getFigureYTD(5, i));
            ++i;
        }
        this.investmentTotalAcquisition = this.investmentTotalAcquisition.add(bean.investmentTotalAcquisition);
        this.investmentTotalDepreciation = this.investmentTotalDepreciation.add(bean.investmentTotalDepreciation);
        this.disinvestmentTotalAcquisition = this.disinvestmentTotalAcquisition.add(bean.disinvestmentTotalAcquisition);
        this.disinvestmentTotalDepreciation = this.disinvestmentTotalDepreciation.add(bean.disinvestmentTotalDepreciation);
        if (this.typeIds == null) {
            this.typeIds = new Vector();
        }
        this.typeIds.add(bean.getAssetTypeId());
    }

    public void addFigure(BigDecimal value, int type, int index) {
        this.figures[type][index] = this.figures[type][index].add(value);
        int i = index;
        while (i <= this.numberOfPeriods) {
            this.figuresYTD[type][i] = this.figuresYTD[type][i].add(value);
            ++i;
        }
    }

    public void addFIS2000YTDFigure(BigDecimal value, int type, int index) {
        this.figuresYTD[type][index] = value;
        this.figures[type][index] = index > 0 ? value.subtract(this.figuresYTD[type][index - 1]) : value;
    }

    public BigDecimal getFigure(int type, int index) {
        return this.figures[type][index];
    }

    public BigDecimal getFigureYTD(int type, int index) {
        return this.figuresYTD[type][index];
    }

    public void handleTotalDifferences() throws Exception {
        if (this.beanType > 0) {
            return;
        }
        this.acquisitionTotalDifference = this.glAcquisitionTotal.subtract(this.facAcquisitionTotal);
        this.depreciationTotalDifference = this.glDepreciationTotal.subtract(this.facDepreciationTotal);
    }

    public void handleDetailDifferences() throws Exception {
        if (this.beanType > 0) {
            return;
        }
        int i = 0;
        while (i <= this.numberOfPeriods) {
            this.acquisitionDetailDifferences[i] = this.figures[0][i].subtract(this.figures[1][i]);
            this.depreciationDetailDifferences[i] = this.figures[2][i].subtract(this.figures[3][i]);
            this.costDetailDifferences[i] = this.figures[4][i].subtract(this.figures[5][i]);
            ++i;
        }
        this.costTotalDifference = this.figuresYTD[4][this.numberOfPeriods].subtract(this.figuresYTD[5][this.numberOfPeriods]);
    }

    public void setGLAcquisitionTotal(BigDecimal t) {
        this.glAcquisitionTotal = t;
    }

    public void setGLDepreciationTotal(BigDecimal t) {
        this.glDepreciationTotal = t;
    }

    public BigDecimal getGLAcquisitionTotal() {
        return this.glAcquisitionTotal;
    }

    public BigDecimal getGLDepreciationTotal() {
        return this.glDepreciationTotal;
    }

    public void setFACAcquisitionTotal(BigDecimal t) {
        this.facAcquisitionTotal = t;
    }

    public void setFACDepreciationTotal(BigDecimal t) {
        this.facDepreciationTotal = t;
    }

    public BigDecimal getFACAcquisitionTotal() {
        return this.facAcquisitionTotal;
    }

    public BigDecimal getFACDepreciationTotal() {
        return this.facDepreciationTotal;
    }

    public BigDecimal getFACCostTotal() {
        return this.getFigureYTD(5, this.numberOfPeriods);
    }

    public BigDecimal getFACBookTotal() {
        return this.facAcquisitionTotal.subtract(this.facDepreciationTotal);
    }

    public void setAcquisitionTotalDifference() {
        this.acquisitionTotalDifference = this.glAcquisitionTotal.subtract(this.facAcquisitionTotal);
    }

    public void resetAcquisitionTotalDifference() {
        this.acquisitionTotalDifference = new BigDecimal("0.00");
    }

    public BigDecimal getAcquisitionTotalDifference() {
        return this.acquisitionTotalDifference;
    }

    public void setDepreciationTotalDifference() {
        this.depreciationTotalDifference = this.glDepreciationTotal.subtract(this.facDepreciationTotal);
    }

    public BigDecimal getDepreciationTotalDifference() {
        return this.depreciationTotalDifference;
    }

    public void setCostTotalDifference(BigDecimal value) {
        this.costTotalDifference = new BigDecimal("0.00").add(value);
    }

    public BigDecimal getCostTotalDifference() {
        return this.costTotalDifference;
    }

    public void setInvestmentTotalAcquisition(BigDecimal t) {
        this.investmentTotalAcquisition = t;
    }

    public BigDecimal getInvestmentTotalAcquisition() {
        return this.investmentTotalAcquisition;
    }

    public void setDisinvestmentTotalAcquisition(BigDecimal t) {
        this.disinvestmentTotalAcquisition = t;
    }

    public BigDecimal getDisinvestmentTotalAcquisition() {
        return this.disinvestmentTotalAcquisition;
    }

    public void setDisinvestmentTotalDepreciation(BigDecimal t) {
        this.disinvestmentTotalDepreciation = t;
    }

    public BigDecimal getDisinvestmentTotalDepreciation() {
        return this.disinvestmentTotalDepreciation;
    }

    public void calculateFACBookValue() {
        BigDecimal save = new BigDecimal("0.00").add(this.facAcquisitionTotal);
        this.facAcquisitionTotal = this.facAcquisitionTotal.subtract(this.facDepreciationTotal);
        this.glDepreciationTotal = new BigDecimal("0.00").add(this.facDepreciationTotal);
        this.facDepreciationTotal = save;
    }

    public void setAcquisitionDetailDifference(int index, BigDecimal b) {
        this.acquisitionDetailDifferences[index] = b;
    }

    public BigDecimal getAcquisitionDetailDifference(int index) {
        return this.acquisitionDetailDifferences[index];
    }

    public void setDepreciationDetailDifference(int index, BigDecimal b) {
        this.depreciationDetailDifferences[index] = b;
    }

    public BigDecimal getDepreciationDetailDifference(int index) {
        return this.depreciationDetailDifferences[index];
    }

    public void setCostDetailDifference(int index, BigDecimal b) {
        this.costDetailDifferences[index] = b;
    }

    public BigDecimal getCostDetailDifference(int index) {
        return this.costDetailDifferences[index];
    }

    public void setDetailsAlreadyAvailable(boolean b) {
        this.detailsAlreadyAvailable = b;
    }

    public boolean getDetailsAlreadyAvailable() {
        return this.detailsAlreadyAvailable;
    }

    public void setMultipleTypes(boolean b) {
        this.multipleTypes = b;
    }

    public boolean getMultipleTypes() {
        return this.multipleTypes;
    }

    public void setBeanType(int bt) {
        this.beanType = bt;
    }

    public int getBeanType() {
        return this.beanType;
    }

    public void setCurrentIndex(int ci) {
        this.currentIndex = ci;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setAssetTypeDescription(String d) {
        this.assetTypeDescription = d;
    }

    public String getAssetTypeDescription() {
        return this.assetTypeDescription;
    }

    public void setAcquisitionAccountDescription(String d) {
        this.acquisitionAccountDescription = d;
    }

    public String getAcquisitionAccountDescription() {
        return this.acquisitionAccountDescription;
    }

    public void setDepreciationAccountDescription(String d) {
        this.depreciationAccountDescription = d;
    }

    public String getDepreciationAccountDescription() {
        return this.depreciationAccountDescription;
    }

    public void setCostAccountDescription(String d) {
        this.costAccountDescription = d;
    }

    public String getCostAccountDescription() {
        return this.costAccountDescription;
    }

    public String getAcquisitionAccount() {
        return this.acquisitionAccount;
    }

    public String getDepreciationAccount() {
        return this.depreciationAccount;
    }

    public String getCostAccount() {
        return this.costAccount;
    }

    public int getAccountingPrinciple() {
        return this.accountingPrinciple;
    }

    public int getAssetState() {
        return this.assetState;
    }

    public void setAssetTypeId(String id) {
        this.assetTypeId = id;
    }

    public String getAssetTypeId() {
        return this.assetTypeId;
    }

    public void setCreditId(String id) {
        this.creditId = id;
    }

    public String getCreditId() {
        return this.creditId;
    }

    public String[] retrieveAssetTypeIds() {
        if (this.typeIds == null) {
            return new String[]{this.assetTypeId};
        }
        String[] typeIdsArray = new String[this.typeIds.size()];
        return this.typeIds.toArray(typeIdsArray);
    }
}

