/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.UserContext;

public class Cumulator {
    public static final String UNDEFINED = "*NONE";
    public static final int GENERAL = 0;
    public static final int MAINACCOUNT = 1;
    public static final int DIM1 = 2;
    public static final int DIM2 = 3;
    public static final int DIM3 = 4;
    public static final int DIM4 = 5;
    public static final int DIM5 = 6;
    public static final int TYPE = 7;
    public static final int ASSET = 8;
    public static final int MAX = 9;
    private int nrOfColumns = 0;
    private boolean allSwitchesOff = true;
    private boolean initialized = false;
    private boolean[] switchCumulate = new boolean[9];
    private String oldValue = "";
    private String newValue = "";
    private String[] levelName = null;
    private String[][] levelValue = new String[9][2];
    private String[] newLevelValue = new String[9];
    private BigDecimal[][] total = null;
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(UserContext.getLocale());
    private Object object = null;

    private void initialize(int nrOfColumns) throws Exception {
        this.nrOfColumns = nrOfColumns;
        this.total = new BigDecimal[9][nrOfColumns];
        int lvl = 0;
        while (lvl < 9) {
            int col = 0;
            while (col < nrOfColumns) {
                this.total[lvl][col] = ZERO;
                ++col;
            }
            ++lvl;
        }
        this.initialized = true;
    }

    public void setSwitchCumulationLevel(int level, boolean sw) throws Exception {
        this.switchCumulate[level] = sw;
        this.allSwitchesOff = true;
        int i = 0;
        while (i < 9) {
            if (this.switchCumulate[i]) {
                this.allSwitchesOff = false;
                break;
            }
            ++i;
        }
    }

    public boolean getSwitchCumulationLevel(int level) throws Exception {
        return this.switchCumulate[level];
    }

    public boolean levelBreak(Object obj, int level) throws Exception {
        if (level == 0) {
            return false;
        }
        this.retrieveNewLevelValues(obj);
        this.oldValue = this.getLevelValue(level)[0];
        this.newValue = this.newLevelValue[level];
        return !this.newValue.equals(this.oldValue) && !this.oldValue.equals(UNDEFINED);
    }

    private void retrieveNewLevelValues(Object obj) throws Exception {
        if (obj instanceof Asset) {
            this.newLevelValue[1] = "";
            this.newLevelValue[2] = ((Asset)obj).getFinDimId1();
            this.newLevelValue[3] = ((Asset)obj).getFinDimId2();
            this.newLevelValue[4] = ((Asset)obj).getFinDimId3();
            this.newLevelValue[5] = ((Asset)obj).getFinDimId4();
            this.newLevelValue[6] = ((Asset)obj).getFinDimId5();
            this.newLevelValue[7] = ((Asset)obj).getTypeId();
            this.newLevelValue[8] = ((Asset)obj).getId();
        } else {
            this.newLevelValue[1] = ((IncomingFinancialTransaction)obj).getMainAccount();
            this.newLevelValue[2] = ((IncomingFinancialTransaction)obj).getFinDimId1();
            this.newLevelValue[3] = ((IncomingFinancialTransaction)obj).getFinDimId2();
            this.newLevelValue[4] = ((IncomingFinancialTransaction)obj).getFinDimId3();
            this.newLevelValue[5] = ((IncomingFinancialTransaction)obj).getFinDimId4();
            this.newLevelValue[6] = ((IncomingFinancialTransaction)obj).getFinDimId5();
            this.newLevelValue[7] = "";
            this.newLevelValue[8] = "";
        }
    }

    private void resetLevel(int level) throws Exception {
        int col = 0;
        while (col < this.nrOfColumns) {
            this.total[level][col] = ZERO;
            ++col;
        }
    }

    public void add(Object asset, Object[] values) throws Exception {
        if (this.allSwitchesOff) {
            return;
        }
        if (!this.initialized) {
            this.initialize(values.length);
        }
        int lvl = 1;
        while (lvl < 9) {
            if (this.switchCumulate[lvl] && this.levelBreak(asset, lvl)) {
                this.resetLevel(lvl);
            }
            ++lvl;
        }
        this.setLevelValues(asset);
        BigDecimal val = ZERO;
        Object obj = null;
        int col = 0;
        while (col < values.length) {
            obj = values[col];
            if (obj instanceof BigDecimal) {
                val = (BigDecimal)obj;
            } else if (obj instanceof String) {
                val = this.getValueOf((String)obj);
            } else if (obj == null) {
                val = ZERO;
            }
            int lvl2 = 0;
            while (lvl2 < 9) {
                if (this.switchCumulate[lvl2]) {
                    this.total[lvl2][col] = this.total[lvl2][col].add(val);
                }
                ++lvl2;
            }
            ++col;
        }
    }

    public BigDecimal[] getTotalsForLevel(int level) throws Exception {
        if (this.switchCumulate[level] && this.total != null && this.total[level] != null) {
            return this.total[level];
        }
        if (this.total == null) {
            this.nrOfColumns = 50;
            this.total = new BigDecimal[9][this.nrOfColumns];
        }
        this.total[level] = new BigDecimal[this.nrOfColumns];
        int col = 0;
        while (col < this.nrOfColumns) {
            this.total[level][col] = ZERO;
            ++col;
        }
        return this.total[level];
    }

    public String getLevelName(int level, Environment environment) throws Exception {
        if (this.levelName == null) {
            this.levelName = new String[9];
            this.levelName[0] = LanguageHelper.getString("nl.ibs.fac.language", "totGen");
            this.levelName[1] = LanguageHelper.getString("nl.ibs.fac.language", "MainAccount");
            this.levelName[2] = environment.getName1();
            this.levelName[3] = environment.getName2();
            this.levelName[4] = environment.getName3();
            this.levelName[5] = environment.getName4();
            this.levelName[6] = environment.getName5();
            this.levelName[7] = LanguageHelper.getString("nl.ibs.fac.language", "Type");
            this.levelName[8] = LanguageHelper.getString("nl.ibs.fac.language", "Asset");
        }
        return this.levelName[level];
    }

    public String[] getLevelValue(int level) throws Exception {
        if (this.object == null) {
            return new String[]{UNDEFINED, UNDEFINED};
        }
        return this.levelValue[level];
    }

    public void setLevelValues(Object obj) throws Exception {
        this.object = obj;
        if (obj instanceof Asset) {
            this.levelValue[1][0] = "";
            this.levelValue[1][1] = "";
            this.levelValue[2][0] = ((Asset)obj).getFinDimId1();
            this.levelValue[2][1] = "";
            this.levelValue[3][0] = ((Asset)obj).getFinDimId2();
            this.levelValue[3][1] = "";
            this.levelValue[4][0] = ((Asset)obj).getFinDimId3();
            this.levelValue[4][1] = "";
            this.levelValue[5][0] = ((Asset)obj).getFinDimId4();
            this.levelValue[5][1] = "";
            this.levelValue[6][0] = ((Asset)obj).getFinDimId5();
            this.levelValue[6][1] = "";
            this.levelValue[7][0] = ((Asset)obj).getTypeId();
            this.levelValue[7][1] = ((Asset)obj).getAssetType().getDescription();
            this.levelValue[8][0] = ((Asset)obj).getId();
            this.levelValue[8][1] = ((Asset)obj).getDescription();
        } else {
            this.levelValue[1][0] = ((IncomingFinancialTransaction)obj).getMainAccount();
            this.levelValue[1][1] = "";
            this.levelValue[2][0] = ((IncomingFinancialTransaction)obj).getFinDimId1();
            this.levelValue[2][1] = "";
            this.levelValue[3][0] = ((IncomingFinancialTransaction)obj).getFinDimId2();
            this.levelValue[3][1] = "";
            this.levelValue[4][0] = ((IncomingFinancialTransaction)obj).getFinDimId3();
            this.levelValue[4][1] = "";
            this.levelValue[5][0] = ((IncomingFinancialTransaction)obj).getFinDimId4();
            this.levelValue[5][1] = "";
            this.levelValue[6][0] = ((IncomingFinancialTransaction)obj).getFinDimId5();
            this.levelValue[6][1] = "";
            this.levelValue[7][0] = "";
            this.levelValue[7][1] = "";
            this.levelValue[8][0] = "";
            this.levelValue[8][1] = "";
        }
    }

    private BigDecimal getValueOf(String s) {
        try {
            return new BigDecimal(this.df.parse(s).doubleValue()).setScale(2, 4);
        }
        catch (ParseException e) {
            return new BigDecimal(0).setScale(2, 4);
        }
    }
}

