/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileOutputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.util.AS400Enhanced;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.PropertiesHelper;

public abstract class DBPropertiesHelper {
    private static String system;
    private static String library;
    private static String databaseUser;
    private static String databasePassword;
    private static String dataBaseUrl;
    public static final String FILENAME = "jsql_config.properties";

    public static List getPropertyList() throws Exception {
        Properties properties = PropertiesHelper.getProperties((String)FILENAME);
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            list.add(new NameValuePair((String)entry.getKey(), (String)entry.getValue()));
        }
        return list;
    }

    public static String savePropertyList(List properties, LoginHelper loginHelper) throws Exception {
        String message = DBPropertiesHelper.savePropertyList(properties);
        if (message == null && loginHelper != null) {
            message = DBPropertiesHelper.saveToIFS(properties, loginHelper);
        }
        return message;
    }

    public static String savePropertyList(List properties) throws Exception {
        String message = null;
        try (FileOutputStream fos = null;){
            try {
                URL url = PropertiesHelper.class.getClassLoader().getResource(FILENAME);
                fos = new FileOutputStream(URLDecoder.decode(url.getFile(), System.getProperty("file.encoding")));
                fos.write(DBPropertiesHelper.getBytes(properties, false));
            }
            catch (Exception e) {
                message = e.getMessage();
                if (fos != null) {
                    fos.close();
                }
            }
        }
        return message;
    }

    public static byte[] getBytes(List properties, boolean localhost) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (NameValuePair pair : properties) {
            String name = pair.getName();
            String value = pair.getValue();
            sb.append(name);
            sb.append('=');
            if ("db_url".equals(name) && localhost && !"localhost".equals(DBPropertiesHelper.getSystem(value))) {
                sb.append(DBPropertiesHelper.replaceSystemByLocalhost(value));
            } else {
                sb.append(value);
            }
            sb.append(FacConstants.EOL);
        }
        if (Log.debug()) {
            Log.debug((String)sb.toString());
        }
        return sb.toString().getBytes();
    }

    public static String saveToIFS(List properties, LoginHelper loginHelper) throws Exception {
        String message = null;
        AS400Enhanced as400 = loginHelper.getAs400();
        try {
            IFSFile ifsFile = new IFSFile((AS400)as400, String.valueOf(FacConstants.getContextName()) + "/WEB-INF/classes/" + FILENAME);
            if (!ifsFile.exists()) {
                TokenList tl = new TokenList();
                tl.addNonTranslatable(String.valueOf(FacConstants.getContextName()) + "/WEB-INF/classes");
                message = LanguageHelper.getString("nl.ibs.fac.language", "DoesNotExistOnAS400", tl);
            } else {
                IFSFileOutputStream fos = new IFSFileOutputStream(ifsFile, -4, false, 0);
                Log.info((String)("transferring file IFSFile: " + ifsFile.getName()));
                fos.write(DBPropertiesHelper.getBytes(properties, true));
                fos.close();
            }
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        if (Log.debug()) {
            Log.debug((String)message);
        }
        return message;
    }

    public static void getProperties() throws Exception {
        Properties properties = PropertiesHelper.getProperties((String)FILENAME);
        dataBaseUrl = properties.getProperty("fac_db_url", null);
        system = DBPropertiesHelper.getSystem(dataBaseUrl);
        databaseUser = properties.getProperty("fac_db_user", null);
        databasePassword = properties.getProperty("fac_db_password", null);
        library = properties.getProperty("fac_db_schema", null);
    }

    private static String getSystem(String url) throws ServletException {
        int b = url.indexOf("as400:");
        if (b > -1) {
            int e = url.indexOf(";", b);
            if (e == -1) {
                e = url.length();
            }
            return url.substring(b + 6, e);
        }
        return null;
    }

    private static String replaceSystemByLocalhost(String url) throws ServletException {
        int b = url.indexOf("as400:");
        if (b > -1) {
            int e = url.indexOf(";", b);
            if (e == -1) {
                e = url.length();
            }
            return String.valueOf(url.substring(0, b)) + "as400:localhost" + url.substring(e);
        }
        return null;
    }

    public static String getLibrary() {
        return library;
    }

    public static String getSystem() {
        return system;
    }

    public static String getDatabaseUser() {
        return databaseUser;
    }

    public static String getDatabasePassword() {
        return databasePassword;
    }

    public static String getDataBaseUrl() {
        return dataBaseUrl;
    }
}

