/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import java.math.BigDecimal;
import java.text.NumberFormat;
import nl.ibs.fac.language.UserContext;

public abstract class IBSDecimal {
    public static final int DECIMALS = 2;

    public static String format(BigDecimal value) {
        return IBSDecimal.format(value, 2);
    }

    public static String format(BigDecimal value, boolean suppressZero) {
        return IBSDecimal.format(value, 2, suppressZero);
    }

    public static String format(BigDecimal value, int decimals) {
        return IBSDecimal.format(value, decimals, false);
    }

    public static String format(BigDecimal value, int decimals, boolean suppressZero) {
        if (value == null) {
            return "";
        }
        if (suppressZero && value.doubleValue() == 0.0) {
            return "";
        }
        NumberFormat numberformat = NumberFormat.getInstance(UserContext.getLocale());
        numberformat.setMinimumFractionDigits(decimals);
        numberformat.setMaximumFractionDigits(decimals);
        return numberformat.format(value.doubleValue());
    }

    public static BigDecimal create(String value) {
        return IBSDecimal.create(value, 2);
    }

    public static BigDecimal create(String value, int decimals) {
        return new BigDecimal(value).setScale(decimals, 4);
    }
}

