/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.User;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.util.AS400ConnectionManager;
import nl.ibs.util.AS400Enhanced;

public class LoginHelper
implements Serializable {
    private static final long serialVersionUID = 260383340324310168L;
    public static final String LOGINHELPER = LoginHelper.class.getName();
    private static Map<String, AS400Enhanced> sessions = new HashMap<String, AS400Enhanced>();
    private transient AS400Enhanced as400;
    private String sessionId;
    private String system;
    private String user;
    private String password;
    private String library = null;
    private boolean passwordExpired;

    public LoginHelper(String system, String user, String password, String library) {
        this(null, system, user, password, library);
    }

    public LoginHelper(String sessionId, String system, String user, String password, String library) {
        this.sessionId = sessionId;
        this.system = system;
        this.user = user;
        this.password = password;
        this.library = library;
    }

    public String login() {
        if (Log.debug()) {
            Log.debug((String)this.system);
            Log.debug((String)this.user);
            Log.debug((String)this.password);
        }
        String message = null;
        try {
            this.as400 = AS400ConnectionManager.instance().getNonNullConnection(this.system, this.user, this.password);
            if (this.sessionId != null) {
                sessions.put(this.sessionId, this.as400);
            }
            try {
                CommandCall cmd = new CommandCall((AS400)this.as400);
                cmd.run("CHGJOB INQMSGRPY(*DFT)");
                cmd.run("ADDLIBLE QGPL");
            }
            catch (Exception e) {
                Log.error((Exception)e);
            }
        }
        catch (UnknownHostException uhe) {
            message = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "unknow_host")) + ": " + this.system;
        }
        catch (AS400SecurityException e) {
            message = e.getMessage();
            this.passwordExpired = 7 == e.getReturnCode();
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        return message;
    }

    public String login(Environment env, String companyId, String bookYear) throws Exception {
        if (Log.debug()) {
            Log.debug((String)env.getFacLib());
            Log.debug((String)companyId);
            Log.debug((String)bookYear);
        }
        String message = null;
        String operationArea = env.getOperationArea();
        if (operationArea.length() == 0) {
            FISHelper helper = new FISHelper(this);
            helper.login(env.getDataLib(), env.getProgramLib());
            message = helper.getMessage();
            if (companyId != null && companyId.trim().length() > 0 && (message == null || message.trim().length() == 0)) {
                message = helper.checkAdministration(companyId, Integer.parseInt(bookYear));
            }
        } else {
            FMSHelper helper = new FMSHelper(this);
            helper.login(operationArea, companyId, bookYear);
            message = helper.getMessage();
        }
        return message;
    }

    public String checkIFS() throws Exception {
        String message = null;
        IFSFile file = new IFSFile((AS400)this.getAs400(), FacConstants.getContextName());
        if (!file.exists()) {
            TokenList tl = new TokenList();
            tl.addNonTranslatable(FacConstants.getContextName());
            message = LanguageHelper.getString("nl.ibs.fac.language", "DoesNotExistOnAS400", tl);
        }
        return message;
    }

    public String getUserDescription() throws Exception {
        return new User((AS400)this.getAs400(), this.user).getDescription();
    }

    public String[] getUserDescription(String user) throws Exception {
        String[] result = new String[2];
        String description = "";
        try {
            description = (String)new ObjectDescription((AS400)this.getAs400(), "QUSRSYS", user.trim(), "MSGQ").getValue(203);
        }
        catch (Exception e) {
            result[1] = e.getMessage();
        }
        result[0] = description;
        return result;
    }

    public void logout(Environment env, String companyId, String bookYear) throws Exception {
        String operationArea;
        if (Log.debug()) {
            Log.debug((String)env.getFacLib());
            Log.debug((String)companyId);
            Log.debug((String)bookYear);
        }
        if ((operationArea = env.getOperationArea()).length() == 0) {
            new FISHelper(this).logout(env.getDataLib(), env.getProgramLib());
        } else {
            new FMSHelper(this).logout(operationArea, companyId, bookYear);
        }
    }

    public void logout() {
        if (Log.debug()) {
            Log.debug((String)this.system);
            Log.debug((String)this.user);
            Log.debug((String)this.password);
        }
        AS400ConnectionManager.instance().returnConnection(this.getAs400(), this.password);
        if (this.sessionId != null) {
            sessions.remove(this.sessionId);
        }
    }

    public static void disconnectAll() {
        for (Map.Entry<String, AS400Enhanced> entry : sessions.entrySet()) {
            AS400Enhanced as400 = entry.getValue();
            as400.disconnectAllServices();
        }
        sessions.clear();
    }

    public String getPassword() {
        return this.password;
    }

    public String getSystem() {
        return this.system;
    }

    public String getUser() {
        return this.user;
    }

    public String getLibrary() {
        return this.library;
    }

    public AS400Enhanced getAs400() {
        if (this.sessionId == null) {
            return this.as400;
        }
        AS400Enhanced as400 = sessions.get(this.sessionId);
        if (as400 == null) {
            Log.debug((String)"connection_lost");
        }
        return as400;
    }

    public boolean isPasswordExpired() {
        return this.passwordExpired;
    }
}

