/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import java.util.Calendar;
import java.util.Date;

public abstract class PeriodHelper {
    public static boolean isAfter(int bookYear1, int period1, int bookYear2, int period2) {
        if (bookYear1 > bookYear2) {
            return true;
        }
        return bookYear1 == bookYear2 && period1 > period2;
    }

    public static boolean isAfterOrEquals(int bookYear1, int period1, int bookYear2, int period2) {
        if (bookYear1 > bookYear2) {
            return true;
        }
        return bookYear1 == bookYear2 && period1 >= period2;
    }

    public static boolean isBefore(int bookYear1, int period1, int bookYear2, int period2) {
        if (bookYear1 < bookYear2) {
            return true;
        }
        return bookYear1 == bookYear2 && period1 < period2;
    }

    public static boolean equals(int bookYear1, int period1, int bookYear2, int period2) {
        return bookYear1 == bookYear2 && period1 == period2;
    }

    public static String toString(int bookYear, int period) {
        if (bookYear == 0) {
            return "";
        }
        return String.valueOf(bookYear) + "-" + period;
    }

    public static int[] getBookYearPeriod(String value) throws Exception {
        int index = value.indexOf(45);
        int[] yp = new int[]{Integer.parseInt(value.substring(0, index)), Integer.parseInt(value.substring(index + 1))};
        return yp;
    }

    public static int[] getNextPeriod(int numberOfPeriods, int year, int period) throws Exception {
        int[] yp = new int[]{year, period};
        yp[1] = yp[1] + 1;
        if (yp[1] > numberOfPeriods) {
            yp[0] = yp[0] + 1;
            yp[1] = 1;
        }
        return yp;
    }

    public static int[] getPreviousPeriod(int numberOfPeriods, int year, int period) throws Exception {
        int[] yp = new int[]{year, period};
        yp[1] = yp[1] - 1;
        if (yp[1] < 1) {
            yp[0] = yp[0] - 1;
            yp[1] = numberOfPeriods;
        }
        return yp;
    }

    public static int calculateNumberOfPeriods(int numberOfPeriods, int yearFrom, int periodFrom, int yearTo, int periodTo) throws Exception {
        int[] yp;
        int endPeriod;
        int endYear;
        int startPeriod;
        int startYear;
        int periods = 0;
        if (PeriodHelper.isBefore(yearFrom, periodFrom, yearTo, periodTo)) {
            startYear = yearFrom;
            startPeriod = periodFrom;
            endYear = yearTo;
            endPeriod = periodTo;
        } else {
            startYear = yearTo;
            startPeriod = periodTo;
            endYear = yearFrom;
            endPeriod = periodFrom;
        }
        do {
            ++periods;
        } while (!PeriodHelper.isAfter(startYear = (yp = PeriodHelper.getNextPeriod(numberOfPeriods, startYear, startPeriod))[0], startPeriod = yp[1], endYear, endPeriod));
        return periods;
    }

    public static Date getLastDayOfMonth(int startMonth, int year, int period, int yearCorrection) {
        int month = period;
        if (startMonth != 0) {
            if ((month = month + startMonth - 1) > 12) {
                month -= 12;
            }
            if (yearCorrection > 0) {
                if (yearCorrection == 1 && month >= startMonth) {
                    --year;
                }
                if (yearCorrection == 2 && month < startMonth) {
                    ++year;
                }
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static int[] determineStartDepreciationPeriod(int numberOfPeriods, Date acquisitionDate, int investmentYear, int investmentPeriod, int startMonth, int yearCorrection) throws Exception {
        int month = investmentPeriod;
        int year = investmentYear;
        if (startMonth != 0) {
            if ((month = month + startMonth - 1) > 12) {
                month -= 12;
            }
            if (yearCorrection > 0) {
                if (yearCorrection == 1 && month >= startMonth) {
                    --year;
                }
                if (yearCorrection == 2 && month < startMonth) {
                    ++year;
                }
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 15);
        int[] yp = new int[]{investmentYear, investmentPeriod};
        if (acquisitionDate.after(cal.getTime())) {
            return PeriodHelper.getNextPeriod(numberOfPeriods, investmentYear, investmentPeriod);
        }
        return yp;
    }
}

