/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import com.ibm.as400.access.IFSFile;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import nl.ibs.fac.ReportFileHelper;

public class ReportFile
implements Serializable {
    private static final long serialVersionUID = 6834657275870715013L;
    private String name;
    private String shortName;
    private String company;
    private String user;
    private long size;
    private Date date;
    private String time;
    private boolean directory;
    private File file;

    public ReportFile(File file) throws Exception {
        this.file = file;
        this.directory = file.isDirectory();
        this.name = file.getName();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(file.lastModified());
        this.date = cal.getTime();
        this.time = this.getTime(this.date);
        this.size = new BigDecimal(file.length()).divide(new BigDecimal(1024), 0, 0).longValue();
        String[] result = ReportFileHelper.getDetailsFromFileName(this.name);
        this.shortName = result[0];
        this.company = result[1];
        if (this.company != null) {
            this.company = this.company.replace('-', '/');
        }
        this.user = result[2];
    }

    public ReportFile(IFSFile ifsFile) throws Exception {
        this.name = ifsFile.getName();
        this.directory = ifsFile.isDirectory();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(ifsFile.lastModified());
        this.date = cal.getTime();
        this.time = this.getTime(this.date);
        this.size = new BigDecimal(ifsFile.length()).divide(new BigDecimal(1024), 0, 0).longValue();
        String[] result = ReportFileHelper.getDetailsFromFileName(this.name);
        this.shortName = result[0];
        this.company = result[1];
        if (this.company != null) {
            this.company = this.company.replace('-', '/');
        }
        this.user = result[2];
    }

    private String getTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        StringBuffer sb = new StringBuffer();
        int hour = cal.get(11);
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(':');
        int minute = cal.get(12);
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(':');
        int second = cal.get(13);
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public Date getDate() {
        return this.date;
    }

    public long getSize() {
        return this.size;
    }

    public String getTime() {
        return this.time;
    }

    public String getCompany() {
        return this.company;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getUser() {
        return this.user;
    }

    public File getFile() {
        return this.file;
    }

    public boolean getDirectory() {
        return this.directory;
    }
}

