/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.OutputField;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.EnvironmentReferenceField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FinancialCompanyReferenceField;
import nl.ibs.fac.boadapters.UserBO;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.User;

public class ActiveCompanyAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 3003128743735264669L;
    public static final String PAGE = ActiveCompanyAdapter.class.getName();
    private Window window;
    private FieldGroup fg;
    private EnvironmentReferenceField environmentReferenceField;
    private FinancialCompanyReferenceField companyReferenceField;
    private FloatBar fb;
    private User user;
    private Environment environment;

    public ActiveCompanyAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.window = new Window(this.finish.getPageid(), this.finish.getMethod());
        this.fg = new FieldGroup();
        this.environmentReferenceField = new EnvironmentReferenceField();
        this.fb = new FloatBar();
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.window.setLabel("Title.ActiveCompany");
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.environmentReferenceField.addOnChangeListener(new EnvironmentListener());
        this.user = (User)UserBO.get(this.loginHelper.getUser())[0];
        this.environmentReferenceField.setReadonly(this.user != null && this.user.getOneEnvironment());
        this.environmentReferenceField.setSelectableOnly(true);
        this.environmentReferenceField.setMandatory(true);
        if (this.env == null) {
            this.fg.add((Field)this.environmentReferenceField);
        }
        this.environmentReferenceField.setValue(this.env);
        if (this.companyReferenceField != null) {
            this.companyReferenceField.setValue(this.companyId);
        }
        this.window.add(this.fg);
        Action activate = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("activate");
        activate.setDefault(true);
        activate.setValidationEnabled(true);
        this.fb.addAction(activate);
        this.fb.addAction(this.finish);
        this.window.add(this.fb);
    }

    public DataObject show(DataObject object) throws Exception {
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject activate(DataObject object) throws Exception {
        if (this.activateEnvironment(object, this.environment) && this.activateCompany(object, this.companyReferenceField.getCompany(), this.user)) {
            return this.finish(object);
        }
        return object;
    }

    private class EnvironmentListener
    implements EventListener {
        private static final long serialVersionUID = -8541924483018914353L;

        private EnvironmentListener() {
        }

        public void event(UIObject object, String type) throws Exception {
            ActiveCompanyAdapter.this.environment = ActiveCompanyAdapter.this.environmentReferenceField.getEnvironment();
            if (ActiveCompanyAdapter.this.environment == null) {
                return;
            }
            if (ActiveCompanyAdapter.this.env != null) {
                ActiveCompanyAdapter.this.loginHelper.logout(ActiveCompanyAdapter.this.env, ActiveCompanyAdapter.this.companyId, ActiveCompanyAdapter.this.bookYear);
            }
            ActiveCompanyAdapter.this.fg.removeAllUIObjects();
            String message = ActiveCompanyAdapter.this.loginHelper.login(ActiveCompanyAdapter.this.environment, null, null);
            if (message != null && message.trim().length() > 0) {
                if (ActiveCompanyAdapter.this.env != null) {
                    ActiveCompanyAdapter.this.loginHelper.login(ActiveCompanyAdapter.this.env, ActiveCompanyAdapter.this.companyId, ActiveCompanyAdapter.this.bookYear);
                }
                ActiveCompanyAdapter.this.fg.add((Field)ActiveCompanyAdapter.this.environmentReferenceField);
                ActiveCompanyAdapter.this.fg.add(new OutputField(message, 50));
                return;
            }
            ActiveCompanyAdapter.this.companyReferenceField = new FinancialCompanyReferenceField(ActiveCompanyAdapter.this.loginHelper, ActiveCompanyAdapter.this.environment);
            ActiveCompanyAdapter.this.loginHelper.logout(ActiveCompanyAdapter.this.environment, null, null);
            if (ActiveCompanyAdapter.this.env != null) {
                ActiveCompanyAdapter.this.loginHelper.login(ActiveCompanyAdapter.this.env, ActiveCompanyAdapter.this.companyId, ActiveCompanyAdapter.this.bookYear);
            }
            ActiveCompanyAdapter.this.companyReferenceField.setMandatory(true);
            ActiveCompanyAdapter.this.companyReferenceField.setLength(10);
            ActiveCompanyAdapter.this.companyReferenceField.setDescriptionLength(40);
            ActiveCompanyAdapter.this.fg.removeAllUIObjects();
            ActiveCompanyAdapter.this.fg.add((Field)ActiveCompanyAdapter.this.environmentReferenceField);
            ActiveCompanyAdapter.this.fg.add((Field)ActiveCompanyAdapter.this.companyReferenceField);
        }
    }
}

