/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.AdditionalDepreciationBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Valuation;

public class AdditionalDepreciationAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -2478738998203102294L;
    public static final String PAGE = AdditionalDepreciationAdapter.class.getName();
    public static final String RETURNPAGE = "AdditionalDepreciationAdapterReturnPage";
    public static final String RETURNMETHOD = "AdditionalDepreciationAdapterReturnMethod";
    private Company company;
    private String[] fgTexts = new String[2];
    private FieldGroup[] fg1 = new FieldGroup[2];
    private FieldGroup fg3 = new FieldGroup("Label.Description");
    private FACDecimalField[] additionalDepreciationAmounts = new FACDecimalField[2];
    private FACDecimalField[] additionalInterestAmounts = new FACDecimalField[2];
    private BookYearPeriodGrid[] activationPeriods = new BookYearPeriodGrid[2];
    private BookYearPeriodGrid[] financialBookPeriods = new BookYearPeriodGrid[2];
    private Field description = new Field();
    private FieldGroup fgAD;
    private Asset asset;
    private Window window;
    private AdditionalDepreciationBP businessProcess;
    private Valuation[] valuations = new Valuation[2];
    private int[] facYears = new int[2];
    private int[] facPeriods = new int[2];
    private int[] finYears = new int[2];
    private int[] finPeriods = new int[2];
    private BigDecimal[] ads = new BigDecimal[2];
    private BigDecimal[] ais = new BigDecimal[2];

    public AdditionalDepreciationAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.businessProcess = new AdditionalDepreciationBP(this.company, this.numberOfPeriods);
        this.fgTexts[0] = this.governmentActivated ? "" : this.env.getAPName1();
        this.fgTexts[1] = this.env.getAPName2();
        int i = 0;
        while (i < 2) {
            this.fg1[i] = new FieldGroup(this.fgTexts[i]);
            if (this.governmentActivated && i == 0) {
                this.fg1[i].forceBorder(true);
            }
            this.additionalDepreciationAmounts[i] = new FACDecimalField("Label.AdditionalDepreciation", 15, 2);
            this.fg1[i].add((Field)this.additionalDepreciationAmounts[i]);
            this.additionalInterestAmounts[i] = new FACDecimalField("Label.AdditionalInterest", 15, 2);
            this.fg1[i].add((Field)this.additionalInterestAmounts[i]);
            this.activationPeriods[i] = new BookYearPeriodGrid("Label.FACStartPeriod", this.bookYear, this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
            this.fg1[i].add((ESPGridLayout)this.activationPeriods[i]);
            this.financialBookPeriods[i] = new BookYearPeriodGrid("Label.BookPeriod", false);
            this.fg1[i].add((ESPGridLayout)this.financialBookPeriods[i]);
            ++i;
        }
        this.fg3.add(this.description);
        this.description.setDiscardLabel(true);
        this.description.setLength(50);
        this.description.setMaxLength(30);
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAdditionalDepreciation");
        ok.setDefault(true);
        ok.setValidationEnabled(true);
        FloatBar fb = new FloatBar();
        fb.addAction(ok);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
        this.fgAD = new FieldGroup();
        this.fgAD.forceBorder(false);
        this.fgAD.add(fb);
    }

    public DataObject additionalDepreciationForm(DataObject object) throws Exception {
        this.asset = (Asset)this.getProcess().getAttribute("additionalDepreciationAsset");
        String message = this.businessProcess.hasNotPostedTransactions(this.asset);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.retrieveYearsAndPeriods();
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Title.AdditionalDepreciationAndInterest");
        this.additionalDepreciationAmounts[0].requestFocus(true);
        this.additionalDepreciationAmounts[0].setValue();
        if (this.governmentActivated && this.asset.getLoan()) {
            this.additionalDepreciationAmounts[0].setHidden(true);
        } else {
            this.additionalDepreciationAmounts[0].setHidden(false);
        }
        this.additionalInterestAmounts[0].setValue();
        this.window.add(this.fg1[0]);
        if (this.valuations[1] != null) {
            this.additionalDepreciationAmounts[1].setValue();
            this.additionalInterestAmounts[1].setValue();
            this.window.add(this.fg1[1]);
        }
        this.description.setValue();
        this.window.add(this.fg3);
        this.window.add(this.fgAD);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    private void retrieveYearsAndPeriods() throws Exception {
        this.valuations[0] = (Valuation)ValuationBO.get(this.company.getDBData(), this.company.getId(), this.asset.getCora(), this.asset.getId(), 1)[0];
        String[] yps = this.businessProcess.retrieveYearsAndPeriods(this.valuations[0]);
        this.activationPeriods[0].setValues(yps[0], yps[1]);
        this.financialBookPeriods[0].setValues(yps[2], yps[3]);
        this.valuations[1] = (Valuation)ValuationBO.get(this.company.getDBData(), this.company.getId(), this.asset.getCora(), this.asset.getId(), 2)[0];
        if (this.valuations[1] != null) {
            yps = this.businessProcess.retrieveYearsAndPeriods(this.valuations[1]);
            this.activationPeriods[1].setValues(yps[0], yps[1]);
            this.financialBookPeriods[1].setValues(yps[2], yps[3]);
        }
    }

    public DataObject createAdditionalDepreciation(DataObject object) throws Exception {
        String message;
        boolean error0 = false;
        boolean error1 = false;
        boolean error2 = false;
        this.fg1[0].removeInvalidTags();
        error0 = this.validateForCreate(object, 0);
        if (this.valuations[1] != null) {
            this.fg1[1].removeInvalidTags();
            error1 = this.validateForCreate(object, 1);
        }
        error2 = this.validateOverall(object);
        if (error0 || error1 || error2) {
            return object;
        }
        this.fillUpArrays(0);
        if (this.valuations[1] != null) {
            this.fillUpArrays(1);
        }
        if ((message = this.businessProcess.createAdditionalDepreciation(this.asset, this.valuations, this.facYears, this.facPeriods, this.finYears, this.finPeriods, this.ads, this.ais, this.description.getValue().trim(), this.loginHelper.getUser())) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.getProcess().setAttribute("additionalDepreciationAmounts", (Object)this.ads);
        this.getProcess().setAttribute("additionalInterestAmounts", (Object)this.ais);
        return this.close(object);
    }

    private void fillUpArrays(int index) throws Exception {
        this.facYears[index] = this.activationPeriods[index].getBookYear().getIntValue();
        this.facPeriods[index] = this.activationPeriods[index].getPeriod().getIntValue();
        this.finYears[index] = this.financialBookPeriods[index].getBookYear().getIntValue();
        this.finPeriods[index] = this.financialBookPeriods[index].getPeriod().getIntValue();
        this.ads[index] = this.additionalDepreciationAmounts[index].getBigDecimal();
        this.ais[index] = this.additionalInterestAmounts[index].getBigDecimal();
    }

    private boolean validateForCreate(DataObject object, int index) throws Exception {
        boolean error = false;
        if (this.additionalDepreciationAmounts[index].getBigDecimal().doubleValue() == 0.0 && this.additionalInterestAmounts[index].getBigDecimal().doubleValue() == 0.0) {
            return error;
        }
        String[] messages = null;
        messages = this.businessProcess.validateFACYearAndPeriod(this.valuations[index], this.activationPeriods[index].getBookYear().getIntValue(), this.activationPeriods[index].getPeriod().getIntValue());
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.activationPeriods[index].setInvalidTag();
        }
        if ((messages = this.businessProcess.validateFINYearAndPeriod(this.financialBookPeriods[index].getBookYear().getIntValue(), this.financialBookPeriods[index].getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.financialBookPeriods[index].setInvalidTag();
        }
        if ((messages = this.businessProcess.validateDepreciationAmount(this.asset, this.valuations[index], this.additionalDepreciationAmounts[index].getBigDecimal())) != null) {
            error = true;
            this.addErrors(object, messages);
            this.additionalDepreciationAmounts[index].setInvalidTag();
        }
        return error;
    }

    private boolean validateOverall(DataObject object) throws Exception {
        boolean error = false;
        String[] messages = null;
        messages = this.businessProcess.validateAmounts(this.additionalDepreciationAmounts[0].getBigDecimal(), this.additionalInterestAmounts[0].getBigDecimal(), this.additionalDepreciationAmounts[1].getBigDecimal(), this.additionalInterestAmounts[1].getBigDecimal());
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.additionalDepreciationAmounts[0].setInvalidTag();
            this.additionalInterestAmounts[0].setInvalidTag();
            this.additionalDepreciationAmounts[1].setInvalidTag();
            this.additionalInterestAmounts[1].setInvalidTag();
        }
        return error;
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        int i = 0;
        while (i < errors.length) {
            if (errors[i] != null && errors[i].trim().length() > 0) {
                object.addUIObject((UIObject)new Message(errors[i], "error"));
            }
            ++i;
        }
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(RETURNPAGE).toString(), this.getProcess().getAttribute(RETURNMETHOD).toString(), this.getProcess().getProcessId()));
        return object;
    }
}

