/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.servlet.ESPTranslationContext;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FormattedField;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.AnalysisCodeBO;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.db.AnalysisCode;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.queries.AnalysisCodeQuery;
import nl.ibs.jsql.DBData;

public class AnalysisCodeReferenceField
extends ODBQueryReferenceField
implements FormattedField {
    private static final long serialVersionUID = -7182925032335208105L;
    private static final String[] NAMES = new String[]{"code", "description"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description"};
    private Transformer transformer = null;
    private AnalysisGroup analysisGroup;

    public AnalysisCodeReferenceField(DBData dbData, AnalysisGroup analysisGroup) throws Exception {
        super(analysisGroup.getName(), "upper", (ODBQuery)new AnalysisCodeQuery(dbData, analysisGroup), AnalysisCode.class);
        this.setHelpId("FACDimension");
        this.analysisGroup = analysisGroup;
        this.setName(((Object)((Object)this)).getClass().getName());
        this.setTableFields(NAMES);
        this.setTableHeaderLabels(LABELS);
        this.setValueField(NAMES[0]);
        this.setDescriptionField(NAMES[1]);
        this.setTableKeys(new String[]{NAMES[0]});
        this.setTableHeaderSizes(new short[]{100, 500});
        this.setLength(10);
        this.setMaxLength(analysisGroup.getLength());
        this.setDescriptionLength(40);
        this.setSearchFields(NAMES);
        this.setSearchFieldLabels(LABELS);
        if (analysisGroup.getType().equals("N")) {
            this.setType("number");
            String[] stringArray = new String[2];
            stringArray[0] = "number";
            this.setTableColumnTypes(stringArray);
            this.transformer = new NumericIdTransformer();
            Transformer[] transformerArray = new Transformer[2];
            transformerArray[0] = this.transformer;
            this.setTableTransformers(transformerArray);
        }
        this.addOnChangeListener(new MyListener());
    }

    protected boolean selectedValueExecuteHook(DataObject object) {
        AnalysisCode analysisCode = (AnalysisCode)this.getSelectedObject();
        try {
            String code = analysisCode.getCode();
            if (this.transformer != null) {
                this.setValue((String)this.transformer.transform((Object)code));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public Field setValue(AssetAnalysisCode assetAnalysisCode) throws Exception {
        if (assetAnalysisCode == null) {
            this.setValue();
            this.setDescription("");
            return this;
        }
        this.setDescription(assetAnalysisCode.getAnalysisCode().getDescription());
        String value = assetAnalysisCode.getCode();
        if (this.transformer != null) {
            return super.setValue((String)this.transformer.transform((Object)value));
        }
        return super.setValue(value);
    }

    public void validate() throws Exception {
        super.validate();
        if (this.getValue().trim().length() == 0) {
            this.setDescription("");
            return;
        }
        Object[] result = AnalysisCodeBO.get(this.analysisGroup.getDBData(), this.analysisGroup, this.getValue().trim());
        if (result[1] != null) {
            this.setInvalidTag();
            throw new UserErrorMessage(ESPTranslationContext.getTranslationHelper().translate("key_not_found", (Object)this.getLabel(), false));
        }
        AnalysisCode analysisCode = (AnalysisCode)result[0];
        this.setDescription(analysisCode.getDescription());
    }

    public String getFormattedId() throws Exception {
        return AnalysisGroupBO.formatCode(this.analysisGroup, this.getValue());
    }

    private class MyListener
    implements EventListener {
        private static final long serialVersionUID = 3479164341424923213L;

        private MyListener() {
        }

        public void event(UIObject object, String eventType) throws Exception {
            if (AnalysisCodeReferenceField.this.getValue().trim().length() == 0) {
                AnalysisCodeReferenceField.this.setDescription("");
                return;
            }
            Object[] result = AnalysisCodeBO.get(AnalysisCodeReferenceField.this.analysisGroup.getDBData(), AnalysisCodeReferenceField.this.analysisGroup, AnalysisCodeReferenceField.this.getValue().trim());
            if (result[0] != null) {
                AnalysisCode analysisCode = (AnalysisCode)result[0];
                AnalysisCodeReferenceField.this.setDescription(analysisCode.getDescription());
                return;
            }
            AnalysisCodeReferenceField.this.setDescription("");
        }
    }
}

