/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.AlphaNumericEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.adapters.AnalysisCodeAdapter;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.AssetAnalysisCodeBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.queries.AnalysisGroupQuery;

public class AnalysisGroupAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -420558773132404621L;
    public static final String PAGE = AnalysisGroupAdapter.class.getName();
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"name", "shortName"};
    private static final String[] LABELS = new String[]{"Label.Name", "Label.ShortName"};
    private static final short[] SIZES = new short[]{500, 150};
    private static final String[] TYPES = new String[2];
    private static final Transformer[] TRANSFORMERS = new Transformer[2];
    private Map inputComponents = new HashMap();
    private static final String REFRESH = "refresh";
    private static final String CREATEFORM = "initCreateForm";
    private static final String CREATE = "create";
    private static final String ANALYSISCODES = "showAnalysisCodes";
    private static final String EDITFORM = "editForm";
    private static final String EDIT = "edit";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    protected FloatBar fbShow = new FloatBar();
    protected FloatBar fbCreate = new FloatBar();
    protected FloatBar fbEdit = new FloatBar();
    protected FloatBar fbDelete = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private Panel group1 = new HeaderPanel();
    private FieldGroup group2 = new FieldGroup("Label.AnalysisCodeId");
    private Field name = new Field("Label.Description");
    private Field shortName = new Field("Label.ShortName");
    private ChangeAction changeAction = new ChangeAction();
    private ComboBox type;
    private NumberField length = new NumberField("Label.Length", 2, true);
    private CheckBox autoNumber = new CheckBox("Label.AutoNumber");
    private NumberField startValue = new NumberField("Label.StartValue", 9, true);
    private AnalysisGroup analysisGroup;
    private Object[] analysisGroups;
    private static final int NEW = 0;
    private static final int UPD = 1;

    public AnalysisGroupAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEFORM);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDITFORM);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(edit);
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        Action analysisCodes = new Action("Button.AnalysisCodes").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(ANALYSISCODES);
        this.rowActions = new Action[]{analysisCodes, edit, confirmDelete};
        this.headerActions = new Action[]{refresh, create};
        Action createOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        createOK.setValidationEnabled(true);
        createOK.setDefault(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.cancel);
        this.fbCreate.addAction(this.finish);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
        this.group1.setWidth(676);
        this.name.setMandatory(true);
        this.name.setLength(30);
        this.name.setMaxLength(25);
        this.group1.addUIObject((UIObject)this.name);
        this.shortName.setMandatory(true);
        this.shortName.setLength(12);
        this.shortName.setMaxLength(10);
        this.group1.addUIObject((UIObject)this.shortName);
        this.type = EnumHelper.createComboBox("Label.Type", AlphaNumericEnum.getCollection(), true);
        this.type.setWidth("120");
        this.type.add((Action)this.changeAction);
        this.group2.add(this.type);
        this.length.setMandatory(true);
        this.group2.add((Field)this.length);
        this.group2.add(this.autoNumber);
        this.startValue.setMinValue(0L, true);
        this.startValue.setValue(0L);
        this.group2.add((Field)this.startValue);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        if (this.dataSetId != null && !this.companyId.equals(this.dataSetId)) {
            object.addUIObject((UIObject)new Message(String.valueOf(object.translate("company_uses_basic_data_from_other_company", object.getLocale())) + " (" + this.dataSetId + ")", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.AnalysisGroups", "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        AnalysisGroupQuery query = new AnalysisGroupQuery(this.dbData, this.companyId, 1);
        this.table = new ODBTable(AnalysisGroup.class, (ODBQuery)query, new String[]{"name"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setInputComponents(this.inputComponents);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.searchPanel.setCSSClass("headerPanel");
        Action filterAction = this.table.createFilterAction(NAMES, LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        this.name.setValue();
        this.shortName.setValue();
        this.type.setSelectedOptionValue("A");
        this.length.setValue();
        this.autoNumber.setValue(false);
        this.autoNumber.setHidden(true);
        this.startValue.setValue();
        this.startValue.setHidden(true);
        return this.createForm(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateAnalysisGroup", "screen_name"));
        object.addUIObject((UIObject)this.group1);
        object.addUIObject((UIObject)this.group2);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        boolean validationOK = this.validate(object, 0);
        if (!validationOK) {
            return object;
        }
        Object[] result = AnalysisGroupBO.create(this.dbData, this.companyId, 0, 1, this.name.getValue().trim(), this.shortName.getValue().trim(), this.type.getValue(), this.length.getIntValue(), 0, this.autoNumber.isChecked(), this.startValue.getIntValue());
        String message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        boolean bDesc = this.table.getODBCursor().getDescending();
        String sSortedColumn = this.table.getODBCursor().getOrderColumn();
        this.table.getODBCursor().orderByColumn(sSortedColumn);
        this.table.getODBCursor().setDescending(bDesc);
        this.table.reload();
        return this.show(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        boolean validSelection = this.getSelectedItems(object, false);
        if (!validSelection) {
            return object;
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditAnalysisGroup", "screen_name"));
        this.name.setValue(this.analysisGroup.getName().trim());
        this.shortName.setValue(this.analysisGroup.getShortName().trim());
        this.type.setValueAsString(this.analysisGroup.getType());
        this.length.setValue(Integer.toString(this.analysisGroup.getLength()));
        this.autoNumber.setValue(this.analysisGroup.getAutoNumber());
        this.startValue.setValue(Integer.toString(this.analysisGroup.getStartValue()));
        this.changeAction.execute(object);
        object.addUIObject((UIObject)this.group1);
        object.addUIObject((UIObject)this.group2);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        boolean validationOK = this.validate(object, 1);
        if (!validationOK) {
            return object;
        }
        String message = AnalysisGroupBO.update(this.analysisGroup, 1, this.name.getValue().trim(), this.shortName.getValue().trim(), this.type.getValue(), this.length.getIntValue(), 0, this.autoNumber.isChecked(), this.startValue.getIntValue());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("name", (Object)this.name.getValue(), true);
        this.table.reload();
        return this.show(object);
    }

    private boolean validate(DataObject object, int mode) throws Exception {
        String message = AlphaNumericEnum.validateLength(this.length.getIntValue(), this.type.getValue());
        if (message != null) {
            this.length.setInvalidTag();
            object.addUIObject((UIObject)new Message(message, "error"));
            return false;
        }
        message = AlphaNumericEnum.validateStartValue(this.autoNumber.isChecked(), this.startValue.getIntValue(), this.length.getIntValue());
        if (message != null) {
            this.startValue.setInvalidTag();
            object.addUIObject((UIObject)new Message(message, "error"));
            return false;
        }
        return true;
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        boolean validSelection = this.getSelectedItems(object, true);
        int i = 0;
        while (i < this.analysisGroups.length) {
            AnalysisGroup ac = (AnalysisGroup)this.analysisGroups[i];
            if (AssetAnalysisCodeBO.hasAssetsForAnalysisGroup(ac)) {
                object.addUIObject((UIObject)new Message("code_to_delete_cannot_have_assets", "error"));
                return object;
            }
            if (AssetTypeBO.hasAssetTypesForAnalysisGroup(ac)) {
                object.addUIObject((UIObject)new Message("code_to_delete_cannot_have_assetType", "error"));
                return object;
            }
            ++i;
        }
        if (!validSelection) {
            return object;
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteAnalysisGroups", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.analysisGroups.length);
        int i = 0;
        while (i < this.analysisGroups.length) {
            list.add(this.analysisGroups[i]);
            ++i;
        }
        CollectionTable table = new CollectionTable(AnalysisGroup.class, list, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setColumnTypes(TYPES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        int i = 0;
        while (i < this.analysisGroups.length) {
            AnalysisGroup analysisGroup = (AnalysisGroup)this.analysisGroups[i];
            if (analysisGroup != null && (message = AnalysisGroupBO.delete(analysisGroup)) != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
            }
            ++i;
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    public DataObject showAnalysisCodes(DataObject object) throws Exception {
        this.analysisGroup = (AnalysisGroup)TableHelper.getSelectedItem((DataObject)object);
        if (this.analysisGroup.getUsage() != 1) {
            object.addUIObject((UIObject)new Message("no_FAC_dimension", "error"));
            return object;
        }
        this.getProcess().setAttribute("analysisGroup", (Object)this.analysisGroup);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(AnalysisCodeAdapter.PAGE), "initDependingFields", this.getProcess().getProcessId()));
        return object;
    }

    private boolean getSelectedItems(DataObject object, boolean multipleSelectionAllowed) throws Exception {
        boolean validSelection = true;
        this.analysisGroups = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.analysisGroups.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            validSelection = false;
        }
        if (validSelection && !multipleSelectionAllowed && this.analysisGroups.length > 1) {
            object.addUIObject((UIObject)new Message("OnlyOneSelectionAllowed", "error"));
            validSelection = false;
        }
        if (validSelection && !multipleSelectionAllowed) {
            this.analysisGroup = (AnalysisGroup)this.analysisGroups[0];
        }
        return validSelection;
    }

    private class ChangeAction
    extends Action {
        private static final long serialVersionUID = -4724248188029638538L;

        private ChangeAction() {
        }

        public boolean execute(DataObject dataObject) throws Exception {
            AnalysisGroupAdapter.this.type.setHidden(false);
            AnalysisGroupAdapter.this.type.setMandatory(true);
            AnalysisGroupAdapter.this.length.setHidden(false);
            AnalysisGroupAdapter.this.length.setMandatory(true);
            if (!AnalysisGroupAdapter.this.type.getValue().equals("N")) {
                AnalysisGroupAdapter.this.autoNumber.setValue(false);
                AnalysisGroupAdapter.this.autoNumber.setHidden(true);
                AnalysisGroupAdapter.this.startValue.setValue();
                AnalysisGroupAdapter.this.startValue.setHidden(true);
                return true;
            }
            AnalysisGroupAdapter.this.autoNumber.setHidden(false);
            AnalysisGroupAdapter.this.startValue.setHidden(false);
            return true;
        }
    }
}

