/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.AnalysisCodeReferenceField;
import nl.ibs.fac.adapters.AnalysisFieldHelper;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.AssetAnalysisCodeBO;
import nl.ibs.fac.boadapters.AssetValueBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.jsql.DBData;

public class AssetDimensionPanels
implements Serializable {
    private static final long serialVersionUID = 861406354098066590L;
    private LoginHelper loginHelper;
    private DBData dbData = null;
    private Environment env = null;
    private Company company = null;
    private Company dataSet = null;
    private boolean readOnly;
    protected FieldGroup financialPanel;
    protected String[] finTexts = new String[5];
    public FinancialReferenceField[] financialDimension = new FinancialReferenceField[5];
    public boolean assetHasFinancialDimensions;
    protected FieldGroup dimensionPanel;
    public AnalysisGroup[] analysisGroup = new AnalysisGroup[10];
    public AnalysisCodeReferenceField[] dimension = new AnalysisCodeReferenceField[10];
    public AssetAnalysisCode[] assetAnalysisCode = new AssetAnalysisCode[10];
    public Field[] freeDimension;
    public AssetValue[] assetValue = new AssetValue[10];

    public AssetDimensionPanels(LoginHelper loginHelper, DBData dbData, Environment env, Company company, boolean readOnly) throws Exception {
        this.loginHelper = loginHelper;
        this.dbData = dbData;
        this.env = env;
        this.company = company;
        this.dataSet = company;
        if (company.getDataSetId() != null) {
            this.dataSet = company.getDataSet();
        }
        this.readOnly = readOnly;
        this.initialize();
    }

    private void initialize() throws Exception {
        this.finTexts[0] = this.env.getName1();
        this.finTexts[1] = this.env.getName2();
        this.finTexts[2] = this.env.getName3();
        this.finTexts[3] = this.env.getName4();
        this.finTexts[4] = this.env.getName5();
        this.financialPanel = new FieldGroup("Label.FinancialDimensions");
        this.dimensionPanel = new FieldGroup("Label.OtherDimensions");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected FieldGroup initializeFINDimensionPanel(Asset asset, AssetType assetType, IncomingFinancialTransaction ift, Credit credit) throws Exception {
        this.financialPanel.removeAllChildUIObjects();
        this.assetHasFinancialDimensions = false;
        int usage = 0;
        int i = 0;
        while (i < this.finTexts.length) {
            block21: {
                String value = null;
                switch (i) {
                    case 0: {
                        usage = assetType.getFinancialDimension1Usage();
                        if (usage != 0) {
                            if (asset != null) {
                                value = asset.getFinDimId1();
                                break;
                            }
                            if (ift != null) {
                                value = ift.getFinDimId1();
                                break;
                            }
                            if (credit == null) break;
                            value = credit.getFinDimId1();
                            break;
                        }
                        break block21;
                    }
                    case 1: {
                        usage = assetType.getFinancialDimension2Usage();
                        if (usage != 0) {
                            if (asset != null) {
                                value = asset.getFinDimId2();
                                break;
                            }
                            if (ift != null) {
                                value = ift.getFinDimId2();
                                break;
                            }
                            if (credit == null) break;
                            value = credit.getFinDimId2();
                            break;
                        }
                        break block21;
                    }
                    case 2: {
                        usage = assetType.getFinancialDimension3Usage();
                        if (usage != 0) {
                            if (asset != null) {
                                value = asset.getFinDimId3();
                                break;
                            }
                            if (ift != null) {
                                value = ift.getFinDimId3();
                                break;
                            }
                            if (credit == null) break;
                            value = credit.getFinDimId3();
                            break;
                        }
                        break block21;
                    }
                    case 3: {
                        usage = assetType.getFinancialDimension4Usage();
                        if (usage != 0) {
                            if (asset != null) {
                                value = asset.getFinDimId4();
                                break;
                            }
                            if (ift != null) {
                                value = ift.getFinDimId4();
                                break;
                            }
                            if (credit == null) break;
                            value = credit.getFinDimId4();
                            break;
                        }
                        break block21;
                    }
                    case 4: {
                        usage = assetType.getFinancialDimension5Usage();
                        if (usage == 0) break block21;
                        if (asset != null) {
                            value = asset.getFinDimId5();
                            break;
                        }
                        if (ift == null) break;
                        value = ift.getFinDimId5();
                    }
                }
                this.assetHasFinancialDimensions = true;
                this.financialDimension[i] = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company) : new FMSReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company);
                this.financialDimension[i].setValue(value);
                this.financialDimension[i].setMandatory(usage == 2);
                this.financialDimension[i].setReadonly(this.readOnly);
                this.financialPanel.add((Field)this.financialDimension[i]);
            }
            ++i;
        }
        return this.financialPanel;
    }

    protected FieldGroup initializeFACDimensionPanel(Asset asset, AssetType assetType, boolean facDimensionsReadOnly, Credit credit) throws Exception {
        this.dimensionPanel.removeAllChildUIObjects();
        this.freeDimension = new Field[10];
        boolean mandatory = false;
        String defaultCode = "";
        int i = 0;
        while (i < 10) {
            switch (i) {
                case 0: {
                    this.analysisGroup[i] = assetType.getAnalysisGroup1();
                    mandatory = assetType.getSeqNr1Mandatory();
                    defaultCode = assetType.getDefaultAnalysisCode1();
                    break;
                }
                case 1: {
                    this.analysisGroup[i] = assetType.getAnalysisGroup2();
                    mandatory = assetType.getSeqNr2Mandatory();
                    defaultCode = assetType.getDefaultAnalysisCode2();
                    break;
                }
                case 2: {
                    this.analysisGroup[i] = assetType.getAnalysisGroup3();
                    mandatory = assetType.getSeqNr3Mandatory();
                    defaultCode = assetType.getDefaultAnalysisCode3();
                    break;
                }
                case 3: {
                    this.analysisGroup[i] = assetType.getAnalysisGroup4();
                    mandatory = assetType.getSeqNr4Mandatory();
                    defaultCode = assetType.getDefaultAnalysisCode4();
                    break;
                }
                case 4: {
                    this.analysisGroup[i] = assetType.getAnalysisGroup5();
                    mandatory = assetType.getSeqNr5Mandatory();
                    defaultCode = assetType.getDefaultAnalysisCode5();
                    break;
                }
                case 5: {
                    this.analysisGroup[i] = assetType.getAnalysisGroup6();
                    mandatory = assetType.getSeqNr6Mandatory();
                    defaultCode = assetType.getDefaultAnalysisCode6();
                    break;
                }
                case 6: {
                    this.analysisGroup[i] = assetType.getAnalysisGroup7();
                    mandatory = assetType.getSeqNr7Mandatory();
                    defaultCode = assetType.getDefaultAnalysisCode7();
                    break;
                }
                case 7: {
                    this.analysisGroup[i] = assetType.getAnalysisGroup8();
                    mandatory = assetType.getSeqNr8Mandatory();
                    defaultCode = assetType.getDefaultAnalysisCode8();
                    break;
                }
                case 8: {
                    this.analysisGroup[i] = assetType.getAnalysisGroup9();
                    mandatory = assetType.getSeqNr9Mandatory();
                    defaultCode = assetType.getDefaultAnalysisCode9();
                    break;
                }
                case 9: {
                    this.analysisGroup[i] = assetType.getAnalysisGroup10();
                    mandatory = assetType.getSeqNr10Mandatory();
                    defaultCode = assetType.getDefaultAnalysisCode10();
                }
            }
            if (this.analysisGroup[i] != null) {
                Object field;
                if (this.analysisGroup[i].getUsage() == 1) {
                    this.dimension[i] = new AnalysisCodeReferenceField(this.dbData, this.analysisGroup[i]);
                    if (asset != null) {
                        AssetAnalysisCode code = (AssetAnalysisCode)AssetAnalysisCodeBO.get(this.dbData, this.company.getId(), this.analysisGroup[i].getSeqNr(), asset.getCora(), asset.getId())[0];
                        if (code != null) {
                            this.assetAnalysisCode[i] = code;
                            this.dimension[i].setValue(code);
                        }
                    } else if (credit != null) {
                        String creditCode = this.retrieveCreditAnalysisCode(credit, this.analysisGroup[i].getSeqNr());
                        if (creditCode.trim().length() > 0) {
                            this.dimension[i].setValue(creditCode);
                            this.dimension[i].validate();
                        }
                    } else if (!"".equals(defaultCode.trim())) {
                        this.dimension[i].setValue(defaultCode);
                        this.dimension[i].validate();
                    }
                    field = this.dimension[i];
                } else {
                    String creditValue;
                    if (this.analysisGroup[i].getUsage() == 3) {
                        if (this.env.getOperationArea().length() == 0) {
                            int index = 10;
                            if (this.analysisGroup[i].getSeqNr() == this.dataSet.getAGCreditorSequenceNbr()) {
                                index = 11;
                            }
                            this.freeDimension[i] = new FISReferenceField(this.loginHelper, this.analysisGroup[i].getName(), index, this.company);
                        } else {
                            int index = 10;
                            if (this.analysisGroup[i].getSeqNr() == this.dataSet.getAGCreditorSequenceNbr()) {
                                index = 11;
                            }
                            if (this.analysisGroup[i].getSeqNr() == this.dataSet.getAGRelationSequenceNbr()) {
                                index = 12;
                            }
                            this.freeDimension[i] = new FMSReferenceField(this.loginHelper, this.analysisGroup[i].getName(), index, this.company);
                        }
                    } else {
                        this.freeDimension[i] = AnalysisFieldHelper.create(this.analysisGroup[i]);
                    }
                    if (asset != null) {
                        AssetValue value = (AssetValue)AssetValueBO.get(this.dbData, this.company.getId(), this.analysisGroup[i].getSeqNr(), asset.getCora(), asset.getId())[0];
                        if (value != null) {
                            this.assetValue[i] = value;
                            this.freeDimension[i].setValue(value.getValue());
                        }
                    } else if (credit != null && (creditValue = this.retrieveCreditAnalysisCode(credit, this.analysisGroup[i].getSeqNr())).trim().length() > 0) {
                        this.freeDimension[i].setValue(creditValue.trim());
                    }
                    field = this.freeDimension[i];
                }
                if (facDimensionsReadOnly) {
                    field.setReadonly(true);
                } else {
                    field.setMandatory(mandatory);
                }
                this.dimensionPanel.add(field);
            }
            ++i;
        }
        this.dimensionPanel.setHidden(!this.dimensionPanel.hasUIObjects());
        return this.dimensionPanel;
    }

    private String retrieveCreditAnalysisCode(Credit credit, int seqNr) throws Exception {
        String creditCode = "";
        if (this.company.getSeqNr1() != null && this.company.getSeqNr1() == seqNr) {
            creditCode = credit.getDimValue1();
        } else if (this.company.getSeqNr2() != null && this.company.getSeqNr2() == seqNr) {
            creditCode = credit.getDimValue2();
        } else if (this.company.getSeqNr3() != null && this.company.getSeqNr3() == seqNr) {
            creditCode = credit.getDimValue3();
        } else if (this.company.getSeqNr4() != null && this.company.getSeqNr4() == seqNr) {
            creditCode = credit.getDimValue4();
        } else if (this.company.getSeqNr5() != null && this.company.getSeqNr5() == seqNr) {
            creditCode = credit.getDimValue5();
        } else if (this.company.getSeqNr6() != null && this.company.getSeqNr6() == seqNr) {
            creditCode = credit.getDimValue6();
        }
        return creditCode;
    }

    protected void validateDimensionForm() throws Exception {
        this.financialPanel.removeInvalidTags();
        this.financialPanel.validateAll();
        int i = 0;
        while (i < 10) {
            if (this.dimension[i] != null) {
                this.dimension[i].validate();
            }
            ++i;
        }
    }

    public String getFreeDimensionValue(int i) throws Exception {
        if (this.freeDimension[i] instanceof FinancialReferenceField) {
            return ((FinancialReferenceField)this.freeDimension[i]).getFormattedId();
        }
        return this.freeDimension[i].getValue().trim();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected FinancialReferenceField[] getFINDimensions() throws Exception {
        int usage = 0;
        int i = 0;
        while (i < this.finTexts.length) {
            block8: {
                switch (i) {
                    case 0: {
                        usage = this.company.getFinancialDimension1Usage();
                        if (usage != 0) break;
                        break block8;
                    }
                    case 1: {
                        usage = this.company.getFinancialDimension2Usage();
                        if (usage != 0) break;
                        break block8;
                    }
                    case 2: {
                        usage = this.company.getFinancialDimension3Usage();
                        if (usage != 0) break;
                        break block8;
                    }
                    case 3: {
                        usage = this.company.getFinancialDimension4Usage();
                        if (usage != 0) break;
                        break block8;
                    }
                    case 4: {
                        usage = this.company.getFinancialDimension5Usage();
                        if (usage == 0) break block8;
                    }
                }
                this.financialDimension[i] = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company) : new FMSReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company);
                this.financialDimension[i].setMandatory(usage == 2);
                this.financialDimension[i].setReadonly(this.readOnly);
            }
            ++i;
        }
        return this.financialDimension;
    }
}

