/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.AssetTypeBooleanTransformer;
import nl.ibs.fac.adapters.AssetTypeCategoryTransformer;
import nl.ibs.fac.adapters.AssetTypePanels;
import nl.ibs.fac.adapters.AssetTypeReportAdapter;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.MainAccountSchemeAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.queries.AssetTypeQuery;
import nl.ibs.util.Scrambler;

public class AssetTypeAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -3811316965786130608L;
    public static final String PAGE = AssetTypeAdapter.class.getName();
    private Company company;
    private AssetTypePanels panels;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"id", "description", "category", "is3rdPartyLoan", "limitedDepreciation", "exclWriteOff", "notUsed"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.Category", "Label.ThirdPartyLoan", "Label.LimitedDepreciation", "Label.ExclWriteOff", "Label.NotUsedAnymore"};
    private static final String[] TYPES;
    private static final short[] SIZES;
    private static final Transformer[] TRANSFORMERS;
    private static final String[] TOOLTIPS;
    private ODBTable table = null;
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbShow;
    private FloatBar fbCreate;
    private FloatBar fbCreateContinued;
    private FloatBar fbEdit;
    private FloatBar fbDelete;
    private AssetType assetType;
    private Object[] assetTypes;
    private String masActionName = "Label.MainAccountScheme";

    static {
        String[] stringArray = new String[7];
        stringArray[2] = "text";
        TYPES = stringArray;
        SIZES = new short[]{100, 280, 140, 20, 20, 20, 20};
        Transformer[] transformerArray = new Transformer[7];
        transformerArray[2] = new AssetTypeCategoryTransformer();
        transformerArray[3] = new AssetTypeBooleanTransformer(1);
        transformerArray[4] = new AssetTypeBooleanTransformer(2);
        transformerArray[5] = new AssetTypeBooleanTransformer(3);
        transformerArray[6] = new AssetTypeBooleanTransformer(0);
        TRANSFORMERS = transformerArray;
        TOOLTIPS = new String[]{"Label.ThirdPartyLoan", "Label.LimitedDepreciation", "Label.ExclWriteOff", "Label.NotUsedAnymore"};
    }

    public AssetTypeAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.fbShow = new FloatBar();
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh");
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initCreateForm");
        Action report = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("report");
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete");
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(report);
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        this.fbCreate = new FloatBar();
        Action createOK = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createCommonFormContinued");
        createOK.setDefault(true);
        createOK.setValidationEnabled(true);
        this.fbCreate.addAction(this.back);
        this.fbCreate.addAction(createOK);
        this.fbCreateContinued = new FloatBar();
        Action createOKContinued = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm");
        createOKContinued.setDefault(true);
        createOKContinued.setValidationEnabled(true);
        this.fbCreateContinued.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createCommonForm"));
        this.fbCreateContinued.addAction(createOKContinued);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initEditForm");
        this.rowActions = new Action[]{edit, report, confirmDelete};
        Action reportAll = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("reportAll");
        this.headerActions = new Action[]{refresh, create, reportAll};
        this.fbEdit = new FloatBar();
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
        editOK.setDefault(true);
        editOK.setValidationEnabled(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        this.fbDelete = new FloatBar();
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete");
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Types", "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        AssetTypeQuery query = new AssetTypeQuery(this.dbData, this.companyId, false);
        this.table = new ODBTable(AssetType.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setTextCodeSingleObject("Label.AssetType");
        this.table.setTextCodeMultipleObjects("Label.AssetTypes");
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnTypes(TYPES);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.searchPanel.setCSSClass("headerPanel");
        Action filterAction = this.table.createFilterAction(NAMES, LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        this.panels = new AssetTypePanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, null);
        return this.createCommonForm(object);
    }

    public DataObject createCommonForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        Header header = new Header("Title.CreateType", "screen_name");
        header.setHelpId("Title.CreateTypeLabel.Common");
        object.addUIObject((UIObject)header);
        header = new Header("Label.Common", "sub_screen_name");
        object.addUIObject((UIObject)header);
        object.addUIObject((UIObject)this.panels.mainPanel);
        this.panels.id.setReadonly(false);
        this.panels.description.setReadonly(false);
        object.addUIObject((UIObject)this.panels.financialPanel);
        object.addUIObject((UIObject)this.panels.subPanel2);
        object.addUIObject((UIObject)this.panels.subPanel);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject createCommonFormContinued(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        Header header = new Header("Title.CreateType", "screen_name");
        header.setHelpId("Title.CreateTypeLabel.OtherDimensions");
        object.addUIObject((UIObject)header);
        header = new Header("Label.OtherDimensions", "sub_screen_name");
        object.addUIObject((UIObject)header);
        object.addUIObject((UIObject)this.panels.mainPanel);
        this.panels.id.setReadonly(true);
        this.panels.description.setReadonly(true);
        object.addUIObject((UIObject)this.panels.dimensionPanel);
        object.addUIObject((UIObject)this.fbCreateContinued);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        String message;
        if (this.panels.jtTabCountMax == -1 && (message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount)) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.createAccountingPrincipleForm(object);
        }
        Object[] result = this.panels.create();
        String message2 = (String)result[1];
        if (message2 != null) {
            object.addUIObject((UIObject)new Message(message2, "error"));
            return object;
        }
        this.assetType = (AssetType)result[0];
        this.table.setPointer("id", (Object)this.assetType.getId(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject initEditForm(DataObject object) throws Exception {
        this.assetType = (AssetType)TableHelper.getSelectedItem((DataObject)object);
        this.panels = new AssetTypePanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, this.assetType);
        this.panels.setValues();
        this.getProcess().setAttribute("MainAccountSchemeAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("MainAccountSchemeAdapterReturnMethod", (Object)"editForm");
        this.getProcess().setAttribute("assetType", (Object)this.assetType);
        this.panels.setMASAction(new MainAccountSchemeAction(this.masActionName).setAdapter(this.getProcessAdapterPageName(MainAccountSchemeAdapter.PAGE)).setMethod("show"));
        return this.editForm(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditType", "screen_name"));
        object.addUIObject((UIObject)this.panels.mainPanel);
        object.addUIObject((UIObject)this.panels.mainTabPanel);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = this.panels.update();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.assetType.getId(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject report(DataObject object) throws Exception {
        this.assetTypes = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.assetTypes.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        int i = 0;
        while (i < this.assetTypes.length) {
            this.assetType = (AssetType)this.assetTypes[i];
            String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"System", this.loginHelper.getSystem()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getId()}, {"Company", this.companyId}, {"BookYear", this.bookYear}, {"FromType", this.assetType.getId()}, {"ToType", this.assetType.getId()}};
            this.getProcess().setAttribute("selections", (Object)selections);
            this.getProcess().setAttribute("classNamePDF", (Object)AssetTypeReportAdapter.CLASSNAMEPDF);
            this.getProcess().setAttribute("jobName", (Object)"Job.AssetType");
            this.getProcess().setAttribute("returnPage", (Object)PAGE);
            object = ((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).submit(object);
            ++i;
        }
        return object;
    }

    public DataObject reportAll(DataObject object) throws Exception {
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(AssetTypeReportAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.assetTypes = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        int i = 0;
        while (i < this.assetTypes.length) {
            AssetType at = (AssetType)this.assetTypes[i];
            if (AssetBO.hasAssets(at)) {
                object.addUIObject((UIObject)new Message("type_to_delete_cannot_have_assets", "error"));
                return object;
            }
            ++i;
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteTypes", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.assetTypes.length);
        int i = 0;
        while (i < this.assetTypes.length) {
            list.add(this.assetTypes[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            ++i;
        }
        CollectionTable table = new CollectionTable(AssetType.class, list, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        int i = 0;
        while (i < this.assetTypes.length) {
            AssetType assetType = (AssetType)this.assetTypes[i];
            if (assetType != null && (message = AssetTypeBO.delete(assetType)) != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
            }
            ++i;
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    public DataObject createAccountingPrincipleFormNext(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleFormPrevious(DataObject object) throws Exception {
        --this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleForm(DataObject object) throws Exception {
        if (this.panels.apTabCount == 0) {
            Object[] result = AssetTypeBO.get(this.dbData, this.companyId, this.panels.id.getValue().trim());
            if (result[0] != null) {
                this.panels.id.setInvalidTag();
                object.addUIObject((UIObject)new Message("duplicate_key", "error"));
                return object;
            }
            String message = this.panels.validateFacDims();
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
        }
        this.clearScreen(true, false, true);
        Header header = new Header(String.valueOf(object.translate("Title.CreateType", object.getLocale())) + " - " + object.translate("Label.Valuation", object.getLocale()), "screen_name");
        header.setHelpId("Title.CreateTypeLabel.Valuation");
        object.addUIObject((UIObject)header);
        header = new Header(this.panels.getAccountingPrincipleTabText(), "sub_screen_name");
        object.addUIObject((UIObject)header);
        this.panels.id.setReadonly(true);
        this.panels.description.setReadonly(true);
        object.addUIObject((UIObject)this.panels.mainPanel);
        object.addUIObject((UIObject)this.panels.apPanels[this.panels.apTabCount]);
        FloatBar fbCreateAP = new FloatBar();
        Action action = this.panels.apTabCount == 0 ? new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createCommonFormContinued") : new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious");
        fbCreateAP.addAction(action);
        action = this.panels.apTabCount == this.panels.apTabCountMax ? (this.panels.jtTabCountMax == -1 ? new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create") : new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createJournalingTermForm")) : new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormNext");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fbCreateAP.addAction(action);
        fbCreateAP.addAction(this.cancel);
        object.addUIObject((UIObject)fbCreateAP);
        return object;
    }

    public DataObject createJournalingTermFormNext(DataObject object) throws Exception {
        ++this.panels.jtTabCount;
        return this.createJournalingTermForm(object);
    }

    public DataObject createJournalingTermFormPrevious(DataObject object) throws Exception {
        --this.panels.jtTabCount;
        return this.createJournalingTermForm(object);
    }

    public DataObject createJournalingTermForm(DataObject object) throws Exception {
        String message;
        if (this.panels.jtTabCount == 0 && (message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount)) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.createAccountingPrincipleForm(object);
        }
        this.clearScreen(true, false, true);
        Header header = new Header(String.valueOf(object.translate("Title.CreateType", object.getLocale())) + " - " + object.translate("Label.MainAccountScheme", object.getLocale()), "screen_name");
        header.setHelpId("Title.CreateTypeLabel.MainAccountScheme");
        object.addUIObject((UIObject)header);
        header = new Header(this.panels.getJournalingTermTabText(), "sub_screen_name");
        header.setHelpId("Title.CreateTypeLabel.MainAccountScheme");
        object.addUIObject((UIObject)header);
        object.addUIObject((UIObject)this.panels.mainPanel);
        object.addUIObject((UIObject)this.panels.jtPanels[this.panels.jtTabCount]);
        FloatBar fbCreateJP = new FloatBar();
        Action action = this.panels.jtTabCount == 0 ? new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm") : new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createJournalingTermFormPrevious");
        fbCreateJP.addAction(action);
        action = this.panels.jtTabCount == this.panels.jtTabCountMax ? new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create") : new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createJournalingTermFormNext");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fbCreateJP.addAction(action);
        fbCreateJP.addAction(this.cancel);
        object.addUIObject((UIObject)fbCreateJP);
        return object;
    }

    private class MainAccountSchemeAction
    extends Action {
        private static final long serialVersionUID = -2677601693468038405L;

        public MainAccountSchemeAction(String name) {
            super(name);
        }

        public boolean execute(DataObject dataObject) throws Exception {
            AssetTypeAdapter.this.getProcess().setAttribute("accountingPrinciple", (Object)("" + AssetTypeAdapter.this.panels.getCurrentAccountingPrinciple()));
            return false;
        }
    }
}

