/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.queries.AssetTypeQuery;
import nl.ibs.jsql.DBData;

public class AssetTypeReferenceField
extends ODBQueryReferenceField {
    private static final long serialVersionUID = 4345351511762694162L;
    private static final String[] NAMES = new String[]{"id", "description"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description"};
    private DBData dbData;
    private String companyId;
    private boolean notUsed;
    private AssetType assetType;

    public AssetTypeReferenceField(DBData dbData, String companyId) throws Exception {
        this(dbData, companyId, false);
    }

    public AssetTypeReferenceField(DBData dbData, String companyId, boolean notUsed) throws Exception {
        super("Label.Type", "upper", (ODBQuery)new AssetTypeQuery(dbData, companyId, notUsed), AssetType.class);
        this.dbData = dbData;
        this.companyId = companyId;
        this.notUsed = notUsed;
        this.setName(((Object)((Object)this)).getClass().getName());
        this.setTableFields(NAMES);
        this.setTableHeaderLabels(LABELS);
        this.setValueField(NAMES[0]);
        this.setDescriptionField(NAMES[1]);
        this.setTableKeys(new String[]{NAMES[0]});
        this.setTableHeaderSizes(new short[]{100, 500});
        this.setLength(10);
        this.setMaxLength(10);
        this.setDescriptionLength(40);
        this.setSearchFields(NAMES);
        this.setSearchFieldLabels(LABELS);
    }

    public void validate() throws Exception {
        super.validate();
        if (this.getValue().trim().length() == 0) {
            this.setDescription("");
            return;
        }
        Object[] result = AssetTypeBO.get(this.dbData, this.companyId, this.getValue().trim());
        if (result[1] != null) {
            this.setInvalidTag();
            throw new UserErrorMessage((String)result[1]);
        }
        if (!this.getReadonly() && this.notUsed && ((AssetType)result[0]).getNotUsed()) {
            this.setInvalidTag();
            throw new UserErrorMessage("record_not_in_use");
        }
        this.assetType = (AssetType)result[0];
        this.setDescription(this.assetType.getDescription());
    }

    public AssetType getAssetType() {
        return this.assetType;
    }
}

