/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.AssetWOZValueAdapter;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.boadapters.WozValueBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.WozValue;
import nl.ibs.fac.queries.WOZValueQuery;

public class AssetWOZValueDetailAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 2879393343090664522L;
    public static final String PAGE = AssetWOZValueDetailAdapter.class.getName();
    public static final String ASSET = "asset";
    public static final String SHOW = "show";
    public static final String EDIT = "edit";
    public static final String START_ACTION = "refresh";
    private Company company;
    private Asset asset;
    private WozValue wozValue;
    private WozValue lastWozValue;
    private ODBTable table = null;
    private Panel header;
    private ReferenceField idDesc = new ReferenceField("Label.Asset");
    private AssetTypeReferenceField refType;
    private FloatBar fbShow = new FloatBar();
    private String[] names;
    private String[] labels;
    private short[] sizes;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static Transformer[] transformers;
    private static boolean[] sortable;
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbCreateGen = new FloatBar();
    private FloatBar fbCreateDetail = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private ArrayList<Object> deleteList;
    private FieldGroup generalGroup;
    private FieldGroup accPrinGroup1;
    private FieldGroup accPrinGroup2;
    private FACDecimalField wozAmount = new FACDecimalField("Label.WozValue", 15, 2);
    private BookYearPeriodGrid wozValuePeriod = null;
    private FACDecimalField limitValPercentage = new FACDecimalField("Label.LimitValPercentage", 5, 2);
    private BookYearPeriodGrid ap1LastDepreciatedPeriod = null;
    private BookYearPeriodGrid ap1LastInterestPeriod = null;
    private FACDecimalField ap1BookValue = new FACDecimalField("Label.BookValue", 15, 2);
    private FACDecimalField ap1LimitAmount = new FACDecimalField("Label.LimitValue", 15, 2);
    private BookYearPeriodGrid ap1LimitPeriod = null;
    private BookYearPeriodGrid ap2LastDepreciatedPeriod = null;
    private BookYearPeriodGrid ap2LastInterestPeriod = null;
    private FACDecimalField ap2BookValue = new FACDecimalField("Label.BookValue", 15, 2);
    private FACDecimalField ap2LimitAmount = new FACDecimalField("Label.LimitValue", 15, 2);
    private BookYearPeriodGrid ap2LimitPeriod = null;
    private boolean ap2UsedForTable = false;
    private boolean ap2UsedForAsset = false;
    private int lastDepreciationBookYearAp1 = 0;
    private int lastDepreciationPeriodAp1 = 0;
    private int lastDepreciationBookYearAp2 = 0;
    private int lastDepreciationPeriodAp2 = 0;
    private BigDecimal totalBookValueAp1;
    private BigDecimal totalBookValueAp2;

    public AssetWOZValueDetailAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        int ap2Usage;
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        String cId = this.companyId;
        if (this.dataSetId != null) {
            cId = this.dataSetId;
        }
        if ((ap2Usage = this.company.getAccountingPrinciple2Usage()) < 0) {
            Company dataSet = (Company)CompanyBO.get(this.dbData, this.company.getDataSetId())[0];
            ap2Usage = dataSet.getAccountingPrinciple2Usage();
        }
        this.ap2UsedForTable = ap2Usage != 0;
        Action previous = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(AssetWOZValueAdapter.PAGE)).setMethod(SHOW);
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(START_ACTION);
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initCreateFormGeneral");
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initEditForm");
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete");
        this.fbShow.addAction(previous);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        Action next = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initCreateFormDetail");
        next.setDefault(true);
        next.setValidationEnabled(true);
        this.fbCreateGen.addAction(this.back);
        this.fbCreateGen.addAction(next);
        this.fbCreateGen.addAction(this.finish);
        Action prev = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createFormGeneral");
        Action complete = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create");
        complete.setDefault(true);
        complete.setValidationEnabled(true);
        this.fbCreateDetail.addAction(prev);
        this.fbCreateDetail.addAction(complete);
        this.fbCreateDetail.addAction(this.finish);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete");
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
        this.rowActions = new Action[]{edit, confirmDelete};
        this.headerActions = new Action[]{refresh, create};
        this.header = new HeaderPanel();
        this.header.setWidth(600);
        this.idDesc.setReadonly(true);
        this.idDesc.setLength(10);
        this.idDesc.setDescriptionLength(40);
        this.header.addUIObject((UIObject)this.idDesc);
        this.refType = new AssetTypeReferenceField(this.dbData, cId);
        this.refType.setReadonly(true);
        this.refType.setDescriptionLength(40);
        this.header.addUIObject((UIObject)this.refType);
        this.wozAmount.setMinValue(0.0, false);
        this.wozAmount.setMandatory(true);
        this.wozValuePeriod = new BookYearPeriodGrid("Label.StartPeriod", false);
        this.wozValuePeriod.setMandatory(true);
        this.limitValPercentage.setMinValue(0.0, false);
        this.limitValPercentage.setMaxValue(100.0, true);
        this.limitValPercentage.setMandatory(true);
        this.ap1LimitPeriod = new BookYearPeriodGrid("Label.StartPeriod", false);
        this.ap2LimitPeriod = new BookYearPeriodGrid("Label.StartPeriod", false);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.MaintainWOZdetails", "screen_name"));
        object.addUIObject((UIObject)this.header);
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        WOZValueQuery query = new WOZValueQuery(this.dbData, this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId());
        this.table = new ODBTable(WozValue.class, (ODBQuery)query, new String[]{"wOZValueYear", "wOZValuePeriod"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(this.names);
        this.table.setColumnLabels(this.labels);
        this.table.setColumnSizes(this.sizes);
        this.table.setDisplayTransformers(transformers);
        this.table.setColumnSortable(sortable);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.asset = (Asset)this.getProcess().getAttribute(ASSET);
        this.setTableLabels(object);
        this.table = null;
        this.idDesc.setValue(AssetBO.unFormatId(this.company, this.asset.getId(), false));
        this.idDesc.setDescription(this.asset.getDescription());
        this.refType.setValue(this.asset.getTypeId());
        this.refType.validate();
        this.ap2UsedForAsset = this.ap2UsedForTable ? this.refType.getAssetType().getAccountingPrinciple2IsUsed() : false;
        return this.show(object);
    }

    private void setTableLabels(DataObject object) throws Exception {
        if (this.ap2UsedForTable) {
            this.names = new String[]{"WOZYearAndPeriod", "wOZAmount", "limitAmount1", "limitAmount2"};
            this.labels = new String[]{"Label.Period", "Label.WozAmount", String.valueOf(object.translate("Label.LimitValue", object.getLocale())) + "-1", String.valueOf(object.translate("Label.LimitValue", object.getLocale())) + "-2"};
            this.sizes = new short[]{90, 160, 160, 160};
            Transformer[] transformerArray = new Transformer[4];
            transformerArray[1] = DECIMALTRANSFORMER;
            transformerArray[2] = DECIMALTRANSFORMER;
            transformerArray[3] = DECIMALTRANSFORMER;
            transformers = transformerArray;
            boolean[] blArray = new boolean[4];
            blArray[1] = true;
            blArray[2] = true;
            blArray[3] = true;
            sortable = blArray;
        } else {
            this.names = new String[]{"WOZYearAndPeriod", "wOZAmount", "limitAmount1"};
            this.labels = new String[]{"Label.Period", "Label.WozAmount", String.valueOf(object.translate("Label.LimitValue", object.getLocale())) + "-1"};
            this.sizes = new short[]{90, 160, 160};
            Transformer[] transformerArray = new Transformer[3];
            transformerArray[1] = DECIMALTRANSFORMER;
            transformerArray[2] = DECIMALTRANSFORMER;
            transformers = transformerArray;
            boolean[] blArray = new boolean[3];
            blArray[1] = true;
            blArray[2] = true;
            sortable = blArray;
        }
    }

    public DataObject initCreateFormGeneral(DataObject object) throws Exception {
        this.lastWozValue = WozValueBO.getLastWozValue(this.dbData, this.companyId, this.asset.getCora(), this.asset.getId());
        this.wozAmount.setValue();
        if (this.lastWozValue != null) {
            this.wozValuePeriod.setValues("" + (this.lastWozValue.getWOZValueYear() + 1), "1");
            this.limitValPercentage.setValue(this.lastWozValue.getLimitValuePercentage());
        } else {
            this.wozValuePeriod.getBookYear().setValue(this.bookYear);
            this.wozValuePeriod.getPeriod().setValueAsString("1");
            this.limitValPercentage.setValue();
        }
        return this.createFormGeneral(object);
    }

    public DataObject createFormGeneral(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateWOZDetail", "screen_name"));
        object.addUIObject((UIObject)this.header);
        this.wozAmount.setReadonly(false);
        this.wozValuePeriod.setReadonly(false);
        this.limitValPercentage.setReadonly(false);
        this.generalGroup = new FieldGroup("Label.WozValue");
        this.generalGroup.add((Field)this.wozAmount);
        this.generalGroup.add((ESPGridLayout)this.wozValuePeriod);
        this.generalGroup.add((Field)this.limitValPercentage);
        object.addUIObject((UIObject)this.generalGroup);
        object.addUIObject((UIObject)this.fbCreateGen);
        return object;
    }

    public DataObject initCreateFormDetail(DataObject object) throws Exception {
        if (this.lastWozValue != null && !PeriodHelper.isAfter(this.wozValuePeriod.getBookYear().getIntValue(), this.wozValuePeriod.getPeriod().getIntValue(), this.lastWozValue.getWOZValueYear(), this.lastWozValue.getWOZValuePeriod())) {
            this.wozValuePeriod.setInvalidTag();
            object.addUIObject((UIObject)new Message("PeriodNotAfterLastWOZPeriod", "error"));
            return object;
        }
        this.wozAmount.setReadonly(true);
        this.wozValuePeriod.setReadonly(true);
        this.limitValPercentage.setReadonly(true);
        this.initCreateFormDetail();
        return this.createFormDetail(object);
    }

    private void initCreateFormDetail() throws Exception {
        Object[] result = ValuationBO.getLastDepreciatedPeriod(this.asset, 1);
        this.lastDepreciationBookYearAp1 = Integer.parseInt((String)result[0]);
        this.lastDepreciationPeriodAp1 = Integer.parseInt((String)result[1]);
        this.totalBookValueAp1 = (BigDecimal)result[2];
        result = ValuationBO.getLastDepreciatedPeriod(this.asset, 2);
        this.lastDepreciationBookYearAp2 = Integer.parseInt((String)result[0]);
        this.lastDepreciationPeriodAp2 = Integer.parseInt((String)result[1]);
        this.totalBookValueAp2 = (BigDecimal)result[2];
        this.ap1LastDepreciatedPeriod = new BookYearPeriodGrid("Label.LastDepreciated", "" + this.lastDepreciationBookYearAp1, "" + this.lastDepreciationPeriodAp1, true);
        this.ap1BookValue.setValue(this.totalBookValueAp1);
        this.ap1BookValue.setReadonly(true);
        this.ap1LimitAmount.setValue(this.limitValPercentage.getBigDecimal().multiply(this.wozAmount.getBigDecimal()).divide(new BigDecimal(100), 4));
        this.ap1LimitPeriod.setValues(this.wozValuePeriod.getBookYear().getValue(), this.wozValuePeriod.getPeriod().getValue());
        if (this.ap2UsedForAsset) {
            this.ap2LastDepreciatedPeriod = new BookYearPeriodGrid("Label.LastDepreciated", "" + this.lastDepreciationBookYearAp2, "" + this.lastDepreciationPeriodAp2, true);
            this.ap2BookValue.setValue(this.totalBookValueAp2);
            this.ap2BookValue.setReadonly(true);
            this.ap2LimitAmount.setValue(this.limitValPercentage.getBigDecimal().multiply(this.wozAmount.getBigDecimal()).divide(new BigDecimal(100), 4));
            this.ap2LimitPeriod.setValues(this.wozValuePeriod.getBookYear().getValue(), this.wozValuePeriod.getPeriod().getValue());
        }
    }

    public DataObject createFormDetail(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateWOZDetail", "screen_name"));
        object.addUIObject((UIObject)this.header);
        this.generalGroup = new FieldGroup("Label.WozValue");
        this.generalGroup.add((Field)this.wozAmount);
        this.generalGroup.add((ESPGridLayout)this.wozValuePeriod);
        this.generalGroup.add((Field)this.limitValPercentage);
        if (this.governmentActivated) {
            this.accPrinGroup1 = new FieldGroup("");
            this.accPrinGroup1.forceBorder(true);
        } else {
            this.accPrinGroup1 = new FieldGroup(this.env.getAPName1());
        }
        if (this.lastDepreciationBookYearAp1 != -1) {
            this.accPrinGroup1.add((ESPGridLayout)this.ap1LastDepreciatedPeriod);
            this.accPrinGroup1.add((ESPGridLayout)this.ap1LastInterestPeriod);
            this.accPrinGroup1.add((Field)this.ap1BookValue);
        }
        this.accPrinGroup1.add((Field)this.ap1LimitAmount);
        this.accPrinGroup1.add((ESPGridLayout)this.ap1LimitPeriod);
        object.addUIObject((UIObject)this.generalGroup);
        object.addUIObject((UIObject)this.accPrinGroup1);
        if (this.ap2UsedForAsset) {
            this.accPrinGroup2 = new FieldGroup(this.env.getAPName2());
            if (this.lastDepreciationBookYearAp2 != -1) {
                this.accPrinGroup2.add((ESPGridLayout)this.ap2LastDepreciatedPeriod);
                this.accPrinGroup2.add((ESPGridLayout)this.ap2LastInterestPeriod);
                this.accPrinGroup2.add((Field)this.ap2BookValue);
            }
            this.accPrinGroup2.add((Field)this.ap2LimitAmount);
            this.accPrinGroup2.add((ESPGridLayout)this.ap2LimitPeriod);
            object.addUIObject((UIObject)this.accPrinGroup2);
        }
        object.addUIObject((UIObject)this.fbCreateDetail);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        String message = this.validateForm();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        Object[] result = this.ap2UsedForAsset ? WozValueBO.create(this.dbData, this.companyId, "A", this.asset.getId(), Integer.parseInt(this.wozValuePeriod.getBookYear().getValue()), Integer.parseInt(this.wozValuePeriod.getPeriod().getValue()), this.wozAmount.getBigDecimal(), this.limitValPercentage.getBigDecimal(), Integer.parseInt(this.ap1LimitPeriod.getBookYear().getValue()), Integer.parseInt(this.ap1LimitPeriod.getPeriod().getValue()), this.ap1LimitAmount.getBigDecimal(), Integer.parseInt(this.ap2LimitPeriod.getBookYear().getValue()), Integer.parseInt(this.ap2LimitPeriod.getPeriod().getValue()), this.ap2LimitAmount.getBigDecimal()) : WozValueBO.create(this.dbData, this.companyId, "A", this.asset.getId(), Integer.parseInt(this.wozValuePeriod.getBookYear().getValue()), Integer.parseInt(this.wozValuePeriod.getPeriod().getValue()), this.wozAmount.getBigDecimal(), this.limitValPercentage.getBigDecimal(), Integer.parseInt(this.ap1LimitPeriod.getBookYear().getValue()), Integer.parseInt(this.ap1LimitPeriod.getPeriod().getValue()), this.ap1LimitAmount.getBigDecimal(), 0, 0, new BigDecimal(0));
        message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    private String validateForm() throws Exception {
        String message = null;
        message = this.validateAccountingPrinciple(this.ap1LimitPeriod, this.lastDepreciationBookYearAp1, this.lastDepreciationPeriodAp1);
        if (message != null) {
            return message;
        }
        if (this.ap2UsedForAsset) {
            return this.validateAccountingPrinciple(this.ap2LimitPeriod, this.lastDepreciationBookYearAp2, this.lastDepreciationPeriodAp2);
        }
        return null;
    }

    private String validateAccountingPrinciple(BookYearPeriodGrid bookYearPeriodGrid, int bookYear, int period) throws Exception {
        if (bookYearPeriodGrid.getBookYear().getIntValue() < Integer.parseInt(this.bookYearMin) || bookYearPeriodGrid.getBookYear().getIntValue() > Integer.parseInt(this.bookYearMax) || bookYearPeriodGrid.getPeriod().getIntValue() > this.numberOfPeriods) {
            bookYearPeriodGrid.setInvalidTag();
            return "YearPeriodInError";
        }
        if (PeriodHelper.isAfter(bookYearPeriodGrid.getBookYear().getIntValue(), bookYearPeriodGrid.getPeriod().getIntValue(), bookYear, period)) {
            if (PeriodHelper.isBefore(bookYearPeriodGrid.getBookYear().getIntValue(), bookYearPeriodGrid.getPeriod().getIntValue(), this.wozValuePeriod.getBookYear().getIntValue(), this.wozValuePeriod.getPeriod().getIntValue())) {
                bookYearPeriodGrid.setInvalidTag();
                return "PeriodBeforeWOZPeriod";
            }
        } else {
            bookYearPeriodGrid.setInvalidTag();
            return "PeriodNotAfterLastDepreciatedPeriod";
        }
        return null;
    }

    public DataObject initEditForm(DataObject object) throws Exception {
        this.wozValue = (WozValue)TableHelper.getSelectedItem((DataObject)object);
        this.wozAmount.setValue(this.wozValue.getWOZAmount());
        this.wozAmount.setReadonly(false);
        this.wozValuePeriod.setValues("" + this.wozValue.getWOZValueYear(), "" + this.wozValue.getWOZValuePeriod());
        this.wozValuePeriod.setReadonly(true);
        this.limitValPercentage.setValue(this.wozValue.getLimitValuePercentage());
        this.limitValPercentage.setReadonly(false);
        this.ap1LimitAmount.setValue(this.wozValue.getLimitAmount1());
        this.ap1LimitAmount.setMinValue(0.0, true);
        this.ap1LimitPeriod.setValues("" + this.wozValue.getLimitValueYear1(), "" + this.wozValue.getLimitValuePeriod1());
        this.ap2LimitAmount.setValue(this.wozValue.getLimitAmount2());
        this.ap2LimitAmount.setMinValue(0.0, true);
        this.ap2LimitPeriod.setValues("" + this.wozValue.getLimitValueYear2(), "" + this.wozValue.getLimitValuePeriod2());
        return this.editForm(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditWOZDetail", "screen_name"));
        object.addUIObject((UIObject)this.header);
        this.generalGroup = new FieldGroup("Label.WozValue");
        this.generalGroup.add((Field)this.wozAmount);
        this.generalGroup.add((ESPGridLayout)this.wozValuePeriod);
        this.generalGroup.add((Field)this.limitValPercentage);
        object.addUIObject((UIObject)this.generalGroup);
        if (this.governmentActivated) {
            this.accPrinGroup1 = new FieldGroup("");
            this.accPrinGroup1.forceBorder(true);
        } else {
            this.accPrinGroup1 = new FieldGroup(this.env.getAPName1());
        }
        this.accPrinGroup1.add((Field)this.ap1LimitAmount);
        this.accPrinGroup1.add((ESPGridLayout)this.ap1LimitPeriod);
        object.addUIObject((UIObject)this.accPrinGroup1);
        if (this.ap2UsedForAsset) {
            this.accPrinGroup2 = new FieldGroup(this.env.getAPShortName2());
            this.accPrinGroup2.add((Field)this.ap2LimitAmount);
            this.accPrinGroup2.add((ESPGridLayout)this.ap2LimitPeriod);
            object.addUIObject((UIObject)this.accPrinGroup2);
        }
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = this.validateForm();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        String result = WozValueBO.update(this.wozValue, this.wozAmount.getBigDecimal(), this.limitValPercentage.getBigDecimal(), this.ap1LimitAmount.getBigDecimal(), Integer.parseInt(this.ap1LimitPeriod.getBookYear().getValue()), Integer.parseInt(this.ap1LimitPeriod.getPeriod().getValue()), this.ap2LimitAmount.getBigDecimal(), this.ap2LimitPeriod.getBookYear().getIntValue(), this.ap2LimitPeriod.getPeriod().getIntValue());
        if (result != null) {
            object.addUIObject((UIObject)new Message(result, "error"));
            return object;
        }
        this.table.reload();
        return this.show(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteWOZDetails", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.createConfirmationTable(object));
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable(DataObject object) throws Exception {
        Object[] details = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.deleteList = new ArrayList(details.length);
        int i = 0;
        while (i < details.length) {
            this.deleteList.add(details[i]);
            ++i;
        }
        CollectionTable table = new CollectionTable(WozValue.class, this.deleteList, 12);
        table.setName(PAGE);
        table.setColumnNames(this.names);
        table.setColumnLabels(this.labels);
        table.setColumnSizes(this.sizes);
        table.setDisplayTransformers(transformers);
        table.setSortable(false);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        Object[] details = this.deleteList.toArray();
        int i = 0;
        while (i < details.length) {
            WozValue wozValue = (WozValue)details[i];
            if (wozValue != null && (message = WozValueBO.delete(this.asset, wozValue)) != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
            }
            ++i;
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }
}

