/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigInteger;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.InputComponent;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.UIObject;

public class BookYearPeriodGrid
extends ESPGridLayout {
    private static final long serialVersionUID = 2415685200616749768L;
    private NumberField bookYear;
    private NumberField period;

    public BookYearPeriodGrid(String label, String activeBookYear, String bookYearMin, String bookYearMax, int numberOfPeriods) throws Exception {
        this.initialize(label);
        this.bookYear.setMandatory(true);
        this.bookYear.setValue(activeBookYear);
        if (bookYearMin != null) {
            this.bookYear.setMinValue(new BigInteger(bookYearMin), true);
        }
        if (bookYearMax != null) {
            this.bookYear.setMaxValue(new BigInteger(bookYearMax), true);
        }
        this.period.setMandatory(true);
        this.period.setMinValue(new BigInteger("1"), true);
        this.period.setMaxValue(new BigInteger("" + numberOfPeriods), true);
    }

    public BookYearPeriodGrid(String label, boolean readOnly) throws Exception {
        this.initialize(label);
        this.setReadonly(readOnly);
    }

    public BookYearPeriodGrid(String label, String year, String period, boolean readOnly) throws Exception {
        this.initialize(label);
        this.setValues(year, period);
        this.setReadonly(readOnly);
    }

    private void initialize(String label) throws Exception {
        this.setPaddingBottom(0);
        this.setPaddingTop(0);
        if (label != null) {
            short[] sArray = new short[3];
            sArray[0] = 198;
            this.setColumnWidths(sArray);
            this.add((UIObject)new Label(label), 0, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        }
        this.bookYear = new NumberField(label, 4, true);
        this.add((UIObject)this.bookYear, 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.bookYear.setDiscardLabel(true);
        this.bookYear.getFormat().setGroupingUsed(false);
        this.period = new NumberField(label, 2, true);
        this.period.setDiscardLabel(true);
        this.add((UIObject)this.period, 0, 2, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
    }

    public NumberField getBookYear() {
        return this.bookYear;
    }

    public NumberField getPeriod() {
        return this.period;
    }

    public void setMandatory(boolean mandatory) throws Exception {
        this.bookYear.setMandatory(mandatory);
        this.period.setMandatory(mandatory);
    }

    public void setReadonly(boolean readonly) {
        this.bookYear.setReadonly(readonly);
        this.period.setReadonly(readonly);
    }

    public void setValues(String bookYear, String period) throws Exception {
        this.bookYear.setValue(bookYear);
        this.period.setValue(period);
    }

    public void setInvalidTag() {
        this.bookYear.setInvalidTag();
        this.period.setInvalidTag();
    }

    public void setHidden(boolean isHidden) {
        for (UIObject uiObject : this.getUIObjects()) {
            if (uiObject instanceof InputComponent) {
                ((InputComponent)uiObject).setHidden(isHidden);
            }
            if (!(uiObject instanceof Label)) continue;
            ((Label)uiObject).setHidden(isHidden);
        }
    }

    public void requestFocus(boolean focus) {
        this.bookYear.requestFocus(focus);
    }
}

