/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.InputComponent;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.Option;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabActivateAction;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.validators.RangeValidator;
import nl.ibs.fac.AlphaNumericEnum;
import nl.ibs.fac.DaybookEnum;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.GenericUsageEnum;
import nl.ibs.fac.InterestCalculationMethodEnum;
import nl.ibs.fac.JournalingMethodEnum;
import nl.ibs.fac.JournalingsTermEnum;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodEnum;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.adapters.AnalysisCodeReferenceField;
import nl.ibs.fac.adapters.CompanyAdapter;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.InterestTableReferenceField;
import nl.ibs.fac.adapters.YearPercentageTableReferenceField;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.BookYear;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.EnvironmentAccountingPrincipleDefault;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.queries.AnalysisGroupQuery;
import nl.ibs.fac.queries.CompanyQuery;
import nl.ibs.jsql.DBData;
import nl.ibs.util.NameValuePair;
import nl.ibs.vegas.input.Validator;

public class CompanyPanels
implements Serializable {
    private static final long serialVersionUID = 2523689940249201850L;
    private LoginHelper loginHelper;
    private DBData dbData = null;
    private Environment env = null;
    private Company company = null;
    private int numberOfPeriods;
    private boolean governmentActivated;
    private CompanyAccountingPrincipleDefault[] accountingPrincipleDefault = new CompanyAccountingPrincipleDefault[4];
    private Tab commonTab;
    private Tab finDimTab;
    protected MainTabActivateAction mainTabActivateAction;
    protected Panel mainPanel;
    protected ReferenceField idDesc = new ReferenceField("Label.Company");
    protected FieldGroup fgCreate;
    protected CheckBox useOwnBasicData = new CheckBox("Label.OwnBasicData", true);
    private UseOwnBasicDataChangeAction useOwnBasicDataChangeAction = new UseOwnBasicDataChangeAction();
    protected FinancialReferenceField companyField;
    protected ComboBox currentBookYear;
    protected FieldGroup fgAssetId;
    private ComboBox assetIdType;
    private AssetIdTypeChangeAction assetIdTypeChangeAction = new AssetIdTypeChangeAction();
    private NumberField assetIdLength = new NumberField("Label.Length", 2, true);
    private CheckBox assetIdAutoNumber = new CheckBox("Label.AutoNumber");
    private NumberField assetIdStartValue = new NumberField("Label.StartValue", 9, true);
    protected FieldGroup fgCreditId;
    private ComboBox creditIdType = new ComboBox();
    private CreditIdTypeChangeAction creditIdTypeChangeAction = new CreditIdTypeChangeAction();
    private NumberField creditIdLength = new NumberField("Label.Length", 2, true);
    private CheckBox creditIdAutoNumber = new CheckBox("Label.AutoNumber");
    private NumberField creditIdStartValue = new NumberField("Label.StartValue", 9, true);
    protected FieldGroup fgDataSet;
    protected DataSetReferenceField dataSet;
    protected FieldGroup fgMiscellaneous;
    protected FieldGroup fgMiscellaneous1;
    protected FieldGroup fgMiscellaneous2;
    private NumberField blockTo = new NumberField("Label.BlockedUntil", 2, true);
    private NumberField blockFrom = new NumberField("Label.BlockedFrom", 2, true);
    private NumberField correctionPeriods = new NumberField("Label.NumberOfCorrectionPeriods", 2, true);
    private Field lastRun = new Field("Label.LastDepreciationRunPeriod");
    private Field famMemberPrefix = new Field("Label.PrefixFIS2000", "upper");
    private Collection years;
    private int arraySize;
    private String[] ayr;
    private int[] abt;
    private int[] abf;
    private boolean[] agg;
    private boolean[] chg;
    private int previousYearIndex = 0;
    private boolean firstTime = true;
    private CurrentYearChangeAction currentYearChangeAction;
    protected ComboBox initialBookYear;
    private ComboBox cbNumberOfPeriods;
    private ComboBox cbAP2;
    protected UseAccountingPrinciple2ChangeAction useAccountingPrinciple2ChangeAction = new UseAccountingPrinciple2ChangeAction();
    protected FieldGroup financialPanel;
    private ESPGridLayout financialGrid;
    private String[] finTexts = new String[11];
    private ComboBox[] fins = new ComboBox[11];
    private FinancialReferenceField[] finFrom = new FinancialReferenceField[5];
    private FinancialReferenceField[] finTo = new FinancialReferenceField[5];
    protected FieldGroup dimensionPanel;
    private ESPGridLayout gridLayout;
    private ComboBox[] dims = new ComboBox[6];
    private DimensionComboBoxChangeAction[] acts = new DimensionComboBoxChangeAction[6];
    private CheckBox[] mans = new CheckBox[6];
    private AnalysisCodeReferenceField[] dfts = new AnalysisCodeReferenceField[6];
    private Tab apTab;
    protected Panel[] apPanels = new Panel[3];
    private TabbedPanel apTabbedPanel;
    private Tab[] apTabs = new Tab[3];
    private int[] ap = new int[4];
    private FieldGroup[] depreciationGroups = new FieldGroup[3];
    private CheckBox[] calculateDepreciation = new CheckBox[3];
    private ComboBox[] depreciationMethod = new ComboBox[3];
    private ComboBox[] startPeriodHandlingMethod = new ComboBox[3];
    private FACDecimalField[] degressivePercentage = new FACDecimalField[3];
    private ODBQueryReferenceField[] yearPercentageTableId = new ODBQueryReferenceField[3];
    private ODBQueryReferenceField[] annuityInterestTableId = new ODBQueryReferenceField[3];
    private FACDecimalField[] annuityPercentage = new FACDecimalField[3];
    private FieldGroup[] interestGroups = new FieldGroup[3];
    private CheckBox[] calculateInterest = new CheckBox[3];
    private ComboBox[] interestCalculationMethod = new ComboBox[3];
    private FACDecimalField[] interestPercentage = new FACDecimalField[3];
    private ODBQueryReferenceField[] interestTableId = new ODBQueryReferenceField[3];
    private FieldGroup[] journalingGroups = new FieldGroup[3];
    protected ComboBox[] journalingMethod = new ComboBox[3];
    private CheckBox useValuationMainAccount;
    private CalculateDepreciationChangeAction[] calculateDepreciationChangeAction = new CalculateDepreciationChangeAction[3];
    private CalculateInterestChangeAction[] calculateInterestChangeAction = new CalculateInterestChangeAction[3];
    private DepreciationMethodChangeAction[] depreciationMethodChangeAction = new DepreciationMethodChangeAction[3];
    private InterestCalculationMethodChangeAction[] interestCalculationMethodChangeAction = new InterestCalculationMethodChangeAction[3];
    private JournalingMethodChangeAction[] journalingMethodChangeAction = new JournalingMethodChangeAction[3];
    private Tab jtTab;
    protected Panel[] jtPanels = new Panel[4];
    private TabbedPanel jtTabbedPanel;
    private int[] jtAp = new int[4];
    private Tab[] jtTabs = new Tab[4];
    private JTTabActivateAction[] jtTabActivateActions = new JTTabActivateAction[4];
    private FinancialReferenceField[][] mainAccount = new FinancialReferenceField[4][11];
    private FinancialReferenceField[][] daybook = new FinancialReferenceField[4][7];
    private int jteLength = 0;
    private int dbeLength = 0;
    protected TabbedPanel mainTabPanel;
    private String[] apTabTexts = new String[3];
    private String[] jtTabTexts = new String[4];
    private int mode = 0;
    private static final int NEW = 0;
    private static final int UPDATE = 1;
    protected int apTabCount = 0;
    protected int apTabCountMax = 0;
    protected int jtTabCount = 0;
    protected int jtTabCountMax = 0;
    private String compId;
    private FloatBar fbPP = new FloatBar();
    private Action disinvestmentReasonMainAccountAction = null;
    private CompanyAdapter companyAdapter;
    private static final String[] NAMES = new String[]{"id", "description"};
    private static final String[] LABELS = new String[]{"Label.DataSet", "Label.Description"};
    private static final short[] SIZES = new short[]{70, 500};

    public CompanyPanels(LoginHelper loginHelper, DBData dbData, Environment env, int numberOfPeriods, boolean governmentActivated, Company company) throws Exception {
        this.loginHelper = loginHelper;
        this.dbData = dbData;
        this.env = env;
        this.numberOfPeriods = numberOfPeriods;
        this.governmentActivated = governmentActivated;
        this.company = company;
        if (company == null) {
            this.mode = 0;
        } else {
            this.mode = 1;
            BookYearBO.synchronizeWithFinancials(loginHelper, env, company);
        }
        this.initialize();
    }

    private void initialize() throws Exception {
        this.apTabTexts[0] = this.env.getAPShortName1();
        this.apTabTexts[1] = this.env.getAPShortName2();
        this.apTabTexts[2] = this.env.getAPShortName3();
        this.jtTabTexts[0] = this.env.getAPShortName1();
        this.jtTabTexts[1] = this.env.getAPShortName2();
        this.jtTabTexts[2] = this.env.getAPShortName3();
        this.jtTabTexts[3] = this.env.getAPShortName4();
        this.finTexts[0] = this.env.getName1();
        this.finTexts[1] = this.env.getName2();
        this.finTexts[2] = this.env.getName3();
        this.finTexts[3] = this.env.getName4();
        this.finTexts[4] = this.env.getName5();
        this.finTexts[5] = this.env.getNameDebtor();
        this.finTexts[6] = this.env.getNameCreditor();
        this.finTexts[7] = this.env.getNameRelation();
        this.finTexts[8] = this.env.getCMSName1();
        this.finTexts[9] = this.env.getCMSName2();
        this.finTexts[10] = this.env.getCMSName3();
        this.initializeCommonFieldGroups();
        if (this.mode == 0) {
            this.initializeCreateForms();
        } else {
            this.initializeDimensionPanels();
            this.initializeAccountingPrincipleForms();
            this.initializeJournalingTermForms();
            this.initializeEditForm();
            this.mainTabPanel = new TabbedPanel();
            this.mainTabPanel.setWidth(620);
            this.commonTab = new Tab("Label.Common");
            this.commonTab.add(this.fgDataSet);
            this.commonTab.add(this.fgMiscellaneous1);
            this.commonTab.add(this.fgMiscellaneous2);
            this.commonTab.add(this.fgAssetId);
            if (this.fgCreditId != null) {
                this.commonTab.add(this.fgCreditId);
            }
            this.fbPP.alignment(1);
            this.commonTab.add(this.fbPP);
            this.mainTabActivateAction = new MainTabActivateAction(this.commonTab, this.mainTabPanel);
            this.mainTabPanel.add(this.commonTab, (TabActivateAction)this.mainTabActivateAction);
            this.finDimTab = new Tab("Label.Dimensions");
            this.finDimTab.add(this.financialPanel);
            this.finDimTab.add(this.dimensionPanel);
            this.mainTabActivateAction = new MainTabActivateAction(this.finDimTab, this.mainTabPanel);
            this.mainTabPanel.add(this.finDimTab, (TabActivateAction)this.mainTabActivateAction);
            this.apTab = new Tab("Label.Valuation");
            this.apTab.add(this.apTabbedPanel);
            this.mainTabPanel.add(this.apTab, (TabActivateAction)new MainTabActivateAction(this.apTab, this.mainTabPanel));
            this.jtTab = new Tab("Label.MainAccountScheme");
            this.jtTab.add(this.jtTabbedPanel);
            this.mainTabPanel.add(this.jtTab, (TabActivateAction)new MainTabActivateAction(this.jtTab, this.mainTabPanel));
        }
    }

    public void showPeriodHandlingStuffOnly() throws Exception {
        this.finDimTab.setHidden(true);
        this.apTab.setHidden(true);
        this.jtTab.setHidden(true);
        this.fgMiscellaneous2.setHidden(true);
        this.fgAssetId.setHidden(true);
        if (this.fgCreditId != null) {
            this.fgCreditId.setHidden(true);
        }
    }

    private void initializeCommonFieldGroups() throws Exception {
        this.mainPanel = new HeaderPanel();
        if (this.mode == 0) {
            this.mainPanel.setWidth(620);
        }
        this.fgDataSet = new FieldGroup("Label.BasicData");
        this.fgMiscellaneous = new FieldGroup("Label.Miscellaneous");
        this.fgMiscellaneous1 = new FieldGroup("");
        this.fgMiscellaneous2 = new FieldGroup("");
        this.fgAssetId = new FieldGroup("Label.Asset");
        this.fgCreditId = null;
        this.idDesc.setReadonly(true);
        this.idDesc.setLength(7);
        this.idDesc.setDescriptionLength(40);
        this.mainPanel.addUIObject((UIObject)this.idDesc);
        this.dataSet = new DataSetReferenceField(this.dbData, null);
        this.fgDataSet.add((Field)this.dataSet);
        this.initialBookYear = new ComboBox("Label.StartYear");
        this.initialBookYear.setWidth("120");
        this.currentBookYear = new ComboBox("Label.CurrentYear");
        this.currentBookYear.setWidth("120");
        this.cbNumberOfPeriods = EnumHelper.createComboBox("Label.DepreciationYearNumberOfPeriods", PeriodEnum.getCollection(), false);
        this.cbNumberOfPeriods.setMandatory(true);
        this.cbNumberOfPeriods.setWidth("120");
        this.cbAP2 = EnumHelper.createComboBox("Label.AccountingPrinciple_2", GenericUsageEnum.getCollection(), false);
        this.cbAP2.setMandatory(true);
        this.cbAP2.setWidth("120");
        this.cbAP2.add((Action)this.useAccountingPrinciple2ChangeAction);
        this.lastRun.setLength(8);
        this.lastRun.setReadonly(true);
        this.correctionPeriods.setMinValue(new BigInteger("0"), true);
        this.correctionPeriods.setMaxValue(new BigInteger("99"), true);
        this.famMemberPrefix.setLength(8);
        this.famMemberPrefix.setMaxLength(7);
        if (this.mode == 0) {
            this.fgMiscellaneous.add(this.currentBookYear);
            this.fgMiscellaneous.add(this.initialBookYear);
            this.fgMiscellaneous.add(this.cbNumberOfPeriods);
            this.fgMiscellaneous.add((Field)this.correctionPeriods);
            this.fgMiscellaneous.add(this.famMemberPrefix);
            this.fgMiscellaneous.add(this.cbAP2);
        } else {
            this.idDesc.setValue(this.company.getId());
            this.blockTo.setMinValue(new BigInteger("0"), true);
            this.blockTo.setMaxValue(new BigInteger("" + this.numberOfPeriods), true);
            this.blockFrom.setMinValue(new BigInteger("0"), true);
            this.blockFrom.setMaxValue(new BigInteger("" + this.numberOfPeriods), true);
            this.initialBookYear.setReadonly(true);
            this.initializeBookYearsForUpdate();
            this.currentYearChangeAction = new CurrentYearChangeAction();
            this.currentBookYear.add((Action)this.currentYearChangeAction);
            this.currentYearChangeAction.execute(null);
            this.fgMiscellaneous1.add(this.currentBookYear);
            this.fgMiscellaneous1.add((Field)this.blockTo);
            this.fgMiscellaneous1.add((Field)this.blockFrom);
            this.fgMiscellaneous1.add(this.lastRun);
            this.fgMiscellaneous2.add(this.initialBookYear);
            this.fgMiscellaneous2.add(this.cbNumberOfPeriods);
            this.fgMiscellaneous2.add((Field)this.correctionPeriods);
            this.fgMiscellaneous2.add(this.famMemberPrefix);
            this.fgMiscellaneous2.add(this.cbAP2);
        }
        if (this.env.getOperationArea().length() > 0) {
            this.famMemberPrefix.setHidden(true);
        }
        this.assetIdType = EnumHelper.createComboBox("Label.AssetId", AlphaNumericEnum.getCollection(), false);
        this.assetIdType.setMandatory(true);
        this.assetIdType.setWidth("120");
        this.assetIdType.add((Action)this.assetIdTypeChangeAction);
        this.fgAssetId.add(this.assetIdType);
        this.assetIdLength.setMandatory(true);
        this.fgAssetId.add((Field)this.assetIdLength);
        this.assetIdAutoNumber.setHidden(true);
        this.fgAssetId.add(this.assetIdAutoNumber);
        this.assetIdStartValue.setHidden(true);
        this.assetIdStartValue.setMinValue(0L, true);
        this.assetIdStartValue.setValue(0L);
        this.assetIdStartValue.getFormat().setGroupingUsed(false);
        this.fgAssetId.add((Field)this.assetIdStartValue);
        if (this.governmentActivated) {
            this.fgCreditId = new FieldGroup("Krediet");
            this.creditIdType = EnumHelper.createComboBox("Krediet-id", AlphaNumericEnum.getCollection(), false);
            this.creditIdType.setMandatory(true);
            this.creditIdType.setWidth("120");
            this.creditIdType.add((Action)this.creditIdTypeChangeAction);
            this.fgCreditId.add(this.creditIdType);
            this.creditIdLength.setMandatory(true);
            this.fgCreditId.add((Field)this.creditIdLength);
            this.creditIdAutoNumber.setHidden(true);
            this.fgCreditId.add(this.creditIdAutoNumber);
            this.creditIdStartValue.setHidden(true);
            this.creditIdStartValue.setMinValue(0L, true);
            this.creditIdStartValue.setValue(0L);
            this.creditIdStartValue.getFormat().setGroupingUsed(false);
            this.fgCreditId.add((Field)this.creditIdStartValue);
        }
        this.useValuationMainAccount = new CheckBox("Label.ValuationMainAccounts", false);
    }

    protected void addProcessParametersAction(Action action) {
        this.fbPP.addAction(action);
    }

    protected void setDisinvestmentReasonMainAccountAction(Action action) {
        this.disinvestmentReasonMainAccountAction = action;
    }

    protected void initializeBookYears() throws Exception {
        this.initialBookYear.removeAllChildUIObjects();
        this.currentBookYear.removeAllChildUIObjects();
        int start = 0;
        if (this.company != null) {
            start = this.company.getInitialBookYear();
        }
        List years = BookYearBO.getFinancialBookYears(this.loginHelper, this.env, this.idDesc.getValue(), start);
        for (String year : years) {
            this.currentBookYear.addOption(year, year);
            this.initialBookYear.addOption(year, year);
        }
    }

    protected void initializeBookYearsForUpdate() throws Exception {
        this.initialBookYear.removeAllChildUIObjects();
        this.currentBookYear.removeAllChildUIObjects();
        int startYear = this.company.getInitialBookYear();
        this.initialBookYear.addOption("" + startYear, "" + startYear);
        this.years = BookYearBO.getFACBookYears(this.company);
        Iterator iterator = this.years.iterator();
        this.arraySize = this.years.size();
        this.ayr = new String[this.arraySize];
        this.abt = new int[this.arraySize];
        this.abf = new int[this.arraySize];
        this.agg = new boolean[this.arraySize];
        this.chg = new boolean[this.arraySize];
        int index = 0;
        while (iterator.hasNext()) {
            BookYear year = (BookYear)iterator.next();
            this.currentBookYear.addOption("" + year.getBookYear(), "" + year.getBookYear());
            this.ayr[index] = "" + year.getBookYear();
            this.abt[index] = year.getPeriodTo();
            this.abf[index] = year.getPeriodFrom();
            this.agg[index] = year.getAggregated();
            this.chg[index] = false;
            ++index;
        }
        this.currentBookYear.setSelectedOptionValue("" + this.company.getCurrentBookYear());
    }

    protected void initializeDimensionPanels() throws Exception {
        this.initializeFinancialDimensionPanel();
        if (this.governmentActivated && this.mode == 1) {
            this.initializeFACDimensionPanel();
        }
    }

    private void initializeFinancialDimensionPanel() throws Exception {
        Label label;
        int i;
        Label blank04 = new Label("&nbsp;&nbsp;&nbsp;&nbsp;");
        Label blank10 = new Label("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.financialPanel = new FieldGroup("");
        this.financialPanel.forceBorder(true);
        this.financialGrid = new ESPGridLayout();
        this.financialPanel.add(this.financialGrid);
        this.financialGrid.add((UIObject)new Label("from"), 0, 4);
        this.financialGrid.add((UIObject)new Label("up-to-and-including"), 0, 5);
        this.compId = this.company == null ? this.idDesc.getValue() : this.company.getId();
        if (this.env.getOperationArea().length() == 0) {
            i = 0;
            while (i < 5) {
                if (this.finTexts[i].length() != 0) {
                    label = new Label(this.finTexts[i]);
                    label.setHelpId("FinDimension");
                    this.financialGrid.add((UIObject)label, i + 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
                    this.financialGrid.add((UIObject)blank10, i + 1, 1);
                    this.fins[i] = EnumHelper.createComboBox("", GenericUsageEnum.getCollection(), false);
                    this.fins[i].setWidth("120");
                    if (this.mode == 0) {
                        this.fins[i].setSelectedOptionValue("1");
                    }
                    this.financialGrid.add((UIObject)this.fins[i], i + 1, 2);
                    this.financialGrid.add((UIObject)blank04, i + 1, 3);
                    this.finFrom[i] = new FISReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.compId, this.currentBookYear.getValue(), false);
                    this.finFrom[i].setDiscardLabel(true);
                    this.finFrom[i].showDescription(false);
                    this.financialGrid.add((UIObject)this.finFrom[i], i + 1, 4);
                    this.finTo[i] = new FISReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.compId, this.currentBookYear.getValue(), false);
                    this.finTo[i].setDiscardLabel(true);
                    this.finTo[i].showDescription(false);
                    this.finTo[i].addValidator((Validator)new RangeValidator((InputComponent)this.finFrom[i]));
                    this.financialGrid.add((UIObject)this.finTo[i], i + 1, 5);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < 5) {
                if (this.finTexts[i].length() != 0) {
                    label = new Label(this.finTexts[i]);
                    label.setHelpId("FinDimension");
                    this.financialGrid.add((UIObject)label, i + 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
                    this.financialGrid.add((UIObject)blank10, i + 1, 1);
                    this.fins[i] = EnumHelper.createComboBox("", GenericUsageEnum.getCollection(), false);
                    this.fins[i].setWidth("120");
                    if (this.mode == 0) {
                        this.fins[i].setSelectedOptionValue("1");
                    }
                    this.financialGrid.add((UIObject)this.fins[i], i + 1, 2);
                    this.financialGrid.add((UIObject)blank04, i + 1, 3);
                    this.finFrom[i] = new FMSReferenceField(this.loginHelper, this.finTexts[i], i + 1, false);
                    this.finFrom[i].setDiscardLabel(true);
                    this.finFrom[i].showDescription(false);
                    this.financialGrid.add((UIObject)this.finFrom[i], i + 1, 4);
                    this.finTo[i] = new FMSReferenceField(this.loginHelper, this.finTexts[i], i + 1, false);
                    this.finTo[i].setDiscardLabel(true);
                    this.finTo[i].showDescription(false);
                    this.financialGrid.add((UIObject)this.finTo[i], i + 1, 5);
                    this.finTo[i].addValidator((Validator)new RangeValidator((InputComponent)this.finFrom[i]));
                }
                ++i;
            }
        }
        if (this.mode != 0 && !this.governmentActivated) {
            int limit = 8;
            if (this.env.getOperationArea().length() == 0) {
                limit = 7;
            }
            int i2 = 5;
            while (i2 < limit) {
                label = new Label(this.finTexts[i2]);
                label.setHelpId("ExtDimension");
                this.financialGrid.add((UIObject)label, i2 + 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
                this.financialGrid.add((UIObject)blank10, i2 + 1, 1);
                this.fins[i2] = EnumHelper.createComboBox("", GenericUsageEnum.getCollection(), false);
                this.fins[i2].removeOption(this.fins[i2].getOptionByValue("2"));
                this.fins[i2].setWidth("120");
                if (this.mode == 0) {
                    this.fins[i2].setSelectedOptionValue("0");
                }
                this.financialGrid.add((UIObject)this.fins[i2], i2 + 1, 2);
                ++i2;
            }
        }
    }

    private void initializeFACDimensionPanel() throws Exception {
        Label[] labs = new Label[6];
        Label blank01 = new Label("&nbsp;");
        Label blank02 = new Label("&nbsp;&nbsp;");
        this.dimensionPanel = new FieldGroup("Label.Credits");
        this.dimensionPanel.forceBorder(true);
        this.gridLayout = new ESPGridLayout();
        this.dimensionPanel.add(this.gridLayout);
        this.gridLayout.add((UIObject)new Label("Label.DimensionOrAttribute"), 0, 2);
        this.gridLayout.add((UIObject)new Label("Label.Mandatory.short"), 0, 3);
        this.gridLayout.add((UIObject)new Label("Label.Default"), 0, 5);
        ArrayList agCollection = (ArrayList)new AnalysisGroupQuery(this.dbData, this.company.getId()).fetchData(null, "name", null, 0);
        Iterator iter = agCollection.iterator();
        Option[] options = new Option[agCollection.size() + 1];
        options[0] = new Option("", "0");
        int j = 1;
        while (iter.hasNext()) {
            AnalysisGroup ag = (AnalysisGroup)iter.next();
            options[j] = new Option(ag.getName(), "" + ag.getSeqNr());
            ++j;
        }
        int i = 0;
        while (i < 6) {
            labs[i] = new Label(i + 1 + ".");
            this.dims[i] = new ComboBox("", options);
            this.mans[i] = new CheckBox("");
            this.acts[i] = new DimensionComboBoxChangeAction(i);
            this.acts[i].execute(null);
            this.dims[i].add((Action)this.acts[i]);
            this.gridLayout.add((UIObject)labs[i], i + 1, 0);
            this.gridLayout.add((UIObject)blank01, i + 1, 1);
            this.gridLayout.add((UIObject)this.dims[i], i + 1, 2);
            this.gridLayout.add((UIObject)this.mans[i], i + 1, 3);
            this.gridLayout.add((UIObject)blank02, i + 1, 4);
            ++i;
        }
    }

    private void initializeAccountingPrincipleForms() throws Exception {
        this.apTabCount = 0;
        this.apTabbedPanel = new TabbedPanel();
        this.initializeAccountingPrincipleForm(0, 1);
        this.apTabCountMax = 0;
        if (this.mode == 1 || !"0".equals(this.cbAP2.getValue())) {
            this.initializeAccountingPrincipleForm(++this.apTabCountMax, 2);
        }
        if (this.governmentActivated) {
            this.initializeAccountingPrincipleForm(++this.apTabCountMax, 3);
            this.depreciationGroups[this.apTabCountMax].setHidden(true);
            this.interestCalculationMethod[this.apTabCountMax].removeOption(this.interestCalculationMethod[this.apTabCountMax].getOptionByValue("2"));
        }
    }

    private void initializeAccountingPrincipleForm(int tabNumber, int accountingPrinciple) throws Exception {
        if (this.mode == 0) {
            this.apPanels[tabNumber] = new Panel();
        } else {
            this.apTabs[tabNumber] = new Tab(this.apTabTexts[accountingPrinciple - 1]);
            this.apTabbedPanel.add(this.apTabs[tabNumber], (TabActivateAction)new APTabActivateAction(this.apTabs[tabNumber], this.apTabbedPanel));
        }
        this.depreciationGroups[tabNumber] = new FieldGroup("Label.Depreciations");
        this.ap[tabNumber] = accountingPrinciple;
        this.calculateDepreciation[tabNumber] = new CheckBox("Label.CalculateDepreciations", true);
        this.calculateDepreciationChangeAction[tabNumber] = new CalculateDepreciationChangeAction(tabNumber);
        this.calculateDepreciation[tabNumber].setAction((Action)this.calculateDepreciationChangeAction[tabNumber]);
        this.depreciationGroups[tabNumber].add(this.calculateDepreciation[tabNumber]);
        this.depreciationMethod[tabNumber] = EnumHelper.createComboBox("Label.DepreciationMethod", DepreciationMethodEnum.getCollection(), false);
        this.depreciationMethod[tabNumber].setWidth("225");
        this.depreciationMethodChangeAction[tabNumber] = new DepreciationMethodChangeAction(tabNumber);
        this.depreciationMethod[tabNumber].add((Action)this.depreciationMethodChangeAction[tabNumber]);
        this.depreciationGroups[tabNumber].add(this.depreciationMethod[tabNumber]);
        this.yearPercentageTableId[tabNumber] = new YearPercentageTableReferenceField(this.dbData);
        this.depreciationGroups[tabNumber].add((Field)this.yearPercentageTableId[tabNumber]);
        this.degressivePercentage[tabNumber] = new FACDecimalField("Label.Percentage", 5, 2);
        this.degressivePercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.degressivePercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.depreciationGroups[tabNumber].add((Field)this.degressivePercentage[tabNumber]);
        this.annuityInterestTableId[tabNumber] = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.depreciationGroups[tabNumber].add((Field)this.annuityInterestTableId[tabNumber]);
        this.annuityPercentage[tabNumber] = new FACDecimalField("Label.Percentage", 6, 3);
        this.annuityPercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.annuityPercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.depreciationGroups[tabNumber].add((Field)this.annuityPercentage[tabNumber]);
        this.startPeriodHandlingMethod[tabNumber] = EnumHelper.createComboBox("Label.StartPeriodHandlingPolicy", StartPeriodHandlingEnum.getCollection(), false);
        this.startPeriodHandlingMethod[tabNumber].setWidth("225");
        this.depreciationGroups[tabNumber].add(this.startPeriodHandlingMethod[tabNumber]);
        this.addFieldGroupAP(this.depreciationGroups[tabNumber], tabNumber);
        this.interestGroups[tabNumber] = new FieldGroup("Label.Interest");
        this.calculateInterest[tabNumber] = new CheckBox("Label.CalculateInterest", true);
        this.calculateInterestChangeAction[tabNumber] = new CalculateInterestChangeAction(tabNumber);
        this.calculateInterest[tabNumber].setAction((Action)this.calculateInterestChangeAction[tabNumber]);
        this.interestGroups[tabNumber].add(this.calculateInterest[tabNumber]);
        this.interestCalculationMethod[tabNumber] = EnumHelper.createComboBox("Label.InterestCalculationMethod", InterestCalculationMethodEnum.getCollection(), false);
        this.interestCalculationMethod[tabNumber].setWidth("225");
        this.interestCalculationMethodChangeAction[tabNumber] = new InterestCalculationMethodChangeAction(tabNumber);
        this.interestCalculationMethod[tabNumber].add((Action)this.interestCalculationMethodChangeAction[tabNumber]);
        this.interestGroups[tabNumber].add(this.interestCalculationMethod[tabNumber]);
        this.interestPercentage[tabNumber] = new FACDecimalField("Label.Percentage", 6, 3);
        this.interestPercentage[tabNumber].setMinValue(new BigDecimal(0), true);
        this.interestPercentage[tabNumber].setMaxValue(new BigDecimal(100), true);
        this.interestGroups[tabNumber].add((Field)this.interestPercentage[tabNumber]);
        this.interestTableId[tabNumber] = new InterestTableReferenceField(this.dbData, this.numberOfPeriods);
        this.interestGroups[tabNumber].add((Field)this.interestTableId[tabNumber]);
        this.addFieldGroupAP(this.interestGroups[tabNumber], tabNumber);
        this.journalingGroups[tabNumber] = new FieldGroup("Label.MainAccountScheme");
        this.journalingMethod[tabNumber] = EnumHelper.createComboBox("Label.JournalingMethod", JournalingMethodEnum.getCollection(), false);
        this.journalingMethodChangeAction[tabNumber] = new JournalingMethodChangeAction(tabNumber);
        this.journalingMethod[tabNumber].add((Action)this.journalingMethodChangeAction[tabNumber]);
        this.journalingMethod[tabNumber].setWidth("225");
        this.journalingGroups[tabNumber].add(this.journalingMethod[tabNumber]);
        if (this.governmentActivated && accountingPrinciple == 1) {
            this.useValuationMainAccount.setValue(true);
            this.journalingGroups[tabNumber].add(this.useValuationMainAccount);
        }
        this.addFieldGroupAP(this.journalingGroups[tabNumber], tabNumber);
    }

    private void addFieldGroupAP(FieldGroup fieldGroup, int tabNumber) throws Exception {
        if (this.mode == 0) {
            this.apPanels[tabNumber].addUIObject((UIObject)fieldGroup);
        } else {
            this.apTabs[tabNumber].add(fieldGroup);
        }
    }

    protected void initializeJournalingTermForms() throws Exception {
        this.jtTabCount = 0;
        this.jtTabbedPanel = new TabbedPanel();
        this.initializeJournalingTermForm(0, 1);
        this.jtTabCountMax = 0;
        if (this.mode == 1 || !"0".equals(this.cbAP2.getValue())) {
            this.initializeJournalingTermForm(++this.jtTabCountMax, 2);
        }
        if (this.governmentActivated) {
            this.initializeJournalingTermForm(++this.jtTabCountMax, 3);
        }
    }

    private void initializeJournalingTermForm(int tabNumber, int accountingPrinciple) throws Exception {
        NameValuePair pair;
        if (this.mode == 0) {
            this.jtPanels[tabNumber] = new Panel();
        } else {
            this.jtTabs[tabNumber] = new Tab(this.jtTabTexts[accountingPrinciple - 1]);
            this.jtTabActivateActions[tabNumber] = new JTTabActivateAction(this.jtTabs[tabNumber], this.jtTabbedPanel);
            this.jtTabbedPanel.add(this.jtTabs[tabNumber], (TabActivateAction)this.jtTabActivateActions[tabNumber]);
        }
        this.jtAp[tabNumber] = accountingPrinciple;
        FieldGroup fgMainAccounts = new FieldGroup("Label.MainAccounts");
        Object[] jte = JournalingsTermEnum.getCollection().toArray();
        this.jteLength = jte.length;
        int i = 0;
        while (i < this.jteLength) {
            if (i != 9 && i != 10) {
                pair = (NameValuePair)jte[i];
                this.mainAccount[tabNumber][i] = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, pair.getValue(), 0, this.compId, this.currentBookYear.getValue(), true) : new FMSReferenceField(this.loginHelper, pair.getValue(), 0, true);
                fgMainAccounts.add((Field)this.mainAccount[tabNumber][i]);
                if (i < 3) {
                    this.mainAccount[tabNumber][i].setHidden(true);
                }
                if (accountingPrinciple == 3 && (i == 4 || i == 5)) {
                    this.mainAccount[tabNumber][i].setHidden(true);
                }
                if (this.governmentActivated && i == 8) {
                    this.mainAccount[tabNumber][i].setHidden(true);
                }
            }
            ++i;
        }
        FieldGroup fgDaybooks = new FieldGroup("Label.DayBooks");
        Object[] dbe = DaybookEnum.getCollection().toArray();
        this.dbeLength = dbe.length;
        int i2 = 0;
        while (i2 < this.dbeLength) {
            pair = (NameValuePair)dbe[i2];
            this.daybook[tabNumber][i2] = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, pair.getValue(), -1, this.compId, this.currentBookYear.getValue(), true) : new FMSReferenceField(this.loginHelper, pair.getValue(), -1, true);
            fgDaybooks.add((Field)this.daybook[tabNumber][i2]);
            if (i2 == 6) {
                this.daybook[tabNumber][i2].setHidden(true);
            }
            ++i2;
        }
        if (this.mode == 0) {
            this.jtPanels[tabNumber].addUIObject((UIObject)fgMainAccounts);
            if (accountingPrinciple != 3) {
                this.jtPanels[tabNumber].addUIObject((UIObject)fgDaybooks);
            }
        } else {
            this.jtTabs[tabNumber].add(fgMainAccounts);
            if (accountingPrinciple != 3) {
                this.jtTabs[tabNumber].add(fgDaybooks);
            }
        }
    }

    private void initializeCreateForms() throws Exception {
        this.fgCreate = new FieldGroup();
        this.companyField = this.env.getOperationArea().length() > 0 ? new FMSReferenceField(this.loginHelper, "Label.CompanyId", -2, true) : new FISReferenceField(this.loginHelper, "Label.CompanyId", -3, "0", "0000", true);
        this.fgCreate.add((Field)this.companyField);
        this.companyField.setHelpId("Label.CompanyId");
        this.useOwnBasicData.setAction((Action)this.useOwnBasicDataChangeAction);
        this.useOwnBasicData.setHidden(true);
        this.fgCreate.add(this.useOwnBasicData);
        if (this.env.getAccountingPrinciple2IsUsed()) {
            this.cbAP2.setSelectedOptionValue("1");
            this.cbAP2.setHidden(false);
        } else {
            this.cbAP2.setSelectedOptionValue("0");
            this.cbAP2.setHidden(true);
        }
    }

    protected Object[] create() throws Exception {
        String message;
        this.validateJournalingTermForm(this.jtTabCount);
        this.numberOfPeriods = Integer.parseInt(this.cbNumberOfPeriods.getValue());
        int iCreditIdLength = 0;
        int iCreditIdStartValue = 0;
        if (this.governmentActivated) {
            iCreditIdLength = this.creditIdLength.getIntValue();
            iCreditIdStartValue = this.creditIdStartValue.getIntValue();
        }
        int[] usageFinDims = new int[11];
        String[] finDimFrom = new String[5];
        String[] finDimTo = new String[5];
        int i = 0;
        while (i < 11) {
            if (this.fins[i] != null) {
                usageFinDims[i] = Integer.parseInt(this.fins[i].getValue());
                if (i < 5) {
                    finDimFrom[i] = this.finFrom[i].getFormattedId();
                    finDimTo[i] = this.finTo[i].getFormattedId();
                }
            } else {
                usageFinDims[i] = 0;
                if (i < 5) {
                    finDimFrom[i] = "";
                    finDimTo[i] = "";
                }
            }
            ++i;
        }
        Object[] result = CompanyBO.create(this.dbData, this.idDesc.getValue(), this.idDesc.getDescription(), Integer.parseInt(this.initialBookYear.getValue().trim()), Integer.parseInt(this.currentBookYear.getValue().trim()), this.dataSet.getValue().trim(), this.numberOfPeriods, this.correctionPeriods.getIntValue(), this.famMemberPrefix.getValue().trim(), this.assetIdType.getValue(), this.assetIdLength.getIntValue(), this.assetIdAutoNumber.isChecked(), this.assetIdStartValue.getIntValue(), this.creditIdType.getValue(), iCreditIdLength, this.creditIdAutoNumber.isChecked(), iCreditIdStartValue, usageFinDims, finDimFrom, finDimTo, Integer.parseInt(this.cbAP2.getValue()), this.loginHelper.getUser());
        if (result[1] != null) {
            return result;
        }
        this.company = (Company)result[0];
        if (this.governmentActivated) {
            this.company.setUseValuationMainAccount(this.useValuationMainAccount.getValueAsBoolean());
            this.copyAssetAPDataToCreditAPData();
        }
        if (this.dataSet.getValue().trim().length() == 0) {
            Object[] result2 = ProcessParametersBO.create(this.dbData, this.company.getId(), false, false, false, true, 1, false, false, false, false, 0, false, 0, 0, false, false, 0, false, false, false);
            if (result2[1] != null) {
                return result2;
            }
            int i2 = 0;
            while (i2 <= this.jtTabCountMax) {
                message = this.saveAccountingPrincipleDefault(i2, this.company.getId());
                if (message != null) {
                    result[1] = message;
                    return result;
                }
                ++i2;
            }
        }
        if ((message = BookYearBO.synchronizeWithFinancials(this.loginHelper, this.env, this.company)) != null) {
            result[1] = message;
            return result;
        }
        return result;
    }

    private void initializeEditForm() throws Exception {
        if (this.company.getDataSet() == null) {
            this.fgDataSet.setHidden(true);
            this.cbNumberOfPeriods.setHidden(false);
            this.correctionPeriods.setHidden(false);
            this.cbAP2.setHidden(false);
        } else {
            this.dataSet.setReadonly(true);
            this.cbNumberOfPeriods.setHidden(true);
            this.correctionPeriods.setHidden(true);
            this.cbAP2.setHidden(true);
        }
    }

    protected void setValues() throws Exception {
        this.idDesc.setValue(this.company.getId());
        this.idDesc.setDescription(this.company.getDescription());
        String adminName = null;
        if (this.env.getOperationArea().length() > 0) {
            adminName = new FMSHelper(this.loginHelper).getAdministrationDescription(this.company.getId().trim());
        } else {
            adminName = new FISHelper(this.loginHelper).getAdministrationDescription(this.company.getId().trim(), this.company.getCurrentBookYear());
            this.famMemberPrefix.setValue(this.company.getFamMemberPrefix());
        }
        if (adminName != null && !"".equals(adminName)) {
            this.idDesc.setDescription(adminName);
        }
        this.currentBookYear.setSelectedOptionValue("" + this.company.getCurrentBookYear());
        this.initialBookYear.setSelectedOptionValue("" + this.company.getInitialBookYear());
        if (this.company.getLastDepreciationRunYear() > 0) {
            this.lastRun.setValue(this.company.getLastDepreciationRunYear() + "-" + this.company.getLastDepreciationRunPeriod());
            this.lastRun.setHidden(false);
        } else {
            this.lastRun.setHidden(true);
        }
        this.cbNumberOfPeriods.setReadonly(false);
        this.dataSet.setValue(this.company.getDataSetId());
        if (this.company.getDataSet() != null) {
            this.dataSet.setDescription(this.company.getDataSet().getDescription());
        } else {
            this.cbNumberOfPeriods.setValueAsString("" + this.company.getNumberOfPeriods());
            this.correctionPeriods.setValue((long)this.company.getNumberOfCorrectionPeriods());
            this.cbAP2.setValueAsString("" + this.company.getAccountingPrinciple2Usage());
            if (!this.env.getAccountingPrinciple2IsUsed() && this.cbAP2.getSelectedOptionValue().equals("0")) {
                this.cbAP2.setHidden(true);
            }
        }
        this.assetIdType.setValueAsString(this.company.getAssetIdType());
        this.assetIdLength.setValue(Integer.toString(this.company.getAssetIdLength()));
        this.assetIdAutoNumber.setValue(this.company.getAssetIdAuto());
        this.assetIdStartValue.setValue(Integer.toString(this.company.getAssetIdStartValue()));
        if (this.governmentActivated) {
            this.creditIdType.setValueAsString(this.company.getCreditIdType());
            this.creditIdLength.setValue(Integer.toString(this.company.getCreditIdLength()));
            this.creditIdAutoNumber.setValue(this.company.getCreditIdAuto());
            this.creditIdStartValue.setValue(Integer.toString(this.company.getCreditIdStartValue()));
            this.useValuationMainAccount.setValue(this.company.getUseValuationMainAccount());
            this.useValuationMainAccount.setReadonly(AssetBO.hasAssets(this.company));
        }
        this.fins[0].setSelectedOptionValue("" + this.company.getFinancialDimension1Usage());
        this.finFrom[0].setValue(this.company.getFD1From());
        this.finTo[0].setValue(this.company.getFD1To());
        this.fins[1].setSelectedOptionValue("" + this.company.getFinancialDimension2Usage());
        this.finFrom[1].setValue(this.company.getFD2From());
        this.finTo[1].setValue(this.company.getFD2To());
        this.fins[2].setSelectedOptionValue("" + this.company.getFinancialDimension3Usage());
        this.finFrom[2].setValue(this.company.getFD3From());
        this.finTo[2].setValue(this.company.getFD3To());
        this.fins[3].setSelectedOptionValue("" + this.company.getFinancialDimension4Usage());
        this.finFrom[3].setValue(this.company.getFD4From());
        this.finTo[3].setValue(this.company.getFD4To());
        if (this.fins[4] != null) {
            this.fins[4].setSelectedOptionValue("" + this.company.getFinancialDimension5Usage());
            this.finFrom[4].setValue(this.company.getFD5From());
            this.finTo[4].setValue(this.company.getFD5To());
        }
        boolean[] externals = new boolean[11];
        externals[5] = this.company.getAGDebtorUsed();
        externals[6] = this.company.getAGCreditorUsed();
        externals[7] = this.company.getAGRelationUsed();
        externals[8] = this.company.getCMSDimension1Used();
        externals[9] = this.company.getCMSDimension2Used();
        externals[10] = this.company.getCMSDimension3Used();
        int i = 5;
        while (i < 11) {
            if (this.fins[i] != null) {
                if (!externals[i]) {
                    this.fins[i].setSelectedOptionValue("0");
                } else {
                    this.fins[i].setSelectedOptionValue("1");
                }
            }
            ++i;
        }
        if (this.dims[0] != null) {
            this.dims[0].setSelectedOptionValue(this.company.getSeqNr1() == null ? "0" : "" + this.company.getSeqNr1());
            this.dims[1].setSelectedOptionValue(this.company.getSeqNr2() == null ? "0" : "" + this.company.getSeqNr2());
            this.dims[2].setSelectedOptionValue(this.company.getSeqNr3() == null ? "0" : "" + this.company.getSeqNr3());
            this.dims[3].setSelectedOptionValue(this.company.getSeqNr4() == null ? "0" : "" + this.company.getSeqNr4());
            this.dims[4].setSelectedOptionValue(this.company.getSeqNr5() == null ? "0" : "" + this.company.getSeqNr5());
            this.dims[5].setSelectedOptionValue(this.company.getSeqNr6() == null ? "0" : "" + this.company.getSeqNr6());
            i = 0;
            while (i < 6) {
                if (!this.dims[i].getValue().equals("0")) {
                    this.dims[i].setReadonly(CreditBO.dimensionInUse(this.company, i + 1));
                }
                ++i;
            }
            this.mans[0].setValue(this.company.getSeqNr1Mandatory());
            this.mans[1].setValue(this.company.getSeqNr2Mandatory());
            this.mans[2].setValue(this.company.getSeqNr3Mandatory());
            this.mans[3].setValue(this.company.getSeqNr4Mandatory());
            this.mans[4].setValue(this.company.getSeqNr5Mandatory());
            this.mans[5].setValue(this.company.getSeqNr6Mandatory());
        }
        if (this.company.getDataSet() == null) {
            i = 0;
            while (i <= this.jtTabCountMax) {
                this.accountingPrincipleDefault[i] = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.dbData, this.company.getId(), this.jtAp[i])[0];
                if (this.accountingPrincipleDefault[i] == null) {
                    this.getAccountingPrincipleDefaultFromEnvironment(i);
                } else {
                    if (i <= this.apTabCountMax) {
                        this.calculateDepreciation[i].setValue(this.accountingPrincipleDefault[i].getCalculateDepreciation());
                        this.depreciationMethod[i].setSelectedOptionValue("" + this.accountingPrincipleDefault[i].getDepreciationMethod());
                        this.yearPercentageTableId[i].setValue(this.accountingPrincipleDefault[i].getYearPercentageTableId());
                        YearPercentageTable yearPercentageTable = this.accountingPrincipleDefault[i].getYearPercentageTable();
                        if (yearPercentageTable != null) {
                            this.yearPercentageTableId[i].setDescription(yearPercentageTable.getDescription());
                        }
                        this.degressivePercentage[i].setValue(this.accountingPrincipleDefault[i].getDegressivePercentage());
                        this.annuityPercentage[i].setValue(this.accountingPrincipleDefault[i].getAnnuityPercentage());
                        this.annuityInterestTableId[i].setValue(this.accountingPrincipleDefault[i].getAnnuityInterestTableId());
                        InterestTable interestTable = this.accountingPrincipleDefault[i].getAnnuityInterestTable();
                        if (interestTable != null) {
                            this.annuityInterestTableId[i].setDescription(interestTable.getDescription());
                        }
                        this.startPeriodHandlingMethod[i].setSelectedOptionValue("" + this.accountingPrincipleDefault[i].getStartPeriodHandlingMethod());
                        this.calculateInterest[i].setValue(this.accountingPrincipleDefault[i].getCalculateInterest());
                        this.interestCalculationMethod[i].setSelectedOptionValue("" + this.accountingPrincipleDefault[i].getInterestCalculationMethod());
                        this.interestTableId[i].setValue(this.accountingPrincipleDefault[i].getInterestTableId());
                        interestTable = this.accountingPrincipleDefault[i].getInterestTable();
                        if (interestTable != null) {
                            this.interestTableId[i].setDescription(interestTable.getDescription());
                        }
                        this.interestPercentage[i].setValue(this.accountingPrincipleDefault[i].getInterestPercentage());
                        this.journalingMethod[i].setSelectedOptionValue("" + this.accountingPrincipleDefault[i].getJournalingMethod());
                    }
                    this.mainAccount[i][0].setValue(this.accountingPrincipleDefault[i].getMainAccountId1());
                    this.mainAccount[i][1].setValue(this.accountingPrincipleDefault[i].getMainAccountId2());
                    this.mainAccount[i][2].setValue(this.accountingPrincipleDefault[i].getMainAccountId3());
                    this.mainAccount[i][3].setValue(this.accountingPrincipleDefault[i].getMainAccountId4());
                    this.mainAccount[i][4].setValue(this.accountingPrincipleDefault[i].getMainAccountId5());
                    this.mainAccount[i][5].setValue(this.accountingPrincipleDefault[i].getMainAccountId6());
                    this.mainAccount[i][6].setValue(this.accountingPrincipleDefault[i].getMainAccountId7());
                    this.mainAccount[i][7].setValue(this.accountingPrincipleDefault[i].getMainAccountId8());
                    this.mainAccount[i][8].setValue(this.accountingPrincipleDefault[i].getMainAccountId9());
                    this.daybook[i][0].setValue(this.accountingPrincipleDefault[i].getDaybookId1());
                    this.daybook[i][1].setValue(this.accountingPrincipleDefault[i].getDaybookId2());
                    this.daybook[i][2].setValue(this.accountingPrincipleDefault[i].getDaybookId3());
                    this.daybook[i][3].setValue(this.accountingPrincipleDefault[i].getDaybookId4());
                    this.daybook[i][4].setValue(this.accountingPrincipleDefault[i].getDaybookId5());
                    this.daybook[i][5].setValue(this.accountingPrincipleDefault[i].getDaybookId6());
                    this.daybook[i][6].setValue(this.accountingPrincipleDefault[i].getDaybookId7());
                }
                ++i;
            }
        }
        this.modifyFieldAttributes();
        if (this.dfts[0] != null) {
            this.dfts[0].setValue(!"0".equals(this.dims[0].getSelectedOptionValue()) ? this.company.getDefaultAnalysisCode1() : "");
            this.dfts[0].validate();
        }
        if (this.dfts[1] != null) {
            this.dfts[1].setValue(!"0".equals(this.dims[1].getSelectedOptionValue()) ? this.company.getDefaultAnalysisCode2() : "");
            this.dfts[1].validate();
        }
        if (this.dfts[2] != null) {
            this.dfts[2].setValue(!"0".equals(this.dims[2].getSelectedOptionValue()) ? this.company.getDefaultAnalysisCode3() : "");
            this.dfts[2].validate();
        }
        if (this.dfts[3] != null) {
            this.dfts[3].setValue(!"0".equals(this.dims[3].getSelectedOptionValue()) ? this.company.getDefaultAnalysisCode4() : "");
            this.dfts[3].validate();
        }
        if (this.dfts[4] != null) {
            this.dfts[4].setValue(!"0".equals(this.dims[4].getSelectedOptionValue()) ? this.company.getDefaultAnalysisCode5() : "");
            this.dfts[4].validate();
        }
        if (this.dfts[5] != null) {
            this.dfts[5].setValue(!"0".equals(this.dims[5].getSelectedOptionValue()) ? this.company.getDefaultAnalysisCode6() : "");
            this.dfts[5].validate();
        }
    }

    protected void refreshCompanyAPDefaults() throws Exception {
        int i = 0;
        while (i <= this.jtTabCountMax) {
            this.accountingPrincipleDefault[i] = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.dbData, this.company.getId(), this.jtAp[i])[0];
            if (this.accountingPrincipleDefault[i] == null) {
                this.getAccountingPrincipleDefaultFromEnvironment(i);
            }
            ++i;
        }
    }

    protected String update() throws Exception {
        int i;
        String message = this.validateAll();
        if (message != null) {
            return message;
        }
        Company dataSetCompany = null;
        if (this.dataSet.getValue().trim().length() > 0) {
            Object[] result = CompanyBO.get(this.dbData, this.dataSet.getValue().trim());
            if (result[1] != null) {
                this.mainTabPanel.setActiveTabByName("Label.Common");
                this.dataSet.setInvalidTag();
                return (String)result[1];
            }
            dataSetCompany = (Company)result[0];
        }
        this.numberOfPeriods = Integer.parseInt(this.cbNumberOfPeriods.getValue());
        int iCreditIdLength = 0;
        int iCreditIdStartValue = 0;
        if (this.governmentActivated) {
            iCreditIdLength = this.creditIdLength.getIntValue();
            iCreditIdStartValue = this.creditIdStartValue.getIntValue();
        }
        int[] usageFinDims = new int[11];
        String[] finDimFrom = new String[5];
        String[] finDimTo = new String[5];
        int i2 = 0;
        while (i2 < 11) {
            if (this.fins[i2] != null) {
                usageFinDims[i2] = Integer.parseInt(this.fins[i2].getValue());
                if (i2 < 5) {
                    finDimFrom[i2] = this.finFrom[i2].getFormattedId();
                    finDimTo[i2] = this.finTo[i2].getFormattedId();
                }
            }
            ++i2;
        }
        int j = 0;
        int[] seqNr = new int[6];
        boolean[] seqNrMandatory = new boolean[6];
        String[] defaults = new String[6];
        if (this.dims[0] != null) {
            i = 0;
            while (i < 6) {
                defaults[i] = "";
                if (!this.dims[i].getSelectedOptionValue().equals("0")) {
                    seqNr[j] = Integer.parseInt(this.dims[i].getSelectedOptionValue());
                    seqNrMandatory[j] = this.mans[i].isChecked();
                    if (this.dfts[i] != null) {
                        defaults[j] = this.dfts[i].getValue();
                    }
                    ++j;
                }
                ++i;
            }
        }
        if ((message = CompanyBO.update(this.company, this.idDesc.getDescription().trim(), Integer.parseInt(this.initialBookYear.getValue()), Integer.parseInt(this.currentBookYear.getValue()), dataSetCompany, this.numberOfPeriods, this.correctionPeriods.getIntValue(), this.famMemberPrefix.getValue().trim(), this.assetIdType.getValue(), this.assetIdLength.getIntValue(), this.assetIdAutoNumber.isChecked(), this.assetIdStartValue.getIntValue(), this.creditIdType.getValue(), iCreditIdLength, this.creditIdAutoNumber.isChecked(), iCreditIdStartValue, usageFinDims, finDimFrom, finDimTo, Integer.parseInt(this.cbAP2.getValue()), this.loginHelper.getUser(), seqNr, seqNrMandatory, defaults)) != null) {
            this.mainTabPanel.setActiveTabByName("Label.Common");
            return message;
        }
        if (this.governmentActivated) {
            this.company.setUseValuationMainAccount(this.useValuationMainAccount.getValueAsBoolean());
            this.copyAssetAPDataToCreditAPData();
        }
        i = 0;
        while (i <= this.jtTabCountMax) {
            if (this.dataSet.getValue().trim().length() == 0) {
                message = this.saveAccountingPrincipleDefault(i, this.company.getId());
            } else if (this.accountingPrincipleDefault[i] != null) {
                message = CompanyAccountingPrincipleDefaultBO.delete(this.accountingPrincipleDefault[i]);
            }
            if (message != null) {
                this.mainTabPanel.setActiveTabByName("Label.Common");
                return message;
            }
            ++i;
        }
        Iterator iterator = this.years.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            BookYear year = (BookYear)iterator.next();
            if (this.chg[index]) {
                message = BookYearBO.update(year, Integer.parseInt(this.ayr[index]), this.abt[index], this.abf[index]);
                if (message != null) {
                    this.mainTabPanel.setActiveTabByName("Label.Common");
                    return message;
                }
            } else if (this.currentBookYear.getValue().trim().equals(this.ayr[index]) && (message = BookYearBO.update(year, Integer.parseInt(this.ayr[index]), this.blockTo.getIntValue(), this.blockFrom.getIntValue())) != null) {
                this.mainTabPanel.setActiveTabByName("Label.Common");
                return message;
            }
            ++index;
        }
        return null;
    }

    private String validateAll() throws Exception {
        String message;
        int nop = Integer.parseInt(this.cbNumberOfPeriods.getValue());
        int nocp = this.correctionPeriods.getIntValue();
        if (this.env.getOperationArea().length() == 0) {
            if (nop == 12 && nocp > 1 || nop == 13 && nocp > 0) {
                this.mainTabPanel.setActiveTabByName("Label.Common");
                this.correctionPeriods.setInvalidTag();
                return "InvalidValueForNumberOfCorrectionPeriods";
            }
        } else if (nop == 12 && nocp > 77 || nop == 13 && nocp > 76) {
            this.mainTabPanel.setActiveTabByName("Label.Common");
            this.correctionPeriods.setInvalidTag();
            return "InvalidValueForNumberOfCorrectionPeriods";
        }
        if (this.initialBookYear.getValue().compareTo(this.currentBookYear.getValue()) > 0) {
            this.mainTabPanel.setActiveTabByName("Label.Common");
            this.initialBookYear.setInvalidTag();
            this.currentBookYear.setInvalidTag();
            return "CurrentYearBeforeStartYear";
        }
        String prefix = this.famMemberPrefix.getValue().trim();
        if (prefix.length() > 0 && !Character.isLetter(prefix.charAt(0))) {
            this.mainTabPanel.setActiveTabByName("Label.Common");
            this.famMemberPrefix.setInvalidTag();
            return "PrefixShouldBeginWithAlpha";
        }
        if (prefix.length() > 1) {
            int i = 1;
            while (i < prefix.length()) {
                if (!Character.isLetterOrDigit(prefix.charAt(i))) {
                    this.mainTabPanel.setActiveTabByName("Label.Common");
                    this.famMemberPrefix.setInvalidTag();
                    return "SecondCharacterOfPrefixInvalid";
                }
                ++i;
            }
        }
        if ((message = this.validateIdLengths()) != null) {
            this.mainTabPanel.setActiveTabByName("Label.Common");
            return message;
        }
        if (this.dataSet.getValue().trim().length() == 0) {
            int i = 0;
            while (i <= this.apTabCountMax) {
                message = this.validateAccountingPrincipleForm(i);
                if (message != null) {
                    this.mainTabPanel.setActiveTabByName("Label.Valuation");
                    this.apTabbedPanel.setActiveTab(this.apTabs[i]);
                    return message;
                }
                ++i;
            }
        }
        if (this.dims[0] != null && (message = this.validateFacDims()) != null) {
            this.mainTabPanel.setActiveTabByName("Label.Dimensions");
            return message;
        }
        return null;
    }

    protected String validateCreateForm() throws Exception {
        String id = this.companyField.getValue().trim();
        this.idDesc.setValue(id);
        this.idDesc.setDescription(this.companyField.getDescription().trim());
        Object[] result = CompanyBO.get(this.dbData, id);
        if (result[0] != null) {
            return "duplicate_key";
        }
        return null;
    }

    protected String validateCreateForm2() throws Exception {
        Object[] result;
        int nop = Integer.parseInt(this.cbNumberOfPeriods.getValue());
        int nocp = this.correctionPeriods.getIntValue();
        if (this.env.getOperationArea().length() == 0) {
            if (nop == 12 && nocp > 1 || nop == 13 && nocp > 0) {
                this.correctionPeriods.setInvalidTag();
                return "InvalidValueForNumberOfCorrectionPeriods";
            }
        } else if (nop == 12 && nocp > 77 || nop == 13 && nocp > 76) {
            this.correctionPeriods.setInvalidTag();
            return "InvalidValueForNumberOfCorrectionPeriods";
        }
        if (this.dataSet.getValue().trim().length() > 0 && (result = CompanyBO.get(this.dbData, this.dataSet.getValue().trim()))[1] != null) {
            this.dataSet.setInvalidTag();
            return (String)result[1];
        }
        if (this.initialBookYear.getValue().compareTo(this.currentBookYear.getValue()) > 0) {
            this.initialBookYear.setInvalidTag();
            this.currentBookYear.setInvalidTag();
            return "CurrentYearBeforeStartYear";
        }
        String prefix = this.famMemberPrefix.getValue().trim();
        if (prefix.length() > 0 && !Character.isLetter(prefix.charAt(0))) {
            this.famMemberPrefix.setInvalidTag();
            return "PrefixShouldBeginWithAlpha";
        }
        if (prefix.length() > 1) {
            int i = 1;
            while (i < prefix.length()) {
                if (!Character.isLetterOrDigit(prefix.charAt(i))) {
                    this.famMemberPrefix.setInvalidTag();
                    return "SecondCharacterOfPrefixInvalid";
                }
                ++i;
            }
        }
        return this.validateIdLengths();
    }

    protected String validateIdLengths() throws Exception {
        String message = this.validateIdLengths(this.assetIdLength, this.assetIdType, this.assetIdAutoNumber, this.assetIdStartValue);
        if (message == null && this.governmentActivated) {
            message = this.validateIdLengths(this.creditIdLength, this.creditIdType, this.creditIdAutoNumber, this.creditIdStartValue);
        }
        return message;
    }

    protected String validateIdLengths(NumberField length, ComboBox idType, CheckBox idAutoNumber, NumberField startValue) throws Exception {
        String message = null;
        message = AlphaNumericEnum.validateLength(length.getIntValue(), idType.getValue());
        if (message != null) {
            length.setInvalidTag();
        } else {
            message = AlphaNumericEnum.validateStartValue(idAutoNumber.isChecked(), startValue.getIntValue(), length.getIntValue());
            if (message != null) {
                startValue.setInvalidTag();
            }
        }
        return message;
    }

    protected String validateAccountingPrincipleForm(int tabNumber) throws Exception {
        Object[] result;
        String message;
        Object[] result2;
        String message2;
        if (this.mode == 0) {
            this.apPanels[tabNumber].removeInvalidTags();
            this.apPanels[tabNumber].validateAll();
        } else {
            if (this.apTabs[tabNumber].isHidden()) {
                return null;
            }
            this.apTabs[tabNumber].removeInvalidTags();
            this.apTabs[tabNumber].validateAll();
        }
        String id = this.yearPercentageTableId[tabNumber].getValue().trim();
        if (id.length() > 0 && (message2 = (String)(result2 = YearPercentageTableBO.get(this.dbData, id))[1]) != null) {
            this.yearPercentageTableId[tabNumber].setInvalidTag();
            return message2;
        }
        if (!"0".equals(this.interestCalculationMethod[tabNumber].getValue())) {
            boolean precentageFilled;
            id = this.interestTableId[tabNumber].getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.interestPercentage[tabNumber].getDoubleValue() > 0.0;
            if (idFilled && precentageFilled) {
                this.interestTableId[tabNumber].setInvalidTag();
                this.interestPercentage[tabNumber].setInvalidTag();
                return "provide_only_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.interestTableId[tabNumber].setInvalidTag();
                return message;
            }
        }
        if ("2".equals(this.depreciationMethod[tabNumber].getValue()) && this.degressivePercentage[tabNumber].getDoubleValue() == 0.0) {
            this.degressivePercentage[tabNumber].setInvalidTag();
            return "value_must_be_positive";
        }
        if ("12".equals(this.depreciationMethod[tabNumber].getValue()) || "11".equals(this.depreciationMethod[tabNumber].getValue())) {
            boolean precentageFilled;
            id = this.annuityInterestTableId[tabNumber].getValue().trim();
            boolean idFilled = id.length() > 0;
            boolean bl = precentageFilled = this.annuityPercentage[tabNumber].getDoubleValue() > 0.0;
            if (idFilled && precentageFilled) {
                this.annuityInterestTableId[tabNumber].setInvalidTag();
                this.annuityPercentage[tabNumber].setInvalidTag();
                return "provide_only_one_value";
            }
            if (idFilled && (message = (String)(result = InterestTableBO.get(this.dbData, id, this.numberOfPeriods))[1]) != null) {
                this.annuityInterestTableId[tabNumber].setInvalidTag();
                return message;
            }
        }
        return null;
    }

    private void validateJournalingTermForm(int tabNumber) throws Exception {
        if (tabNumber == -1) {
            return;
        }
        if (this.mode == 1 && this.jtTab.isHidden()) {
            return;
        }
        int i = 0;
        while (i < this.jteLength) {
            if (i != 9 && i != 10) {
                this.mainAccount[tabNumber][i].removeInvalidTag();
            }
            ++i;
        }
        i = 0;
        while (i < this.dbeLength) {
            this.daybook[tabNumber][i].removeInvalidTag();
            ++i;
        }
        i = 0;
        while (i < this.jteLength) {
            if (i != 9 && i != 10) {
                this.mainAccount[tabNumber][i].validate();
            }
            ++i;
        }
        i = 0;
        while (i < this.dbeLength) {
            this.daybook[tabNumber][i].validate();
            ++i;
        }
    }

    private String validateFacDims() throws Exception {
        HashSet<String> set = new HashSet<String>(6);
        int i = 0;
        while (i < 6) {
            if (!this.dims[i].getSelectedOptionValue().equals("0")) {
                if (set.contains(this.dims[i].getSelectedOptionValue())) {
                    this.dims[i].setInvalidTag();
                    return "duplicate_key";
                }
                set.add(this.dims[i].getSelectedOptionValue());
            }
            ++i;
        }
        return null;
    }

    private void copyAssetAPDataToCreditAPData() throws Exception {
        int index = 2;
        if (this.mode == 0) {
            index = 1;
        }
        this.mainAccount[index][0].setValue(this.mainAccount[0][0].getValue());
        this.mainAccount[index][1].setValue(this.mainAccount[0][1].getValue());
        this.mainAccount[index][2].setValue(this.mainAccount[0][2].getValue());
        this.mainAccount[index][4].setValue(this.mainAccount[0][4].getValue());
        this.mainAccount[index][5].setValue(this.mainAccount[0][5].getValue());
        this.mainAccount[index][8].setValue(this.mainAccount[0][8].getValue());
        this.mainAccount[index][0].validate();
        this.mainAccount[index][1].validate();
        this.mainAccount[index][2].validate();
        this.mainAccount[index][4].validate();
        this.mainAccount[index][5].validate();
        this.mainAccount[index][8].validate();
        if (this.mode == 0) {
            this.mainAccount[index][3].setValue(this.mainAccount[0][3].getValue());
            this.mainAccount[index][6].setValue(this.mainAccount[0][6].getValue());
            this.mainAccount[index][7].setValue(this.mainAccount[0][7].getValue());
            this.mainAccount[index][3].validate();
            this.mainAccount[index][6].validate();
            this.mainAccount[index][7].validate();
        }
        this.daybook[index][0].setValue(this.daybook[0][0].getValue());
        this.daybook[index][1].setValue(this.daybook[0][1].getValue());
        this.daybook[index][2].setValue(this.daybook[0][2].getValue());
        this.daybook[index][3].setValue(this.daybook[0][3].getValue());
        this.daybook[index][4].setValue(this.daybook[0][4].getValue());
        this.daybook[index][5].setValue(this.daybook[0][5].getValue());
        this.daybook[index][6].setValue(this.daybook[0][6].getValue());
        this.daybook[index][0].validate();
        this.daybook[index][1].validate();
        this.daybook[index][2].validate();
        this.daybook[index][3].validate();
        this.daybook[index][4].validate();
        this.daybook[index][5].validate();
        this.daybook[index][6].validate();
    }

    private void getAccountingPrincipleDefaultsFromEnvironment() throws Exception {
        int i = 0;
        while (i <= this.apTabCountMax) {
            this.getAccountingPrincipleDefaultFromEnvironment(i);
            ++i;
        }
    }

    private void getAccountingPrincipleDefaultFromEnvironment(int i) throws Exception {
        EnvironmentAccountingPrincipleDefault environmentAccountingPrincipleDefault;
        if (i <= this.apTabCountMax && (environmentAccountingPrincipleDefault = (EnvironmentAccountingPrincipleDefault)EnvironmentAccountingPrincipleDefaultBO.get(this.env, this.ap[i])[0]) != null) {
            this.calculateDepreciation[i].setValue(environmentAccountingPrincipleDefault.getCalculateDepreciation());
            this.depreciationMethod[i].setSelectedOptionValue("" + environmentAccountingPrincipleDefault.getDepreciationMethod());
            this.yearPercentageTableId[i].setValue(environmentAccountingPrincipleDefault.getYearPercentageTableId());
            YearPercentageTable yearPercentageTable = environmentAccountingPrincipleDefault.getYearPercentageTable();
            if (yearPercentageTable != null) {
                this.yearPercentageTableId[i].setDescription(yearPercentageTable.getDescription());
            }
            this.degressivePercentage[i].setValue(environmentAccountingPrincipleDefault.getDegressivePercentage());
            this.annuityPercentage[i].setValue(environmentAccountingPrincipleDefault.getAnnuityPercentage());
            this.annuityInterestTableId[i].setValue(environmentAccountingPrincipleDefault.getAnnuityInterestTableId());
            this.startPeriodHandlingMethod[i].setSelectedOptionValue("" + environmentAccountingPrincipleDefault.getStartPeriodHandlingMethod());
            this.calculateInterest[i].setValue(environmentAccountingPrincipleDefault.getCalculateInterest());
            this.interestCalculationMethod[i].setSelectedOptionValue("" + environmentAccountingPrincipleDefault.getInterestCalculationMethod());
            this.interestTableId[i].setValue(environmentAccountingPrincipleDefault.getInterestTableId());
            InterestTable interestTable = environmentAccountingPrincipleDefault.getInterestTable();
            if (interestTable != null) {
                this.interestTableId[i].setDescription(interestTable.getDescription());
            }
            this.interestPercentage[i].setValue(environmentAccountingPrincipleDefault.getInterestPercentage());
            this.journalingMethod[i].setSelectedOptionValue("" + environmentAccountingPrincipleDefault.getJournalingMethod());
        }
    }

    private void modifyFieldAttributes() throws Exception {
        if (this.companyAdapter == null) {
            return;
        }
        if (this.mode == 1) {
            this.useAccountingPrinciple2ChangeAction.execute(null);
            this.assetIdTypeChangeAction.execute(null);
            if (this.governmentActivated) {
                this.creditIdTypeChangeAction.execute(null);
            }
        }
        int i = 0;
        while (i <= this.apTabCountMax) {
            this.calculateDepreciationChangeAction[i].execute(null);
            this.calculateInterestChangeAction[i].execute(null);
            this.depreciationMethodChangeAction[i].execute(null);
            this.interestCalculationMethodChangeAction[i].execute(null);
            ++i;
        }
        if (this.mode == 1) {
            i = this.jtTabCountMax;
            while (i >= 0) {
                this.journalingMethodChangeAction[i].execute(null);
                --i;
            }
            if (this.governmentActivated) {
                i = 0;
                while (i < 6) {
                    this.acts[i].execute(null);
                    ++i;
                }
            }
        }
    }

    protected String getAccountingPrincipleTabText() {
        return this.apTabTexts[this.ap[this.apTabCount] - 1];
    }

    protected String getJournalingTermTabText() {
        return this.jtTabTexts[this.jtAp[this.jtTabCount] - 1];
    }

    private String saveAccountingPrincipleDefault(int i, String companyId) throws Exception {
        String message = null;
        if (this.accountingPrincipleDefault[i] != null) {
            message = this.jtAp[i] != 2 || !"0".equals(this.cbAP2.getValue()) ? (i <= this.apTabCountMax ? CompanyAccountingPrincipleDefaultBO.update(this.dbData, this.accountingPrincipleDefault[i], this.calculateDepreciation[i].getValueAsBoolean(), Integer.parseInt(this.depreciationMethod[i].getValue()), this.yearPercentageTableId[i].getValue(), this.degressivePercentage[i].getBigDecimal(), this.annuityInterestTableId[i].getValue(), this.annuityPercentage[i].getBigDecimal(), Integer.parseInt(this.startPeriodHandlingMethod[i].getValue()), this.calculateInterest[i].getValueAsBoolean(), Integer.parseInt(this.interestCalculationMethod[i].getValue()), this.interestTableId[i].getValue(), this.numberOfPeriods, this.interestPercentage[i].getBigDecimal(), Integer.parseInt(this.journalingMethod[i].getValue()), this.mainAccount[i][0].getFormattedId(), this.mainAccount[i][1].getFormattedId(), this.mainAccount[i][2].getFormattedId(), this.mainAccount[i][3].getFormattedId(), this.mainAccount[i][4].getFormattedId(), this.mainAccount[i][5].getFormattedId(), this.mainAccount[i][6].getFormattedId(), this.mainAccount[i][7].getFormattedId(), this.mainAccount[i][8].getFormattedId(), this.daybook[i][0].getFormattedId(), this.daybook[i][1].getFormattedId(), this.daybook[i][2].getFormattedId(), this.daybook[i][3].getFormattedId(), this.daybook[i][4].getFormattedId(), this.daybook[i][5].getFormattedId(), this.daybook[i][6].getFormattedId()) : CompanyAccountingPrincipleDefaultBO.update(this.dbData, this.accountingPrincipleDefault[i], this.mainAccount[i][0].getFormattedId(), this.mainAccount[i][1].getFormattedId(), this.mainAccount[i][2].getFormattedId(), this.mainAccount[i][3].getFormattedId(), this.mainAccount[i][4].getFormattedId(), this.mainAccount[i][5].getFormattedId(), this.mainAccount[i][6].getFormattedId(), this.mainAccount[i][7].getFormattedId(), this.mainAccount[i][8].getFormattedId(), this.daybook[i][0].getFormattedId(), this.daybook[i][1].getFormattedId(), this.daybook[i][2].getFormattedId(), this.daybook[i][3].getFormattedId(), this.daybook[i][4].getFormattedId(), this.daybook[i][5].getFormattedId(), this.daybook[i][6].getFormattedId())) : CompanyAccountingPrincipleDefaultBO.delete(this.accountingPrincipleDefault[i]);
        } else if (this.jtAp[i] != 2 || !"0".equals(this.cbAP2.getValue())) {
            Object[] result = null;
            result = i <= this.apTabCountMax ? CompanyAccountingPrincipleDefaultBO.create(this.dbData, companyId, this.jtAp[i], this.calculateDepreciation[i].getValueAsBoolean(), Integer.parseInt(this.depreciationMethod[i].getValue()), this.yearPercentageTableId[i].getValue(), this.degressivePercentage[i].getBigDecimal(), this.annuityInterestTableId[i].getValue(), this.annuityPercentage[i].getBigDecimal(), Integer.parseInt(this.startPeriodHandlingMethod[i].getValue()), this.calculateInterest[i].getValueAsBoolean(), Integer.parseInt(this.interestCalculationMethod[i].getValue()), this.interestTableId[i].getValue(), this.numberOfPeriods, this.interestPercentage[i].getBigDecimal(), Integer.parseInt(this.journalingMethod[i].getValue()), this.mainAccount[i][0].getValue().trim(), this.mainAccount[i][1].getValue().trim(), this.mainAccount[i][2].getValue().trim(), this.mainAccount[i][3].getValue().trim(), this.mainAccount[i][4].getValue().trim(), this.mainAccount[i][5].getValue().trim(), this.mainAccount[i][6].getValue().trim(), this.mainAccount[i][7].getValue().trim(), this.mainAccount[i][8].getValue().trim(), this.daybook[i][0].getValue().trim(), this.daybook[i][1].getValue().trim(), this.daybook[i][2].getValue().trim(), this.daybook[i][3].getValue().trim(), this.daybook[i][4].getValue().trim(), this.daybook[i][5].getValue().trim(), this.daybook[i][6].getValue().trim()) : CompanyAccountingPrincipleDefaultBO.create(this.dbData, companyId, this.jtAp[i], this.mainAccount[i][0].getValue().trim(), this.mainAccount[i][1].getValue().trim(), this.mainAccount[i][2].getValue().trim(), this.mainAccount[i][3].getValue().trim(), this.mainAccount[i][4].getValue().trim(), this.mainAccount[i][5].getValue().trim(), this.mainAccount[i][6].getValue().trim(), this.mainAccount[i][7].getValue().trim(), this.mainAccount[i][8].getValue().trim(), this.daybook[i][0].getValue().trim(), this.daybook[i][1].getValue().trim(), this.daybook[i][2].getValue().trim(), this.daybook[i][3].getValue().trim(), this.daybook[i][4].getValue().trim(), this.daybook[i][5].getValue().trim(), this.daybook[i][6].getValue().trim());
            this.accountingPrincipleDefault[i] = (CompanyAccountingPrincipleDefault)result[0];
            message = (String)result[1];
        }
        return message;
    }

    public void setCompanyAdapter(CompanyAdapter companyAdapter) {
        this.companyAdapter = companyAdapter;
    }

    private class APTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = 4698365794179208227L;

        public APTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            object.removeMessages();
            int tabNumber = this.getActiveAccountingPrincipleTabIndex();
            String message = CompanyPanels.this.validateAccountingPrincipleForm(tabNumber);
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return true;
            }
            super.execute(object);
            return true;
        }

        private int getActiveAccountingPrincipleTabIndex() {
            String tabName = CompanyPanels.this.apTabbedPanel.getActiveTabName();
            int i = 0;
            while (i <= CompanyPanels.this.apTabCountMax) {
                if (CompanyPanels.this.apTabTexts[i].equals(tabName)) {
                    return i;
                }
                ++i;
            }
            return CompanyPanels.this.apTabCount;
        }
    }

    private class AssetIdTypeChangeAction
    extends Action {
        private static final long serialVersionUID = -6052168292489482271L;

        private AssetIdTypeChangeAction() {
        }

        public boolean execute(DataObject dataObject) throws Exception {
            CompanyPanels.this.assetIdType.setReadonly(AssetBO.hasAssets(CompanyPanels.this.company));
            if (CompanyPanels.this.assetIdType.getValue().equals("A")) {
                CompanyPanels.this.assetIdAutoNumber.setValue(false);
                CompanyPanels.this.assetIdAutoNumber.setHidden(true);
                CompanyPanels.this.assetIdStartValue.setValue("0");
                CompanyPanels.this.assetIdStartValue.setHidden(true);
                CompanyPanels.this.assetIdLength.setReadonly(false);
                return true;
            }
            CompanyPanels.this.assetIdAutoNumber.setHidden(false);
            CompanyPanels.this.assetIdStartValue.setHidden(false);
            CompanyPanels.this.assetIdLength.setReadonly(AssetBO.hasAssets(CompanyPanels.this.company));
            return true;
        }
    }

    private class CalculateDepreciationChangeAction
    extends Action {
        private static final long serialVersionUID = 7466661560217263804L;
        private int tabNumber = 0;

        public CalculateDepreciationChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (CompanyPanels.this.calculateDepreciation[this.tabNumber].getValueAsBoolean()) {
                CompanyPanels.this.depreciationMethod[this.tabNumber].setHidden(false);
                CompanyPanels.this.startPeriodHandlingMethod[this.tabNumber].setHidden(false);
                return true;
            }
            CompanyPanels.this.depreciationMethod[this.tabNumber].setValueAsString("99");
            CompanyPanels.this.depreciationMethod[this.tabNumber].setHidden(true);
            CompanyPanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
            CompanyPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
            CompanyPanels.this.yearPercentageTableId[this.tabNumber].setValue();
            CompanyPanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
            CompanyPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
            CompanyPanels.this.degressivePercentage[this.tabNumber].setValue();
            CompanyPanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
            CompanyPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
            CompanyPanels.this.annuityPercentage[this.tabNumber].setValue();
            CompanyPanels.this.annuityInterestTableId[this.tabNumber].setMandatory(false);
            CompanyPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
            CompanyPanels.this.annuityInterestTableId[this.tabNumber].setValue();
            CompanyPanels.this.startPeriodHandlingMethod[this.tabNumber].setHidden(true);
            return true;
        }
    }

    private class CalculateInterestChangeAction
    extends Action {
        private static final long serialVersionUID = 3562045469454924093L;
        private int tabNumber = 0;

        public CalculateInterestChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (CompanyPanels.this.calculateInterest[this.tabNumber].getValueAsBoolean()) {
                CompanyPanels.this.interestCalculationMethod[this.tabNumber].setHidden(false);
                return true;
            }
            CompanyPanels.this.interestCalculationMethod[this.tabNumber].setHidden(true);
            CompanyPanels.this.interestCalculationMethod[this.tabNumber].setValueAsString("0");
            CompanyPanels.this.interestTableId[this.tabNumber].setHidden(true);
            CompanyPanels.this.interestTableId[this.tabNumber].setValue();
            CompanyPanels.this.interestPercentage[this.tabNumber].setHidden(true);
            CompanyPanels.this.interestPercentage[this.tabNumber].setValue();
            return true;
        }
    }

    private class CreditIdTypeChangeAction
    extends Action {
        private static final long serialVersionUID = 2141277363406563820L;

        private CreditIdTypeChangeAction() {
        }

        public boolean execute(DataObject dataObject) throws Exception {
            CompanyPanels.this.creditIdType.setReadonly(AssetBO.hasAssets(CompanyPanels.this.company));
            if (CompanyPanels.this.creditIdType.getValue().equals("A")) {
                CompanyPanels.this.creditIdAutoNumber.setValue(false);
                CompanyPanels.this.creditIdAutoNumber.setHidden(true);
                CompanyPanels.this.creditIdStartValue.setValue("0");
                CompanyPanels.this.creditIdStartValue.setHidden(true);
                CompanyPanels.this.creditIdLength.setReadonly(false);
                return true;
            }
            CompanyPanels.this.creditIdAutoNumber.setHidden(false);
            CompanyPanels.this.creditIdStartValue.setHidden(false);
            CompanyPanels.this.creditIdLength.setReadonly(CreditBO.hasCredits(CompanyPanels.this.company));
            return true;
        }
    }

    private class CurrentYearChangeAction
    extends Action {
        private static final long serialVersionUID = -6105321829732068607L;

        public boolean execute(DataObject dataObject) throws Exception {
            int limit = Integer.parseInt(CompanyPanels.this.cbNumberOfPeriods.getSelectedOptionValue());
            int period2 = 0;
            int period1 = 0;
            if (!CompanyPanels.this.firstTime) {
                dataObject.removeMessages();
                period2 = CompanyPanels.this.blockFrom.getIntValue() == 0 ? 0 : CompanyPanels.this.blockFrom.getIntValue();
                boolean error2 = this.validate(dataObject, period2, limit, CompanyPanels.this.blockFrom);
                period1 = CompanyPanels.this.blockTo.getIntValue() == 0 ? 0 : CompanyPanels.this.blockTo.getIntValue();
                boolean error1 = this.validate(dataObject, period1, limit, CompanyPanels.this.blockTo);
                if (error2 || error1) {
                    CompanyPanels.this.currentBookYear.setSelectedOptionValue(CompanyPanels.this.ayr[CompanyPanels.this.previousYearIndex]);
                    return true;
                }
                if (period2 != CompanyPanels.this.abf[CompanyPanels.this.previousYearIndex]) {
                    ((CompanyPanels)CompanyPanels.this).abf[((CompanyPanels)CompanyPanels.this).previousYearIndex] = period2;
                    ((CompanyPanels)CompanyPanels.this).chg[((CompanyPanels)CompanyPanels.this).previousYearIndex] = true;
                }
                if (period1 != CompanyPanels.this.abt[CompanyPanels.this.previousYearIndex]) {
                    ((CompanyPanels)CompanyPanels.this).abt[((CompanyPanels)CompanyPanels.this).previousYearIndex] = period1;
                    ((CompanyPanels)CompanyPanels.this).chg[((CompanyPanels)CompanyPanels.this).previousYearIndex] = true;
                }
            }
            CompanyPanels.this.firstTime = false;
            String currentYear = CompanyPanels.this.currentBookYear.getSelectedOptionValue();
            int index = 0;
            while (index < CompanyPanels.this.arraySize) {
                if (currentYear.equals(CompanyPanels.this.ayr[index])) {
                    CompanyPanels.this.blockFrom.setValue((long)CompanyPanels.this.abf[index]);
                    CompanyPanels.this.blockFrom.setReadonly(CompanyPanels.this.agg[index]);
                    CompanyPanels.this.blockTo.setValue((long)CompanyPanels.this.abt[index]);
                    CompanyPanels.this.blockTo.setReadonly(CompanyPanels.this.agg[index]);
                    CompanyPanels.this.previousYearIndex = index;
                    break;
                }
                ++index;
            }
            return true;
        }

        private boolean validate(DataObject dataObject, int period, int limit, NumberField numberField) throws Exception {
            String message;
            boolean error = false;
            numberField.removeInvalidTag();
            if (period > limit) {
                message = String.valueOf(dataObject.translate("Label.TheAttribute", dataObject.getLocale())) + " '" + numberField.getLabel() + "' " + dataObject.translate("Label.CanNotBeGreaterThan", dataObject.getLocale()).toLowerCase() + " " + limit;
                dataObject.addUIObject((UIObject)new Message(message, "error"));
                numberField.setInvalidTag();
                error = true;
            }
            if (period < 0) {
                message = String.valueOf(dataObject.translate("Label.TheAttribute", dataObject.getLocale())) + " '" + numberField.getLabel() + "' " + dataObject.translate("Label.CanNotBeLessThanZero", dataObject.getLocale()).toLowerCase();
                dataObject.addUIObject((UIObject)new Message(message, "error"));
                numberField.setInvalidTag();
                error = true;
            }
            return error;
        }
    }

    protected class DataSetReferenceField
    extends ODBQueryReferenceField {
        private static final long serialVersionUID = 3347467309006784639L;

        public DataSetReferenceField(DBData dbData, String companyId) throws Exception {
            super("Label.Company", (ODBQuery)new CompanyQuery(dbData, companyId));
            this.addOnChangeListener(new MyListener());
            this.setName(((Object)((Object)this)).getClass().getName());
            this.setTableFields(NAMES);
            this.setTableHeaderLabels(LABELS);
            this.setValueField(NAMES[0]);
            this.setDescriptionField(NAMES[1]);
            this.setTableKeys(new String[]{NAMES[0]});
            this.setTableHeaderSizes(SIZES);
            this.setType("upper");
            this.setLength(7);
            this.setMaxLength(7);
            this.setDescriptionLength(40);
            this.setSearchFields(NAMES);
            this.setSearchFieldLabels(LABELS);
        }

        private class MyListener
        implements EventListener {
            private static final long serialVersionUID = -4029588484831596780L;

            private MyListener() {
            }

            public void event(UIObject object, String type) throws Exception {
                if (DataSetReferenceField.this.getValue().trim().length() > 0) {
                    CompanyPanels.this.cbNumberOfPeriods.setReadonly(true);
                    CompanyPanels.this.cbNumberOfPeriods.setValue();
                    CompanyPanels.this.cbAP2.setValue();
                    CompanyPanels.this.cbAP2.setReadonly(true);
                    Object[] result = CompanyBO.get(CompanyPanels.this.dbData, DataSetReferenceField.this.getValue().trim());
                    if (result[0] != null) {
                        Company dataSetCompany = (Company)result[0];
                        CompanyPanels.this.cbNumberOfPeriods.setValueAsString("" + dataSetCompany.getNumberOfPeriods());
                        CompanyPanels.this.cbAP2.setValueAsString("" + dataSetCompany.getAccountingPrinciple2Usage());
                        DataSetReferenceField.this.setDescription(dataSetCompany.getDescription());
                    }
                    if (CompanyPanels.this.mode == 1) {
                        CompanyPanels.this.finDimTab.setHidden(true);
                        CompanyPanels.this.apTab.setHidden(true);
                        CompanyPanels.this.jtTab.setHidden(true);
                    }
                    return;
                }
                CompanyPanels.this.cbNumberOfPeriods.setReadonly(false);
                CompanyPanels.this.cbAP2.setReadonly(false);
                if (CompanyPanels.this.mode == 1) {
                    CompanyPanels.this.cbAP2.setReadonly(AssetTypeBO.hasAssetTypes(CompanyPanels.this.company));
                    CompanyPanels.this.apTab.setHidden(false);
                    CompanyPanels.this.jtTab.setHidden(false);
                }
            }
        }
    }

    private class DepreciationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -7988927228620312875L;
        private int tabNumber;

        public DepreciationMethodChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if ("3".equals(CompanyPanels.this.depreciationMethod[this.tabNumber].getValue())) {
                CompanyPanels.this.yearPercentageTableId[this.tabNumber].setMandatory(true);
                CompanyPanels.this.yearPercentageTableId[this.tabNumber].setHidden(false);
                CompanyPanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
                CompanyPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
                CompanyPanels.this.degressivePercentage[this.tabNumber].setValue();
                CompanyPanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
                CompanyPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
                CompanyPanels.this.annuityPercentage[this.tabNumber].setValue();
                CompanyPanels.this.annuityInterestTableId[this.tabNumber].setMandatory(false);
                CompanyPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
                CompanyPanels.this.annuityInterestTableId[this.tabNumber].setValue();
                return true;
            }
            if ("12".equals(CompanyPanels.this.depreciationMethod[this.tabNumber].getValue()) || "11".equals(CompanyPanels.this.depreciationMethod[this.tabNumber].getValue())) {
                CompanyPanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
                CompanyPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
                CompanyPanels.this.yearPercentageTableId[this.tabNumber].setValue();
                CompanyPanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
                CompanyPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
                CompanyPanels.this.degressivePercentage[this.tabNumber].setValue();
                CompanyPanels.this.annuityPercentage[this.tabNumber].setHidden(false);
                CompanyPanels.this.annuityInterestTableId[this.tabNumber].setHidden(false);
                return true;
            }
            if ("2".equals(CompanyPanels.this.depreciationMethod[this.tabNumber].getValue())) {
                CompanyPanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
                CompanyPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
                CompanyPanels.this.yearPercentageTableId[this.tabNumber].setValue();
                CompanyPanels.this.degressivePercentage[this.tabNumber].setMandatory(true);
                CompanyPanels.this.degressivePercentage[this.tabNumber].setHidden(false);
                CompanyPanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
                CompanyPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
                CompanyPanels.this.annuityPercentage[this.tabNumber].setValue();
                CompanyPanels.this.annuityInterestTableId[this.tabNumber].setMandatory(false);
                CompanyPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
                CompanyPanels.this.annuityInterestTableId[this.tabNumber].setValue();
                return true;
            }
            CompanyPanels.this.yearPercentageTableId[this.tabNumber].setMandatory(false);
            CompanyPanels.this.yearPercentageTableId[this.tabNumber].setHidden(true);
            CompanyPanels.this.yearPercentageTableId[this.tabNumber].setValue();
            CompanyPanels.this.degressivePercentage[this.tabNumber].setMandatory(false);
            CompanyPanels.this.degressivePercentage[this.tabNumber].setHidden(true);
            CompanyPanels.this.degressivePercentage[this.tabNumber].setValue();
            CompanyPanels.this.annuityPercentage[this.tabNumber].setMandatory(false);
            CompanyPanels.this.annuityPercentage[this.tabNumber].setHidden(true);
            CompanyPanels.this.annuityPercentage[this.tabNumber].setValue();
            CompanyPanels.this.annuityInterestTableId[this.tabNumber].setMandatory(false);
            CompanyPanels.this.annuityInterestTableId[this.tabNumber].setHidden(true);
            CompanyPanels.this.annuityInterestTableId[this.tabNumber].setValue();
            return true;
        }
    }

    private class DimensionComboBoxChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;
        int seqNr = 0;

        public DimensionComboBoxChangeAction(int seqNr) {
            this.seqNr = seqNr;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if ("0".equals(CompanyPanels.this.dims[this.seqNr].getValue())) {
                CompanyPanels.this.mans[this.seqNr].setValue(false);
                CompanyPanels.this.mans[this.seqNr].setReadonly(true);
                CompanyPanels.this.gridLayout.removeUIObject((UIObject)CompanyPanels.this.dfts[this.seqNr], false);
                ((CompanyPanels)CompanyPanels.this).dfts[this.seqNr] = null;
            } else {
                CompanyPanels.this.mans[this.seqNr].setReadonly(false);
                AnalysisGroup group = (AnalysisGroup)AnalysisGroupBO.get(CompanyPanels.this.dbData, CompanyPanels.this.company.getId(), Integer.parseInt(CompanyPanels.this.dims[this.seqNr].getValue()))[0];
                if (group != null && group.getUsage() == 1) {
                    AnalysisCodeReferenceField refField = new AnalysisCodeReferenceField(CompanyPanels.this.dbData, group);
                    refField.setDiscardLabel(true);
                    refField.setDescriptionLength(33);
                    CompanyPanels.this.gridLayout.add((UIObject)refField, this.seqNr + 1, 5);
                    ((CompanyPanels)CompanyPanels.this).dfts[this.seqNr] = refField;
                } else {
                    ((CompanyPanels)CompanyPanels.this).dfts[this.seqNr] = null;
                }
            }
            return true;
        }
    }

    private class InterestCalculationMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -4099934352056207581L;
        private int tabNumber;

        public InterestCalculationMethodChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if ("0".equals(CompanyPanels.this.interestCalculationMethod[this.tabNumber].getValue())) {
                CompanyPanels.this.interestTableId[this.tabNumber].setHidden(true);
                CompanyPanels.this.interestTableId[this.tabNumber].setValue();
                CompanyPanels.this.interestPercentage[this.tabNumber].setHidden(true);
                CompanyPanels.this.interestPercentage[this.tabNumber].setValue();
                return true;
            }
            CompanyPanels.this.interestTableId[this.tabNumber].setHidden(false);
            CompanyPanels.this.interestPercentage[this.tabNumber].setHidden(false);
            return true;
        }
    }

    private class JTTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = 150774253075639729L;

        public JTTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            object.removeMessages();
            int tabNumber = this.getActiveJournalingsTermTabIndex();
            CompanyPanels.this.validateJournalingTermForm(tabNumber);
            super.execute(object);
            CompanyPanels.this.companyAdapter.getProcess().setAttribute("disinvestmentReasonMainAccountAP", (Object)("" + (tabNumber + 1)));
            return true;
        }

        private int getActiveJournalingsTermTabIndex() {
            String tabName = CompanyPanels.this.jtTabbedPanel.getActiveTabName();
            int i = 0;
            while (i <= CompanyPanels.this.jtTabCountMax) {
                if (CompanyPanels.this.jtTabTexts[i].equals(tabName)) {
                    return i;
                }
                ++i;
            }
            return CompanyPanels.this.jtTabCount;
        }
    }

    private class JournalingMethodChangeAction
    extends Action {
        private static final long serialVersionUID = -6923482772793225623L;
        private int tabNumber;
        private FloatBar floatBar = null;

        public JournalingMethodChangeAction(int tabNumber) {
            this.tabNumber = tabNumber;
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (CompanyPanels.this.mode == 0) {
                CompanyPanels.this.companyAdapter.createAccountingPrincipleFloatBar(dataObject);
                return true;
            }
            if (CompanyPanels.this.jtTab.isHidden()) {
                return true;
            }
            if ("9".equals(CompanyPanels.this.journalingMethod[this.tabNumber].getValue())) {
                CompanyPanels.this.jtTabs[this.tabNumber].setHidden(true);
                int i = 0;
                while (i <= CompanyPanels.this.jtTabCountMax) {
                    if (!CompanyPanels.this.jtTabs[i].isHidden()) {
                        CompanyPanels.this.jtTabbedPanel.setActiveTab(CompanyPanels.this.jtTabs[i]);
                        return true;
                    }
                    ++i;
                }
                CompanyPanels.this.jtTab.setHidden(true);
                return true;
            }
            CompanyPanels.this.jtTabs[this.tabNumber].setHidden(false);
            if (this.floatBar != null) {
                this.floatBar.removeAllChildUIObjects();
                CompanyPanels.this.jtTabs[this.tabNumber].removeUIObject((UIObject)this.floatBar, false);
                this.floatBar = null;
            }
            if ("1".equals(CompanyPanels.this.journalingMethod[this.tabNumber].getValue()) && this.floatBar == null && CompanyPanels.this.disinvestmentReasonMainAccountAction != null) {
                this.floatBar = new FloatBar();
                this.floatBar.alignment(1);
                this.floatBar.addAction(CompanyPanels.this.disinvestmentReasonMainAccountAction);
                CompanyPanels.this.jtTabs[this.tabNumber].add(this.floatBar);
            }
            CompanyPanels.this.jtTabbedPanel.setActiveTab(CompanyPanels.this.jtTabs[this.tabNumber]);
            CompanyPanels.this.jtTab.setHidden(false);
            CompanyPanels.this.companyAdapter.getProcess().setAttribute("disinvestmentReasonMainAccountAP", (Object)("" + (this.tabNumber + 1)));
            return true;
        }
    }

    protected class MainTabActivateAction
    extends TabActivateAction {
        private static final long serialVersionUID = 2298792855932187199L;

        public MainTabActivateAction(Tab tab, TabbedPanel tabbedPanel) {
            super(tab, tabbedPanel);
        }

        public boolean execute(DataObject object) throws Exception {
            object.removeMessages();
            if ("Label.Common".equals(CompanyPanels.this.mainTabPanel.getActiveTabName()) && Integer.parseInt(CompanyPanels.this.cbNumberOfPeriods.getValue()) != CompanyPanels.this.numberOfPeriods) {
                CompanyPanels.this.numberOfPeriods = Integer.parseInt(CompanyPanels.this.cbNumberOfPeriods.getValue());
                InterestTableReferenceField newObject = new InterestTableReferenceField(CompanyPanels.this.dbData, CompanyPanels.this.numberOfPeriods);
                CompanyPanels.this.apTabbedPanel.replaceUIObject((UIObject)CompanyPanels.this.interestTableId[0], (UIObject)newObject);
                ((CompanyPanels)CompanyPanels.this).interestTableId[0] = newObject;
                newObject = new InterestTableReferenceField(CompanyPanels.this.dbData, CompanyPanels.this.numberOfPeriods);
                CompanyPanels.this.apTabbedPanel.replaceUIObject((UIObject)CompanyPanels.this.interestTableId[1], (UIObject)newObject);
                ((CompanyPanels)CompanyPanels.this).interestTableId[1] = newObject;
                newObject = new InterestTableReferenceField(CompanyPanels.this.dbData, CompanyPanels.this.numberOfPeriods);
                CompanyPanels.this.apTabbedPanel.replaceUIObject((UIObject)CompanyPanels.this.interestTableId[2], (UIObject)newObject);
                ((CompanyPanels)CompanyPanels.this).interestTableId[2] = newObject;
            }
            if ("Label.Valuation".equals(CompanyPanels.this.mainTabPanel.getActiveTabName())) {
                int i = 0;
                while (i <= CompanyPanels.this.apTabCountMax) {
                    String message = CompanyPanels.this.validateAccountingPrincipleForm(i);
                    if (message != null) {
                        object.addUIObject((UIObject)new Message(message, "error"));
                        CompanyPanels.this.mainTabPanel.setActiveTabByName("Label.Valuation");
                        CompanyPanels.this.apTabbedPanel.setActiveTab(CompanyPanels.this.apTabs[i]);
                        return true;
                    }
                    ++i;
                }
            }
            if ("Label.MainAccountScheme".equals(CompanyPanels.this.mainTabPanel.getActiveTabName())) {
                int i = 0;
                while (i <= CompanyPanels.this.jtTabCountMax) {
                    CompanyPanels.this.validateJournalingTermForm(i);
                    ++i;
                }
            }
            super.execute(object);
            return true;
        }
    }

    public class UseAccountingPrinciple2ChangeAction
    extends Action {
        private static final long serialVersionUID = 6404088286134116694L;

        public boolean execute(DataObject dataObject) throws Exception {
            if (CompanyPanels.this.mode == 0) {
                CompanyPanels.this.numberOfPeriods = Integer.parseInt(CompanyPanels.this.cbNumberOfPeriods.getValue());
                CompanyPanels.this.initializeAccountingPrincipleForms();
                CompanyPanels.this.getAccountingPrincipleDefaultsFromEnvironment();
                CompanyPanels.this.modifyFieldAttributes();
                CompanyPanels.this.initializeJournalingTermForms();
                return true;
            }
            if (CompanyPanels.this.jtTab.isHidden()) {
                return true;
            }
            if (!"0".equals(CompanyPanels.this.cbAP2.getValue())) {
                CompanyPanels.this.apTabs[1].setHidden(false);
                CompanyPanels.this.jtTabs[1].setHidden(false);
                return true;
            }
            CompanyPanels.this.apTabs[1].setHidden(true);
            CompanyPanels.this.apTabbedPanel.setActiveTab(CompanyPanels.this.apTabs[0]);
            CompanyPanels.this.jtTabs[1].setHidden(true);
            CompanyPanels.this.jtTabbedPanel.setActiveTab(CompanyPanels.this.jtTabs[0]);
            return true;
        }
    }

    private class UseOwnBasicDataChangeAction
    extends Action {
        private static final long serialVersionUID = -6052168292489482271L;

        private UseOwnBasicDataChangeAction() {
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (!CompanyPanels.this.useOwnBasicData.getValueAsBoolean()) {
                CompanyPanels.this.dataSet.setMandatory(true);
                CompanyPanels.this.cbNumberOfPeriods.setHidden(true);
                CompanyPanels.this.correctionPeriods.setHidden(true);
                CompanyPanels.this.cbAP2.setHidden(true);
            } else {
                CompanyPanels.this.dataSet.setMandatory(false);
                CompanyPanels.this.cbNumberOfPeriods.setHidden(false);
                CompanyPanels.this.correctionPeriods.setHidden(false);
                CompanyPanels.this.cbAP2.setHidden(false);
            }
            return true;
        }
    }
}

