/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.CompanyPanels;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;

public class CompanyPeriodHandlingAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 8841673750144901517L;
    public static final String PAGE = CompanyPeriodHandlingAdapter.class.getName();
    private CompanyPanels panels;
    private FloatBar fbEdit;
    private Company company;

    public CompanyPeriodHandlingAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.fbEdit = new FloatBar();
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
        editOK.setDefault(true);
        editOK.setValidationEnabled(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.panels = new CompanyPanels(this.loginHelper, this.dbData, this.env, this.company.retrieveNumberOfPeriods(), this.governmentActivated, this.company);
        this.panels.setValues();
        this.panels.showPeriodHandlingStuffOnly();
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CompanyPeriodHandling", "screen_name"));
        object.addUIObject((UIObject)this.panels.mainPanel);
        object.addUIObject((UIObject)this.panels.mainTabPanel);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = this.panels.update();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.finish(object);
    }
}

