/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.queries.CompanyQuery;
import nl.ibs.jsql.DBData;

public class CompanyReferenceField
extends ODBQueryReferenceField {
    private static final long serialVersionUID = -1315358237218283836L;
    private static final String[] NAMES = new String[]{"id", "description"};
    private static final String[] LABELS = new String[]{"Label.Company", "Label.Description"};
    private static final short[] SIZES = new short[]{70, 500};
    private DBData dbData;
    private Company company;

    public CompanyReferenceField(DBData dbData) throws Exception {
        super(LABELS[0], "upper", (ODBQuery)new CompanyQuery(dbData), Company.class);
        this.dbData = dbData;
        this.setName(((Object)((Object)this)).getClass().getName());
        this.setTableFields(NAMES);
        this.setTableHeaderLabels(LABELS);
        this.setValueField(NAMES[0]);
        this.setDescriptionField(NAMES[1]);
        this.setTableKeys(new String[]{NAMES[0]});
        this.setTableHeaderSizes(SIZES);
        this.setLength(7);
        this.setMaxLength(7);
        this.setDescriptionLength(50);
        this.setSearchFields(NAMES);
        this.setSearchFieldLabels(LABELS);
    }

    public Field setValue(String id) {
        super.setValue(id);
        if (id == null) {
            return this;
        }
        this.company = null;
        try {
            this.company = (Company)CompanyBO.get(this.dbData, id)[0];
            if (this.company != null) {
                this.setDescription(this.company.getDescription());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public void validate() throws Exception {
        super.validate();
        if (this.getValue().trim().length() == 0) {
            this.setDescription("");
            return;
        }
        Object[] result = CompanyBO.get(this.dbData, this.getValue().trim());
        if (result[1] != null) {
            this.setInvalidTag();
            throw new UserErrorMessage((String)result[1]);
        }
        this.company = (Company)result[0];
        this.setDescription(this.company.getDescription());
    }

    public Company getCompany() {
        return this.company;
    }
}

