/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.InputComponent;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.validators.RangeValidator;
import nl.ibs.fac.adapters.CompanyReferenceField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.reports.CompanyToPDF;
import nl.ibs.util.Scrambler;
import nl.ibs.vegas.input.Validator;

public class CompanyReportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -6899661905996798014L;
    public static final String PAGE = CompanyReportAdapter.class.getName();
    private static final String SUBMIT = "submit";
    private static final String TITLE = "Title.CompanyReport";
    public static final String CLASSNAMEPDF = CompanyToPDF.CLASSNAME;
    public static final String JOBNAME = "Job.Company";
    private FieldGroup group = new FieldGroup("", 600, 0);
    private ODBQueryReferenceField fromId;
    private ODBQueryReferenceField toId;

    public CompanyReportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.env == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.fromId = new CompanyReferenceField(this.dbData);
        this.fromId.setDiscardLabel(true);
        this.fromId.showDescription(false);
        this.toId = new CompanyReferenceField(this.dbData);
        this.toId.setDiscardLabel(true);
        this.toId.showDescription(false);
        this.toId.addValidator((Validator)new RangeValidator((InputComponent)this.fromId));
        ESPGridLayout grid = new ESPGridLayout();
        short[] sArray = new short[3];
        sArray[0] = 198;
        grid.setColumnWidths(sArray);
        grid.add((UIObject)new Label("from"), 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE);
        grid.add((UIObject)new Label("up-to-and-including"), 0, 2, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE);
        Label lCompanyId = new Label("Label.Id");
        lCompanyId.setHelpId("Label.CompanyId");
        grid.add((UIObject)lCompanyId, 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE);
        grid.add((UIObject)this.fromId, 1, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE);
        grid.add((UIObject)this.toId, 1, 2, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE);
        this.group.forceBorder(true);
        this.group.add(grid);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.env == null) {
            object.addUIObject((UIObject)new Message("NoActiveEnvironment", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        this.fromId.setReadonly(false);
        this.toId.setReadonly(false);
        object.addUIObject((UIObject)this.group);
        FloatBar fbShow = new FloatBar();
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        fbShow.addAction(ok);
        fbShow.addAction(((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).getReturnAction());
        fbShow.addAction(this.finish);
        object.addUIObject((UIObject)fbShow);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"System", this.loginHelper.getSystem()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"facLib", this.dbData.getSchema()}, {"governmentActivated", "" + this.governmentActivated}, {"Environment", this.env.getId()}, {"orderBy", "id"}, {"FromCompany", this.fromId.getValue().trim()}, {"ToCompany", this.toId.getValue().trim()}};
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("classNamePDF", (Object)CLASSNAMEPDF);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.fromId.setReadonly(true);
        this.toId.setReadonly(true);
        this.getProcess().setAttribute("header", (Object)this.group);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }
}

