/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFileOutputStream;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FileSelectionField;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserMessageException;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.inport.CurrentCapitalizationCSV;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.util.Scrambler;

public class CurrentCapitalizationImportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 7435930956664598404L;
    public static final String PAGE = CurrentCapitalizationImportAdapter.class.getName();
    private FieldGroup group = new FieldGroup();
    private static final String TITLE = "Title.CurrentCapitalizationImport";
    private static final String CLASSNAME = CurrentCapitalizationCSV.CLASSNAME;
    private static final String JOBNAME = "Job.CurrentCapitalizationImport";
    private FileSelectionField file = new FileSelectionField("Label.File", 40);
    private FloatBar fbShow = new FloatBar();
    private static final String SUBMIT = "submit";
    private static final int CCSID = 819;

    public CurrentCapitalizationImportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.file.setMandatory(true);
        this.group.add((Field)this.file);
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShow.addAction(ok);
        this.fbShow.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        Company company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        company.getUseValuationMainAccount();
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.group);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        this.file.validateSize(object);
        byte[] bytes = this.file.getFileContent(object);
        if (bytes.length == 0) {
            this.file.setInvalidTag();
            throw new UserMessageException("importfile_not_found");
        }
        LoginHelper loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
        String pathToFile = String.valueOf(ImportCSVHelper.getDefaultPath()) + '/' + this.file.getValue();
        IFSFileOutputStream fos = new IFSFileOutputStream((AS400)loginHelper.getAs400(), pathToFile, 819);
        fos.write(bytes);
        fos.close();
        String[][] selections = new String[][]{{"pathToFile", pathToFile}, {"System", loginHelper.getSystem()}, {"User", loginHelper.getUser()}, {"Password", Scrambler.scramble((String)loginHelper.getPassword())}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getId()}, {"Company", this.companyId}};
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("title", (Object)object.translate(TITLE, object.getLocale()));
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }
}

