/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ObjectDescription;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import nl.ibs.esp.adapter.Adapter;
import nl.ibs.esp.dataobject.BinaryObject;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.dataobject.HttpDataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.DBPropertiesHelper;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FACAdapter;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.PropertiesHelper;

public class DBConfigAdapter
extends FACAdapter {
    private static final long serialVersionUID = -8674763507440746978L;
    public static final String PAGE = DBConfigAdapter.class.getName();
    private FieldGroup fg = new FieldGroup();
    private Field system = new Field("Label.System");
    private Field userId = new Field("Label.User", "upper");
    private Field password = new Field("Label.Password", "password");
    private Field library = new Field("Label.Library", "upper");
    private FloatBar fb = new FloatBar();

    public DBConfigAdapter(DataObject object) throws Exception {
        super(object);
        this.showTaskBar(false);
        StartStopServlet.setContextName(((HttpDataObject)object).getRequest());
        StartStopServlet.copyPropertiesFiles();
        DBPropertiesHelper.getProperties();
        this.system.setLength(10);
        this.system.setMandatory(true);
        this.system.setValue(DBPropertiesHelper.getSystem());
        this.fg.add(this.system);
        this.userId.setLength(10);
        this.userId.setMaxLength(10);
        this.userId.setMandatory(true);
        this.userId.setValue(DBPropertiesHelper.getDatabaseUser());
        this.fg.add(this.userId);
        this.password.setLength(10);
        this.password.setMandatory(true);
        this.password.setValue(DBPropertiesHelper.getDatabasePassword());
        this.fg.add(this.password);
        this.library.setLength(10);
        this.library.setMaxLength(10);
        this.library.setMandatory(true);
        this.library.setValue(DBPropertiesHelper.getLibrary());
        this.fg.add(this.library);
        Action save = new Action("Button.OK", (Adapter)this, "save");
        save.setDefault(true);
        save.setValidationEnabled(true);
        this.fb.addAction(save);
        Action download = new Action("Button.Download", (Adapter)this, "download");
        download.setIsDownloadAction(true);
        this.fb.addAction(download);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(false, false, true);
        object.addUIObject((UIObject)new Header("Title.DBConfig", "screen_name"));
        object.addUIObject((UIObject)this.fg);
        object.addUIObject((UIObject)this.fb);
        return object;
    }

    public DataObject save(DataObject object) throws Exception {
        LoginHelper loginHelper = new LoginHelper(this.system.getValue().trim(), this.userId.getValue().trim(), this.password.getValue().trim(), null);
        String message = loginHelper.login();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message));
            return object;
        }
        if (new ObjectDescription((AS400)loginHelper.getAs400(), "/QSYS.LIB/" + this.library.getValue() + ".LIB").exists() && !new ObjectDescription((AS400)loginHelper.getAs400(), "/QSYS.LIB/" + this.library.getValue() + ".LIB/FACOBJLIB.DTAARA").exists()) {
            object.addUIObject((UIObject)new Message("library_is_no_FAC_library"));
            return object;
        }
        Properties properties = PropertiesHelper.getProperties((String)"jsql_config.properties");
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            list.add(new NameValuePair((String)entry.getKey(), (String)entry.getValue()));
        }
        for (NameValuePair pair : list) {
            String name = pair.getName();
            if (name.equals("fac_db_url")) {
                int e;
                String url = pair.getValue();
                int b = url.indexOf("as400:");
                if (b > -1) {
                    e = url.indexOf(";", b);
                    if (e == -1) {
                        e = url.length();
                    }
                    url = String.valueOf(url.substring(0, b + 6)) + this.system.getValue().trim() + url.substring(e);
                }
                if ((b = url.indexOf("package library=")) > -1) {
                    e = url.indexOf(";", b);
                    if (e == -1) {
                        e = url.length();
                    }
                    url = String.valueOf(url.substring(0, b + 16)) + this.library.getValue().trim() + url.substring(e);
                }
                pair.setValue(url);
                continue;
            }
            if (name.equals("fac_db_user")) {
                pair.setValue(this.userId.getValue().trim());
                continue;
            }
            if (name.equals("fac_db_password")) {
                pair.setValue(this.password.getValue().trim());
                continue;
            }
            if (!name.equals("fac_db_schema")) continue;
            pair.setValue(this.library.getValue().trim());
        }
        message = DBPropertiesHelper.savePropertyList(list);
        if (message == null) {
            StartStopServlet.settingsValid(true);
            object.addUIObject((UIObject)new Message(String.valueOf(object.translate("config_is_saved", object.getLocale())) + ": " + DBPropertiesHelper.class.getClassLoader().getResource("jsql_config.properties").getPath()));
            FacConstants.setClassPath(((HttpDataObject)object).getRequest());
            message = DBPropertiesHelper.saveToIFS(list, loginHelper);
        }
        loginHelper.logout();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message));
        } else {
            object.addUIObject((UIObject)new Message(String.valueOf(object.translate("config_is_saved", object.getLocale())) + ": " + FacConstants.getContextName() + "/WEB-INF/classes/" + "jsql_config.properties"));
        }
        return object;
    }

    public DataObject download(DataObject object) throws Exception {
        BinaryObject bobj = new BinaryObject(DBPropertiesHelper.getBytes(DBPropertiesHelper.getPropertyList(), false), "text/plain", object);
        bobj.openSaveAsDialog("jsql_config.properties");
        return bobj;
    }
}

