/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.commands.DepreciationNewProposalCommand;
import nl.ibs.fac.commands.DepreciationProposalCreateCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.util.Scrambler;

public class DepreciationProposalCreateAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -6899661905996798014L;
    public static final String PAGE = DepreciationProposalCreateAdapter.class.getName();
    private static final String SUBMIT = "submit";
    private static final String TITLE = "Title.CreateDepreciationProposal";
    private static final String PREPROCESSOR = DepreciationNewProposalCommand.CLASSNAME;
    private static final String CLASSNAME = DepreciationProposalCreateCommand.CLASSNAME;
    private static final String JOBNAME = "Job.CreateDepreciationProposal";
    private FieldGroup group;
    private BookYearPeriodGrid yearPeriodTo;
    private BookYearPeriodGrid finYearPeriod;
    private CheckBox ap1 = new CheckBox();
    private CheckBox ap2 = new CheckBox();
    private CheckBox post;
    private CheckBox print = new CheckBox();
    private ComboBox fileType = new ComboBox();
    private Label fileTypeLbl = new Label("Label.FileType");
    private Action ok;
    private FloatBar fbShow = new FloatBar();
    private Company company;
    private DepreciationProposalBP businessProcess;

    public DepreciationProposalCreateAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        ESPGridLayout grid;
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.businessProcess = new DepreciationProposalBP(this.company, this.numberOfPeriods, this.governmentActivated);
        this.group = new FieldGroup("", 400, 0);
        this.group.forceBorder(true);
        this.yearPeriodTo = new BookYearPeriodGrid("Label.PeriodTo", this.bookYear, this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.group.add((ESPGridLayout)this.yearPeriodTo);
        this.finYearPeriod = new BookYearPeriodGrid("Label.BookPeriod", false);
        this.group.add((ESPGridLayout)this.finYearPeriod);
        String[] yps = this.businessProcess.retrieveYearsAndPeriods();
        this.yearPeriodTo.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        int ap2Usage = this.company.getAccountingPrinciple2Usage();
        if (ap2Usage < 0) {
            Company dataSet = (Company)CompanyBO.get(this.dbData, this.company.getDataSetId())[0];
            ap2Usage = dataSet.getAccountingPrinciple2Usage();
        }
        if (ap2Usage == 0) {
            this.ap1.setValue(true);
            this.ap2.setValue(false);
        } else {
            this.ap1.setValue(true);
            this.ap2.setValue(true);
            grid = new ESPGridLayout();
            grid.setPaddingBottom(0);
            grid.setPaddingTop(0);
            short[] sArray = new short[2];
            sArray[0] = 198;
            grid.setColumnWidths(sArray);
            Label label = new Label(this.env.getAPName1());
            label.setHelpId("ap1");
            grid.add((UIObject)label, 0, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
            grid.add((UIObject)this.ap1, 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
            label = new Label(this.env.getAPName2());
            label.setHelpId("ap2");
            grid.add((UIObject)label, 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
            grid.add((UIObject)this.ap2, 1, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
            this.group.add(grid);
        }
        grid = new ESPGridLayout();
        grid.setPaddingBottom(0);
        grid.setPaddingTop(0);
        short[] sArray = new short[2];
        sArray[0] = 198;
        grid.setColumnWidths(sArray);
        grid.add((UIObject)new Label("Label.Post"), 0, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.post = new CheckBox();
        if (this.company.getProcessParameters().getStandardVoucherDate() == 5) {
            this.post.setReadonly(true);
        }
        grid.add((UIObject)this.post, 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.print.setAction((Action)new ChangeAction());
        grid.add((UIObject)new Label("Label.Print"), 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        grid.add((UIObject)this.print, 1, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.fileType.addOption("", "");
        this.fileType.addOption("CSV", "CSV");
        this.fileType.addOption("PDF", "PDF");
        this.fileType.setWidth("60");
        this.fileType.setMandatory(true);
        this.fileType.setHidden(true);
        this.fileTypeLbl.setHidden(true);
        grid.add((UIObject)this.fileTypeLbl, 2, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        grid.add((UIObject)this.fileType, 2, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.group.add(grid);
        this.ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        this.ok.setValidationEnabled(true);
        this.ok.setDefault(true);
        this.fbShow.addAction(this.ok);
        this.fbShow.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        TransactionBatch transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(this.dbData, this.companyId);
        if (transactionBatch != null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "depreciation_proposal_already_exists");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(this.dbData, this.companyId);
        if (transactionBatch != null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "mass_transaction_proposal_already_exists");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        this.yearPeriodTo.setReadonly(false);
        this.finYearPeriod.setReadonly(false);
        this.ap1.setReadonly(false);
        this.ap2.setReadonly(false);
        if (this.company.getProcessParameters().getStandardVoucherDate() != 5) {
            this.post.setReadonly(false);
        }
        this.print.setReadonly(false);
        this.fileType.setReadonly(false);
        object.addUIObject((UIObject)this.group);
        object.addUIObject((UIObject)this.fbShow);
        Integer batchId = this.company.getCurrentBatchId();
        if (batchId != null && TransactionBO.getFirstTransaction(transactionBatch = (TransactionBatch)TransactionBatchBO.get(this.dbData, this.companyId, batchId)[0]) != null) {
            this.ok.setConfirmationMessage("CurrentTransactionBatch_is_not_empty");
        }
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        this.group.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return object;
        }
        if (!this.ap1.getValueAsBoolean() && !this.ap2.getValueAsBoolean()) {
            object.addUIObject((UIObject)new Message("no_accounting_principle_selected", "error"));
            return object;
        }
        messages = this.businessProcess.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax));
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.setInvalidTag();
        }
        if (error) {
            return object;
        }
        String[][] selections = new String[][]{{"facLib", this.dbData.getSchema()}, {"System", this.loginHelper.getSystem()}, {"User", this.loginHelper.getUser()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"operationArea", this.env.getOperationArea().trim()}, {"dataLib", this.env.getDataLib().trim()}, {"programLib", this.env.getProgramLib().trim()}, {"object_lib", StartStopServlet.getObjectLibrary()}, {"Environment", this.env.getId()}, {"Company", this.companyId}, {"BookYearTo", this.yearPeriodTo.getBookYear().getValue()}, {"PeriodTo", this.yearPeriodTo.getPeriod().getValue()}, {"finYear", "" + this.finYearPeriod.getBookYear().getIntValue()}, {"finPeriod", "" + this.finYearPeriod.getPeriod().getIntValue()}, {"AP1", "" + this.ap1.getValueAsBoolean()}, {"AP2", "" + this.ap2.getValueAsBoolean()}, {"Post", "" + this.post.getValueAsBoolean()}, {"orderBy", "assetId"}, {"levels", "0000000"}, {"BookYear", this.bookYear}, {"Print", "" + this.print.getValueAsBoolean()}, {"FileType", this.fileType.getSelectedOptionValue()}, {"governmentActivated", "" + this.governmentActivated}};
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("preprocessor", (Object)PREPROCESSOR);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("header", (Object)this.group);
        this.yearPeriodTo.setReadonly(true);
        this.finYearPeriod.setReadonly(true);
        this.ap1.setReadonly(true);
        this.ap2.setReadonly(true);
        this.post.setReadonly(true);
        this.print.setReadonly(true);
        this.fileType.setReadonly(true);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        int i = 0;
        while (i < errors.length) {
            if (errors[i] != null && errors[i].trim().length() > 0) {
                object.addUIObject((UIObject)new Message(errors[i], "error"));
            }
            ++i;
        }
    }

    private class ChangeAction
    extends Action {
        private static final long serialVersionUID = -95011077132350820L;

        private ChangeAction() {
        }

        public boolean execute(DataObject object) throws Exception {
            DepreciationProposalCreateAdapter.this.fileType.setHidden(!DepreciationProposalCreateAdapter.this.print.getValueAsBoolean());
            DepreciationProposalCreateAdapter.this.fileTypeLbl.setHidden(!DepreciationProposalCreateAdapter.this.print.getValueAsBoolean());
            return true;
        }
    }
}

