/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.adapters.TransactionBatchTransactionAdapter;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.commands.DepreciationProposalDeleteCommand;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;

public class DepreciationProposalDeleteAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 379823599917630406L;
    public static final String PAGE = DepreciationProposalDeleteAdapter.class.getName();
    private static final String TITLE = "Title.DeleteDepreciationProposal";
    private static final String CLASSNAME = DepreciationProposalDeleteCommand.CLASSNAME;
    private static final String JOBNAME = "Job.DeleteDepreciationProposal";

    public DepreciationProposalDeleteAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        TransactionBatch transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(this.dbData, this.companyId);
        if (transactionBatch == null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getId()}, {"Company", this.companyId}};
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("header", (Object)TransactionBatchTransactionAdapter.getHeaderPanel(transactionBatch));
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }
}

