/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FilterTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.InputComponent;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.adapters.TransactionBatchTransactionAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.DepreciationProposalToCSV;
import nl.ibs.fac.reports.DepreciationProposalToPDF;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Scrambler;

public class DepreciationProposalReportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 5502438705156232217L;
    public static final String BACK_PAGE = "dpBackPage";
    public static final String BACK_METHOD = "dpBackMethod";
    public static final String PAGE = DepreciationProposalReportAdapter.class.getName();
    public static final String BATCH = "batch";
    private static final String SUBMIT = "submit";
    private static final String TITLE = "Title.DepreciationProposalReport";
    private static final String CLASSNAMECSV = DepreciationProposalToCSV.CLASSNAME;
    private static final String CLASSNAMEPDF = DepreciationProposalToPDF.CLASSNAME;
    private static final String JOBNAME = "Job.DepreciationProposalReport";
    private static final String[] FIELDNAMES = new String[]{"finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "proFormaTypeId", "assetId"};
    private Panel header;
    private FinancialReferenceField[] finFrom = new FinancialReferenceField[5];
    private FinancialReferenceField[] finTo = new FinancialReferenceField[5];
    private ODBQueryReferenceField fromType;
    private ODBQueryReferenceField toType;
    private ODBQueryReferenceField fromId;
    private ODBQueryReferenceField toId;
    private FieldGroup screen;
    private FilterTable table;

    public DepreciationProposalReportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.screen = new FieldGroup(LanguageHelper.getString("nl.ibs.fac.language", "SelectSort"));
        this.createTable();
        this.screen.add((Table)this.table);
        this.screen.add((InputComponent)this.table.getClearAction());
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        TransactionBatch transactionBatch = null;
        transactionBatch = this.getProcess().getAttribute(BATCH) != null ? (TransactionBatch)this.getProcess().getAttribute(BATCH) : DepreciationProposalBP.getCurrentDepreciationBatch(this.dbData, this.companyId);
        if (transactionBatch == null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        this.header = TransactionBatchTransactionAdapter.getHeaderPanel(transactionBatch);
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.screen);
        object.addUIObject((UIObject)this.createFloatBar());
        return object;
    }

    private FloatBar createFloatBar() throws Exception {
        FloatBar fbShow = new FloatBar();
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        fbShow.addAction(ok);
        String page = (String)this.getProcess().getAttribute(BACK_PAGE);
        if (page != null) {
            String method = (String)this.getProcess().getAttribute(BACK_METHOD);
            if (method == null) {
                method = "show";
            }
            fbShow.addAction(new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(page)).setMethod(method));
        }
        fbShow.addAction(this.finish);
        return fbShow;
    }

    private void createTable() throws Exception {
        Company company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        String[] finTexts = new String[5];
        if (company.retrieveFinancialDimension1Usage() != 0) {
            finTexts[0] = this.env.getName1();
        }
        if (company.retrieveFinancialDimension2Usage() != 0) {
            finTexts[1] = this.env.getName2();
        }
        if (company.retrieveFinancialDimension3Usage() != 0) {
            finTexts[2] = this.env.getName3();
        }
        if (company.retrieveFinancialDimension4Usage() != 0) {
            finTexts[3] = this.env.getName4();
        }
        if (company.retrieveFinancialDimension5Usage() != 0) {
            finTexts[4] = this.env.getName5();
        }
        this.table = new FilterTable(FIELDNAMES, true, true, false, 100);
        this.table.setName("DepreciationProposalReport");
        int index = 0;
        while (index < finTexts.length) {
            if (finTexts[index] != null) {
                if (this.env.getOperationArea().length() == 0) {
                    this.finFrom[index] = new FISReferenceField(this.loginHelper, finTexts[index], index + 1, company);
                    this.finTo[index] = new FISReferenceField(this.loginHelper, finTexts[index], index + 1, company);
                } else {
                    this.finFrom[index] = new FMSReferenceField(this.loginHelper, finTexts[index], index + 1, company);
                    this.finTo[index] = new FMSReferenceField(this.loginHelper, finTexts[index], index + 1, company);
                }
                this.table.addRow(index, (Field)this.finFrom[index], (Field)this.finTo[index]);
            }
            ++index;
        }
        String companyOrDataSetId = company.getId();
        String dataSetId = company.getDataSetId();
        if (dataSetId != null) {
            companyOrDataSetId = dataSetId;
        }
        this.fromType = new AssetTypeReferenceField(this.dbData, companyOrDataSetId);
        this.toType = new AssetTypeReferenceField(this.dbData, companyOrDataSetId);
        this.table.addRow(5, (Field)this.fromType, (Field)this.toType);
        this.fromId = new AssetReferenceField(company, null, null, true, false);
        this.fromId.setLabel("Label.Asset");
        this.toId = new AssetReferenceField(company, null, null, true, false);
        this.table.addRow(6, (Field)this.fromId, (Field)this.toId);
        this.table.reload();
    }

    public DataObject submit(DataObject object) throws Exception {
        this.table.save();
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("User", this.loginHelper.getUser()));
        list.add(new NameValuePair("System", this.loginHelper.getSystem()));
        list.add(new NameValuePair("Password", Scrambler.scramble((String)this.loginHelper.getPassword())));
        list.add(new NameValuePair("facLib", this.dbData.getSchema()));
        list.add(new NameValuePair("Environment", this.env.getId()));
        list.add(new NameValuePair("Company", this.companyId));
        list.add(new NameValuePair("BookYear", this.bookYear));
        if (this.getProcess().getAttribute(BATCH) != null) {
            TransactionBatch transactionBatch = (TransactionBatch)this.getProcess().getAttribute(BATCH);
            list.add(new NameValuePair("batchId", "" + transactionBatch.getBatchId()));
        }
        list.add(new NameValuePair("FromAsset", this.fromId.getValue().trim()));
        list.add(new NameValuePair("ToAsset", this.toId.getValue().trim()));
        list.add(new NameValuePair("FromType", this.fromType.getValue().trim()));
        list.add(new NameValuePair("ToType", this.toType.getValue().trim()));
        if (this.finFrom[0] != null) {
            list.add(new NameValuePair("FromFinDimId1", this.finFrom[0].getFormattedId()));
            list.add(new NameValuePair("ToFinDimId1", this.finTo[0].getFormattedId()));
        }
        if (this.finFrom[1] != null) {
            list.add(new NameValuePair("FromFinDimId2", this.finFrom[1].getFormattedId()));
            list.add(new NameValuePair("ToFinDimId2", this.finTo[1].getFormattedId()));
        }
        if (this.finFrom[2] != null) {
            list.add(new NameValuePair("FromFinDimId3", this.finFrom[2].getFormattedId()));
            list.add(new NameValuePair("ToFinDimId3", this.finTo[2].getFormattedId()));
        }
        if (this.finFrom[3] != null) {
            list.add(new NameValuePair("FromFinDimId4", this.finFrom[3].getFormattedId()));
            list.add(new NameValuePair("ToFinDimId4", this.finTo[3].getFormattedId()));
        }
        if (this.finFrom[4] != null) {
            list.add(new NameValuePair("FromFinDimId5", this.finFrom[4].getFormattedId()));
            list.add(new NameValuePair("ToFinDimId5", this.finTo[4].getFormattedId()));
        }
        list.add(new NameValuePair("orderBy", this.table.getOrderBy()));
        list.add(new NameValuePair("levels", this.table.getLevels()));
        this.getProcess().setAttribute("selections", (Object)NameValuePair.getStringArray(list));
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("classNameCSV", (Object)CLASSNAMECSV);
        this.getProcess().setAttribute("classNamePDF", (Object)CLASSNAMEPDF);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "showInWindow", this.getProcess().getProcessId()));
        return object;
    }
}

