/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.VoucherDateHandlingEnum;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.CurrentBatchImageTransformer;
import nl.ibs.fac.adapters.DepreciationProposalImageTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.MassTransactionBatchImageTransformer;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.commands.DepreciationNewProposalCommand;
import nl.ibs.fac.commands.DepreciationProposalCreateCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.queries.CompanyQuery;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.util.Scrambler;

public class DepreciationProposalsCreateAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -6899661905996798014L;
    public static final String PAGE = DepreciationProposalsCreateAdapter.class.getName();
    private static final String SELECTALL = "selectAll";
    private static final String SUBMIT = "submit";
    private static final String TITLE = "Title.CreateDepreciationProposals";
    private static final String PREPROCESSOR = DepreciationNewProposalCommand.CLASSNAME;
    private static final String CLASSNAME = DepreciationProposalCreateCommand.CLASSNAME;
    private static final String JOBNAME = "Job.CreateDepreciationProposal";
    private FMSHelper fmsHelper;
    private FISHelper fisHelper;
    private CollectionTable table;
    private static final String[] NAMES = new String[]{"id", "description", "lastDepreciationRunYearPeriod", "currentBatchHasTransactions", "hasDepreciationProposal", "hasCurrentMassTransactionBatch"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.LastDepreciationRunPeriod.short", "Label.CurrentBatchHasTransactions", "Label.HasDepreciationProposal", "Label.HasCurrentMassTransactionBatch"};
    private static final short[] SIZES = new short[]{70, 350, 110, 20, 20, 20};
    private static final Transformer[] TRANSFORMERS;
    private static final String[] TOOLTIPS;
    private FloatBar theFloatBar;
    private FieldGroup theGroup;
    private BookYearPeriodGrid yearPeriodTo;
    private BookYearPeriodGrid finYearPeriod;
    private CheckBox ap1 = new CheckBox();
    private CheckBox ap2 = new CheckBox();
    private Action selectAll;
    private boolean selected = false;
    private FloatBar fbShow = new FloatBar();
    private DepreciationProposalBP businessProcess;
    private String companyIds;
    private Object[] companies;

    static {
        Transformer[] transformerArray = new Transformer[6];
        transformerArray[3] = new CurrentBatchImageTransformer();
        transformerArray[4] = new DepreciationProposalImageTransformer();
        transformerArray[5] = new MassTransactionBatchImageTransformer();
        TRANSFORMERS = transformerArray;
        TOOLTIPS = new String[]{"Label.CurrentBatchHasTransactions", "Label.HasDepreciationProposal", "Label.HasCurrentMassTransactionBatch"};
    }

    public DepreciationProposalsCreateAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        if (this.env.getOperationArea().length() > 0) {
            this.fmsHelper = new FMSHelper(this.loginHelper);
        } else {
            this.fisHelper = new FISHelper(this.loginHelper);
        }
        Action ok = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show2");
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShow.addAction(ok);
        this.selectAll = new Action("Button.SelectAll").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SELECTALL);
        this.fbShow.addAction(this.selectAll);
        this.fbShow.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        this.selected = false;
        this.selectAll.setLabel("Button.SelectAll");
        this.createTable();
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        this.table = new CollectionTable(Company.class, this.getCollection(), 12);
        this.table.setName(PAGE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.orderByColumn(NAMES[0]);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setMultipleSelectable();
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    private Collection<?> getCollection() throws Exception {
        Collection collection = new CompanyQuery(this.dbData).fetchData(null, "id", null, 0);
        Set names = this.fmsHelper != null ? this.fmsHelper.getAdministrations() : this.fisHelper.getAdministrations();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Company company = (Company)iterator.next();
            if (names.contains(company.getId())) continue;
            iterator.remove();
        }
        return collection;
    }

    public DataObject selectAll(DataObject object) throws Exception {
        this.selected = !this.selected;
        TableHelper.selectAllRows((AbstractTable)this.table, (DataObject)object, (boolean)this.selected);
        if (this.selected) {
            this.selectAll.setLabel("Button.DeselectAll");
        } else {
            this.selectAll.setLabel("Button.SelectAll");
        }
        return object;
    }

    public DataObject show2(DataObject object) throws Exception {
        boolean validSelection = this.getSelectedItems(object);
        if (!validSelection) {
            return object;
        }
        Company company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.businessProcess = new DepreciationProposalBP(company, this.numberOfPeriods, this.governmentActivated);
        this.theGroup = new FieldGroup();
        this.theGroup.forceBorder(false);
        this.theGroup.add((Table)this.createConfirmationTable());
        FieldGroup group = new FieldGroup("", 400, -1);
        group.forceBorder(true);
        this.yearPeriodTo = new BookYearPeriodGrid("Label.PeriodTo", this.bookYear, this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        group.add((ESPGridLayout)this.yearPeriodTo);
        this.finYearPeriod = new BookYearPeriodGrid("Label.BookPeriod", false);
        group.add((ESPGridLayout)this.finYearPeriod);
        String[] yps = this.businessProcess.retrieveYearsAndPeriods();
        this.yearPeriodTo.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        int ap2Usage = company.getAccountingPrinciple2Usage();
        if (ap2Usage < 0) {
            Company dataSet = (Company)CompanyBO.get(this.dbData, company.getDataSetId())[0];
            ap2Usage = dataSet.getAccountingPrinciple2Usage();
        }
        if (ap2Usage == 0) {
            this.ap1.setValue(true);
            this.ap2.setValue(false);
        } else {
            this.ap1.setValue(true);
            this.ap2.setValue(true);
            ESPGridLayout grid = new ESPGridLayout();
            grid.setPaddingBottom(0);
            grid.setPaddingTop(0);
            short[] sArray = new short[2];
            sArray[0] = 198;
            grid.setColumnWidths(sArray);
            Label label = new Label(this.env.getAPName1());
            label.setHelpId("ap1");
            grid.add((UIObject)label, 0, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
            grid.add((UIObject)this.ap1, 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
            label = new Label(this.env.getAPName2());
            label.setHelpId("ap2");
            grid.add((UIObject)label, 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
            grid.add((UIObject)this.ap2, 1, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
            group.add(grid);
        }
        this.theGroup.add(group);
        Action ok = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        Action previous = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show");
        this.theFloatBar = new FloatBar();
        this.theFloatBar.addAction(ok);
        this.theFloatBar.addAction(previous);
        this.theFloatBar.addAction(this.finish);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.theGroup);
        object.addUIObject((UIObject)this.theFloatBar);
        return object;
    }

    public DataObject show3(DataObject object) throws Exception {
        this.yearPeriodTo.setReadonly(false);
        this.finYearPeriod.setReadonly(false);
        this.ap1.setReadonly(false);
        this.ap2.setReadonly(false);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.theGroup);
        object.addUIObject((UIObject)this.theFloatBar);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        this.yearPeriodTo.removeInvalidTags();
        this.finYearPeriod.removeInvalidTags();
        this.ap1.removeInvalidTags();
        this.ap2.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        if (!this.ap1.getValueAsBoolean() && !this.ap2.getValueAsBoolean()) {
            object.addUIObject((UIObject)new Message("no_accounting_principle_selected", "error"));
            return object;
        }
        messages = this.businessProcess.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax));
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.setInvalidTag();
        }
        if (error) {
            return object;
        }
        String[][] selections = new String[][]{{"facLib", this.dbData.getSchema()}, {"System", this.loginHelper.getSystem()}, {"User", this.loginHelper.getUser()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"operationArea", this.env.getOperationArea().trim()}, {"dataLib", this.env.getDataLib().trim()}, {"programLib", this.env.getProgramLib().trim()}, {"object_lib", StartStopServlet.getObjectLibrary()}, {"Environment", this.env.getId()}, {"Company", this.companyIds}, {"BookYearTo", this.yearPeriodTo.getBookYear().getValue()}, {"PeriodTo", this.yearPeriodTo.getPeriod().getValue()}, {"finYear", "" + this.finYearPeriod.getBookYear().getIntValue()}, {"finPeriod", "" + this.finYearPeriod.getPeriod().getIntValue()}, {"AP1", "" + this.ap1.getValueAsBoolean()}, {"AP2", "" + this.ap2.getValueAsBoolean()}, {"Post", "" + Boolean.FALSE}, {"orderBy", "assetId"}, {"levels", "0000000"}, {"BookYear", this.bookYear}, {"Print", "" + Boolean.FALSE}, {"FileType", ""}, {"governmentActivated", "" + this.governmentActivated}};
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("preprocessor", (Object)PREPROCESSOR);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("backMethod", (Object)"show3");
        this.getProcess().setAttribute("header", (Object)this.theGroup);
        this.yearPeriodTo.setReadonly(true);
        this.finYearPeriod.setReadonly(true);
        this.ap1.setReadonly(true);
        this.ap2.setReadonly(true);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    private boolean getSelectedItems(DataObject object) throws Exception {
        Company company;
        boolean validSelection = true;
        this.companies = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.companies.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            validSelection = false;
        }
        int i = 0;
        while (i < this.companies.length) {
            company = (Company)this.companies[i];
            if (company.getHasDepreciationProposal()) {
                object.addUIObject((UIObject)new Message(String.valueOf(this.translate("Label.CompanyId")) + " " + company.getId() + ": " + this.translate("Label.HasDepreciationProposal"), "error"));
                validSelection = false;
            }
            if (company.getHasCurrentMassTransactionBatch()) {
                object.addUIObject((UIObject)new Message(String.valueOf(this.translate("Label.CompanyId")) + " " + company.getId() + ": " + this.translate("Label.HasCurrentMassTransactionBatch"), "error"));
                validSelection = false;
            }
            if (company.getNumberOfPeriods() != this.numberOfPeriods) {
                object.addUIObject((UIObject)new Message(String.valueOf(this.translate("Label.CompanyId")) + " " + company.getId() + ": " + this.translate("Label.DepreciationYearNumberOfPeriods"), "error"));
                validSelection = false;
            }
            if (company.getProcessParameters().getStandardVoucherDate() == 5) {
                object.addUIObject((UIObject)new Message(String.valueOf(this.translate("Label.CompanyId")) + " " + company.getId() + ": " + this.translate("Label.VoucherDate") + " " + VoucherDateHandlingEnum.getValue(5), "error"));
                validSelection = false;
            }
            ++i;
        }
        this.companyIds = null;
        i = 0;
        while (i < this.companies.length) {
            company = (Company)this.companies[i];
            this.companyIds = this.companyIds == null ? company.getId() : String.valueOf(this.companyIds) + "," + company.getId();
            ++i;
        }
        return validSelection;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        CollectionTable table = new CollectionTable(Company.class, new ArrayList<Object>(Arrays.asList(this.companies)), 12);
        table.setName(String.valueOf(PAGE) + "_CT");
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        int i = 0;
        while (i < errors.length) {
            if (errors[i] != null && errors[i].trim().length() > 0) {
                object.addUIObject((UIObject)new Message(errors[i], "error"));
            }
            ++i;
        }
    }
}

