/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.VoucherDateHandlingEnum;
import nl.ibs.fac.adapters.CurrentBatchImageTransformer;
import nl.ibs.fac.adapters.DepreciationProposalEmptyImageTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.adapters.TransactionBatchTransactionAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.commands.DepreciationProposalDeleteCommand;
import nl.ibs.fac.commands.DepreciationProposalPostCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.queries.CompanyQuery;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.util.Scrambler;

public class DepreciationProposalsPostAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 2339683653360786171L;
    public static final String PAGE = DepreciationProposalsPostAdapter.class.getName();
    private static final String SELECTALL = "selectAll";
    private static final String SUBMIT = "submit";
    private static final String TITLE = "Title.PostDepreciationProposals";
    private static final String CLASSNAME = DepreciationProposalPostCommand.CLASSNAME;
    private static final String JOBNAME = "Job.PostDepreciationProposal";
    private FMSHelper fmsHelper;
    private FISHelper fisHelper;
    private CollectionTable table;
    private static final String[] NAMES = new String[]{"id", "description", "lastDepreciationRunYearPeriod", "depreciationProposalEndYearPeriod", "currentBatchHasTransactions", "depreciationProposalIsEmpty"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.LastDepreciationRunPeriod.short", "Label.ProposalEndPeriod", "Label.CurrentBatchHasTransactions", "Label.DepreciationProposalEmpty"};
    private static final short[] SIZES = new short[]{70, 350, 110, 110, 20, 20};
    private static final Transformer[] TRANSFORMERS;
    private static final String[] TOOLTIPS;
    private FloatBar fbShow = new FloatBar();
    private Action selectAll;
    private boolean selected = false;
    private String companyIds;
    private Object[] companies;
    private Action[] rowActions;
    private Action[] headerActions;
    private Company companyForDeletion;

    static {
        Transformer[] transformerArray = new Transformer[6];
        transformerArray[4] = new CurrentBatchImageTransformer();
        transformerArray[5] = new DepreciationProposalEmptyImageTransformer();
        TRANSFORMERS = transformerArray;
        TOOLTIPS = new String[]{"Label.CurrentBatchHasTransactions", "Label.DepreciationProposalEmpty"};
    }

    public DepreciationProposalsPostAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        if (this.env.getOperationArea().length() > 0) {
            this.fmsHelper = new FMSHelper(this.loginHelper);
        } else {
            this.fisHelper = new FISHelper(this.loginHelper);
        }
        Action ok = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShow.addAction(ok);
        this.selectAll = new Action("Button.SelectAll").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SELECTALL);
        this.fbShow.addAction(this.selectAll);
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show");
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(this.finish);
        this.headerActions = new Action[]{refresh};
        Action showTransactions = new Action("Button.Transactions").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showTransactions");
        Action deleteProposal = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("deleteProposal");
        this.rowActions = new Action[]{showTransactions, deleteProposal};
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        this.selected = false;
        this.selectAll.setLabel("Button.SelectAll");
        this.createTable();
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        this.table = new CollectionTable(Company.class, this.getCollection(), 12);
        this.table.setName(PAGE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.orderByColumn(NAMES[0]);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    private Collection<?> getCollection() throws Exception {
        Collection collection = new CompanyQuery(this.dbData).fetchData(null, "id", null, 0);
        Set names = this.fmsHelper != null ? this.fmsHelper.getAdministrations() : this.fisHelper.getAdministrations();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Company company = (Company)iterator.next();
            if (!names.contains(company.getId())) {
                iterator.remove();
            }
            if (company.getHasDepreciationProposal()) continue;
            iterator.remove();
        }
        return collection;
    }

    public DataObject selectAll(DataObject object) throws Exception {
        this.selected = !this.selected;
        TableHelper.selectAllRows((AbstractTable)this.table, (DataObject)object, (boolean)this.selected);
        if (this.selected) {
            this.selectAll.setLabel("Button.DeselectAll");
        } else {
            this.selectAll.setLabel("Button.SelectAll");
        }
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        boolean validSelection = this.getSelectedItems(object);
        if (!validSelection) {
            return object;
        }
        FieldGroup theGroup = new FieldGroup();
        theGroup.forceBorder(false);
        theGroup.add((Table)this.createConfirmationTable());
        String[][] selections = new String[][]{{"facLib", this.dbData.getSchema()}, {"System", this.loginHelper.getSystem()}, {"User", this.loginHelper.getUser()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"operationArea", this.env.getOperationArea().trim()}, {"dataLib", this.env.getDataLib().trim()}, {"programLib", this.env.getProgramLib().trim()}, {"object_lib", StartStopServlet.getObjectLibrary()}, {"Environment", this.env.getId()}, {"Company", this.companyIds}, {"governmentActivated", "" + this.governmentActivated}};
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("backMethod", (Object)"show");
        this.getProcess().setAttribute("header", (Object)theGroup);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    private boolean getSelectedItems(DataObject object) throws Exception {
        Company company;
        boolean validSelection = true;
        this.companies = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.companies.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            validSelection = false;
        }
        int i = 0;
        while (i < this.companies.length) {
            company = (Company)this.companies[i];
            BookYearBO.synchronizeWithFinancials(this.loginHelper, this.env, company);
            if (company.getDepreciationProposalIsEmpty()) {
                object.addUIObject((UIObject)new Message(String.valueOf(this.translate("Label.CompanyId")) + " " + company.getId() + ": " + this.translate("Label.DepreciationProposalEmpty"), "error"));
                validSelection = false;
            }
            if (company.getProcessParameters().getStandardVoucherDate() == 5) {
                object.addUIObject((UIObject)new Message(String.valueOf(this.translate("Label.CompanyId")) + " " + company.getId() + ": " + this.translate("Label.VoucherDate") + " " + VoucherDateHandlingEnum.getValue(5), "error"));
                validSelection = false;
            }
            TransactionBatch transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(this.dbData, company.getId());
            int ap = 1;
            while (ap <= 2) {
                int err = ap == 1 ? TransactionBatchBO.numberOfSevereErrors(company.getId(), ap, transactionBatch, false) : TransactionBatchBO.numberOfSevereErrors(company.getId(), ap, transactionBatch, this.governmentActivated);
                if (err > 0) {
                    String apDescription = ap == 1 ? this.env.getAPName1() : (this.governmentActivated ? this.env.getAPName3() : this.env.getAPName2());
                    object.addUIObject((UIObject)new Message(String.valueOf(this.translate("Label.CompanyId")) + " " + company.getId() + ": " + this.translate("Label.DepreciationProposal") + " " + apDescription + " " + this.translate("Label.IsInError"), "error"));
                    validSelection = false;
                }
                ++ap;
            }
            ++i;
        }
        this.companyIds = null;
        i = 0;
        while (i < this.companies.length) {
            company = (Company)this.companies[i];
            this.companyIds = this.companyIds == null ? company.getId() : String.valueOf(this.companyIds) + "," + company.getId();
            ++i;
        }
        return validSelection;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        CollectionTable table = new CollectionTable(Company.class, new ArrayList<Object>(Arrays.asList(this.companies)), 12);
        table.setName(String.valueOf(PAGE) + "_CT");
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    public DataObject showTransactions(DataObject object) throws Exception {
        TransactionBatch theTransactionBatch;
        Company theCompany = (Company)TableHelper.getSelectedItem((DataObject)object);
        if (theCompany != null && (theTransactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(this.dbData, theCompany.getId())) != null) {
            this.getProcess().setAttribute("TransactionBatch", (Object)theTransactionBatch);
            object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(TransactionBatchTransactionAdapter.PAGE), "show", this.getProcess().getProcessId()));
        }
        return object;
    }

    public DataObject deleteProposal(DataObject object) throws Exception {
        TransactionBatch theTransactionBatch;
        this.companyForDeletion = null;
        Company theCompany = (Company)TableHelper.getSelectedItem((DataObject)object);
        if (theCompany != null && (theTransactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(this.dbData, theCompany.getId())) != null) {
            this.companyForDeletion = theCompany;
            Window window = new Window();
            window.setLabel("Title.DeleteDepreciationProposal");
            HeaderPanel thePanel = new HeaderPanel();
            thePanel.setWidth(550);
            ReferenceField crf = new ReferenceField("Label.Company");
            crf.setReadonly(true);
            crf.setDescriptionLength("40");
            crf.setValue(theCompany.getId());
            crf.setDescription(theCompany.getDescription());
            thePanel.addUIObject((UIObject)crf);
            window.add(TransactionBatchTransactionAdapter.getHeaderPanel(theTransactionBatch, (Panel)thePanel));
            window.add(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete"));
            object.addUIObject((UIObject)window);
        }
        return object;
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        String CLASSNAME = DepreciationProposalDeleteCommand.CLASSNAME;
        String JOBNAME = "Job.DeleteDepreciationProposal";
        Company theCompany = this.companyForDeletion;
        if (theCompany != null) {
            String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getId()}, {"Company", theCompany.getId()}};
            this.getProcess().setAttribute("selections", (Object)selections);
            this.getProcess().setAttribute("className", (Object)CLASSNAME);
            this.getProcess().setAttribute("jobName", (Object)JOBNAME);
            this.getProcess().setAttribute("returnPage", (Object)PAGE);
            SubmitAdapter submitAdapter = (SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE);
            submitAdapter.fileType.setHidden(true);
            object = ((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).submit(object);
            this.companyForDeletion = null;
        }
        return object;
    }
}

