/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FilterTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.InputComponent;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.DepreciationProposalEmptyImageTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.queries.CompanyQuery;
import nl.ibs.fac.reports.DepreciationProposalToCSV;
import nl.ibs.fac.reports.DepreciationProposalToPDF;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Scrambler;

public class DepreciationProposalsReportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 5502438705156232217L;
    public static final String BACK_PAGE = "dpBackPage";
    public static final String BACK_METHOD = "dpBackMethod";
    public static final String PAGE = DepreciationProposalsReportAdapter.class.getName();
    private static final String SELECTALL = "selectAll";
    private static final String SUBMIT = "submit";
    private static final String TITLE = "Title.DepreciationProposalsReport";
    private static final String CLASSNAMECSV = DepreciationProposalToCSV.CLASSNAME;
    private static final String CLASSNAMEPDF = DepreciationProposalToPDF.CLASSNAME;
    private static final String JOBNAME = "Job.DepreciationProposalReport";
    private static final String[] FIELDNAMES = new String[]{"finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "proFormaTypeId", "assetId"};
    private FinancialReferenceField[] finFrom = new FinancialReferenceField[5];
    private FinancialReferenceField[] finTo = new FinancialReferenceField[5];
    private ODBQueryReferenceField fromType;
    private ODBQueryReferenceField toType;
    private ODBQueryReferenceField fromId;
    private ODBQueryReferenceField toId;
    private FieldGroup screen;
    private FilterTable filterTable;
    private FieldGroup theGroup;
    private FloatBar theFloatBar;
    private FMSHelper fmsHelper;
    private FISHelper fisHelper;
    private CollectionTable table;
    private static final String[] NAMES = new String[]{"id", "description", "lastDepreciationRunYearPeriod", "depreciationProposalEndYearPeriod", "depreciationProposalIsEmpty"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.LastDepreciationRunPeriod.short", "Label.ProposalEndPeriod", "Label.DepreciationProposalEmpty"};
    private static final short[] SIZES = new short[]{70, 350, 110, 110, 20};
    private static final Transformer[] TRANSFORMERS;
    private static final String[] TOOLTIPS;
    private FloatBar fbShow = new FloatBar();
    private Action selectAll;
    private boolean selected = false;
    private String companyIds;
    private Object[] companies;

    static {
        Transformer[] transformerArray = new Transformer[5];
        transformerArray[4] = new DepreciationProposalEmptyImageTransformer();
        TRANSFORMERS = transformerArray;
        TOOLTIPS = new String[]{"Label.DepreciationProposalEmpty"};
    }

    public DepreciationProposalsReportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        if (this.env.getOperationArea().length() > 0) {
            this.fmsHelper = new FMSHelper(this.loginHelper);
        } else {
            this.fisHelper = new FISHelper(this.loginHelper);
        }
        Action ok = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show2");
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShow.addAction(ok);
        this.selectAll = new Action("Button.SelectAll").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SELECTALL);
        this.fbShow.addAction(this.selectAll);
        this.fbShow.addAction(this.finish);
        this.screen = new FieldGroup(LanguageHelper.getString("nl.ibs.fac.language", "SelectSort"));
        this.createFilterTable();
        this.screen.add((Table)this.filterTable);
        this.screen.add((InputComponent)this.filterTable.getClearAction());
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        this.selected = false;
        this.selectAll.setLabel("Button.SelectAll");
        this.createTable();
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        this.table = new CollectionTable(Company.class, this.getCollection(), 12);
        this.table.setName(PAGE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.orderByColumn(NAMES[0]);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setMultipleSelectable();
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    private Collection<?> getCollection() throws Exception {
        Collection collection = new CompanyQuery(this.dbData).fetchData(null, "id", null, 0);
        Set names = this.fmsHelper != null ? this.fmsHelper.getAdministrations() : this.fisHelper.getAdministrations();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Company company = (Company)iterator.next();
            if (!names.contains(company.getId())) {
                iterator.remove();
            }
            if (company.getHasDepreciationProposal()) continue;
            iterator.remove();
        }
        return collection;
    }

    public DataObject selectAll(DataObject object) throws Exception {
        this.selected = !this.selected;
        TableHelper.selectAllRows((AbstractTable)this.table, (DataObject)object, (boolean)this.selected);
        if (this.selected) {
            this.selectAll.setLabel("Button.DeselectAll");
        } else {
            this.selectAll.setLabel("Button.SelectAll");
        }
        return object;
    }

    public DataObject show2(DataObject object) throws Exception {
        boolean validSelection = this.getSelectedItems(object);
        if (!validSelection) {
            return object;
        }
        this.theGroup = new FieldGroup();
        this.theGroup.forceBorder(false);
        this.theGroup.add((Table)this.createConfirmationTable());
        this.theGroup.add(this.screen);
        Action ok = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        Action previous = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show");
        this.theFloatBar = new FloatBar();
        this.theFloatBar.addAction(ok);
        this.theFloatBar.addAction(previous);
        this.theFloatBar.addAction(this.finish);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.theGroup);
        object.addUIObject((UIObject)this.theFloatBar);
        return object;
    }

    public DataObject show3(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.theGroup);
        object.addUIObject((UIObject)this.theFloatBar);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        CollectionTable table = new CollectionTable(Company.class, new ArrayList<Object>(Arrays.asList(this.companies)), 12);
        table.setName(String.valueOf(PAGE) + "_CT");
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    private boolean getSelectedItems(DataObject object) throws Exception {
        boolean validSelection = true;
        this.companies = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.companies.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            validSelection = false;
        }
        this.companyIds = null;
        int i = 0;
        while (i < this.companies.length) {
            Company company = (Company)this.companies[i];
            this.companyIds = this.companyIds == null ? company.getId() : String.valueOf(this.companyIds) + "," + company.getId();
            ++i;
        }
        return validSelection;
    }

    private void createFilterTable() throws Exception {
        Company company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        String[] finTexts = new String[5];
        if (company.retrieveFinancialDimension1Usage() != 0) {
            finTexts[0] = this.env.getName1();
        }
        if (company.retrieveFinancialDimension2Usage() != 0) {
            finTexts[1] = this.env.getName2();
        }
        if (company.retrieveFinancialDimension3Usage() != 0) {
            finTexts[2] = this.env.getName3();
        }
        if (company.retrieveFinancialDimension4Usage() != 0) {
            finTexts[3] = this.env.getName4();
        }
        if (company.retrieveFinancialDimension5Usage() != 0) {
            finTexts[4] = this.env.getName5();
        }
        this.filterTable = new FilterTable(FIELDNAMES, true, true, false, 100);
        this.filterTable.setName("DepreciationProposalReport");
        int index = 0;
        while (index < finTexts.length) {
            if (finTexts[index] != null) {
                if (this.env.getOperationArea().length() == 0) {
                    this.finFrom[index] = new FISReferenceField(this.loginHelper, finTexts[index], index + 1, company);
                    this.finTo[index] = new FISReferenceField(this.loginHelper, finTexts[index], index + 1, company);
                } else {
                    this.finFrom[index] = new FMSReferenceField(this.loginHelper, finTexts[index], index + 1, company);
                    this.finTo[index] = new FMSReferenceField(this.loginHelper, finTexts[index], index + 1, company);
                }
                this.filterTable.addRow(index, (Field)this.finFrom[index], (Field)this.finTo[index]);
            }
            ++index;
        }
        String companyOrDataSetId = company.getId();
        String dataSetId = company.getDataSetId();
        if (dataSetId != null) {
            companyOrDataSetId = dataSetId;
        }
        this.fromType = new AssetTypeReferenceField(this.dbData, companyOrDataSetId);
        this.toType = new AssetTypeReferenceField(this.dbData, companyOrDataSetId);
        this.filterTable.addRow(5, (Field)this.fromType, (Field)this.toType);
        this.fromId = new AssetReferenceField(company, null, null, true, false);
        this.fromId.setLabel("Label.Asset");
        this.toId = new AssetReferenceField(company, null, null, true, false);
        this.filterTable.addRow(6, (Field)this.fromId, (Field)this.toId);
        this.filterTable.reload();
    }

    public DataObject submit(DataObject object) throws Exception {
        this.filterTable.save();
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("User", this.loginHelper.getUser()));
        list.add(new NameValuePair("System", this.loginHelper.getSystem()));
        list.add(new NameValuePair("Password", Scrambler.scramble((String)this.loginHelper.getPassword())));
        list.add(new NameValuePair("facLib", this.dbData.getSchema()));
        list.add(new NameValuePair("Environment", this.env.getId()));
        list.add(new NameValuePair("Company", this.companyIds));
        list.add(new NameValuePair("BookYear", this.bookYear));
        list.add(new NameValuePair("FromAsset", this.fromId.getValue().trim()));
        list.add(new NameValuePair("ToAsset", this.toId.getValue().trim()));
        list.add(new NameValuePair("FromType", this.fromType.getValue().trim()));
        list.add(new NameValuePair("ToType", this.toType.getValue().trim()));
        if (this.finFrom[0] != null) {
            list.add(new NameValuePair("FromFinDimId1", this.finFrom[0].getFormattedId()));
            list.add(new NameValuePair("ToFinDimId1", this.finTo[0].getFormattedId()));
        }
        if (this.finFrom[1] != null) {
            list.add(new NameValuePair("FromFinDimId2", this.finFrom[1].getFormattedId()));
            list.add(new NameValuePair("ToFinDimId2", this.finTo[1].getFormattedId()));
        }
        if (this.finFrom[2] != null) {
            list.add(new NameValuePair("FromFinDimId3", this.finFrom[2].getFormattedId()));
            list.add(new NameValuePair("ToFinDimId3", this.finTo[2].getFormattedId()));
        }
        if (this.finFrom[3] != null) {
            list.add(new NameValuePair("FromFinDimId4", this.finFrom[3].getFormattedId()));
            list.add(new NameValuePair("ToFinDimId4", this.finTo[3].getFormattedId()));
        }
        if (this.finFrom[4] != null) {
            list.add(new NameValuePair("FromFinDimId5", this.finFrom[4].getFormattedId()));
            list.add(new NameValuePair("ToFinDimId5", this.finTo[4].getFormattedId()));
        }
        list.add(new NameValuePair("orderBy", this.filterTable.getOrderBy()));
        list.add(new NameValuePair("levels", this.filterTable.getLevels()));
        this.getProcess().setAttribute("selections", (Object)NameValuePair.getStringArray(list));
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("classNameCSV", (Object)CLASSNAMECSV);
        this.getProcess().setAttribute("classNamePDF", (Object)CLASSNAMEPDF);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("backMethod", (Object)"show3");
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "showInWindow", this.getProcess().getProcessId()));
        return object;
    }
}

