/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;

public class DisinvestmentReasonMainAccountAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -7639301830848246217L;
    public static final String PAGE = DisinvestmentReasonMainAccountAdapter.class.getName();
    public static final String RETURNPAGE = "DisinvestmentReasonMainAccountAdapterReturnPage";
    public static final String RETURNMETHOD = "DisinvestmentReasonMainAccountAdapterReturnMethod";
    private FieldGroup fgLoss = new FieldGroup("Label.LossAccounts");
    private FieldGroup fgProfit = new FieldGroup("Label.ProfitAccounts");
    private FloatBar fb = new FloatBar();
    private Window window;
    private FinancialReferenceField[] lossAccounts = new FinancialReferenceField[6];
    private FinancialReferenceField[] profitAccounts = new FinancialReferenceField[6];
    private String[] descriptions = new String[6];
    private Company company;
    private CompanyAccountingPrincipleDefault apDefault;

    public DisinvestmentReasonMainAccountAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize();
    }

    private void initialize() throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.descriptions[0] = this.env.getDIRCName0();
        this.descriptions[1] = this.env.getDIRCName1();
        this.descriptions[2] = this.env.getDIRCName2();
        this.descriptions[3] = this.env.getDIRCName3();
        this.descriptions[4] = this.env.getDIRCName4();
        this.descriptions[5] = this.env.getDIRCName5();
        int i = 0;
        while (i < 6) {
            if (!"".equals(this.descriptions[i].trim())) {
                this.lossAccounts[i] = this.retrieveFRF(this.descriptions[i]);
                this.fgLoss.add((Field)this.lossAccounts[i]);
                this.profitAccounts[i] = this.retrieveFRF(this.descriptions[i]);
                this.fgProfit.add((Field)this.profitAccounts[i]);
            }
            ++i;
        }
        this.lossAccounts[0].setReadonly(true);
        this.profitAccounts[0].setReadonly(true);
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("edit");
        ok.setDefault(true);
        ok.setValidationEnabled(true);
        this.fb.addAction(ok);
        this.fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
    }

    private FinancialReferenceField retrieveFRF(String description) throws Exception {
        if (this.env.getOperationArea().length() == 0) {
            return new FISReferenceField(this.loginHelper, description, 0, this.companyId, "" + this.company.getCurrentBookYear(), true);
        }
        return new FMSReferenceField(this.loginHelper, description, 0, true);
    }

    public DataObject show(DataObject object) throws Exception {
        String sAP = (String)this.getProcess().getAttribute("disinvestmentReasonMainAccountAP");
        this.apDefault = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.dbData, this.companyId, Integer.parseInt(sAP))[0];
        this.setValues();
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Label.DisinvestmentReasonCodes");
        this.window.add(this.fgLoss);
        this.window.add(this.fgProfit);
        this.window.add(this.fb);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        return object;
    }

    private void setValues() throws Exception {
        String[] lossValues = new String[]{this.apDefault.getMainAccountId5(), this.apDefault.getMainAccountDIRC150(), this.apDefault.getMainAccountDIRC250(), this.apDefault.getMainAccountDIRC350(), this.apDefault.getMainAccountDIRC450(), this.apDefault.getMainAccountDIRC550()};
        String[] profitValues = new String[]{this.apDefault.getMainAccountId5(), this.apDefault.getMainAccountDIRC160(), this.apDefault.getMainAccountDIRC260(), this.apDefault.getMainAccountDIRC360(), this.apDefault.getMainAccountDIRC460(), this.apDefault.getMainAccountDIRC560()};
        int i = 0;
        while (i < 6) {
            if (!"".equals(this.descriptions[i].trim())) {
                this.lossAccounts[i].setValue(lossValues[i]);
                this.profitAccounts[i].setValue(profitValues[i]);
            }
            ++i;
        }
    }

    public DataObject edit(DataObject object) throws Exception {
        if (!"".equals(this.descriptions[1].trim())) {
            this.apDefault.setMainAccountDIRC150(this.lossAccounts[1].getFormattedId());
            this.apDefault.setMainAccountDIRC160(this.profitAccounts[1].getFormattedId());
        }
        if (!"".equals(this.descriptions[2].trim())) {
            this.apDefault.setMainAccountDIRC250(this.lossAccounts[2].getFormattedId());
            this.apDefault.setMainAccountDIRC260(this.profitAccounts[2].getFormattedId());
        }
        if (!"".equals(this.descriptions[3].trim())) {
            this.apDefault.setMainAccountDIRC350(this.lossAccounts[3].getFormattedId());
            this.apDefault.setMainAccountDIRC360(this.profitAccounts[3].getFormattedId());
        }
        if (!"".equals(this.descriptions[4].trim())) {
            this.apDefault.setMainAccountDIRC450(this.lossAccounts[4].getFormattedId());
            this.apDefault.setMainAccountDIRC460(this.profitAccounts[4].getFormattedId());
        }
        if (!"".equals(this.descriptions[5].trim())) {
            this.apDefault.setMainAccountDIRC550(this.lossAccounts[5].getFormattedId());
            this.apDefault.setMainAccountDIRC560(this.profitAccounts[5].getFormattedId());
        }
        object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(RETURNPAGE).toString(), this.getProcess().getAttribute(RETURNMETHOD).toString(), this.getProcess().getProcessId()));
        return this.close(object);
    }
}

