/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.queries.EnvironmentQuery;

public class EnvironmentReferenceField
extends ODBQueryReferenceField {
    private static final long serialVersionUID = 3786079557013739907L;
    private static final String[] NAMES = new String[]{"facLib", "description", "operationArea", "dataLib", "programLib"};
    private static final String[] LABELS = new String[]{"Label.Environment", "Label.Description", "Label.OperationArea.short", "Label.DataLib.short", "Label.ProgramLib.short"};
    private static final short[] SIZES = new short[]{90, 290, 70, 90, 90};
    private Environment environment;

    public EnvironmentReferenceField() throws Exception {
        super(LABELS[0], "upper", (ODBQuery)new EnvironmentQuery(), Environment.class);
        this.setName(((Object)((Object)this)).getClass().getName());
        this.setTableFields(NAMES);
        this.setTableHeaderLabels(LABELS);
        this.setValueField(NAMES[0]);
        this.setDescriptionField(NAMES[1]);
        this.setTableKeys(new String[]{NAMES[0]});
        this.setTableHeaderSizes(SIZES);
        this.setLength(10);
        this.setMaxLength(10);
        this.setDescriptionLength(40);
    }

    public void setValue(Environment environment) throws Exception {
        if (environment == null) {
            this.setDescription("");
            this.setValue();
            return;
        }
        this.setDescription(environment.getDescription());
        if (environment.getOperationArea().length() > 0) {
            this.setValue(environment.getOperationArea());
        } else {
            this.setValue(environment.getDataLib());
        }
    }

    protected boolean selectedValueExecuteHook(DataObject object) {
        try {
            this.environment = (Environment)this.getSelectedObject();
            this.setValue(this.environment);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void validate() throws Exception {
        super.validate();
        this.environment = this.getEnvironment();
        if (this.environment == null) {
            this.setInvalidTag();
            throw new UserErrorMessage("key_not_found");
        }
        this.setDescription(this.environment.getDescription());
    }

    public Environment getEnvironment() throws Exception {
        if (this.getValue().trim().length() == 0) {
            return null;
        }
        Environment environment = EnvironmentBO.getEnvironment(this.getValue().trim(), null);
        if (environment == null) {
            environment = EnvironmentBO.getEnvironment(null, this.getValue().trim());
        }
        return environment;
    }
}

