/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.Collection;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.TransactionAdapter;
import nl.ibs.fac.adapters.TransactionTypeTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;

public class ExtendedTransactionAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 3222365021538547885L;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    public static final String PAGE = ExtendedTransactionAdapter.class.getName();
    private Company company;
    private Transaction transaction;
    private Asset asset;
    private AssetPanels panels;
    private AssetType assetType;
    private boolean ap2Present = false;
    private Window window;
    private TabbedPanel tabbedPanel;
    private Tab[] tabs;
    private String[] tabTexts = new String[2];
    private CollectionTable table;
    private static final String[] NAMES = new String[]{"FACYearAndPeriod", "transactionType", "valueForAmount1", "valueForAmount2", "valueForAmount3", "description", "documentAndSequenceNumber"};
    private static final String[] LABELS = new String[]{"Label.Period", "Label.TransactionType", "Label.Acquisition", "Label.Depreciation", "Label.Interest", "Label.Description", "Label.TransNbrShort"};
    private static final short[] SIZES = new short[]{80, 150, 120, 120, 120, 200, 100};
    private static final String[] TYPES;
    private static final ZeroBigDecimalToBlankTransformer ZTB_DECIMALTRANSFORMER;
    private static final Transformer[] TRANSFORMERS;
    private static final boolean[] COLUMNNOWRAPS;
    private static final boolean[] SORTABLE;
    private Action[] rowActions = new Action[]{new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(TransactionAdapter.PAGE)).setMethod("show")};

    static {
        String[] stringArray = new String[6];
        stringArray[1] = "text";
        TYPES = stringArray;
        ZTB_DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
        Transformer[] transformerArray = new Transformer[7];
        transformerArray[1] = new TransactionTypeTransformer();
        transformerArray[2] = ZTB_DECIMALTRANSFORMER;
        transformerArray[3] = ZTB_DECIMALTRANSFORMER;
        transformerArray[4] = ZTB_DECIMALTRANSFORMER;
        TRANSFORMERS = transformerArray;
        COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true};
        boolean[] blArray = new boolean[7];
        blArray[1] = true;
        blArray[5] = true;
        SORTABLE = blArray;
    }

    public ExtendedTransactionAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.tabTexts[0] = this.env.getAPShortName1();
        this.tabTexts[1] = this.env.getAPShortName2();
        if (this.governmentActivated) {
            this.tabTexts[0] = "Details";
        }
    }

    public DataObject show(DataObject object) throws Exception {
        this.window = new Window();
        this.window.setTop("20%");
        this.window.setLeft("20%");
        this.transaction = (Transaction)TableHelper.getSelectedItem((DataObject)object);
        int mtt = this.transaction.getMainTransactionType();
        switch (mtt) {
            case 1: {
                this.asset = this.transaction.getAsset();
                this.assetType = this.asset.getAssetType();
                boolean bl = this.ap2Present = this.asset.getValuationsCollection(null).size() > 1;
                if (this.transaction.getAssetOriginatedByFinancialTransaction() || this.transaction.getAssetOriginatedByCredit()) {
                    this.showNewAsset();
                } else {
                    this.showAdditionalInvestment();
                }
                object.addUIObject((UIObject)this.window);
                break;
            }
            case 2: {
                this.asset = this.transaction.getAsset();
                this.assetType = this.asset.getAssetType();
                this.ap2Present = this.asset.getValuationsCollection(null).size() > 1;
                this.showDisinvestment();
                object.addUIObject((UIObject)this.window);
                break;
            }
            case 4: {
                object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(TransactionAdapter.PAGE), "show", this.getProcess().getProcessId()));
            }
        }
        return object;
    }

    private void showNewAsset() throws Exception {
        this.window.setLabel("Title.NewAsset");
        FieldGroup fg = this.getHeaderFieldGroup();
        Field field = new Field("Label.Transaction", "text", null, this.transaction.getDocumentAndSequenceNumber());
        field.setReadonly(true);
        fg.add(field);
        field = new Field("Label.AcquisitionValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount1()), 15);
        field.setReadonly(true);
        fg.add(field);
        Valuation valuation = (Valuation)ValuationBO.get(this.dbData, this.companyId, "A", this.asset.getId(), 1)[0];
        if (valuation != null && valuation.getNumberOfDepreciatedPeriods() != 0 || valuation != null && valuation.getPostedDepreciationBalance().doubleValue() != 0.0) {
            field = new Field("Label.TotalDepreciationAmount", "decimal", null, (String)DECIMALTRANSFORMER.transform(valuation.getPostedDepreciationBalance()), 15);
            field.setReadonly(true);
            fg.add(field);
            field = new Field("Label.DepreciatedPeriods", "number", null, "" + valuation.getNumberOfDepreciatedPeriods(), 4);
            field.setReadonly(true);
            fg.add(field);
        }
        this.window.add(fg);
        Action showDimensionPanel = new Action("Label.Dimensions").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showDimensionPanel");
        FloatBar fb = new FloatBar();
        fb.addAction(showDimensionPanel);
        this.window.add(fb);
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, this.asset, false, false, false, null, false, null, null);
        this.panels.setValues();
        this.tabbedPanel = new TabbedPanel();
        this.tabs = new Tab[2];
        this.updateValuationPanel(0);
        this.panels.apTabs[0].setReadonly(true);
        this.tabs[0] = this.panels.apTabs[0];
        this.tabbedPanel.add(this.tabs[0]);
        if (this.ap2Present) {
            this.updateValuationPanel(1);
            this.panels.apTabs[1].setReadonly(true);
            this.tabs[1] = this.panels.apTabs[1];
            this.tabbedPanel.add(this.tabs[1]);
        }
        Panel panel = new Panel();
        panel.addUIObject((UIObject)this.tabbedPanel);
        this.window.add(panel);
    }

    private FieldGroup getHeaderFieldGroup() throws Exception {
        FieldGroup fg = new FieldGroup("");
        fg.forceBorder(true);
        ReferenceField rf = new ReferenceField("Label.Asset");
        rf.setLength(10);
        rf.setDescriptionLength(40);
        rf.setReadonly(true);
        rf.setValue(this.asset.getId());
        rf.setDescription(this.asset.getDescription());
        fg.add((Field)rf);
        rf = new ReferenceField("Label.Type");
        rf.setLength(10);
        rf.setDescriptionLength(40);
        rf.setReadonly(true);
        rf.setValue(this.assetType.getId());
        rf.setDescription(this.assetType.getDescription());
        fg.add((Field)rf);
        Field field = new Field("Label.StartPeriod", "text", null, PeriodHelper.toString(this.asset.getStartUseYear(), this.asset.getStartUsePeriod()), 10);
        field.setReadonly(true);
        fg.add(field);
        return fg;
    }

    private void updateValuationPanel(int index) throws Exception {
        this.panels.values[index].setHidden(true);
        NumberField life = new NumberField("Label.DepreciationLife", 4, true);
        life.setReadonly(true);
        life.setValue((long)this.panels.valuation[index].getDepreciatableLife());
        this.panels.depreciationGroups2[index].replaceUIObject((UIObject)this.panels.lastDepreciated[index], (UIObject)life);
        if (!this.panels.depreciationPaused[index].getValueAsBoolean()) {
            this.panels.depreciationPaused[index].setHidden(true);
        }
        if (this.panels.startInterest[index].getBookYear().getIntValue() == 0) {
            this.panels.startInterest[index].setHidden(true);
        }
    }

    public DataObject showDimensionPanel(DataObject object) throws Exception {
        Window dimensionWindow = new Window();
        dimensionWindow.setLabel("Label.Dimensions");
        this.panels.finDimensionPanel.setReadonly(true);
        this.panels.facDimensionPanel.setReadonly(true);
        dimensionWindow.add(this.panels.finDimensionPanel);
        dimensionWindow.add(this.panels.facDimensionPanel);
        object.addUIObject((UIObject)dimensionWindow);
        return object;
    }

    private void showAdditionalInvestment() throws Exception {
        this.window.setLabel("Title.AdditionalInvestment");
        this.window.add(this.getHeaderFieldGroup());
        this.setValuesForAdditionalInvestmentOrDisinvestment();
    }

    private void showDisinvestment() throws Exception {
        this.window.setLabel("Label.DisInvestment");
        this.window.add(this.getHeaderFieldGroup());
        this.setValuesForAdditionalInvestmentOrDisinvestment();
    }

    private void setValuesForAdditionalInvestmentOrDisinvestment() throws Exception {
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, this.asset, false, false, false, null, false, null, null);
        this.panels.setValues();
        this.tabbedPanel = new TabbedPanel();
        this.tabs = new Tab[2];
        this.tabs[0] = new Tab(this.tabTexts[0]);
        this.tabbedPanel.add(this.tabs[0]);
        this.setValuesForTab(0);
        if (this.ap2Present) {
            this.tabs[1] = new Tab(this.tabTexts[1]);
            this.tabbedPanel.add(this.tabs[1]);
            this.setValuesForTab(1);
        }
        Panel panel = new Panel();
        panel.addUIObject((UIObject)this.tabbedPanel);
        this.window.add(panel);
        Collection allTransactions = TransactionBO.getTransactionsForDocument(this.transaction);
        if (!this.ap2Present) {
            this.createTable(allTransactions, 0);
            this.tabs[0].add((Table)this.table);
        } else {
            this.createTable(allTransactions, 1);
            this.tabs[0].add((Table)this.table);
            this.createTable(allTransactions, 2);
            this.tabs[1].add((Table)this.table);
        }
    }

    private void setValuesForTab(int index) throws Exception {
        this.panels.depreciatableLife[0].setReadonly(true);
        this.tabs[index].add(this.panels.values[index]);
    }

    private void createTable(Collection allTransactions, int accountingPrinciple) throws Exception {
        ArrayList<Transaction> theCollection;
        if (accountingPrinciple == 0) {
            theCollection = allTransactions;
        } else {
            theCollection = new ArrayList<Transaction>();
            for (Transaction transaction : allTransactions) {
                if (transaction.getAccountingPrinciple() != accountingPrinciple) continue;
                theCollection.add(transaction);
            }
        }
        this.table = new CollectionTable(Transaction.class, theCollection, 12);
        this.table.setName(PAGE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setColumnSortable(SORTABLE);
        this.table.setSortable(true);
        this.table.setSelectable(false);
        TableHelper.createMenu((Table)this.table, null, (Action[])this.rowActions);
        this.table.reload();
    }
}

