/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Iterator;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.adapter.ProcessAwareAdapter;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.servlet.ESPSessionContext;
import nl.ibs.esp.session.ActiveUsers;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.MenuBar;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.UserBO;
import nl.ibs.fac.db.BookYearManager;
import nl.ibs.fac.db.BookYearManagerFactory;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.User;
import nl.ibs.fac.ui.ApplicationIdentifierHelper;
import nl.ibs.fac.ui.FACMenuBarHelper;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.UserSettings;
import nl.ibs.vegas.SettingsStore;

public abstract class FACProcessAwareAdapter
extends ProcessAwareAdapter {
    protected static final String ACTION_FINISH = "finish";
    protected static final String ACTION_CANCEL = "cancel";
    public static final String START_ACTION = "show";
    private String adapterName = ((Object)((Object)this)).getClass().getName();
    protected DBData dbData = null;
    protected Environment env = null;
    protected String companyId = null;
    protected String bookYear = null;
    protected String bookYearMin = null;
    protected String bookYearMax = null;
    protected int numberOfPeriods = 0;
    protected String dataSetId = null;
    protected boolean governmentActivated;
    protected LoginHelper loginHelper;
    protected Action cancel = new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(this.adapterName)).setMethod("show");
    protected Action back = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(this.adapterName)).setMethod("show");
    protected Action finish = new Action("Button.Exit").setAdapter(this.getProcessAdapterPageName(this.adapterName)).setMethod("finish");

    public FACProcessAwareAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Iterator iterator = object.getScreen().getUIObjects(Message.class, false).iterator();
        if (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            object.setSessionAttribute("MESSAGE", (Object)message.getLanguageCode());
            object.setSessionAttribute("ALERT", (Object)message.getType());
        }
        object.removeMessages();
        this.dbData = (DBData)object.getSessionAttribute("ActiveDBData");
        this.env = (Environment)object.getSessionAttribute("ActiveEnvironment");
        this.companyId = (String)object.getSessionAttribute("ActiveCompany");
        this.bookYear = (String)object.getSessionAttribute("ActiveBookYear");
        this.bookYearMin = (String)object.getSessionAttribute("MinBookYear");
        this.bookYearMax = (String)object.getSessionAttribute("MaxBookYear");
        Object tmp = object.getSessionAttribute("NumberOfPeriods");
        if (tmp != null) {
            this.numberOfPeriods = Integer.parseInt((String)tmp);
        }
        this.dataSetId = (String)object.getSessionAttribute("ActiveDataSet");
        this.governmentActivated = object.getSessionAttribute("GOV") != null;
        this.loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
    }

    protected void setMenuBar(DataObject object) throws Exception {
        if ("FACSYSBEH".equals(this.loginHelper.getUser()) || "APPSYSBEH".equals(this.loginHelper.getUser())) {
            MenuBar menuBar = FACMenuBarHelper.getFACSYSBEHMenu(object);
            super.setMenuBar(object, menuBar);
            return;
        }
        if (object.getSessionAttribute("ActiveEnvironment") == null) {
            MenuBar menuBar = FACMenuBarHelper.getNoActiveEnvironmentMenu(object);
            super.setMenuBar(object, menuBar);
            return;
        }
        if ((String)object.getSessionAttribute("AdministratorMenu") != null) {
            MenuBar menuBar = FACMenuBarHelper.getADMINMenu(object, this.governmentActivated);
            super.setMenuBar(object, menuBar);
            return;
        }
        String userGroupId = (String)object.getSessionAttribute("userGroupId");
        String isAdmin = (String)object.getSessionAttribute("Administrator");
        MenuBar menuBar = FACMenuBarHelper.getUSERMenu(userGroupId, isAdmin != null, this.governmentActivated, this.dataSetId != null, object);
        super.setMenuBar(object, menuBar);
    }

    public DataObject finish(DataObject object) throws Exception {
        this.getProcess().destroyAdapter(object);
        return this.showMainPage(object);
    }

    public DataObject showMainPage(DataObject object) throws Exception {
        object.addUIObject((UIObject)new RedirectAction("nl.ibs.fac.adapters.MainProcess:nl.ibs.fac.adapters.MainAdapter", START_ACTION));
        return object;
    }

    protected boolean activateEnvironment(DataObject object, Environment newEnv) throws Exception {
        this.killProcesses(object);
        if (this.env != null) {
            this.loginHelper.logout(this.env, this.companyId, this.bookYear);
        }
        this.env = newEnv;
        if (this.env == null) {
            object.removeSessionAttribute("ActiveEnvironment");
            object.removeSessionAttribute("ActiveDBData");
            ESPSessionContext.setSettingStore((SettingsStore)new UserSettings("fac", this.loginHelper.getUser(), ""));
        } else {
            int maxUsers;
            String message = this.loginHelper.login(this.env, null, null);
            if (message != null && message.trim().length() > 0) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return false;
            }
            Object[] result = EnvironmentBO.checkActivated(this.loginHelper, this.env.getOperationArea(), false);
            message = (String)result[0];
            if (message != null) {
                if (result[1] == null) {
                    object.addUIObject((UIObject)new Message(message, "error"));
                    this.loginHelper.logout(this.env, null, null);
                    return false;
                }
                object.setSessionAttribute("MESSAGE", (Object)message);
            }
            if ((maxUsers = Integer.parseInt((String)result[2])) != 0 && ActiveUsers.getSessions((DataObject)object).size() > maxUsers - 1) {
                message = String.valueOf(object.translate("max_users_exceeded", object.getLocale())) + ": " + maxUsers;
                object.addUIObject((UIObject)new Message(message, "error"));
                this.loginHelper.logout(this.env, null, null);
                return false;
            }
            object.removeSessionAttribute("GOV");
            if (this.env.getGovernmentActivated() && ((result = EnvironmentBO.checkActivated(this.loginHelper, this.env.getOperationArea(), true))[0] == null || result[1] != null)) {
                object.setSessionAttribute("GOV", (Object)"");
            }
            object.setSessionAttribute("ActiveEnvironment", (Object)this.env);
            if (this.env.getGovernmentActivated()) {
                object.setSessionAttribute("ActiveCompany", (Object)"");
                this.governmentActivated = true;
            } else {
                object.removeSessionAttribute("GOV");
                this.governmentActivated = false;
            }
            object.setSessionAttribute("ActiveDBData", (Object)EnvironmentBO.getDBData(this.env.getFacLib()));
            ESPSessionContext.setSettingStore((SettingsStore)new UserSettings("fac", this.loginHelper.getUser(), this.env.getFacLib()));
        }
        object.removeSessionAttribute("ActiveCompany");
        object.removeSessionAttribute("ActiveBookYear");
        object.removeSessionAttribute("NumberOfPeriods");
        ApplicationIdentifierHelper.update(object);
        return true;
    }

    protected boolean activateCompany(DataObject object, Company company, User user) throws Exception {
        this.killProcesses(object);
        this.loginHelper.logout(this.env, this.companyId, this.bookYear);
        if (company == null) {
            String message = this.loginHelper.login(this.env, "", "");
            if (message != null && message.trim().length() > 0) {
                this.loginHelper.login(this.env, this.companyId, this.bookYear);
                object.addUIObject((UIObject)new Message(message, "error"));
                return false;
            }
            this.companyId = "";
            this.bookYear = "";
            object.removeSessionAttribute("ActiveCompany");
            ESPSessionContext.setSettingStore((SettingsStore)new UserSettings("fac", this.loginHelper.getUser(), this.env.getFacLib()));
            object.removeSessionAttribute("ActiveBookYear");
        } else {
            String message = this.loginHelper.login(this.env, company.getId(), "" + company.getCurrentBookYear());
            if (message != null && message.trim().length() > 0) {
                this.loginHelper.login(this.env, this.companyId, this.bookYear);
                object.addUIObject((UIObject)new Message(message, "error"));
                return false;
            }
            this.companyId = company.getId();
            this.bookYear = "" + company.getCurrentBookYear();
            object.setSessionAttribute("ActiveCompany", (Object)this.companyId);
            ESPSessionContext.setSettingStore((SettingsStore)new UserSettings("fac", this.loginHelper.getUser(), String.valueOf(this.env.getFacLib()) + " " + company.getId()));
            object.setSessionAttribute("MinBookYear", (Object)("" + company.getInitialBookYear()));
            object.setSessionAttribute("ActiveBookYear", (Object)this.bookYear);
            BookYearManager manager = BookYearManagerFactory.getInstance(company.getDBData());
            object.setSessionAttribute("MaxBookYear", (Object)("" + (manager.getMax(this.companyId) + 1)));
            object.removeSessionAttribute("ActiveDataSet");
            if (company.getDataSet() != null) {
                object.setSessionAttribute("ActiveDataSet", (Object)company.getDataSetId());
            }
            object.setSessionAttribute("NumberOfPeriods", (Object)("" + company.retrieveNumberOfPeriods()));
            UserBO.update(user, this.env.getFacLib(), this.companyId);
        }
        this.dataSetId = (String)object.getSessionAttribute("ActiveDataSet");
        ApplicationIdentifierHelper.update(object);
        return true;
    }

    protected String getHelpPageName() {
        return "";
    }
}

